/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.param;

import javax.swing.JComponent;
import org.dom4j.Element;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;

public class GridCellSupersamplingParam
extends AbstractParameter<GridCellSupersamplingSettings> {
    public static String NAME = "Grid Cell Supersampling";
    private Editor editor;

    public GridCellSupersamplingParam() {
        this(null);
        this.setInfo("These settings enable and control supersampling of gridded seismicity sources across the original cell represented by each grid node.");
    }

    public GridCellSupersamplingParam(GridCellSupersamplingSettings params) {
        super(NAME, null, null, params);
    }

    @Override
    public ParameterEditor getEditor() {
        if (this.editor == null) {
            this.editor = new Editor(this);
        }
        this.editor.setValue((GridCellSupersamplingSettings)this.getValue());
        return this.editor;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.editor != null;
    }

    @Override
    public Object clone() {
        return new GridCellSupersamplingParam((GridCellSupersamplingSettings)this.getValue());
    }

    @Override
    protected boolean setIndividualParamValueFromXML(Element el) {
        throw new UnsupportedOperationException("Not supported");
    }

    private static class Editor
    extends AbstractParameterEditor<GridCellSupersamplingSettings>
    implements ParameterChangeListener {
        private ParameterList paramList;
        private ParameterListEditor paramEdit;
        private BooleanParameter enabledParam;
        private ParameterList settingsList;
        private DoubleParameter targetSpacingParam;
        private DoubleParameter fullDistParam;
        private DoubleParameter borderDistParam;
        private DoubleParameter cornerDistParam;
        private BooleanParameter applyToFiniteParam;
        private ParameterListParameter settingsListParam;
        private boolean updating = false;

        public Editor(GridCellSupersamplingParam param) {
            super(param);
        }

        private Double getCutoffParamValue(double cutoff) {
            if (cutoff > 0.0) {
                return cutoff;
            }
            return null;
        }

        private double paramValueToCutoff(DoubleParameter param) {
            Double paramValue = (Double)param.getValue();
            if (paramValue == null) {
                return 0.0;
            }
            return paramValue;
        }

        @Override
        public boolean isParameterSupported(Parameter<GridCellSupersamplingSettings> param) {
            return param != null;
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (this.paramEdit != null) {
                this.paramEdit.setEnabled(enabled);
            }
        }

        @Override
        protected JComponent buildWidget() {
            this.paramList = new ParameterList();
            this.enabledParam = new BooleanParameter("Enable", false);
            this.enabledParam.setInfo("This enables supersampling of gridded seismicity across the original cell represented by each grid node. This is done in a distance-dependent manner for computational efficiency. Sites near the source will be supersampled, but those further away will not be. Sampling parameters are set to default values initially but can be edited once enabled.");
            this.enabledParam.addParameterChangeListener(this);
            this.paramList.addParameter(this.enabledParam);
            this.settingsList = new ParameterList();
            this.targetSpacingParam = new DoubleParameter("Target Grid Spacing", 0.1, 10.0, (Double)1.0);
            this.targetSpacingParam.getConstraint().setNullAllowed(false);
            this.targetSpacingParam.setInfo("Target supersampling spacing in kilometers. This is used to determine the number of samples in each direction (latitude and longitude), but adapts to non-rectangular grid cells further from the equator.");
            this.targetSpacingParam.setUnits("km");
            this.settingsList.addParameter(this.targetSpacingParam);
            this.fullDistParam = new DoubleParameter("Full Supersampling Distance", 0.0, 1000.0, (Double)30.0);
            this.targetSpacingParam.getConstraint().setNullAllowed(true);
            this.fullDistParam.setInfo("The site-to-grid-center distance below which grid cells will be fully supersampled. Set to 0 or black to disable full supersampling at all distances.");
            this.fullDistParam.setUnits("km");
            this.settingsList.addParameter(this.fullDistParam);
            this.borderDistParam = new DoubleParameter("Border Supersampling Distance", 0.0, 1000.0, (Double)60.0);
            this.borderDistParam.getConstraint().setNullAllowed(true);
            this.borderDistParam.setInfo("The site-to-grid-center distance below which grid cell borders will be supersampled (but interiors will not be). Set to 0 or black to disable border supersampling at all distances.");
            this.borderDistParam.setUnits("km");
            this.settingsList.addParameter(this.borderDistParam);
            this.cornerDistParam = new DoubleParameter("Corner Supersampling Distance", 0.0, 1000.0, (Double)0.0);
            this.cornerDistParam.getConstraint().setNullAllowed(true);
            this.cornerDistParam.setInfo("The site-to-grid-center distance below which a grid cell will represented by its 4 corners. Set to 0 or black to disable corner supersampling at all distances.");
            this.cornerDistParam.setUnits("km");
            this.settingsList.addParameter(this.cornerDistParam);
            this.applyToFiniteParam = new BooleanParameter("Apply To Finite Ruptures", false);
            this.applyToFiniteParam.setInfo("If checked, supersampling will also be applied to finite ruptures (randomly generated or otherwise). Note that not all models implement supersampling of random finite surfaces, so this setting may be ignored.");
            this.settingsList.addParameter(this.applyToFiniteParam);
            this.settingsListParam = new ParameterListParameter("Sampling Parameters", this.settingsList);
            this.settingsListParam.addParameterChangeListener(this);
            this.paramList.addParameter(this.settingsListParam);
            this.paramEdit = new ParameterListEditor(this.paramList);
            this.paramEdit.setName(this.getParameter().getName());
            return this.updateWidget();
        }

        @Override
        protected synchronized JComponent updateWidget() {
            GridCellSupersamplingSettings value = (GridCellSupersamplingSettings)this.getValue();
            this.updating = true;
            this.enabledParam.setValue(value != null);
            if (value != null) {
                this.targetSpacingParam.setValue(value.targetSpacingKM);
                this.fullDistParam.setValue(this.getCutoffParamValue(value.fullDist));
                this.borderDistParam.setValue(this.getCutoffParamValue(value.borderDist));
                this.cornerDistParam.setValue(this.getCutoffParamValue(value.cornerDist));
                this.applyToFiniteParam.setValue(value.applyToFinite);
                this.paramEdit.setParameterVisible(this.settingsListParam.getName(), true);
            } else {
                this.paramEdit.setParameterVisible(this.settingsListParam.getName(), false);
            }
            this.paramEdit.refreshParamEditor();
            this.updating = false;
            JComponent contents = this.paramEdit.getContents();
            contents.invalidate();
            contents.repaint();
            return contents;
        }

        @Override
        public synchronized void parameterChange(ParameterChangeEvent event) {
            if (this.updating) {
                return;
            }
            if (event.getParameter() == this.enabledParam) {
                this.paramEdit.setParameterVisible(this.settingsListParam.getName(), (Boolean)this.enabledParam.getValue());
            }
            GridCellSupersamplingSettings settings = this.buildCurrentValue();
            System.out.println("GridCellSupersamplingParam.Editor: param change, setting in parent: " + String.valueOf(settings));
            this.getParameter().setValue(settings);
        }

        private GridCellSupersamplingSettings buildCurrentValue() {
            if (((Boolean)this.enabledParam.getValue()).booleanValue()) {
                return new GridCellSupersamplingSettings(this.paramValueToCutoff(this.targetSpacingParam), this.paramValueToCutoff(this.fullDistParam), this.paramValueToCutoff(this.borderDistParam), this.paramValueToCutoff(this.cornerDistParam), (Boolean)this.applyToFiniteParam.getValue());
            }
            return null;
        }
    }
}

