/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.MagScalingRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class FloatingPoissonFaultSource
extends ProbEqkSource {
    private static String C = new String("FloatingPoissonFaultSource");
    private boolean D = false;
    protected String NAME = "Floating Poisson Fault Source";
    private ArrayList<ProbEqkRupture> ruptureList;
    private double duration;
    private AbstractEvenlyGriddedSurfaceWithSubsets faultSurface;
    private Region sourceRegion;
    private LocationList sourceTrace;
    private double lastDuration = Double.NaN;

    public FloatingPoissonFaultSource(IncrementalMagFreqDist magDist, AbstractEvenlyGriddedSurfaceWithSubsets faultSurface, MagScalingRelationship magScalingRel, double magScalingSigma, double rupAspectRatio, double rupOffset, double rake, double duration, double minMag, int floatTypeFlag, double fullFaultRupMagThresh) {
        this.duration = duration;
        this.faultSurface = faultSurface;
        if (this.D) {
            System.out.println(magDist.getName());
            System.out.println("surface rows, cols: " + faultSurface.getNumCols() + ", " + faultSurface.getNumRows());
            System.out.println("magScalingRelationship: " + magScalingRel.getName());
            System.out.println("magScalingSigma: " + magScalingSigma);
            System.out.println("rupAspectRatio: " + rupAspectRatio);
            System.out.println("rupOffset: " + rupOffset);
            System.out.println("rake: " + rake);
            System.out.println("timeSpan: " + duration);
            System.out.println("minMag: " + minMag);
        }
        this.mkApproxSourceSurface(faultSurface);
        this.ruptureList = new ArrayList();
        if (magScalingSigma == 0.0) {
            this.addRupturesToList(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, minMag, 0.0, 1.0, floatTypeFlag, fullFaultRupMagThresh);
        } else {
            GaussianMagFreqDist gDist = new GaussianMagFreqDist(-3.0, 3.0, 25, 0.0, 1.0, 1.0);
            gDist.scaleToCumRate(0, 1.0);
            if (this.D) {
                System.out.println("gDist:\n" + gDist.toString());
            }
            for (int m = 0; m < gDist.size(); ++m) {
                this.addRupturesToList(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, minMag, gDist.getX(m), gDist.getY(m), floatTypeFlag, fullFaultRupMagThresh);
                if (!this.D) continue;
                System.out.println(m + "\t" + gDist.getX(m) + "\t" + gDist.getY(m));
            }
        }
        this.lastDuration = duration;
    }

    public FloatingPoissonFaultSource(IncrementalMagFreqDist magDist, AbstractEvenlyGriddedSurfaceWithSubsets faultSurface, MagScalingRelationship magScalingRel, double magScalingSigma, double rupAspectRatio, double rupOffset, double rake, double duration, double minMag) {
        this(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, duration, minMag, 1, Double.MAX_VALUE);
    }

    public FloatingPoissonFaultSource(IncrementalMagFreqDist magDist, AbstractEvenlyGriddedSurfaceWithSubsets faultSurface, MagScalingRelationship magScalingRel, double magScalingSigma, double rupAspectRatio, double rupOffset, double rake, double duration) {
        this(magDist, faultSurface, magScalingRel, magScalingSigma, rupAspectRatio, rupOffset, rake, duration, 5.0);
    }

    public void setDuration(double newDuration) {
        for (int r = 0; r < this.ruptureList.size(); ++r) {
            ProbEqkRupture rup = this.ruptureList.get(r);
            double rate = rup.getMeanAnnualRate(this.lastDuration);
            rup.setProbability(1.0 - Math.exp(-this.duration * rate));
        }
        this.lastDuration = newDuration;
    }

    private double getRupLength(MagScalingRelationship magScalingRel, double magScalingSigma, double numSigma, double rupAspectRatio, double mag) throws RuntimeException {
        if (magScalingRel instanceof MagAreaRelationship) {
            double area = magScalingRel.getMedianScale(mag) * Math.pow(10.0, numSigma * magScalingSigma);
            return Math.sqrt(area * rupAspectRatio);
        }
        if (magScalingRel instanceof MagLengthRelationship) {
            return magScalingRel.getMedianScale(mag) * Math.pow(10.0, numSigma * magScalingSigma);
        }
        throw new RuntimeException("bad type of MagScalingRelationship");
    }

    private void addRupturesToList(IncrementalMagFreqDist magDist, AbstractEvenlyGriddedSurfaceWithSubsets faultSurface, MagScalingRelationship magScalingRel, double magScalingSigma, double rupAspectRatio, double rupOffset, double rake, double minMag, double numSigma, double weight, int floatTypeFlag, double fullFaultRupMagThresh) {
        double prob = Double.NaN;
        if (this.D) {
            System.out.println(C + ": magScalingSigma=" + magScalingSigma);
        }
        int numMags = magDist.size();
        for (int i = 0; i < numMags; ++i) {
            double mag = magDist.getX(i);
            double rate = magDist.getY(i);
            if (!(rate > 1.0E-14) || !(mag >= minMag)) continue;
            if (mag < fullFaultRupMagThresh) {
                double ddw = faultSurface.getAveWidth();
                double rupLen = this.getRupLength(magScalingRel, magScalingSigma, numSigma, rupAspectRatio, mag);
                double rupWidth = rupLen / rupAspectRatio;
                if (magScalingRel instanceof MagAreaRelationship && rupWidth > ddw) {
                    rupLen *= rupWidth / ddw;
                    rupWidth = ddw;
                }
                if (floatTypeFlag == 0) {
                    rupWidth = 2.0 * ddw;
                }
                int numRup = floatTypeFlag != 2 ? faultSurface.getNumSubsetSurfaces(rupLen, rupWidth, rupOffset) : faultSurface.getNumSubsetSurfacesAlongLength(rupLen, rupOffset);
                for (int r = 0; r < numRup; ++r) {
                    ProbEqkRupture probEqkRupture = new ProbEqkRupture();
                    probEqkRupture.setAveRake(rake);
                    if (floatTypeFlag != 2) {
                        probEqkRupture.setRuptureSurface(faultSurface.getNthSubsetSurface(rupLen, rupWidth, rupOffset, r));
                    } else {
                        probEqkRupture.setRuptureSurface(faultSurface.getNthSubsetSurfaceCenteredDownDip(rupLen, rupWidth, rupOffset, r));
                    }
                    probEqkRupture.setMag(mag);
                    prob = 1.0 - Math.exp(-this.duration * weight * rate / (double)numRup);
                    probEqkRupture.setProbability(prob);
                    this.ruptureList.add(probEqkRupture);
                }
                continue;
            }
            ProbEqkRupture probEqkRupture = new ProbEqkRupture();
            probEqkRupture.setAveRake(rake);
            probEqkRupture.setRuptureSurface(faultSurface);
            probEqkRupture.setMag(mag);
            prob = 1.0 - Math.exp(-this.duration * weight * rate);
            probEqkRupture.setProbability(prob);
            this.ruptureList.add(probEqkRupture);
        }
    }

    @Override
    public LocationList getAllSourceLocs() {
        return this.faultSurface.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        return this.faultSurface;
    }

    @Override
    public int getNumRuptures() {
        return this.ruptureList.size();
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        return this.ruptureList.get(nthRupture);
    }

    @Override
    public double getMinDistance(Site site) {
        if (this.sourceRegion != null) {
            return this.sourceRegion.distanceToLocation(site.getLocation());
        }
        return this.sourceTrace.minDistToLocation(site.getLocation());
    }

    private void mkApproxSourceSurface(AbstractEvenlyGriddedSurfaceWithSubsets faultSurface) {
        if (faultSurface.getAveDip() != 90.0) {
            int nRows = faultSurface.getNumRows();
            int nCols = faultSurface.getNumCols();
            LocationList faultCornerLocations = new LocationList();
            faultCornerLocations.add(faultSurface.getLocation(0, 0));
            faultCornerLocations.add(faultSurface.getLocation(0, nCols / 2));
            faultCornerLocations.add(faultSurface.getLocation(0, nCols - 1));
            faultCornerLocations.add(faultSurface.getLocation(nRows - 1, nCols - 1));
            faultCornerLocations.add(faultSurface.getLocation(nRows - 1, nCols / 2));
            faultCornerLocations.add(faultSurface.getLocation(nRows - 1, 0));
            try {
                this.sourceRegion = new Region(faultCornerLocations, BorderType.GREAT_CIRCLE);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            ListIterator it = faultSurface.getColumnIterator(0);
            this.sourceTrace = new LocationList();
            while (it.hasNext()) {
                this.sourceTrace.add((Location)it.next());
            }
        }
    }

    public void setName(String name) {
        this.NAME = name;
    }

    @Override
    public String getName() {
        return this.NAME;
    }
}

