/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel02.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public class Frankel02OutputToHazardMapDataset {
    double[] pga = new double[]{0.005, 0.007, 0.0098, 0.0137, 0.0192, 0.0269, 0.0376, 0.0527, 0.0738, 0.103, 0.145, 0.203, 0.284, 0.397, 0.556, 0.778, 1.09, 1.52, 2.13};

    public Frankel02OutputToHazardMapDataset(String fileName, String newDir) {
        int timeDuration = 50;
        try {
            String str;
            new File((String)newDir).mkdir();
            if (!((String)newDir).endsWith("/")) {
                newDir = (String)newDir + "/";
            }
            FileReader fr = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fr);
            br.readLine();
            double prevLat = -1.0;
            double prevLon = -1.0;
            DecimalFormat d = new DecimalFormat("0.00##");
            OutputStreamWriter fw = null;
            int counter = 0;
            while ((str = br.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(str);
                double lon = Double.parseDouble(tokenizer.nextToken());
                double lat = Double.parseDouble(tokenizer.nextToken());
                double val = Double.parseDouble(tokenizer.nextToken());
                if (prevLat == -1.0 || prevLat != lat || prevLon != lon) {
                    if (prevLat != -1.0) {
                        fw.close();
                    }
                    fw = new FileWriter((String)newDir + d.format(lat) + "_" + d.format(lon) + ".txt");
                    counter = 0;
                    prevLat = lat;
                    prevLon = lon;
                }
                fw.write(this.pga[counter] + " " + (1.0 - Math.exp(-val * (double)timeDuration)) + "\n");
                ++counter;
            }
            fw.close();
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Frankel02OutputToHazardMapDataset frankel02OutputToHazardMapDataset1 = new Frankel02OutputToHazardMapDataset(args[0], args[1]);
    }
}

