/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel96;

import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;

public class Frankel96_CharEqkSource
extends ProbEqkSource {
    private double rate;
    private static final String C = new String("Frankel96_CharEqkSource");
    private boolean D = false;
    private AbstractEvenlyGriddedSurfaceWithSubsets surface;
    private ProbEqkRupture probEqkRupture = new ProbEqkRupture();

    public Frankel96_CharEqkSource(double rake, double mag, double rate, AbstractEvenlyGriddedSurfaceWithSubsets surface, String faultName) {
        this.rate = rate;
        this.surface = surface;
        this.probEqkRupture = new ProbEqkRupture();
        this.rate = rate;
        this.probEqkRupture.setAveRake(rake);
        this.probEqkRupture.setMag(mag);
        this.probEqkRupture.setRuptureSurface(surface);
        this.name = faultName + " Char";
    }

    @Override
    public LocationList getAllSourceLocs() {
        return this.surface.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        return this.surface;
    }

    public void setTimeSpan(double yrs) {
        this.probEqkRupture.setProbability(1.0 - Math.exp(-yrs * this.rate));
        if (this.D) {
            System.out.println("probability=" + this.probEqkRupture.getProbability());
        }
    }

    @Override
    public int getNumRuptures() {
        return 1;
    }

    @Override
    public ProbEqkRupture getRupture(int nRupture) {
        if (nRupture != 0) {
            throw new RuntimeException(this.name + ":getRupture():: Char type faults have only1 rupture nRupture should be equal to 0");
        }
        return this.probEqkRupture;
    }

    @Override
    public double getMinDistance(Site site) {
        AbstractEvenlyGriddedSurfaceWithSubsets surface = (AbstractEvenlyGriddedSurfaceWithSubsets)this.probEqkRupture.getRuptureSurface();
        LocationVector dir = LocationUtils.vector(site.getLocation(), (Location)surface.get(0, 0));
        double min = dir.getHorzDistance();
        if (min > (dir = LocationUtils.vector(site.getLocation(), (Location)surface.get(0, surface.getNumCols() - 1))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        if (min > (dir = LocationUtils.vector(site.getLocation(), (Location)surface.get(0, surface.getNumCols() / 2))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        return min;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

