/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.NSHMP_CEUS08;

import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class CEUS_Point2Vert_FaultPoisSource
extends ProbEqkSource
implements Serializable {
    private static String C = new String("Point2Vert_SS_FaultPoisSource");
    private boolean D = false;
    private DiscretizedFunc magFreqDist;
    private static final double aveDip = 90.0;
    private double fracStrikeSlip = 0.0;
    private double fracNormal = 0.0;
    private double fracReverse = 0.0;
    private double duration;
    private MagLengthRelationship magLengthRelationship;
    private double magCutOff;
    private PointSurface ptSurface;
    private FrankelGriddedSurface finiteFaultSurface1;
    private FrankelGriddedSurface finiteFaultSurface2;
    private int numRuptures;
    private int ss_firstIndex;
    private int ss_lastIndex;
    private int n_firstIndex;
    private int n_lastIndex;
    private int rv_firstIndex;
    private int rv_lastIndex;
    private boolean isCrossHair = false;

    public CEUS_Point2Vert_FaultPoisSource(Location loc, DiscretizedFunc magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration, double magCutOff, double fracStrikeSlip, double fracNormal, double fracReverse) {
        this.magCutOff = magCutOff;
        if (this.D) {
            System.out.println("magCutOff=" + magCutOff);
            System.out.println("num pts in magFreqDist=" + magFreqDist.size());
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, duration, fracStrikeSlip, fracNormal, fracReverse);
    }

    public CEUS_Point2Vert_FaultPoisSource(Location loc, DiscretizedFunc magFreqDist, MagLengthRelationship magLengthRelationship, double duration, double magCutOff, double fracStrikeSlip, double fracNormal, double fracReverse, boolean isCrossHair) {
        this.magCutOff = magCutOff;
        this.isCrossHair = isCrossHair;
        this.setAll(loc, magFreqDist, magLengthRelationship, duration, fracStrikeSlip, fracNormal, fracReverse);
    }

    public void setAll(Location loc, DiscretizedFunc magFreqDist, MagLengthRelationship magLengthRelationship, double duration, double fracStrikeSlip, double fracNormal, double fracReverse) {
        double strike = (Math.random() - 0.5) * 180.0;
        if (strike < 0.0) {
            strike += 360.0;
        }
        this.setAll(loc, magFreqDist, magLengthRelationship, strike, duration, fracStrikeSlip, fracNormal, fracReverse);
    }

    public void setAll(Location loc, DiscretizedFunc magFreqDist, MagLengthRelationship magLengthRelationship, double strike, double duration, double fracStrikeSlip, double fracNormal, double fracReverse) {
        if (this.D) {
            System.out.println("duration=" + duration);
        }
        if (this.D) {
            System.out.println("strike=" + strike);
        }
        this.duration = duration;
        this.magFreqDist = magFreqDist;
        this.magLengthRelationship = magLengthRelationship;
        this.fracNormal = fracNormal;
        this.fracReverse = fracReverse;
        this.fracStrikeSlip = fracStrikeSlip;
        if (Math.abs(1.0 - (fracNormal + fracReverse + fracStrikeSlip)) > 1.0E-6) {
            throw new RuntimeException("fractions must sum to 1.0");
        }
        int numMags = magFreqDist.size();
        this.ss_firstIndex = -1;
        this.ss_lastIndex = -1;
        this.n_firstIndex = -1;
        this.n_lastIndex = -1;
        this.rv_firstIndex = -1;
        this.rv_lastIndex = -1;
        this.numRuptures = 0;
        if (fracStrikeSlip > 0.0) {
            this.ss_firstIndex = 0;
            this.ss_lastIndex = numMags - 1;
            this.numRuptures += numMags;
        }
        if (fracNormal > 0.0) {
            this.n_firstIndex = this.numRuptures;
            this.n_lastIndex = this.n_firstIndex + numMags - 1;
            this.numRuptures += numMags;
        }
        if (fracReverse > 0.0) {
            this.rv_firstIndex = this.numRuptures;
            this.rv_lastIndex = this.rv_firstIndex + numMags - 1;
            this.numRuptures += numMags;
        }
        if (this.isCrossHair) {
            this.numRuptures += this.numRuptures;
        }
        double depth = 5.0;
        Location newLoc = new Location(loc.getLatitude(), loc.getLongitude(), depth);
        this.ptSurface = new PointSurface(newLoc);
        this.ptSurface.setAveDip(90.0);
        this.ptSurface.setAveStrike(strike);
        double maxMag = magFreqDist.getX(magFreqDist.size() - 1);
        if (maxMag > this.magCutOff) {
            double halfLength = magLengthRelationship.getMedianLength(maxMag) / 2.0;
            if (this.isCrossHair) {
                strike = 0.0;
            }
            Location loc1 = LocationUtils.location(loc, new LocationVector(strike, halfLength, 0.0));
            LocationVector dir = LocationUtils.vector(loc1, loc);
            dir.setHorzDistance(dir.getHorzDistance() * 2.0);
            Location loc2 = LocationUtils.location(loc1, dir);
            FaultTrace fault = new FaultTrace("");
            fault.add(loc1);
            fault.add(loc2);
            this.finiteFaultSurface1 = new FrankelGriddedSurface(fault, 90.0, depth, depth, 1.0);
            if (this.isCrossHair) {
                strike = 90.0;
                loc1 = LocationUtils.location(loc, new LocationVector(strike, halfLength, 0.0));
                dir = LocationUtils.vector(loc1, loc);
                dir.setHorzDistance(dir.getHorzDistance() * 2.0);
                loc2 = LocationUtils.location(loc1, dir);
                fault = new FaultTrace("");
                fault.add(loc1);
                fault.add(loc2);
                this.finiteFaultSurface2 = new FrankelGriddedSurface(fault, 90.0, depth, depth, 1.0);
            }
        }
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        if (this.finiteFaultSurface1 != null) {
            locList = this.finiteFaultSurface1.getEvenlyDiscritizedListOfLocsOnSurface();
        }
        if (this.finiteFaultSurface2 != null) {
            ListIterator<Location> it = this.finiteFaultSurface2.getLocationsIterator();
            while (it.hasNext()) {
                locList.add((Location)it.next());
            }
        }
        if (this.ptSurface != null) {
            locList.add(this.ptSurface.getLocation());
        }
        return locList;
    }

    @Override
    public AbstractEvenlyGriddedSurface getSourceSurface() {
        throw new RuntimeException("method not supported (not sure what to return)");
    }

    @Override
    public int getNumRuptures() {
        return this.numRuptures;
    }

    @Override
    public ProbEqkRupture getRupture(int nthRupture) {
        boolean secondSurface = false;
        if (this.isCrossHair && nthRupture >= this.numRuptures / 2) {
            nthRupture -= this.numRuptures / 2;
            secondSurface = true;
        }
        double fraction = Double.NaN;
        double rake = Double.NaN;
        double dip = Double.NaN;
        int magIndex = -1;
        if (nthRupture >= this.ss_firstIndex && nthRupture <= this.ss_lastIndex) {
            rake = 0.0;
            dip = 90.0;
            magIndex = nthRupture - this.ss_firstIndex;
            fraction = this.fracStrikeSlip;
        } else if (nthRupture >= this.n_firstIndex && nthRupture <= this.n_lastIndex) {
            rake = -90.0;
            dip = 50.0;
            magIndex = nthRupture - this.n_firstIndex;
            fraction = this.fracNormal;
        } else if (nthRupture >= this.rv_firstIndex && nthRupture <= this.rv_lastIndex) {
            rake = 90.0;
            dip = 50.0;
            magIndex = nthRupture - this.rv_firstIndex;
            fraction = this.fracReverse;
        }
        double mag = this.magFreqDist.getX(magIndex);
        double depth = 5.0;
        ProbEqkRupture probEqkRupture = new ProbEqkRupture();
        probEqkRupture.setMag(mag);
        probEqkRupture.setAveRake(rake);
        if (this.isCrossHair) {
            fraction /= 2.0;
        }
        double prob = 1.0 - Math.exp(-this.duration * fraction * this.magFreqDist.getY(magIndex));
        probEqkRupture.setProbability(prob);
        if (mag <= this.magCutOff) {
            if (this.ptSurface.getDepth() != depth) {
                this.ptSurface.setDepth(depth);
            }
            this.ptSurface.setAveDip(dip);
            probEqkRupture.setRuptureSurface(this.ptSurface);
        } else {
            FrankelGriddedSurface finiteFault = secondSurface ? this.finiteFaultSurface2 : this.finiteFaultSurface1;
            if (finiteFault.getLocation(0, 0).getDepth() != depth) {
                finiteFault = finiteFault.deepCopyOverrideDepth(depth);
            }
            if (magIndex == this.magFreqDist.size() - 1) {
                probEqkRupture.setRuptureSurface(finiteFault);
            } else {
                double rupLen = this.magLengthRelationship.getMedianLength(mag);
                double startPoint = (double)finiteFault.getNumCols() / 2.0 - 0.5 - rupLen / 2.0;
                GriddedSubsetSurface rupSurf = new GriddedSubsetSurface(1, Math.round((float)rupLen + 1.0f), 0, Math.round((float)startPoint), finiteFault);
                probEqkRupture.setRuptureSurface(rupSurf);
            }
        }
        return probEqkRupture;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    public double getMinDistance(Site site) {
        return LocationUtils.horzDistance(site.getLocation(), this.ptSurface.getLocation());
    }

    @Override
    public String getName() {
        return C;
    }

    public static void main(String[] args) {
        Location loc = new Location(34.0, -118.0, 0.0);
        GutenbergRichterMagFreqDist dist = new GutenbergRichterMagFreqDist(5.0, 16, 0.2, 1.0E17, 0.9);
        WC1994_MagLengthRelationship wc_rel = new WC1994_MagLengthRelationship();
        double fracStrikeSlip = 0.3333333333333333;
        double fracNormal = 0.3333333333333333;
        double fracReverse = 0.3333333333333333;
        double duration = 1.0;
        CEUS_Point2Vert_FaultPoisSource src = new CEUS_Point2Vert_FaultPoisSource(loc, (DiscretizedFunc)dist, (MagLengthRelationship)wc_rel, duration, 6.0, fracStrikeSlip, fracNormal, fracReverse, false);
        System.out.println("num rups =" + src.getNumRuptures() + "\ttotProb=" + src.computeTotalProb());
        System.out.println("Rupture mags and end locs:");
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            System.out.println(r + "\t" + (float)rup.getMag() + "\t" + rup.getAveRake() + "\t" + rup.getProbability());
        }
    }
}

