/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.NSHMP_CEUS08;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.NSHMP_CEUS08.CEUS_Point2Vert_FaultPoisSource;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class NSHMP_CEUS_SourceGenerator
extends GriddedRegion {
    private static final WC1994_MagLengthRelationship magLenRel = new WC1994_MagLengthRelationship();
    private static final String PATH = "org" + File.separator + "opensha" + File.separator + "sha" + File.separator + "earthquake" + File.separator + "rupForecastImpl" + File.separator + "NSHMP_CEUS08" + File.separator + "inputFiles" + File.separator;
    private double MIN_MAG = 5.0;
    private double DELTA_MAG = 0.1;
    private double MAX_MAG_DEFAULT = 7.0;
    private double DEFAULT_B_VALUE = 0.95;
    double[] adapt_cn_vals;
    double[] adapt_cy_vals;
    double[] gb_vals;
    double[] gm_ab_6p6_7p1_vals;
    double[] gm_ab_6p8_7p3_vals;
    double[] gm_ab_7p0_7p5_vals;
    double[] gm_ab_7p2_7p7_vals;
    double[] gm_j_6p6_7p1_vals;
    double[] gm_j_6p8_7p3_vals;
    double[] gm_j_7p0_7p5_vals;
    double[] gm_j_7p2_7p7_vals;
    double[] agrd_chrls3_6p8_vals;
    double[] agrd_chrls3_7p1_vals;
    double[] agrd_chrls3_7p3_vals;
    double[] agrd_chrls3_7p5_vals;
    double[] charlnA_vals;
    double[] charlnB_vals;
    double[] charlnarrow_vals;
    double[] charnCagrid1008_vals;
    int[] locIndexForSource;
    int[] locIndexForCharlSources;
    double lastCharlDuration = -10.0;
    int lastCharlType = -1;
    double charlestonStrike = 20.0;
    double ptSrcMagCutOff = 6.0;
    double fracStrikeSlip = 1.0;
    double fracNormal = 0.0;
    double fracReverse = 0.0;
    ArrayList<ProbEqkSource> CharlSources;

    public NSHMP_CEUS_SourceGenerator() {
        super(new Location(24.6, -115.0), new Location(50.0, -65.0), 0.1, new Location(0.0, 0.0));
        this.readAllGridFiles();
        this.mkLocIndexForSource();
        this.mkLocIndexForCharlSources();
    }

    public int getNumSources() {
        return this.locIndexForSource.length;
    }

    private void readAllGridFiles() {
        this.adapt_cn_vals = this.readGridFile(PATH + "adapt_cn_vals.txt");
        this.adapt_cy_vals = this.readGridFile(PATH + "adapt_cy_vals.txt");
        this.gb_vals = this.readGridFile(PATH + "gb_vals.txt");
        this.gm_ab_6p6_7p1_vals = this.readGridFile(PATH + "gm_ab_6p6_7p1_vals.txt");
        this.gm_ab_6p8_7p3_vals = this.readGridFile(PATH + "gm_ab_6p8_7p3_vals.txt");
        this.gm_ab_7p0_7p5_vals = this.readGridFile(PATH + "gm_ab_7p0_7p5_vals.txt");
        this.gm_ab_7p2_7p7_vals = this.readGridFile(PATH + "gm_ab_7p2_7p7_vals.txt");
        this.gm_j_6p6_7p1_vals = this.readGridFile(PATH + "gm_j_6p6_7p1_vals.txt");
        this.gm_j_6p8_7p3_vals = this.readGridFile(PATH + "gm_j_6p8_7p3_vals.txt");
        this.gm_j_7p0_7p5_vals = this.readGridFile(PATH + "gm_j_7p0_7p5_vals.txt");
        this.gm_j_7p2_7p7_vals = this.readGridFile(PATH + "gm_j_7p2_7p7_vals.txt");
        this.agrd_chrls3_6p8_vals = this.readGridFile(PATH + "agrd_chrls3_6p8_vals.txt");
        this.agrd_chrls3_7p1_vals = this.readGridFile(PATH + "agrd_chrls3_7p1_vals.txt");
        this.agrd_chrls3_7p3_vals = this.readGridFile(PATH + "agrd_chrls3_7p3_vals.txt");
        this.agrd_chrls3_7p5_vals = this.readGridFile(PATH + "agrd_chrls3_7p5_vals.txt");
        this.charlnA_vals = this.readGridFile(PATH + "charlnA_vals.txt");
        this.charlnB_vals = this.readGridFile(PATH + "charlnB_vals.txt");
        this.charlnarrow_vals = this.readGridFile(PATH + "charlnarrow_vals.txt");
        this.charnCagrid1008_vals = this.readGridFile(PATH + "charnCagrid1008_vals.txt");
    }

    public double[] readGridFile(String fileName) {
        double[] allGridVals = new double[this.getNodeCount()];
        try {
            InputStreamReader ratesFileReader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(fileName));
            BufferedReader ratesFileBufferedReader = new BufferedReader(ratesFileReader);
            for (int line = 0; line < this.getNodeCount(); ++line) {
                String lineString = ratesFileBufferedReader.readLine();
                StringTokenizer st = new StringTokenizer(lineString);
                double lon = Double.valueOf(st.nextToken());
                double lat = Double.valueOf(st.nextToken());
                double val = Double.valueOf(st.nextToken());
                int index = this.indexForLocation(new Location(lat, lon));
                if (index == -1) {
                    System.err.println("Offending line: " + lineString);
                    throw new RuntimeException("Error in getting index for " + fileName + " (line " + line + ")");
                }
                allGridVals[index] = val;
            }
            ratesFileBufferedReader.close();
            ratesFileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allGridVals;
    }

    public double getMaxMagAtLoc(int locIndex) {
        double mag = this.gm_ab_6p8_7p3_vals[locIndex];
        double maxMagAtLoc = this.gm_ab_6p6_7p1_vals[locIndex];
        if (mag > maxMagAtLoc) {
            maxMagAtLoc = mag;
        }
        if ((mag = this.gm_ab_7p0_7p5_vals[locIndex]) > maxMagAtLoc) {
            maxMagAtLoc = mag;
        }
        if ((mag = this.gm_ab_7p2_7p7_vals[locIndex]) > maxMagAtLoc) {
            maxMagAtLoc = mag;
        }
        if ((mag = this.gm_j_6p6_7p1_vals[locIndex]) > maxMagAtLoc) {
            maxMagAtLoc = mag;
        }
        if ((mag = this.gm_j_6p8_7p3_vals[locIndex]) > maxMagAtLoc) {
            maxMagAtLoc = mag;
        }
        if ((mag = this.gm_j_7p0_7p5_vals[locIndex]) > maxMagAtLoc) {
            maxMagAtLoc = mag;
        }
        if ((mag = this.gm_j_7p2_7p7_vals[locIndex]) > maxMagAtLoc) {
            maxMagAtLoc = mag;
        }
        if (maxMagAtLoc >= 5.0) {
            return maxMagAtLoc;
        }
        return this.MAX_MAG_DEFAULT;
    }

    public double convertMbToMw(double mb, int typeConversion) {
        if (typeConversion == 3) {
            return 1.14 + 0.24 * mb + 0.0933 * mb * mb;
        }
        if (typeConversion == 4) {
            return 2.715 - 0.277 * mb + 0.127 * mb * mb;
        }
        throw new RuntimeException("that conversion type is not supported");
    }

    public ArbDiscrEmpiricalDistFunc getTotMFD_atLoc(int locIndex) {
        double mag;
        double rate;
        int i;
        double maxMagAtLoc = this.getMaxMagAtLoc(locIndex);
        int numMags = (int)Math.round((maxMagAtLoc - this.MIN_MAG) / this.DELTA_MAG) + 1;
        SummedMagFreqDist mfdAtLocConversion3 = new SummedMagFreqDist(this.MIN_MAG, maxMagAtLoc, numMags);
        SummedMagFreqDist mfdAtLocConversion4 = new SummedMagFreqDist(this.MIN_MAG, maxMagAtLoc, numMags);
        boolean allValuesZero = true;
        if (this.adapt_cn_vals[locIndex] > 0.0) {
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_6p6_7p1_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.01667), true);
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_6p8_7p3_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.0333), true);
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_7p0_7p5_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.08333), true);
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_7p2_7p7_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.0333), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_6p6_7p1_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.01667), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_6p8_7p3_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.0333), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_7p0_7p5_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.08333), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_7p2_7p7_vals[locIndex], this.adapt_cn_vals[locIndex], this.gb_vals[locIndex], 0.0333), true);
            allValuesZero = false;
        }
        if (this.adapt_cy_vals[locIndex] > 0.0) {
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_6p6_7p1_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.0333), true);
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_6p8_7p3_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.0667), true);
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_7p0_7p5_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.16667), true);
            mfdAtLocConversion4.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_ab_7p2_7p7_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.0667), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_6p6_7p1_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.0333), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_6p8_7p3_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.0667), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_7p0_7p5_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.16667), true);
            mfdAtLocConversion3.addResampledMagFreqDist(this.getMFD(this.MIN_MAG, this.gm_j_7p2_7p7_vals[locIndex], this.adapt_cy_vals[locIndex], this.gb_vals[locIndex], 0.0667), true);
            allValuesZero = false;
        }
        if (allValuesZero) {
            return null;
        }
        ArbDiscrEmpiricalDistFunc mfdAtLoc = new ArbDiscrEmpiricalDistFunc();
        for (i = 0; i < mfdAtLocConversion4.size(); ++i) {
            rate = mfdAtLocConversion4.getY(i);
            if (!(rate > 0.0)) continue;
            mag = this.convertMbToMw(mfdAtLocConversion4.getX(i), 4);
            mfdAtLoc.set(mag, rate);
        }
        for (i = 0; i < mfdAtLocConversion3.size(); ++i) {
            rate = mfdAtLocConversion3.getY(i);
            if (!(rate > 0.0)) continue;
            mag = this.convertMbToMw(mfdAtLocConversion3.getX(i), 3);
            mfdAtLoc.set(mag, rate);
        }
        return mfdAtLoc;
    }

    public ArbIncrementalMagFreqDist getTotCharl_MFD_atLoc(int locIndex) {
        double mMin = 6.8;
        double mMax = 7.5;
        int numMags = (int)Math.round((mMax - mMin) / this.DELTA_MAG) + 1;
        ArbIncrementalMagFreqDist mfdAtLoc = new ArbIncrementalMagFreqDist(mMin, mMax, numMags);
        double rate = 0.1 * (this.agrd_chrls3_6p8_vals[locIndex] + this.charnCagrid1008_vals[locIndex]) * Math.pow(10.0, -6.8);
        mfdAtLoc.set(6.8, rate);
        rate = 0.1 * (this.agrd_chrls3_7p1_vals[locIndex] + this.charlnA_vals[locIndex]) * Math.pow(10.0, -7.1);
        mfdAtLoc.set(7.1, rate);
        rate = 0.225 * (this.agrd_chrls3_7p3_vals[locIndex] + this.charlnarrow_vals[locIndex]) * Math.pow(10.0, -7.3);
        mfdAtLoc.set(7.3, rate);
        rate = 0.075 * (this.agrd_chrls3_7p5_vals[locIndex] + this.charlnB_vals[locIndex]) * Math.pow(10.0, -7.5);
        mfdAtLoc.set(7.5, rate);
        return mfdAtLoc;
    }

    public GutenbergRichterMagFreqDist getMFD(double minMag, double maxMag, double aValue, double bValue, double weight) {
        if (maxMag < 5.0) {
            maxMag = this.MAX_MAG_DEFAULT;
        }
        double b_val = bValue == 0.0 ? this.DEFAULT_B_VALUE : bValue;
        int numMag = Math.round((float)(((maxMag -= this.DELTA_MAG / 2.0) - (minMag += this.DELTA_MAG / 2.0)) / this.DELTA_MAG + 1.0));
        GutenbergRichterMagFreqDist mfd = new GutenbergRichterMagFreqDist(minMag, numMag, this.DELTA_MAG, 1.0, b_val);
        mfd.scaleToIncrRate(minMag, weight * aValue * Math.pow(10.0, -bValue * minMag));
        return mfd;
    }

    private void mkLocIndexForSource() {
        int i;
        ArrayList<Integer> tempArrayList = new ArrayList<Integer>();
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.adapt_cn_vals[i] + this.adapt_cy_vals[i] > 0.0)) continue;
            tempArrayList.add(i);
        }
        this.locIndexForSource = new int[tempArrayList.size()];
        for (i = 0; i < tempArrayList.size(); ++i) {
            this.locIndexForSource[i] = (Integer)tempArrayList.get(i);
        }
    }

    public ArrayList<ProbEqkSource> getCharlestonSourceList(double duration, int type) {
        if (this.lastCharlDuration == duration && this.lastCharlType == type) {
            return this.CharlSources;
        }
        this.CharlSources = new ArrayList();
        for (int s = 0; s < this.locIndexForCharlSources.length; ++s) {
            int locIndex = this.locIndexForCharlSources[s];
            ArbIncrementalMagFreqDist mfdAtLoc = this.getTotCharl_MFD_atLoc(locIndex);
            if (type == 0) {
                this.CharlSources.add(new CEUS_Point2Vert_FaultPoisSource(this.locationForIndex(locIndex), (DiscretizedFunc)mfdAtLoc, (MagLengthRelationship)magLenRel, this.charlestonStrike, duration, 10.0, this.fracStrikeSlip, this.fracNormal, this.fracReverse));
                continue;
            }
            if (type == 1) {
                this.CharlSources.add(new CEUS_Point2Vert_FaultPoisSource(this.locationForIndex(locIndex), (DiscretizedFunc)mfdAtLoc, (MagLengthRelationship)magLenRel, this.charlestonStrike, duration, this.ptSrcMagCutOff, this.fracStrikeSlip, this.fracNormal, this.fracReverse));
                continue;
            }
            this.CharlSources.add(new CEUS_Point2Vert_FaultPoisSource(this.locationForIndex(locIndex), (DiscretizedFunc)mfdAtLoc, (MagLengthRelationship)magLenRel, this.charlestonStrike, duration, this.ptSrcMagCutOff, this.fracStrikeSlip, this.fracNormal, this.fracReverse));
        }
        return this.CharlSources;
    }

    private void mkLocIndexForCharlSources() {
        int i;
        ArrayList<Integer> tempArrayList = new ArrayList<Integer>();
        for (i = 0; i < this.getNodeCount(); ++i) {
            double rate = this.agrd_chrls3_6p8_vals[i] + this.agrd_chrls3_7p1_vals[i] + this.agrd_chrls3_7p3_vals[i] + this.agrd_chrls3_7p5_vals[i] + this.charlnA_vals[i] + this.charlnB_vals[i] + this.charlnarrow_vals[i] + this.charnCagrid1008_vals[i];
            if (!(rate > 0.0)) continue;
            tempArrayList.add(i);
        }
        this.locIndexForCharlSources = new int[tempArrayList.size()];
        for (i = 0; i < tempArrayList.size(); ++i) {
            this.locIndexForSource[i] = (Integer)tempArrayList.get(i);
        }
    }

    public void test() {
        int i;
        System.out.println("num Locs: " + this.getNodeCount());
        int num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.agrd_chrls3_6p8_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
        num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.agrd_chrls3_7p1_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
        num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.agrd_chrls3_7p3_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
        num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.agrd_chrls3_7p5_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
        num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.charlnA_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
        num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.charlnB_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
        num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.charlnarrow_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
        num = 0;
        for (i = 0; i < this.getNodeCount(); ++i) {
            if (!(this.charnCagrid1008_vals[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("char num: " + num);
    }

    public ProbEqkSource getRandomStrikeGriddedSource(int srcIndex, double duration) {
        int locIndex = this.locIndexForSource[srcIndex];
        ArbDiscrEmpiricalDistFunc mfdAtLoc = this.getTotMFD_atLoc(locIndex);
        return new CEUS_Point2Vert_FaultPoisSource(this.locationForIndex(locIndex), (DiscretizedFunc)mfdAtLoc, (MagLengthRelationship)magLenRel, duration, this.ptSrcMagCutOff, this.fracStrikeSlip, this.fracNormal, this.fracReverse, false);
    }

    public ProbEqkSource getPointGriddedSource(int srcIndex, double duration) {
        int locIndex = this.locIndexForSource[srcIndex];
        ArbDiscrEmpiricalDistFunc mfdAtLoc = this.getTotMFD_atLoc(locIndex);
        double magCutoff = 10.0;
        return new CEUS_Point2Vert_FaultPoisSource(this.locationForIndex(locIndex), (DiscretizedFunc)mfdAtLoc, (MagLengthRelationship)magLenRel, duration, magCutoff, this.fracStrikeSlip, this.fracNormal, this.fracReverse, false);
    }

    public ProbEqkSource getCrosshairGriddedSource(int srcIndex, double duration) {
        int locIndex = this.locIndexForSource[srcIndex];
        ArbDiscrEmpiricalDistFunc mfdAtLoc = this.getTotMFD_atLoc(locIndex);
        return new CEUS_Point2Vert_FaultPoisSource(this.locationForIndex(locIndex), (DiscretizedFunc)mfdAtLoc, (MagLengthRelationship)magLenRel, duration, this.ptSrcMagCutOff, this.fracStrikeSlip, this.fracNormal, this.fracReverse, true);
    }

    public static void main(String[] args) {
        try {
            NSHMP_CEUS_SourceGenerator srcGen = new NSHMP_CEUS_SourceGenerator();
            ProbEqkSource src = srcGen.getCrosshairGriddedSource(60000, 50.0);
            System.out.print(src.getName());
            srcGen.getCharlestonSourceList(30.0, 0);
            srcGen.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

