/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.NewZealand;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.rupForecastImpl.NewZealand.NewZealandERF2010;
import org.opensha.sha.util.TectonicRegionType;

public class NewZealandERF2010_Epistemic
extends AbstractEpistemicListERF {
    public static final String NAME = new String("NewZealand_ERF_2010_Epistemic");
    protected NewZealandERF2010 newZealand2010ERF = new NewZealandERF2010();
    private static final double DURATION_DEFAULT = 1.0;
    public static final String FAULT_AND_BACK_SEIS_NAME = new String("Background and Fault Seismicity");
    public static final String FAULT_AND_BACK_SEIS = new String("Fault and Background Sources");
    public static final String FAULT_SEIS_ONLY = new String("Fault Sources Only");
    public static final String BACK_SEIS_ONLY = new String("Background Sources Only");
    private StringParameter backSeisParam;
    public static final String EPISTEMIC_PARAM_NAME = "Consider Epistemic Uncertainties";
    private static final String EPISTEMIC_PARAM_INFO = "Consideration of Epistemic Uncertainties";
    private static final Boolean EPISTEMIC_PARAM_DEFAULT = true;
    private BooleanParameter epistemicParam;
    public static final String EPISTEMIC_GEOMETRY_PARAM_NAME = "Epistemic Uncertainties in fault length, depth";
    private static final String EPISTEMIC_GEOMETRY_PARAM_INFO = "Epistemic Uncertainties in fault length, depth";
    private static final Boolean EPISTEMIC_GEOMETRY_PARAM_DEFAULT = true;
    private BooleanParameter epistemicGeometryParam;
    public static final String EPISTEMIC_DIP_PARAM_NAME = "Epistemic Uncertainties in fault dip";
    private static final String EPISTEMIC_DIP_PARAM_INFO = "Epistemic Uncertainties in fault dip";
    private static final Boolean EPISTEMIC_DIP_PARAM_DEFAULT = true;
    private BooleanParameter epistemicDipParam;
    public static final String EPISTEMIC_SLIP_PARAM_NAME = "Epistemic Uncertainties in fault slip rate and coupling";
    private static final String EPISTEMIC_SLIP_PARAM_INFO = "Epistemic Uncertainties in fault slip rate and coupling";
    private static final Boolean EPISTEMIC_SLIP_PARAM_DEFAULT = true;
    private BooleanParameter epistemicSlipParam;
    public static final String EPISTEMIC_MAGSCALING_PARAM_NAME = "Epistemic Uncertainties in Magnitude Scaling Relations";
    private static final String EPISTEMIC_MAGSCALING_PARAM_INFO = "Epistemic Uncertainties in Magnitude Scaling Relations";
    private static final Boolean EPISTEMIC_MAGSCALING_PARAM_DEFAULT = true;
    private BooleanParameter epistemicMagScalingParam;
    public static final String EPISTEMIC_MAGSCALINGCORRELATION_PARAM_NAME = "Correlation of Epistemic Uncertainties in Mw Scaling on faults";
    private static final String EPISTEMIC_MAGSCALINGCORRELATION_PARAM_INFO = "Correlation of Epistemic Uncertainties in Mw Scaling on faults";
    private static final double EPISTEMIC_MAGSCALINGCORRELATION_PARAM_DEFAULT = 0.5;
    private DoubleParameter epistemicMagScalingCorrelationParam;
    public static final String EPISTEMIC_MAGSCALINGPROPORTION_PARAM_NAME = "Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)";
    private static final String EPISTEMIC_MAGSCALINGPROPORTION_PARAM_INFO = "Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)";
    private static final double EPISTEMIC_MAGSCALINGPROPORTION_PARAM_DEFAULT = 0.5;
    private DoubleParameter epistemicMagScalingUncertaintyProportionParam;
    private static final String NUM_REALIZATIONS_PARAM_NAME = "Num Realizations";
    private Integer DEFAULT_NUM_REALIZATIONS_VAL = 100;
    private int NUM_REALIZATIONS_MIN = 1;
    private int NUM_REALIZATIONS_MAX = 10000;
    private static final String NUM_REALIZATIONS_PARAM_INFO = "Number of Monte Carlo ERF realizations";
    IntegerParameter numRealizationsParam = new IntegerParameter("Num Realizations", this.NUM_REALIZATIONS_MIN, this.NUM_REALIZATIONS_MAX, this.DEFAULT_NUM_REALIZATIONS_VAL);

    public NewZealandERF2010_Epistemic() {
        this.numRealizationsParam.setInfo(NUM_REALIZATIONS_PARAM_INFO);
        this.initAdjParams();
        this.newZealand2010ERF.setAdjParams(this.adjustableParams);
        this.createParamList();
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(1.0);
    }

    private void initAdjParams() {
        ArrayList<String> backSeisOptionsStrings = new ArrayList<String>();
        backSeisOptionsStrings.add(FAULT_AND_BACK_SEIS);
        backSeisOptionsStrings.add(FAULT_SEIS_ONLY);
        backSeisOptionsStrings.add(BACK_SEIS_ONLY);
        this.backSeisParam = new StringParameter(FAULT_AND_BACK_SEIS_NAME, backSeisOptionsStrings, FAULT_AND_BACK_SEIS);
        this.backSeisParam.addParameterChangeListener(this);
        this.epistemicParam = new BooleanParameter(EPISTEMIC_PARAM_NAME, EPISTEMIC_PARAM_DEFAULT);
        this.epistemicParam.setInfo(EPISTEMIC_PARAM_INFO);
        this.epistemicParam.addParameterChangeListener(this);
        this.epistemicGeometryParam = new BooleanParameter("Epistemic Uncertainties in fault length, depth", EPISTEMIC_GEOMETRY_PARAM_DEFAULT);
        this.epistemicGeometryParam.setInfo("Epistemic Uncertainties in fault length, depth");
        this.epistemicGeometryParam.addParameterChangeListener(this);
        this.epistemicDipParam = new BooleanParameter("Epistemic Uncertainties in fault dip", EPISTEMIC_DIP_PARAM_DEFAULT);
        this.epistemicDipParam.setInfo("Epistemic Uncertainties in fault dip");
        this.epistemicDipParam.addParameterChangeListener(this);
        this.epistemicSlipParam = new BooleanParameter("Epistemic Uncertainties in fault slip rate and coupling", EPISTEMIC_SLIP_PARAM_DEFAULT);
        this.epistemicSlipParam.setInfo("Epistemic Uncertainties in fault slip rate and coupling");
        this.epistemicSlipParam.addParameterChangeListener(this);
        this.epistemicMagScalingParam = new BooleanParameter("Epistemic Uncertainties in Magnitude Scaling Relations", EPISTEMIC_MAGSCALING_PARAM_DEFAULT);
        this.epistemicMagScalingParam.setInfo("Epistemic Uncertainties in Magnitude Scaling Relations");
        this.epistemicMagScalingParam.addParameterChangeListener(this);
        this.epistemicMagScalingCorrelationParam = new DoubleParameter("Correlation of Epistemic Uncertainties in Mw Scaling on faults", EPISTEMIC_MAGSCALINGCORRELATION_PARAM_DEFAULT);
        this.epistemicMagScalingCorrelationParam.setInfo("Correlation of Epistemic Uncertainties in Mw Scaling on faults");
        this.epistemicMagScalingCorrelationParam.addParameterChangeListener(this);
        this.epistemicMagScalingUncertaintyProportionParam = new DoubleParameter("Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)", EPISTEMIC_MAGSCALINGPROPORTION_PARAM_DEFAULT);
        this.epistemicMagScalingUncertaintyProportionParam.setInfo("Proportion of Mw Scaling Unc considered as epistemic (remaining aleatory)");
        this.epistemicMagScalingUncertaintyProportionParam.addParameterChangeListener(this);
    }

    protected void createParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.numRealizationsParam);
        this.adjustableParams.addParameter(this.backSeisParam);
        this.adjustableParams.addParameter(this.epistemicParam);
        if (((Boolean)this.epistemicParam.getValue()).booleanValue()) {
            this.adjustableParams.addParameter(this.epistemicGeometryParam);
            this.adjustableParams.addParameter(this.epistemicDipParam);
            this.adjustableParams.addParameter(this.epistemicSlipParam);
            this.adjustableParams.addParameter(this.epistemicMagScalingParam);
            if (((Boolean)this.epistemicMagScalingParam.getValue()).booleanValue()) {
                this.adjustableParams.addParameter(this.epistemicMagScalingCorrelationParam);
                this.adjustableParams.addParameter(this.epistemicMagScalingUncertaintyProportionParam);
            }
        }
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        return this.newZealand2010ERF.getTectonicRegionTypes();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
        this.createParamList();
        this.newZealand2010ERF.setAdjParams(this.adjustableParams);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumERFs() {
        return (Integer)this.numRealizationsParam.getValue();
    }

    public ArrayList getRelativeWeightsList() {
        ArrayList<Double> weightList = new ArrayList<Double>();
        int numERFs = this.getNumERFs();
        for (int i = 0; i < numERFs; ++i) {
            weightList.add(this.getERF_RelativeWeight(i));
        }
        return weightList;
    }

    @Override
    public ERF getERF(int index) {
        this.newZealand2010ERF.getTimeSpan().setDuration(this.timeSpan.getDuration());
        this.newZealand2010ERF.updateForecast();
        return this.newZealand2010ERF;
    }

    @Override
    public double getERF_RelativeWeight(int index) {
        return 1.0;
    }

    public static void main(String[] args) {
        NewZealandERF2010_Epistemic nzEpistemicList = new NewZealandERF2010_Epistemic();
        int numERFs = nzEpistemicList.getNumERFs();
        System.out.println("Num Branches=" + numERFs);
        for (int i = 0; i < 5; ++i) {
            nzEpistemicList.getERF(i);
        }
    }
}

