/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.SiteAdaptiveSource;
import org.opensha.sha.earthquake.util.GridCellSuperSamplingPoissonPointSourceData;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.faultSurface.FiniteApproxPointSurface;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.faultSurface.utils.PointSurfaceBuilder;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;
import org.opensha.sha.util.TectonicRegionType;

public class PointSourceNshm
extends PointSource.PoissonPointSource {
    private static final String NAME = "NSHMP Point Source";
    public static final double M_DEPTH_CUT_DEFAULT = 6.5;
    public static final double DEPTH_BELOW_M_CUT_DEFAULT = 5.0;
    public static final double DEPTH_ABOVE_M_CUT_DEFAULT = 1.0;
    private static final SurfaceBuilder SURF_BUILDER_DEFAULT = new SurfaceBuilder(6.5, 5.0, 1.0);
    private static final MagLengthRelationship WC94 = new WC1994_MagLengthRelationship();
    private static final Splitter SPLITTER = Splitter.on((String)" ").omitEmptyStrings().trimResults();
    private static final String MAG_ID = "#Mag";
    private static final String COMMENT_ID = "#";
    private static final double RJB_M_MIN = 6.05;
    private static final double RJB_M_CUTOFF = 6.0;
    private static final double RJB_M_DELTA = 0.1;
    private static final int RJB_M_SIZE = 26;
    private static final int RJB_M_MAX_INDEX = 25;
    private static final int RJB_R_SIZE = 1001;
    private static final int RJB_R_MAX_INDEX = 1000;
    private static final String RJB_DAT_DIR = "data/nshmp/";
    private static final double[][] RJB_WC94LENGTH = PointSourceNshm.readRjb("rjb_wc94length.dat");

    public PointSourceNshm(Location loc, IncrementalMagFreqDist mfd, double duration, Map<FocalMech, Double> mechWtMap, WeightedList<PointSourceDistanceCorrection> distCorrs) {
        this(loc, mfd, duration, mechWtMap, SURF_BUILDER_DEFAULT, distCorrs, null);
    }

    public PointSourceNshm(Location loc, IncrementalMagFreqDist mfd, double duration, Map<FocalMech, Double> mechWtMap, double magCut, double depthBelowMagCut, double depthAboveMagCut, WeightedList<PointSourceDistanceCorrection> distCorrs) {
        this(loc, mfd, duration, mechWtMap, new SurfaceBuilder(magCut, depthBelowMagCut, depthAboveMagCut), distCorrs, null);
    }

    private PointSourceNshm(Location loc, IncrementalMagFreqDist mfd, double duration, Map<FocalMech, Double> mechWtMap, SurfaceBuilder surfaceBuilder, WeightedList<PointSourceDistanceCorrection> distCorrs, GridCellSupersamplingSettings supersamplingSettings) {
        super(loc, TectonicRegionType.ACTIVE_SHALLOW, duration, PointSourceNshm.buildData(loc, mfd, mechWtMap, surfaceBuilder, supersamplingSettings), distCorrs);
        this.name = NAME;
    }

    private static PointSource.PoissonPointSourceData buildData(Location loc, IncrementalMagFreqDist mfd, Map<FocalMech, Double> mechWtMap, SurfaceBuilder surfaceBuilder, GridCellSupersamplingSettings supersamplingSettings) {
        PointSource.PoissonPointSourceData data = PointSource.dataForMFDs(loc, mfd, PointSourceNshm.weightsMap(mechWtMap), surfaceBuilder);
        if (supersamplingSettings != null) {
            Preconditions.checkState((PointSourceNshm.multipleOf0p1(loc.lat) && PointSourceNshm.multipleOf0p1(loc.lon) ? 1 : 0) != 0, (String)"Assuming gridding of 0.1 degrees for supersampling, but not all locations are on a 0.1 degree grid: %s", (Object)loc);
            Region cell = new Region(new Location(loc.lat - 0.05, loc.lon - 0.05), new Location(loc.lat + 0.05, loc.lon + 0.05));
            data = new GridCellSuperSamplingPoissonPointSourceData(data, loc, cell, supersamplingSettings);
        }
        return data;
    }

    private static boolean multipleOf0p1(double number) {
        double factor = number / 0.1;
        double roundedFactor = Math.round(factor);
        double reconstructed = roundedFactor * 0.1;
        return Math.abs(number - reconstructed) < 0.001;
    }

    private static Map<FocalMechanism, Double> weightsMap(Map<FocalMech, Double> map) {
        HashMap<FocalMechanism, Double> ret = new HashMap<FocalMechanism, Double>(map.size());
        for (FocalMech mech : map.keySet()) {
            ret.put(mech.mechanism, map.get((Object)mech));
        }
        return ret;
    }

    static double[][] readRjb(String resource) {
        double[][] rjbs = new double[26][1001];
        URL url = Resources.getResource((String)(RJB_DAT_DIR + resource));
        List lines = null;
        try {
            lines = Resources.readLines((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        int magIndex = -1;
        int rIndex = 0;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            if (line.startsWith(MAG_ID)) {
                ++magIndex;
                rIndex = 0;
                continue;
            }
            if (line.startsWith(COMMENT_ID)) continue;
            rjbs[magIndex][rIndex++] = PointSourceNshm.readDouble(line, 1);
        }
        return rjbs;
    }

    private static double readDouble(String s, int position) {
        return Double.valueOf((String)Iterables.get((Iterable)SPLITTER.split((CharSequence)s), (int)position));
    }

    private static class SurfaceBuilder
    implements PointSource.FocalMechRuptureSurfaceBuilder {
        private double depthBelowMagCut;
        private double depthAboveMagCut;
        private double magCut;

        private SurfaceBuilder(double magCut, double depthBelowMagCut, double depthAboveMagCut) {
            this.magCut = magCut;
            this.depthBelowMagCut = depthBelowMagCut;
            this.depthAboveMagCut = depthAboveMagCut;
        }

        @Override
        public int getNumSurfaces(double magnitude, FocalMech mech) {
            return mech == FocalMech.STRIKE_SLIP ? 1 : 2;
        }

        @Override
        public RuptureSurface getSurface(Location loc, double magnitude, FocalMech mech, int surfaceIndex) {
            Preconditions.checkState((surfaceIndex < 2 ? 1 : 0) != 0);
            double zTop = this.depthForMag(magnitude);
            double dipRad = mech.dip() * GeoTools.TO_RAD;
            double widthDD = SurfaceBuilder.calcWidth(magnitude, zTop, dipRad);
            PointSurfaceBuilder builder = new PointSurfaceBuilder(loc);
            builder.upperDepthWidthAndDip(zTop, widthDD, mech.dip());
            builder.footwall(surfaceIndex == 0);
            builder.magnitude(magnitude);
            return builder.buildFiniteApproxPointSurface();
        }

        @Override
        public double getSurfaceWeight(double magnitude, FocalMech mech, int surfaceIndex) {
            return mech == FocalMech.STRIKE_SLIP ? 1.0 : 0.5;
        }

        @Override
        public boolean isSurfaceFinite(double magnitude, FocalMech mech, int surfaceIndex) {
            return false;
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface) {
            Preconditions.checkState((boolean)(rupSurface instanceof FiniteApproxPointSurface));
            double depth = 0.5 * (rupSurface.getAveRupTopDepth() + ((FiniteApproxPointSurface)rupSurface).getLowerDepth());
            return new Location(sourceLoc.lat, sourceLoc.lon, depth);
        }

        private double depthForMag(double mag) {
            return mag >= this.magCut ? this.depthAboveMagCut : this.depthBelowMagCut;
        }

        private static double calcWidth(double mag, double depth, double dipRad) {
            double length = WC94.getMedianLength(mag);
            double aspectWidth = length / 1.5;
            double ddWidth = (14.0 - depth) / Math.sin(dipRad);
            return Math.min(aspectWidth, ddWidth);
        }
    }

    public static class DistanceCorrection2013
    implements PointSourceDistanceCorrection {
        @Override
        public double getCorrectedDistanceJB(double mag, PointSurface surf, double horzDist) {
            if (mag < 6.0) {
                return horzDist;
            }
            int mIndex = Math.min((int)Math.round((mag - 6.05) / 0.1), 25);
            int rIndex = Math.min(1000, (int)Math.floor(horzDist));
            return RJB_WC94LENGTH[mIndex][rIndex];
        }

        public String toString() {
            return "USGS NSHM (2013)";
        }
    }

    public static class Supersampled
    extends PointSourceNshm
    implements SiteAdaptiveSource {
        private PointSource.SiteAdaptivePointSourceData<PointSource.PoissonPointSourceData> adaptiveData;
        private ConcurrentMap<PointSource.PoissonPointSourceData, PointSource.PoissonPointSource> sourceCache;

        public Supersampled(Location loc, IncrementalMagFreqDist mfd, double duration, Map<FocalMech, Double> mechWtMap, WeightedList<PointSourceDistanceCorrection> distCorrs, GridCellSupersamplingSettings supersamplingSettings) {
            super(loc, mfd, duration, mechWtMap, SURF_BUILDER_DEFAULT, distCorrs, supersamplingSettings);
            this.initAdaptive();
        }

        public Supersampled(Location loc, IncrementalMagFreqDist mfd, double duration, Map<FocalMech, Double> mechWtMap, double magCut, double depthBelowMagCut, double depthAboveMagCut, WeightedList<PointSourceDistanceCorrection> distCorrs, GridCellSupersamplingSettings supersamplingSettings) {
            super(loc, mfd, duration, mechWtMap, new SurfaceBuilder(magCut, depthBelowMagCut, depthAboveMagCut), distCorrs, supersamplingSettings);
            this.initAdaptive();
        }

        private void initAdaptive() {
            Preconditions.checkState((boolean)(this.data instanceof PointSource.SiteAdaptivePointSourceData));
            this.adaptiveData = (PointSource.SiteAdaptivePointSourceData)this.data;
            this.sourceCache = new ConcurrentHashMap<PointSource.PoissonPointSourceData, PointSource.PoissonPointSource>();
        }

        @Override
        public ProbEqkSource getForSite(Site site) {
            PointSource.PoissonPointSourceData dataForSite = this.adaptiveData.getForSite(site);
            if (dataForSite == this.adaptiveData) {
                return this;
            }
            PointSource.PoissonPointSource ret = (PointSource.PoissonPointSource)this.sourceCache.get(dataForSite);
            if (ret != null) {
                return ret;
            }
            ret = new PointSource.PoissonPointSource(this.getLocation(), this.getTectonicRegionType(), this.getDuration(), dataForSite, this.getDistCorrs());
            this.sourceCache.putIfAbsent(dataForSite, ret);
            return ret;
        }
    }
}

