/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.PuenteHillsERF;

import java.util.ArrayList;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FaultRuptureSource;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

public class PuenteHillsFaultERF
extends AbstractERF {
    private static String C = new String("PuenteHillsFaultERF");
    private boolean D = false;
    public static final String NAME = "Puente Hills Fault ERF";
    private ArrayList sourceList;

    public PuenteHillsFaultERF() {
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.addParameterChangeListener(this);
        FaultTrace faultTrace = new FaultTrace("Puente Hills Fault Trace");
        double latIncr = 2.0 / (Math.tan(0.47123889803846897) * 111.0);
        if (this.D) {
            System.out.println(NAME + ": latIncr = " + latIncr);
        }
        if (this.D) {
            System.out.println(NAME + ": fault trace name = " + faultTrace.getName());
        }
        faultTrace.add(new Location(33.8995 + latIncr, -117.868, 5.0));
        faultTrace.add(new Location(33.9122 + latIncr, -118.029, 5.0));
        faultTrace.add(new Location(33.9381 + latIncr, -118.133, 5.0));
        faultTrace.add(new Location(34.02 + latIncr, -118.308, 5.0));
        if (this.D) {
            System.out.println(NAME + " num fault trace points = " + faultTrace.size());
        }
        double aveDipDir = 0.0;
        StirlingGriddedSurface surface = new StirlingGriddedSurface(faultTrace, 27.0, 5.0, 17.0, 1.0, aveDipDir);
        double rake = 90.0;
        if (this.D) {
            System.out.println(NAME + " aveDipDir = " + aveDipDir);
        }
        if (this.D) {
            System.out.println(NAME + " rake = " + rake);
        }
        this.sourceList = new ArrayList();
        for (int mag = 71; mag <= 75; ++mag) {
            FaultRuptureSource source = new FaultRuptureSource((double)mag / 10.0, (RuptureSurface)surface, rake, 0.2);
            source.setName("mag = " + (double)mag / 10.0 + " PH fault source");
            this.sourceList.add(source);
        }
        if (this.D) {
            System.out.println("Puente Hills Fault ERF: number of sources = " + this.sourceList.size());
        }
    }

    @Override
    public void updateForecast() {
        String S = C + "updateForecast::";
        if (this.parameterChangeFlag) {
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return (FaultRuptureSource)this.sourceList.get(iSource);
    }

    @Override
    public int getNumSources() {
        return this.sourceList.size();
    }

    public ArrayList getSourceList() {
        return this.sourceList;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

