/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_Downloader;
import org.scec.getfile.GetFile;
import scratch.UCERF3.utils.UCERF3_Downloader;

public class UpdateAllERF {
    private static String[] getModels(File jsonFile) {
        String[] stringArray;
        FileReader reader = new FileReader(jsonFile);
        try {
            String[] keys;
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            stringArray = keys = jsonObject.keySet().toArray(new String[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ((Reader)reader).close();
        return stringArray;
    }

    public static CompletableFuture<Boolean> updateERF(String erfName, GetFile downloader) {
        System.out.println("Starting update for " + erfName);
        return ((CompletableFuture)downloader.updateAll().thenApply(result -> {
            System.out.println("Update completed for " + erfName + ", checking files...");
            try {
                for (String dat : UpdateAllERF.getModels(new File(System.getProperty("user.home"), ".opensha/" + erfName + "/" + erfName + ".json"))) {
                    File model = new File(System.getProperty("user.home"), ".opensha/" + erfName + "/" + dat + ".zip");
                    System.out.println("Checking if " + model.toString() + " exists...");
                    if (model.exists()) continue;
                    System.out.println(model.toString() + " is missing!");
                    return false;
                }
                System.out.println("All files verified for " + erfName);
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        })).exceptionally(throwable -> {
            System.err.println("Error updating " + erfName + ": " + throwable.getMessage());
            throwable.printStackTrace();
            return false;
        });
    }

    public static void main(String[] args) {
        boolean showProgress = false;
        ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
        futures.add(UpdateAllERF.updateERF("ucerf3", new UCERF3_Downloader(showProgress)));
        futures.add(UpdateAllERF.updateERF("nshm23", new NSHM23_Downloader(showProgress)));
        CompletableFuture<Void> allUpdates = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            allUpdates.join();
            System.out.println("All ERF updates completed!");
            boolean allSuccess = true;
            for (CompletableFuture completableFuture : futures) {
                Boolean result = (Boolean)completableFuture.get();
                if (result != null && result.booleanValue()) continue;
                allSuccess = false;
            }
            if (allSuccess) {
                System.out.println("All ERF updates completed successfully!");
            } else {
                System.err.println("Some ERF updates failed!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Error during ERF updates: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

