/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WG02;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.rupForecastImpl.WG02.WG02_EqkRupForecast;

public class WG02_ERF_Epistemic_List
extends AbstractEpistemicListERF {
    private static final String C = new String("WG02 ERF List");
    private boolean D = false;
    public static final String NAME = new String("WG02 ERF List");
    private static final String INPUT_FILE_NAME_30yr = "/data/erf/wgcep_2002/base_mod_23_wgt_n100.OpenSHA.30yr.txt";
    private static final String INPUT_FILE_NAME_20yr = "/data/erf/wgcep_2002/base_mod_23_wgt_n100.OpenSHA.20yr.txt";
    private static final String INPUT_FILE_NAME_10yr = "/data/erf/wgcep_2002/base_mod_23_wgt_n100.OpenSHA.10yr.txt";
    private static final String INPUT_FILE_NAME_5yr = "/data/erf/wgcep_2002/base_mod_23_wgt_n100.OpenSHA.5yr.txt";
    private static final String INPUT_FILE_NAME_1yr = "/data/erf/wgcep_2002/base_mod_23_wgt_n100.OpenSHA.1yr.txt";
    private String INPUT_FILE_NAME;
    private ArrayList iterationLineNumbers;
    private int numIterations;
    private double rupOffset;
    private double deltaMag;
    private double gridSpacing;
    private String backSeis;
    private String grTail;
    private ArrayList inputFileLines = null;
    public static final String BACK_SEIS_NAME = new String("Background Seismicity");
    public static final String GR_TAIL_NAME = new String("GR Tail Seismicity");
    public static final String SEIS_INCLUDE = new String("Include");
    public static final String SEIS_EXCLUDE = new String("Exclude");
    ArrayList backSeisOptionsStrings = new ArrayList();
    ArrayList grTailOptionsStrings = new ArrayList();
    StringParameter backSeisParam;
    StringParameter grTailParam;
    private static final String RUP_OFFSET_PARAM_NAME = "Rupture Offset";
    private Double DEFAULT_RUP_OFFSET_VAL = 5.0;
    private static final String RUP_OFFSET_PARAM_UNITS = "km";
    private static final String RUP_OFFSET_PARAM_INFO = "Length of offset for floating ruptures";
    private static final double RUP_OFFSET_PARAM_MIN = 1.0;
    private static final double RUP_OFFSET_PARAM_MAX = 50.0;
    DoubleParameter rupOffset_Param;
    private static final String GRID_SPACING_PARAM_NAME = "Fault Discretization";
    private Double DEFAULT_GRID_SPACING_VAL = 1.0;
    private static final String GRID_SPACING_PARAM_UNITS = "km";
    private static final String GRID_SPACING_PARAM_INFO = "Grid spacing of fault surface";
    private static final double GRID_SPACING_PARAM_MIN = 0.1;
    private static final double GRID_SPACING_PARAM_MAX = 5.0;
    DoubleParameter gridSpacing_Param;
    private static final String DELTA_MAG_PARAM_NAME = "Delta Mag";
    private Double DEFAULT_DELTA_MAG_VAL = 0.1;
    private static final String DELTA_MAG_PARAM_INFO = "Discretization of magnitude frequency distributions";
    private static final double DELTA_MAG_PARAM_MIN = 0.005;
    private static final double DELTA_MAG_PARAM_MAX = 0.5;
    DoubleParameter deltaMag_Param;
    private static final String NUM_REALIZATIONS_PARAM_NAME = "Num Realizations";
    private Integer DEFAULT_NUM_REALIZATIONS_VAL = 10;
    private int NUM_REALIZATIONS_MIN = 1;
    private int NUM_REALIZATIONS_MAX = 100;
    private static final String NUM_REALIZATIONS_PARAM_INFO = "Number of Monte Carlo ERF realizations";
    IntegerParameter numRealizationsParam;

    public WG02_ERF_Epistemic_List() {
        this.timeSpan = new TimeSpan("Years", "Years");
        ArrayList<Double> durationOptions = new ArrayList<Double>();
        durationOptions.add(1.0);
        durationOptions.add(5.0);
        durationOptions.add(10.0);
        durationOptions.add(20.0);
        durationOptions.add(30.0);
        this.timeSpan.setDurationConstraint(durationOptions);
        this.timeSpan.setStartTimeConstraint("Start Year", 2002, 2002);
        this.timeSpan.setStartTime(2002);
        this.timeSpan.setDuration(30.0);
        this.timeSpan.addParameterChangeListener(this);
        this.initAdjParams();
        this.rupOffset_Param.addParameterChangeListener(this);
        this.deltaMag_Param.addParameterChangeListener(this);
        this.gridSpacing_Param.addParameterChangeListener(this);
        this.backSeisParam.addParameterChangeListener(this);
        this.grTailParam.addParameterChangeListener(this);
        this.numRealizationsParam.addParameterChangeListener(this);
    }

    private void initAdjParams() {
        this.backSeisOptionsStrings.add(SEIS_EXCLUDE);
        this.backSeisOptionsStrings.add(SEIS_INCLUDE);
        this.backSeisParam = new StringParameter(BACK_SEIS_NAME, this.backSeisOptionsStrings, SEIS_EXCLUDE);
        this.grTailOptionsStrings.add(SEIS_EXCLUDE);
        this.grTailOptionsStrings.add(SEIS_INCLUDE);
        this.grTailParam = new StringParameter(GR_TAIL_NAME, this.backSeisOptionsStrings, SEIS_EXCLUDE);
        this.rupOffset_Param = new DoubleParameter(RUP_OFFSET_PARAM_NAME, 1.0, 50.0, "km", this.DEFAULT_RUP_OFFSET_VAL);
        this.rupOffset_Param.setInfo(RUP_OFFSET_PARAM_INFO);
        this.gridSpacing_Param = new DoubleParameter(GRID_SPACING_PARAM_NAME, 0.1, 5.0, "km", this.DEFAULT_GRID_SPACING_VAL);
        this.gridSpacing_Param.setInfo(GRID_SPACING_PARAM_INFO);
        this.deltaMag_Param = new DoubleParameter(DELTA_MAG_PARAM_NAME, 0.005, 0.5, null, this.DEFAULT_DELTA_MAG_VAL);
        this.deltaMag_Param.setInfo(DELTA_MAG_PARAM_INFO);
        this.numRealizationsParam = new IntegerParameter(NUM_REALIZATIONS_PARAM_NAME, this.NUM_REALIZATIONS_MIN, this.NUM_REALIZATIONS_MAX, this.DEFAULT_NUM_REALIZATIONS_VAL);
        this.numRealizationsParam.setInfo(NUM_REALIZATIONS_PARAM_INFO);
        this.adjustableParams.addParameter(this.rupOffset_Param);
        this.adjustableParams.addParameter(this.gridSpacing_Param);
        this.adjustableParams.addParameter(this.deltaMag_Param);
        this.adjustableParams.addParameter(this.backSeisParam);
        this.adjustableParams.addParameter(this.grTailParam);
        this.adjustableParams.addParameter(this.numRealizationsParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.D) {
            System.out.println(NAME + ", updateForecast, parameterChangeFlag = " + this.parameterChangeFlag);
        }
        if (this.D) {
            System.out.println(NAME + ", updateForecast, Duration = " + this.timeSpan.getDuration());
        }
        if (this.parameterChangeFlag) {
            double duration = this.timeSpan.getDuration();
            if (duration == 1.0) {
                this.INPUT_FILE_NAME = INPUT_FILE_NAME_1yr;
            } else if (duration == 5.0) {
                this.INPUT_FILE_NAME = INPUT_FILE_NAME_5yr;
            } else if (duration == 10.0) {
                this.INPUT_FILE_NAME = INPUT_FILE_NAME_10yr;
            } else if (duration == 20.0) {
                this.INPUT_FILE_NAME = INPUT_FILE_NAME_20yr;
            } else if (duration == 30.0) {
                this.INPUT_FILE_NAME = INPUT_FILE_NAME_30yr;
            } else {
                throw new RuntimeException("that duration is not supported by " + NAME);
            }
            try {
                this.inputFileLines = FileUtils.loadJarFile(this.INPUT_FILE_NAME);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.toString());
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
            if (this.inputFileLines == null) {
                throw new FaultException(C + "No data loaded from " + this.INPUT_FILE_NAME + ". File may be empty or doesn't exist.");
            }
            this.iterationLineNumbers = new ArrayList();
            String test = null;
            for (int lineNum = 0; lineNum < this.inputFileLines.size(); ++lineNum) {
                StringTokenizer st = new StringTokenizer((String)this.inputFileLines.get(lineNum));
                st.nextToken();
                if (!st.hasMoreTokens() || !(test = st.nextToken()).equals("ITERATIONS")) continue;
                this.iterationLineNumbers.add(lineNum);
            }
            if (this.D) {
                System.out.println(C + ": number of iterations read = " + this.iterationLineNumbers.size());
            }
            if (this.D) {
                for (int i = 0; i < this.iterationLineNumbers.size(); ++i) {
                    System.out.print("   " + (Integer)this.iterationLineNumbers.get(i));
                }
            }
            this.numIterations = (Integer)this.numRealizationsParam.getValue();
            this.rupOffset = (Double)this.rupOffset_Param.getValue();
            this.deltaMag = (Double)this.deltaMag_Param.getValue();
            this.gridSpacing = (Double)this.gridSpacing_Param.getValue();
            this.backSeis = (String)this.backSeisParam.getValue();
            this.grTail = (String)this.grTailParam.getValue();
            this.parameterChangeFlag = false;
        }
    }

    @Override
    public int getNumERFs() {
        return this.numIterations;
    }

    @Override
    public ERF getERF(int index) {
        int firstLine = (Integer)this.iterationLineNumbers.get(index);
        int lastLine = (Integer)this.iterationLineNumbers.get(index + 1);
        ArrayList inputFileStrings = new ArrayList();
        for (int i = firstLine; i < lastLine; ++i) {
            inputFileStrings.add(this.inputFileLines.get(i));
        }
        return new WG02_EqkRupForecast(inputFileStrings, this.rupOffset, this.gridSpacing, this.deltaMag, this.backSeis, this.grTail, "no name", this.timeSpan);
    }

    @Override
    public double getERF_RelativeWeight(int index) {
        return 1.0;
    }

    public ArrayList getRelativeWeightsList() {
        ArrayList<Double> relativeWeight = new ArrayList<Double>();
        for (int i = 0; i < this.numIterations; ++i) {
            relativeWeight.add(1.0);
        }
        return relativeWeight;
    }

    public static void main(String[] args) {
        WG02_ERF_Epistemic_List list = new WG02_ERF_Epistemic_List();
        list.updateForecast();
        ERF fcast = list.getERF(4);
    }
}

