/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WG02;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagAreaRelationship;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.FloatingPoissonFaultSource;
import org.opensha.sha.earthquake.rupForecastImpl.GriddedRegionPoissonEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WG02.WG02_CharEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WG02.WG02_ERF_Epistemic_List;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class WG02_EqkRupForecast
extends AbstractERF {
    private static final String C = new String("WG02_EqkRupForecast");
    public static final String NAME = "WG02 Eqk Rup Forecast";
    private boolean D = false;
    private ArrayList allSources;
    private ArrayList inputFileStrings = null;
    double rupOffset;
    double gridSpacing;
    double deltaMag;
    String backSeisValue;
    String grTailValue;
    String name;

    public WG02_EqkRupForecast() {
        this.timeSpan = new TimeSpan("Years", "Years");
        this.timeSpan.addParameterChangeListener(this);
        String INPUT_FILE_NAME = "/data/erf/wgcep_2002/singleIterationWithModes.OpenSHA.30yr.txt";
        ArrayList<String> inputFileLines = null;
        try {
            inputFileLines = FileUtils.loadJarFile(INPUT_FILE_NAME);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        this.inputFileStrings = new ArrayList();
        int lastLine = inputFileLines.size();
        for (int i = 2; i < lastLine; ++i) {
            this.inputFileStrings.add(inputFileLines.get(i));
        }
        if (this.D) {
            System.out.println(C + " firstLineOfStrings =" + String.valueOf(this.inputFileStrings.get(0)));
        }
        if (this.D) {
            System.out.println(C + " LastLineOfStrings =" + String.valueOf(this.inputFileStrings.get(this.inputFileStrings.size() - 1)));
        }
        ListIterator<String> it = inputFileLines.listIterator();
        StringTokenizer st = new StringTokenizer(inputFileLines.get(1));
        st.nextToken();
        st.nextToken();
        st.nextToken();
        st.nextToken();
        int year = Double.valueOf(st.nextToken()).intValue();
        double duration = Double.valueOf(st.nextToken());
        int numIterations = Double.valueOf(st.nextToken()).intValue();
        inputFileLines = null;
        if (this.D) {
            System.out.println("year=" + year + "; duration=" + duration + "; numIterations=" + numIterations);
        }
        this.timeSpan.setDuractionConstraint(duration, duration);
        this.timeSpan.setDuration(duration);
        this.timeSpan.setStartTimeConstraint("Start Year", year, year);
        this.timeSpan.setStartTime(year);
        this.rupOffset = 2.0;
        this.gridSpacing = 1.0;
        this.deltaMag = 0.1;
        this.backSeisValue = WG02_ERF_Epistemic_List.SEIS_INCLUDE;
        this.grTailValue = WG02_ERF_Epistemic_List.SEIS_INCLUDE;
        this.name = "noName";
        this.makeSources();
    }

    public WG02_EqkRupForecast(ArrayList inputFileStrings, double rupOffset, double gridSpacing, double deltaMag, String backSeisValue, String grTailValue, String name, TimeSpan timeSpan) {
        this.inputFileStrings = inputFileStrings;
        this.rupOffset = rupOffset;
        this.gridSpacing = gridSpacing;
        this.deltaMag = deltaMag;
        this.backSeisValue = backSeisValue;
        this.grTailValue = grTailValue;
        this.name = name;
        this.timeSpan = timeSpan;
        this.makeSources();
    }

    private void makeSources() throws FaultException {
        if (this.D) {
            System.out.println(C + ": last line of inputFileStrings = " + String.valueOf(this.inputFileStrings.get(this.inputFileStrings.size() - 1)));
        }
        this.allSources = new ArrayList();
        ArrayList<FloatingPoissonFaultSource> grTailSources = new ArrayList<FloatingPoissonFaultSource>();
        GriddedRegionPoissonEqkSource backSource = null;
        FloatingPoissonFaultSource grTailSource = null;
        WC1994_MagAreaRelationship magScalingRel = new WC1994_MagAreaRelationship();
        double dip = 0.0;
        double downDipWidth = 0.0;
        double back_deltaMag = 0.05;
        double tail_deltaMag = 0.1;
        GutenbergRichterMagFreqDist tail_GR_dist = null;
        ListIterator it = this.inputFileStrings.listIterator();
        StringTokenizer st = new StringTokenizer(it.next().toString());
        String interation = st.nextToken().toString();
        st = new StringTokenizer(it.next().toString());
        if (this.backSeisValue.equals(WG02_ERF_Epistemic_List.SEIS_INCLUDE)) {
            double back_N = Double.valueOf(st.nextToken());
            double back_b = Double.valueOf(st.nextToken());
            double back_M1 = Double.valueOf(st.nextToken());
            back_M1 = (double)Math.round(back_M1 * 100.0) / 100.0;
            double back_M2 = Double.valueOf(st.nextToken());
            int back_num = Math.round((float)((back_M2 - 5.0) / back_deltaMag)) + 1;
            GutenbergRichterMagFreqDist back_GR_dist = new GutenbergRichterMagFreqDist(5.0, back_num, back_deltaMag, 1.0, back_b);
            back_GR_dist.scaleToCumRate(back_M1, back_N);
            LocationList locList = new LocationList();
            locList.add(new Location(37.19, -120.61, 0.0));
            locList.add(new Location(36.43, -122.09, 0.0));
            locList.add(new Location(38.23, -123.61, 0.0));
            locList.add(new Location(39.02, -122.08, 0.0));
            GriddedRegion gridReg = new GriddedRegion(locList, BorderType.MERCATOR_LINEAR, 0.1, new Location(0.0, 0.0));
            backSource = new GriddedRegionPoissonEqkSource(gridReg, back_GR_dist, this.timeSpan.getDuration(), 0.0, 90.0, 0.0);
            if (this.D) {
                System.out.println("back_N=" + back_N + "\nback_b=" + back_b + "\nback_M1=" + back_M1 + "\nback_M2=" + back_M2 + "\nback_num=" + back_num + "\nback_deltaMag=" + back_deltaMag);
                System.out.println("GR_cum_rate(M1)=" + back_GR_dist.getCumRate(back_M1));
                System.out.println("GR_cum_rate(5.0)=" + back_GR_dist.getCumRate(5.0));
                System.out.println("M2 in GR_dist =" + back_GR_dist.getMaxX());
                System.out.println("num_back_grid_points=" + gridReg.getNodeCount());
            }
        }
        while (it.hasNext()) {
            FaultTrace faultTrace = new FaultTrace("noName");
            st = new StringTokenizer(it.next().toString());
            String fault = st.nextToken().toString();
            String rup = st.nextToken().toString();
            st = new StringTokenizer(it.next().toString());
            String sourceName = st.nextToken().toString();
            st = new StringTokenizer(it.next().toString());
            int numPts = Integer.valueOf(st.nextToken());
            for (int i = 0; i < numPts; ++i) {
                st = new StringTokenizer(it.next().toString());
                double lon = Double.valueOf(st.nextToken());
                double lat = Double.valueOf(st.nextToken());
                faultTrace.add(new Location(lat, lon));
            }
            if (fault.equals("7")) {
                faultTrace.reverse();
            }
            st = new StringTokenizer(it.next().toString());
            dip = Double.valueOf(st.nextToken());
            double upperSeismoDepth = Double.valueOf(st.nextToken());
            downDipWidth = Double.valueOf(st.nextToken());
            double lowerSeismoDepth = upperSeismoDepth + downDipWidth * Math.sin(dip * Math.PI / 180.0);
            double rupArea = Double.valueOf(st.nextToken());
            st = new StringTokenizer(it.next().toString());
            if (this.grTailValue.equals(WG02_ERF_Epistemic_List.SEIS_INCLUDE)) {
                double tail_M1 = Double.valueOf(st.nextToken());
                if (tail_M1 != 5.0) {
                    throw new RuntimeException("tail_M1 must equal 5.0!");
                }
                double tail_M2 = Double.valueOf(st.nextToken());
                double tail_N = Double.valueOf(st.nextToken());
                double tail_b = Double.valueOf(st.nextToken());
                int tail_num = Math.round((float)((tail_M2 - tail_M1) / tail_deltaMag)) + 1;
                tail_GR_dist = new GutenbergRichterMagFreqDist(tail_M1, tail_num, tail_deltaMag, 1.0, tail_b);
                tail_GR_dist.scaleToCumRate(tail_M1, tail_N);
                if (this.D) {
                    System.out.println("tail_N=" + tail_N + "\ntail_b=" + tail_b + "\ntail_M1=" + tail_M1 + "\ntail_M2=" + tail_M2 + "\ntail_num=" + tail_num + "\ntail_deltaMag=" + tail_deltaMag);
                    System.out.println("GR_rate(M1)=" + tail_GR_dist.getCumRate(tail_M1));
                    System.out.println("M2 in GR_dist =" + tail_GR_dist.getMaxX());
                }
            }
            st = new StringTokenizer(it.next().toString());
            double prob = Double.valueOf(st.nextToken());
            double meanMag = Double.valueOf(st.nextToken());
            double magSigma = Double.valueOf(st.nextToken());
            double nSigmaTrunc = Double.valueOf(st.nextToken());
            StirlingGriddedSurface faultSurface = new StirlingGriddedSurface(faultTrace, dip, upperSeismoDepth, lowerSeismoDepth, this.gridSpacing);
            if (rup.equals("11") || rup.equals("12")) {
                rupArea = Math.pow(10.0, meanMag - 4.2);
            }
            double rake = fault.equals("7") ? 90.0 : 0.0;
            WG02_CharEqkSource wg02_source = new WG02_CharEqkSource(prob, meanMag, magSigma, nSigmaTrunc, this.deltaMag, faultSurface, rupArea, this.rupOffset, sourceName, rake);
            this.allSources.add(wg02_source);
            if (!this.grTailValue.equals(WG02_ERF_Epistemic_List.SEIS_INCLUDE) || !(tail_GR_dist.getTotCumRate() > 0.0)) continue;
            grTailSource = new FloatingPoissonFaultSource(tail_GR_dist, faultSurface, magScalingRel, 0.0, 1.0, this.rupOffset, rake, this.timeSpan.getDuration());
            grTailSource.setName(sourceName + "_tail");
            grTailSources.add(grTailSource);
        }
        if (this.grTailValue.equals(WG02_ERF_Epistemic_List.SEIS_INCLUDE)) {
            this.allSources.addAll(grTailSources);
        }
        if (this.backSeisValue.equals(WG02_ERF_Epistemic_List.SEIS_INCLUDE)) {
            this.allSources.add(backSource);
        }
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return (ProbEqkSource)this.allSources.get(iSource);
    }

    @Override
    public int getNumSources() {
        return this.allSources.size();
    }

    public ArrayList getSourceList() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
        if (this.parameterChangeFlag) {
            this.parameterChangeFlag = false;
        }
    }

    public void listSourceTotalProbs() {
        double p_both;
        double p_tot = 1.0;
        int num = this.getNumSources();
        for (int i1 = 0; i1 < (num - 1) / 2; ++i1) {
            int i2 = i1 + (num - 1) / 2;
            double p_char = this.getSource(i1).computeTotalProb();
            double p_tail = this.getSource(i2).computeTotalProb();
            p_both = 1.0 - (1.0 - p_char) * (1.0 - p_tail);
            p_both = (double)Math.round(p_both * 1000000.0) / 1000000.0;
            p_tot *= 1.0 - p_both;
            System.out.println((float)p_both + "\t" + this.getSource(i1).getName() + "   (" + (float)p_char + " for char,  and " + (float)p_tail + " for " + this.getSource(i2).getName() + ")");
        }
        p_both = this.getSource(num - 1).computeTotalProb();
        p_both = (double)Math.round(p_both * 1000000.0) / 1000000.0;
        System.out.println((float)p_both + "\t" + this.getSource(num - 1).getName());
        p_tot *= 1.0 - p_both;
        p_tot = 1.0 - p_tot;
        System.out.println((float)p_tot + "\tTotal Probability");
    }

    public static void main(String[] args) {
        WG02_EqkRupForecast qkCast = new WG02_EqkRupForecast();
        System.out.println("num_sources=" + qkCast.getNumSources());
        int num = 0;
        for (int i = 0; i < qkCast.getNumSources(); ++i) {
            num += qkCast.getNumRuptures(i);
        }
        System.out.println("tot_ruptures=" + num);
    }
}

