/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.A_Faults;

import org.opensha.sha.earthquake.calc.recurInterval.BPT_DistCalc;

public class WG02_QkProbCalc {
    private static String C = new String("WG02_QkProbCalc");
    private static final boolean D = false;
    protected String NAME = "WG02_QkProbCalc";

    public static double[] getRupProbs(double[] segRate, double[] rupRate, double[] segMoRate, double[] segAlpha, double[] segTimeSinceLast, double duration, int[][] rupInSeg) {
        int num_seg = segRate.length;
        int num_rup = rupRate.length;
        double[] segProb = WG02_QkProbCalc.getSegProbs(segRate, segAlpha, segTimeSinceLast, duration);
        double[] rupProb = new double[num_rup];
        for (int rup = 0; rup < num_rup; ++rup) {
            double totMoRate = 0.0;
            for (int seg = 0; seg < num_seg; ++seg) {
                totMoRate += segMoRate[seg] * (double)rupInSeg[seg][rup];
            }
            double sum = 0.0;
            for (int seg = 0; seg < num_seg; ++seg) {
                sum += segProb[seg] * segMoRate[seg] * (double)rupInSeg[seg][rup] / segRate[seg];
            }
            rupProb[rup] = rupRate[rup] * sum / totMoRate;
        }
        return rupProb;
    }

    public static double[] getRupProbs(double[] segRate, double[] rupRate, double[] segMoRate, double segAlpha, double[] segTimeSinceLast, double duration, int[][] rupInSeg) {
        int num_seg = segRate.length;
        int num_rup = rupRate.length;
        double[] segProb = WG02_QkProbCalc.getSegProbs(segRate, segAlpha, segTimeSinceLast, duration);
        double[] rupProb = new double[num_rup];
        for (int rup = 0; rup < num_rup; ++rup) {
            double totMoRate = 0.0;
            for (int seg = 0; seg < num_seg; ++seg) {
                totMoRate += segMoRate[seg] * (double)rupInSeg[seg][rup];
            }
            double sum = 0.0;
            for (int seg = 0; seg < num_seg; ++seg) {
                sum += segProb[seg] * segMoRate[seg] * (double)rupInSeg[seg][rup] / segRate[seg];
            }
            rupProb[rup] = rupRate[rup] * sum / totMoRate;
        }
        return rupProb;
    }

    public static double[] getSegProbs(double[] segRate, double[] segAlpha, double[] segTimeSinceLast, double duration) {
        int num_seg = segRate.length;
        double[] segProb = new double[num_seg];
        for (int seg = 0; seg < num_seg; ++seg) {
            segProb[seg] = BPT_DistCalc.getCondProb(1.0 / segRate[seg], segAlpha[seg], segTimeSinceLast[seg], duration);
        }
        return segProb;
    }

    public static double[] getSegProbs(double[] segRate, double segAlpha, double[] segTimeSinceLast, double duration) {
        int num_seg = segRate.length;
        double[] segProb = new double[num_seg];
        for (int seg = 0; seg < num_seg; ++seg) {
            segProb[seg] = BPT_DistCalc.getCondProb(1.0 / segRate[seg], segAlpha, segTimeSinceLast[seg], duration);
        }
        return segProb;
    }

    public static void main(String[] args) {
        double[] segRate = new double[]{0.00466746464, 0.00432087015, 0.004199435, 0.004199435};
        double[] rupRate = new double[]{0.00145604357, 7.06832856E-4, 0.0, 0.0, 5.05269971E-4, 0.0, 0.00109066791, 0.0, 4.02616395E-4, 0.00270615076};
        double[] rupMag = new double[]{7.16886, 7.24218, 7.52195, 7.37158, 7.5081, 7.70524, 7.75427, 7.81611, 7.87073, 7.94943};
        double[] segMoRate = new double[]{4.74714853E24, 5.62020641E24, 1.51106804E25, 1.06885024E25};
        double[] segAlpha = new double[]{0.5, 0.5, 0.5, 0.5};
        double alpha = 0.5;
        double[] segTimeSinceLast = new double[]{96.0, 96.0, 96.0, 96.0};
        double duration = 30.0;
        int[][] rupInSeg = new int[][]{{1, 0, 0, 0, 1, 0, 0, 1, 0, 1}, {0, 1, 0, 0, 1, 1, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 0, 0, 1, 0, 1, 1}};
        double[] testRupProb = new double[]{0.0405939706, 0.017191546, 0.0, 0.0, 0.0131122563, 0.0, 0.0250523612, 0.0, 0.00934537873, 0.0644722432};
        double[] testSegProb = new double[]{0.130127236, 0.105091952, 0.0964599401, 0.0964599401};
        double[] rupProb = WG02_QkProbCalc.getRupProbs(segRate, rupRate, segMoRate, alpha, segTimeSinceLast, duration, (int[][])rupInSeg);
        System.out.println("Test rup fractional differences:");
        for (int rup = 0; rup < 10; ++rup) {
            if (rupProb[rup] == 0.0) {
                System.out.println("rup" + rup + ": " + (float)(rupProb[rup] - testRupProb[rup]));
                continue;
            }
            System.out.println("rup" + rup + ": " + (float)((rupProb[rup] - testRupProb[rup]) / testRupProb[rup]));
        }
    }
}

