/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2;

import java.util.ArrayList;
import java.util.Collections;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.B_FaultsFetcherForMeanUCERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2_FM2pt2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.A_FaultsFetcher;
import org.opensha.sha.earthquake.util.EqkSourceNameComparator;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class MeanUCERF2_FM2pt1
extends MeanUCERF2 {
    protected static String C = new String("MeanUCERF2, FM 2.1");
    public static final String NAME = new String("WGCEP (2007) UCERF2 - Single Branch, Fault Model 2.1 only");

    private void mkB_FaultSources() {
        A_FaultsFetcher aFaultsFetcher = this.ucerf2.getA_FaultsFetcher();
        B_FaultsFetcherForMeanUCERF bFaultsFetcher = new B_FaultsFetcherForMeanUCERF(aFaultsFetcher, true);
        this.bFaultSources = new ArrayList();
        double rupOffset = (Double)this.rupOffsetParam.getValue();
        double empiricalModelWt = 0.0;
        String probModel = (String)this.probModelParam.getValue();
        if (probModel.equals("BPT") || probModel.equals("Poisson")) {
            empiricalModelWt = 0.0;
        } else if (probModel.equals("Empirical")) {
            empiricalModelWt = 1.0;
        } else if (probModel.equals("WGCEP Preferred Blend")) {
            empiricalModelWt = 0.3;
        }
        double duration = this.timeSpan.getDuration();
        double wt = 0.5;
        boolean ddwCorr = (Boolean)this.cybershakeDDW_CorrParam.getValue();
        int floaterType = this.getFloaterType();
        ArrayList<FaultSegmentData> faultSegDataList = bFaultsFetcher.getB_FaultsCommonConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 1.0;
        faultSegDataList = bFaultsFetcher.getB_FaultsCommonNoConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.5;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_1ConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 1.0;
        faultSegDataList = bFaultsFetcher.getB_FaultsUniqueToF2_1NoConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        wt = 0.75;
        faultSegDataList = bFaultsFetcher.getB_FaultsCommonWithUniqueConnOpts();
        this.addToB_FaultSources(rupOffset, empiricalModelWt, duration, wt, faultSegDataList, ddwCorr, floaterType);
        if (this.calcSummedMFDs) {
            this.bFaultSummedMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
            for (int srcIndex = 0; srcIndex < this.bFaultSources.size(); ++srcIndex) {
                UnsegmentedSource source = (UnsegmentedSource)this.bFaultSources.get(srcIndex);
                int numRups = source.getNumRuptures();
                for (int rupIndex = 0; rupIndex < numRups; ++rupIndex) {
                    ProbEqkRupture rup = source.getRupture(rupIndex);
                    double mag = rup.getMag();
                    double rate = rup.getMeanAnnualRate(duration);
                    this.bFaultSummedMFD.add(mag, rate);
                }
            }
        }
    }

    private void addToB_FaultSources(double rupOffset, double empiricalModelWt, double duration, double wt, ArrayList<FaultSegmentData> faultSegDataList, boolean ddwCorr, int floaterType) {
        for (int i = 0; i < faultSegDataList.size(); ++i) {
            if (faultSegDataList.get(i).getFaultName().equalsIgnoreCase("Mendocino")) continue;
            this.bFaultSources.add(new UnsegmentedSource(faultSegDataList.get(i), this.empiricalModel, rupOffset, wt, empiricalModelWt, duration, ddwCorr, floaterType, Double.NaN));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected void updateFaultSources() {
        super.updateFaultSources();
        this.allSources = new ArrayList();
        String backSeis = (String)this.backSeisParam.getValue();
        if (!backSeis.equalsIgnoreCase(UCERF2.BACK_SEIS_ONLY)) {
            this.mkB_FaultSources();
            Collections.sort(this.bFaultSources, new EqkSourceNameComparator());
            this.allSources.addAll(this.aFaultSegmentedSources);
            this.allSources.addAll(this.aFaultUnsegmentedSources);
            this.allSources.addAll(this.bFaultSources);
            this.allSources.addAll(this.nonCA_bFaultSources);
        }
    }

    public static void main(String[] args) {
        ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
        MeanUCERF2_FM2pt1 ucerf2_fm2pt1 = new MeanUCERF2_FM2pt1();
        ucerf2_fm2pt1.calcSummedMFDs = true;
        ucerf2_fm2pt1.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        ucerf2_fm2pt1.updateForecast();
        IncrementalMagFreqDist ucerf2_fm2pt1MFD = ucerf2_fm2pt1.getB_FaultMFD();
        funcs.add(ucerf2_fm2pt1MFD);
        ucerf2_fm2pt1 = null;
        MeanUCERF2_FM2pt2 ucerf2_fm2pt2 = new MeanUCERF2_FM2pt2();
        ucerf2_fm2pt2.calcSummedMFDs = true;
        ucerf2_fm2pt2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        ucerf2_fm2pt2.updateForecast();
        IncrementalMagFreqDist ucerf2_fm2pt2MFD = ucerf2_fm2pt2.getB_FaultMFD();
        funcs.add(ucerf2_fm2pt2MFD);
        ucerf2_fm2pt2 = null;
        MeanUCERF2 ucerf2 = new MeanUCERF2();
        ucerf2.calcSummedMFDs = true;
        ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        ucerf2.updateForecast();
        IncrementalMagFreqDist ucerfMFD = ucerf2.getB_FaultMFD();
        funcs.add(ucerfMFD);
        double diffTest = ucerfMFD.getY(7.05) - (ucerf2_fm2pt1MFD.getY(7.05) + ucerf2_fm2pt2MFD.getY(7.05)) / 2.0;
        System.out.println("m 7.05 diffTest=" + (float)diffTest + " (should be zero)");
        double diff = ucerf2_fm2pt1MFD.getY(7.05) - ucerf2_fm2pt2MFD.getY(7.05);
        System.out.println("m 7.05 diff between two fault models =" + (float)diff);
        GraphWindow graph = new GraphWindow(funcs, "Incremental Mag-Freq Dists");
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setYLog(true);
        graph.setY_AxisRange(1.0E-6, 1.0);
    }
}

