/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.ParamOptions;

public class UCERF2_TimeIndependentEpistemicList
extends AbstractEpistemicListERF {
    public static final String NAME = new String("UCERF2 ERF Epistemic List");
    private ArrayList<Double> weights = null;
    private ArrayList<ParameterList> logicTreeParamList = null;
    protected UCERF2 ucerf2 = new UCERF2();
    protected ArrayList<String> logicTreeParamNames;
    protected ArrayList<ParamOptions> logicTreeParamValues;
    private int lastParamIndex;
    static final double DURATION_DEFAULT = 30.0;
    private StringParameter backSeisParam;
    private StringParameter backSeisRupParam;
    private StringParameter floaterTypeParam;

    public UCERF2_TimeIndependentEpistemicList() {
        this.fillLogicTreeParams();
        this.lastParamIndex = this.logicTreeParamNames.size() - 1;
        this.weights = new ArrayList();
        this.logicTreeParamList = new ArrayList();
        this.findBranches(0, 1.0);
        this.initAdjParams();
        this.timeSpan = new TimeSpan("None", "Years");
        this.timeSpan.setDuration(30.0);
        this.timeSpan.addParameterChangeListener(this);
    }

    private void initAdjParams() {
        ArrayList<String> backSeisOptionsStrings = new ArrayList<String>();
        backSeisOptionsStrings.add(UCERF2.BACK_SEIS_EXCLUDE);
        backSeisOptionsStrings.add(UCERF2.BACK_SEIS_INCLUDE);
        backSeisOptionsStrings.add(UCERF2.BACK_SEIS_ONLY);
        this.backSeisParam = new StringParameter(UCERF2.BACK_SEIS_NAME, backSeisOptionsStrings, UCERF2.BACK_SEIS_DEFAULT);
        this.backSeisParam.addParameterChangeListener(this);
        ArrayList<String> backSeisRupStrings = new ArrayList<String>();
        backSeisRupStrings.add(UCERF2.BACK_SEIS_RUP_POINT);
        backSeisRupStrings.add(UCERF2.BACK_SEIS_RUP_FINITE);
        backSeisRupStrings.add(UCERF2.BACK_SEIS_RUP_CROSSHAIR);
        this.backSeisRupParam = new StringParameter(UCERF2.BACK_SEIS_RUP_NAME, backSeisRupStrings, UCERF2.BACK_SEIS_RUP_DEFAULT);
        ArrayList<String> floaterTypes = new ArrayList<String>();
        floaterTypes.add("Only along strike ( rupture full DDW)");
        floaterTypes.add("Along strike and down dip");
        floaterTypes.add("Along strike & centered down dip");
        this.floaterTypeParam = new StringParameter("Floater Type", floaterTypes, "Along strike & centered down dip");
        this.createParamList();
    }

    private void createParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.floaterTypeParam);
        this.adjustableParams.addParameter(this.backSeisParam);
        if (!((String)this.backSeisParam.getValue()).equals(UCERF2.BACK_SEIS_EXCLUDE)) {
            this.adjustableParams.addParameter(this.backSeisRupParam);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(UCERF2.BACK_SEIS_NAME)) {
            this.createParamList();
        }
    }

    protected void fillLogicTreeParams() {
        this.ucerf2.getParameter("Probability Model").setValue("Poisson");
        this.logicTreeParamNames = new ArrayList();
        this.logicTreeParamValues = new ArrayList();
        this.logicTreeParamNames.add("Deformation Model");
        ParamOptions options = new ParamOptions();
        options.addValueWeight("D2.1", 0.25);
        options.addValueWeight("D2.2", 0.1);
        options.addValueWeight("D2.3", 0.15);
        options.addValueWeight("D2.4", 0.25);
        options.addValueWeight("D2.5", 0.1);
        options.addValueWeight("D2.6", 0.15);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Mag-Area Relationship");
        options = new ParamOptions();
        options.addValueWeight("Ellsworth-B (WGCEP, 2002, Eq 4.5b)", 0.5);
        options.addValueWeight("Hanks & Bakun (2002)", 0.5);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("A-Fault Solution Type");
        options = new ParamOptions();
        options.addValueWeight("Segmented Model", 0.9);
        options.addValueWeight("Unsegmented Model", 0.1);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Wt On A-Priori Rates");
        options = new ParamOptions();
        options.addValueWeight(1.0E-4, 0.5);
        options.addValueWeight(1.0E10, 0.5);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("Connect More B Faults?");
        options = new ParamOptions();
        options.addValueWeight(true, 0.5);
        options.addValueWeight(false, 0.5);
        this.logicTreeParamValues.add(options);
        this.logicTreeParamNames.add("B-Faults b-value");
        options = new ParamOptions();
        options.addValueWeight(0.8, 0.5);
        options.addValueWeight(0.0, 0.5);
        this.logicTreeParamValues.add(options);
    }

    public double getWtForParamVal(String paramName, Object val) {
        int paramIndex = this.logicTreeParamNames.indexOf(paramName);
        ParamOptions options = this.logicTreeParamValues.get(paramIndex);
        int numValues = options.getNumValues();
        for (int i = 0; i < numValues; ++i) {
            if (!options.getValue(i).equals(val)) continue;
            return options.getWeight(i);
        }
        return 0.0;
    }

    private void findBranches(int paramIndex, double weight) {
        ParamOptions options = this.logicTreeParamValues.get(paramIndex);
        String paramName = this.logicTreeParamNames.get(paramIndex);
        int numValues = options.getNumValues();
        for (int i = 0; i < numValues; ++i) {
            double newWt;
            if (this.ucerf2.getAdjustableParameterList().containsParameter(paramName)) {
                this.ucerf2.getParameter(paramName).setValue(options.getValue(i));
                newWt = weight * options.getWeight(i);
                if (paramName.equalsIgnoreCase("Wt On A-Priori Rates")) {
                    Parameter param = this.ucerf2.getParameter("Wt On A-Priori Rates");
                    if ((Double)param.getValue() == 1.0E10) {
                        this.ucerf2.getParameter("Min Fraction for Unknown Ruptures").setValue(0.0);
                        this.ucerf2.getParameter("Min Fraction for Unlikely Ruptures").setValue(0.0);
                    } else {
                        this.ucerf2.getParameter("Min Fraction for Unknown Ruptures").setValue(UCERF2.MIN_A_FAULT_RATE_1_DEFAULT);
                        this.ucerf2.getParameter("Min Fraction for Unlikely Ruptures").setValue(UCERF2.MIN_A_FAULT_RATE_2_DEFAULT);
                    }
                }
                if (paramName.equalsIgnoreCase("Probability Model") && this.ucerf2.getParameter("A-Fault Solution Type").getValue().equals("Unsegmented Model") && options.getValue(i).equals("BPT")) {
                    this.ucerf2.getParameter("Probability Model").setValue("Poisson");
                }
            } else if (i == 0) {
                newWt = weight;
            } else {
                return;
            }
            if (paramIndex == this.lastParamIndex) {
                this.logicTreeParamList.add((ParameterList)this.ucerf2.getAdjustableParameterList().clone());
                this.weights.add(newWt);
                continue;
            }
            this.findBranches(paramIndex + 1, newWt);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumERFs() {
        return this.weights.size();
    }

    @Override
    public ERF getERF(int index) {
        this.getERF_noUpdate(index);
        this.ucerf2.updateForecast();
        return this.ucerf2;
    }

    public ERF getERF_noUpdate(int index) {
        ListIterator<Parameter<?>> it = this.logicTreeParamList.get(index).getParametersIterator();
        while (it.hasNext()) {
            AbstractParameter param = (AbstractParameter)it.next();
            this.ucerf2.getParameter(param.getName()).setValue(param.getValue());
        }
        this.ucerf2.setParameter(UCERF2.BACK_SEIS_NAME, this.backSeisParam.getValue());
        if (this.adjustableParams.containsParameter(this.backSeisRupParam)) {
            this.ucerf2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, this.backSeisRupParam.getValue());
        }
        this.ucerf2.setParameter("Floater Type", this.floaterTypeParam.getValue());
        TimeSpan u2TimeSpan = this.ucerf2.getTimeSpan();
        u2TimeSpan.setDuration(this.timeSpan.getDuration());
        if (u2TimeSpan.getStartTimePrecision().equals("Years") && this.timeSpan.getStartTimePrecision().equals("Years")) {
            System.out.println("Setting Start Time for branch " + index);
            u2TimeSpan.setStartTime(this.timeSpan.getStartTimeYear());
        }
        return this.ucerf2;
    }

    public ParameterList getParameterList(int index) {
        return this.logicTreeParamList.get(index);
    }

    @Override
    public double getERF_RelativeWeight(int index) {
        return this.weights.get(index);
    }

    @Override
    public ArrayList<Double> getRelativeWeightsList() {
        return this.weights;
    }

    public static void main(String[] args) {
        UCERF2_TimeIndependentEpistemicList ucerf2EpistemicList = new UCERF2_TimeIndependentEpistemicList();
        int numERFs = ucerf2EpistemicList.getNumERFs();
        System.out.println("Num Branches=" + numERFs);
        ArrayList<String> srcNames = new ArrayList<String>();
        ucerf2EpistemicList.getAdjustableParameterList().getParameter(UCERF2.BACK_SEIS_NAME).setValue(UCERF2.BACK_SEIS_EXCLUDE);
        for (int i = 0; i < 1; ++i) {
            System.out.println(i);
            ERF erf = ucerf2EpistemicList.getERF(i);
            for (int s = 0; s < erf.getNumSources(); ++s) {
                String name = erf.getSource(s).getName();
                System.out.println(name);
                if (srcNames.contains(name)) continue;
                srcNames.add(name);
            }
        }
    }
}

