/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.Frankel02.Frankel02_AdjustableEqkRupForecast;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UnsegmentedSource;
import org.opensha.sha.faultSurface.FaultTrace;

public class MakeB_FaultsTable {
    private static final String CA_B_FILENAME = "B-Faults.xls";
    private static final String NON_CA_B_FILENAME = "Non-CA_B-Faults.xls";
    private static final DecimalFormat SLIP_RATE_FORMAT = new DecimalFormat("0.#####");
    private static final DecimalFormat AREA_LENGTH_FORMAT = new DecimalFormat("0.#");
    private static final DecimalFormat MOMENT_FORMAT = new DecimalFormat("0.000E0");
    private static final DecimalFormat MAG_FORMAT = new DecimalFormat("0.00");
    private static final DecimalFormat RATE_FORMAT = new DecimalFormat("0.00000");
    private static final DecimalFormat ASEISMSIC_FORMAT = new DecimalFormat("0.00");
    private HashMap<String, Integer> nameRowMapping;
    private HashMap<String, String> nameFaultModelMapping;
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private HSSFSheet sheet;
    private UCERF2 ucerf2 = new UCERF2();
    int rowIndex;

    public MakeB_FaultsTable() {
        FileOutputStream fileOut;
        int rId;
        this.workbook = new HSSFWorkbook();
        this.makeCA_B_FaultsNewSheet("B-Faults");
        this.rowIndex = 2;
        this.makeData(false, "D2.1");
        this.makeData(false, "D2.4");
        for (String faultName : this.nameRowMapping.keySet()) {
            rId = this.nameRowMapping.get(faultName);
            this.sheet.getRow(rId).createCell(13).setCellValue(this.nameFaultModelMapping.get(faultName));
        }
        this.rowIndex = 2;
        this.makeCA_B_FaultsNewSheet("Connected B-Faults");
        this.makeData(true, "D2.1");
        this.makeData(true, "D2.4");
        for (String faultName : this.nameRowMapping.keySet()) {
            rId = this.nameRowMapping.get(faultName);
            this.sheet.getRow(rId).createCell(13).setCellValue(this.nameFaultModelMapping.get(faultName));
        }
        try {
            fileOut = new FileOutputStream(CA_B_FILENAME);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.workbook = new HSSFWorkbook();
        this.rowIndex = 2;
        this.makeNonCA_B_FaultsNewSheet("Non-CA B-Faults");
        this.makeNonCAB_FaultsData();
        try {
            fileOut = new FileOutputStream(NON_CA_B_FILENAME);
            this.workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeNonCA_B_FaultsNewSheet(String sheetName) {
        this.sheet = this.workbook.createSheet(sheetName);
        HSSFRow row = this.sheet.createRow(0);
        row.createCell(2).setCellValue("Ellsworth B");
        row.createCell(4).setCellValue("Hans & Bakun 2002");
        row = this.sheet.createRow(1);
        row.createCell(0).setCellValue("Index");
        row.createCell(1).setCellValue("Name");
        row.createCell(2).setCellValue("Mag");
        row.createCell(3).setCellValue("Rate");
        row.createCell(4).setCellValue("Mag");
        row.createCell(5).setCellValue("Rate");
        row.createCell(6).setCellValue("Prob (Mag>=6.7)");
        row.createCell(7).setCellValue("Empirical Correction");
        row.createCell(8).setCellValue("Slip Rate (mm/yr)");
        row.createCell(9).setCellValue("Area (sq-km)");
        row.createCell(10).setCellValue("Length (km)");
        row.createCell(11).setCellValue("Moment Rate (Newton-meters/yr)");
        row.createCell(12).setCellValue("Fault Model");
        this.nameRowMapping = new HashMap();
        this.nameFaultModelMapping = new HashMap();
    }

    private void makeCA_B_FaultsNewSheet(String sheetName) {
        this.sheet = this.workbook.createSheet(sheetName);
        HSSFRow row = this.sheet.createRow(0);
        row.createCell(2).setCellValue("Ellsworth B");
        row.createCell(3).setCellValue("Hans & Bakun 2002");
        row = this.sheet.createRow(1);
        row.createCell(0).setCellValue("Index");
        row.createCell(1).setCellValue("Name");
        row.createCell(2).setCellValue("Mag");
        row.createCell(3).setCellValue("Mag");
        row.createCell(4).setCellValue("Poiss Prob  (Mag>=6.7)");
        row.createCell(5).setCellValue("Mean Prob (Mag>=6.7)");
        row.createCell(6).setCellValue("Min Prob (Mag>=6.7)");
        row.createCell(7).setCellValue("Max Prob (Mag>=6.7)");
        row.createCell(8).setCellValue("Empirical Correction");
        row.createCell(9).setCellValue("Slip Rate (mm/yr)");
        row.createCell(10).setCellValue("Area (sq-km)");
        row.createCell(11).setCellValue("Length (km)");
        row.createCell(12).setCellValue("Moment Rate (Newton-meters/yr)");
        row.createCell(13).setCellValue("Fault Model");
        this.nameRowMapping = new HashMap();
        this.nameFaultModelMapping = new HashMap();
    }

    private void makeNonCAB_FaultsData() {
        HashMap<Object, Double> sourceRateMapping = new HashMap<Object, Double>();
        HashMap<Object, Double> sourceProb6_7Mapping = new HashMap<Object, Double>();
        HashMap<Object, Double> sourceEmpMapping = new HashMap<Object, Double>();
        HashMap<Object, Double> sourceLengthMapping = new HashMap<Object, Double>();
        HashMap<Object, Double> sourceAreaMapping = new HashMap<Object, Double>();
        HashMap<Object, Double> sourceMoRateMapping = new HashMap<Object, Double>();
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Probability Model").setValue("Poisson");
        this.ucerf2.updateForecast();
        ArrayList nonCA_Sources_Poiss = this.ucerf2.getNonCA_B_FaultSources();
        this.ucerf2.getParameter("Probability Model").setValue("Empirical");
        this.ucerf2.updateForecast();
        ArrayList nonCA_Sources_Emp = this.ucerf2.getNonCA_B_FaultSources();
        double duration = this.ucerf2.getTimeSpan().getDuration();
        HashMap<Object, Double> sourceMagMapping = new HashMap<Object, Double>();
        String fileName = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/NearCA_NSHMP/NonCA_Faults.txt";
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(fileName);
            int numLines = fileLines.size();
            double mag = 0.0;
            int i = 0;
            while (i < numLines) {
                double moRate;
                double rate;
                String line = fileLines.get(i++);
                StringTokenizer tokenizer = new StringTokenizer(line);
                int srcTypeId = Integer.parseInt(tokenizer.nextToken().trim());
                int rakeId = Integer.parseInt(tokenizer.nextToken().trim());
                int numMags = Integer.parseInt(tokenizer.nextToken().trim());
                tokenizer.nextToken();
                Object faultName = "";
                while (tokenizer.hasMoreTokens()) {
                    faultName = (String)faultName + tokenizer.nextToken() + " ";
                }
                line = fileLines.get(i++);
                tokenizer = new StringTokenizer(line);
                if (srcTypeId == 1) {
                    mag = Double.parseDouble(tokenizer.nextToken().trim());
                    rate = Double.parseDouble(tokenizer.nextToken().trim());
                    moRate = rate * MagUtils.magToMoment(mag);
                    double wt = Double.parseDouble(tokenizer.nextToken().trim());
                    double wt2 = 1.0;
                    if (mag > 6.5) {
                        wt2 = 0.666;
                    }
                    moRate *= wt * wt2;
                } else if (srcTypeId == 2) {
                    double aVal = Double.parseDouble(tokenizer.nextToken().trim());
                    double bVal = Double.parseDouble(tokenizer.nextToken().trim());
                    double magLower = Double.parseDouble(tokenizer.nextToken().trim());
                    double magUpper = Double.parseDouble(tokenizer.nextToken().trim());
                    double deltaMag = Double.parseDouble(tokenizer.nextToken());
                    mag = magUpper;
                    if (magUpper != magLower) {
                        magLower += deltaMag / 2.0;
                        magUpper -= deltaMag / 2.0;
                    } else {
                        magUpper = magLower = (double)Math.round((float)((magUpper - 5.05) / deltaMag)) * deltaMag + 5.05;
                    }
                    numMags = Math.round((float)((magUpper - magLower) / deltaMag + 1.0));
                    moRate = Frankel02_AdjustableEqkRupForecast.getMomentRate(magLower, numMags, deltaMag, aVal, bVal);
                    double wt = Double.parseDouble(tokenizer.nextToken().trim());
                    double wt2 = 0.334;
                    moRate *= wt * wt2;
                } else {
                    throw new RuntimeException("Src type not supported");
                }
                if (sourceMagMapping.containsKey(faultName)) {
                    double mag1 = (Double)sourceMagMapping.get(faultName);
                    if (Math.abs(mag1 - mag) > 0.001) {
                        throw new RuntimeException("Wrong mags for source " + (String)faultName + ":" + mag1 + "," + mag);
                    }
                    double newMoRate = (Double)sourceMoRateMapping.get(faultName) + moRate;
                    sourceMoRateMapping.put(faultName, newMoRate);
                } else {
                    sourceMagMapping.put(faultName, mag);
                    sourceMoRateMapping.put(faultName, moRate);
                    rate = 0.0;
                    double rate6_7 = 0.0;
                    double emp = 0.0;
                    double num = 0.0;
                    for (int srcId = 0; srcId < nonCA_Sources_Poiss.size(); ++srcId) {
                        ProbEqkSource source_pois = (ProbEqkSource)nonCA_Sources_Poiss.get(srcId);
                        ProbEqkSource source_emp = (ProbEqkSource)nonCA_Sources_Emp.get(srcId);
                        if (!source_pois.getName().equalsIgnoreCase((String)faultName + " GR") && !source_pois.getName().equalsIgnoreCase((String)faultName + " Char")) continue;
                        double prob = source_pois.computeTotalProb();
                        rate += -Math.log(1.0 - prob) / duration;
                        rate6_7 += -Math.log(1.0 - source_pois.computeTotalProbAbove(6.7)) / duration;
                        emp += source_emp.computeTotalProb() / prob;
                        num += 1.0;
                    }
                    sourceProb6_7Mapping.put(faultName, 1.0 - Math.exp(-rate6_7 * duration));
                    sourceRateMapping.put(faultName, rate);
                    sourceEmpMapping.put(faultName, emp / num);
                }
                line = fileLines.get(i++);
                tokenizer = new StringTokenizer(line);
                double dip = Double.parseDouble(tokenizer.nextToken().trim());
                double downDipWidth = Double.parseDouble(tokenizer.nextToken().trim());
                double upperSeisDepth = Double.parseDouble(tokenizer.nextToken().trim());
                double lowerSeisDepth = upperSeisDepth + downDipWidth * Math.sin(Math.toRadians(Math.abs(dip)));
                line = fileLines.get(i++);
                int numLocations = Integer.parseInt(line.trim());
                FaultTrace faultTrace = new FaultTrace((String)faultName);
                for (int locIndex = 0; locIndex < numLocations; ++locIndex) {
                    line = fileLines.get(i++);
                    tokenizer = new StringTokenizer(line);
                    double latitude = Double.parseDouble(tokenizer.nextToken());
                    double longitude = Double.parseDouble(tokenizer.nextToken());
                    faultTrace.add(new Location(latitude, longitude));
                }
                sourceLengthMapping.put(faultName, faultTrace.getTraceLength());
                sourceAreaMapping.put(faultName, faultTrace.getTraceLength() * downDipWidth);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String faultName : sourceMagMapping.keySet()) {
            double mag = (Double)sourceMagMapping.get(faultName);
            double rate = (Double)sourceRateMapping.get(faultName);
            HSSFRow row = this.sheet.createRow(this.rowIndex);
            row.createCell(1).setCellValue(faultName);
            row.createCell(2).setCellValue(MAG_FORMAT.format(mag));
            row.createCell(3).setCellValue((double)((float)rate));
            row.createCell(4).setCellValue(MAG_FORMAT.format(mag));
            row.createCell(5).setCellValue((double)((float)rate));
            row.createCell(6).setCellValue(((Double)sourceProb6_7Mapping.get(faultName)).doubleValue());
            row.createCell(7).setCellValue(((Double)sourceEmpMapping.get(faultName)).doubleValue());
            row.createCell(9).setCellValue(AREA_LENGTH_FORMAT.format(sourceAreaMapping.get(faultName)));
            row.createCell(10).setCellValue(AREA_LENGTH_FORMAT.format(sourceLengthMapping.get(faultName)));
            row.createCell(11).setCellValue(MOMENT_FORMAT.format(sourceMoRateMapping.get(faultName)));
            ++this.rowIndex;
        }
    }

    private void makeData(boolean connectMoreB_Faults, String defModelName) {
        this.ucerf2.getParameter("Connect More B Faults?").setValue(connectMoreB_Faults);
        this.ucerf2.getParameter("Deformation Model").setValue(defModelName);
        this.ucerf2.getParameter("B-Faults b-value").setValue(0.8);
        this.ucerf2.getParameter("Probability Model").setValue("Poisson");
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Ellsworth-B (WGCEP, 2002, Eq 4.5b)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesEllB_Poiss_8 = this.ucerf2.get_B_FaultSources();
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesHB_Poiss_8 = this.ucerf2.get_B_FaultSources();
        this.ucerf2.getParameter("Probability Model").setValue("Empirical");
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Ellsworth-B (WGCEP, 2002, Eq 4.5b)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesEllB_Emp_8 = this.ucerf2.get_B_FaultSources();
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesHB_Emp_8 = this.ucerf2.get_B_FaultSources();
        this.ucerf2.getParameter("B-Faults b-value").setValue(0.0);
        this.ucerf2.getParameter("Probability Model").setValue("Poisson");
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Ellsworth-B (WGCEP, 2002, Eq 4.5b)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesEllB_Poiss_0 = this.ucerf2.get_B_FaultSources();
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesHB_Poiss_0 = this.ucerf2.get_B_FaultSources();
        this.ucerf2.getParameter("Probability Model").setValue("Empirical");
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Ellsworth-B (WGCEP, 2002, Eq 4.5b)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesEllB_Emp_0 = this.ucerf2.get_B_FaultSources();
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        ArrayList bFaultSourcesHB_Emp_0 = this.ucerf2.get_B_FaultSources();
        String faultModel = null;
        if (defModelName.equalsIgnoreCase("D2.4")) {
            faultModel = "F2.2";
        } else if (defModelName.equalsIgnoreCase("D2.1")) {
            faultModel = "F2.1";
        } else {
            throw new RuntimeException("Unsupported deformation model");
        }
        double MAG = 6.7;
        for (int i = 0; i < bFaultSourcesEllB_Poiss_8.size(); ++i) {
            double probHB_Emp_0;
            double probEllB_Emp_0;
            double probHB_Poiss_0;
            double probEllB_Poiss_0;
            double probHB_Emp_8;
            double probEllB_Emp_8;
            double probHB_Poiss_8;
            UnsegmentedSource sourceEllB_Poiss_8 = (UnsegmentedSource)bFaultSourcesEllB_Poiss_8.get(i);
            UnsegmentedSource sourceHB_Poiss_8 = (UnsegmentedSource)bFaultSourcesHB_Poiss_8.get(i);
            UnsegmentedSource sourceEllB_Emp_8 = (UnsegmentedSource)bFaultSourcesEllB_Emp_8.get(i);
            UnsegmentedSource sourceHB_Emp_8 = (UnsegmentedSource)bFaultSourcesHB_Emp_8.get(i);
            UnsegmentedSource sourceEllB_Poiss_0 = (UnsegmentedSource)bFaultSourcesEllB_Poiss_0.get(i);
            UnsegmentedSource sourceHB_Poiss_0 = (UnsegmentedSource)bFaultSourcesHB_Poiss_0.get(i);
            UnsegmentedSource sourceEllB_Emp_0 = (UnsegmentedSource)bFaultSourcesEllB_Emp_0.get(i);
            UnsegmentedSource sourceHB_Emp_0 = (UnsegmentedSource)bFaultSourcesHB_Emp_0.get(i);
            FaultSegmentData faultSegmentData = sourceEllB_Poiss_8.getFaultSegmentData();
            HSSFRow row = this.sheet.createRow(this.rowIndex);
            String bFaultName = faultSegmentData.getFaultName();
            if (connectMoreB_Faults && bFaultName.indexOf("Connected") == -1 || !connectMoreB_Faults && bFaultName.indexOf("Connected") != -1) continue;
            if (this.nameRowMapping.containsKey(bFaultName)) {
                Object faultModelName = this.nameFaultModelMapping.get(bFaultName);
                faultModelName = (String)faultModelName + ",F2.2";
                this.nameFaultModelMapping.put(bFaultName, (String)faultModelName);
                continue;
            }
            this.nameRowMapping.put(bFaultName, this.rowIndex);
            this.nameFaultModelMapping.put(bFaultName, faultModel);
            double minProb = Double.MAX_VALUE;
            double maxProb = -1.0;
            double probEllB_Poiss_8 = sourceEllB_Poiss_8.computeTotalProbAbove(MAG);
            if (probEllB_Poiss_8 < minProb) {
                minProb = probEllB_Poiss_8;
            }
            if (probEllB_Poiss_8 > maxProb) {
                maxProb = probEllB_Poiss_8;
            }
            if ((probHB_Poiss_8 = sourceHB_Poiss_8.computeTotalProbAbove(MAG)) < minProb) {
                minProb = probHB_Poiss_8;
            }
            if (probHB_Poiss_8 > maxProb) {
                maxProb = probHB_Poiss_8;
            }
            if ((probEllB_Emp_8 = sourceEllB_Emp_8.computeTotalProbAbove(MAG)) < minProb) {
                minProb = probEllB_Emp_8;
            }
            if (probEllB_Emp_8 > maxProb) {
                maxProb = probEllB_Emp_8;
            }
            if ((probHB_Emp_8 = sourceHB_Emp_8.computeTotalProbAbove(MAG)) < minProb) {
                minProb = probHB_Emp_8;
            }
            if (probHB_Emp_8 > maxProb) {
                maxProb = probHB_Emp_8;
            }
            if ((probEllB_Poiss_0 = sourceEllB_Poiss_0.computeTotalProbAbove(MAG)) < minProb) {
                minProb = probEllB_Poiss_0;
            }
            if (probEllB_Poiss_0 > maxProb) {
                maxProb = probEllB_Poiss_0;
            }
            if ((probHB_Poiss_0 = sourceHB_Poiss_0.computeTotalProbAbove(MAG)) < minProb) {
                minProb = probHB_Poiss_0;
            }
            if (probHB_Poiss_0 > maxProb) {
                maxProb = probHB_Poiss_0;
            }
            if ((probEllB_Emp_0 = sourceEllB_Emp_0.computeTotalProbAbove(MAG)) < minProb) {
                minProb = probEllB_Emp_0;
            }
            if (probEllB_Emp_0 > maxProb) {
                maxProb = probEllB_Emp_0;
            }
            if ((probHB_Emp_0 = sourceHB_Emp_0.computeTotalProbAbove(MAG)) < minProb) {
                minProb = probHB_Emp_0;
            }
            if (probHB_Emp_0 > maxProb) {
                maxProb = probHB_Emp_0;
            }
            double meanPoissonProb = (probEllB_Poiss_8 + probHB_Poiss_8 + probEllB_Poiss_0 + probHB_Poiss_0) / 4.0;
            double meanProb = 0.7 * (probEllB_Poiss_8 + probHB_Poiss_8 + probEllB_Poiss_0 + probHB_Poiss_0) / 4.0 + 0.3 * (probEllB_Emp_8 + probHB_Emp_8 + probEllB_Emp_0 + probHB_Emp_0) / 4.0;
            if (i == 0) {
                System.out.println(bFaultName + "\t" + defModelName + "\t" + probEllB_Poiss_8 + "\t" + probHB_Poiss_8 + "\t" + probEllB_Poiss_0 + "\t" + probHB_Poiss_0 + "\t" + probEllB_Emp_8 + "\t" + probHB_Emp_8 + "\t" + probEllB_Emp_0 + "\t" + probHB_Emp_0);
            }
            row.createCell(1).setCellValue(bFaultName);
            row.createCell(2).setCellValue(MAG_FORMAT.format(sourceEllB_Poiss_8.getSourceMag()));
            row.createCell(3).setCellValue(MAG_FORMAT.format(sourceHB_Poiss_8.getSourceMag()));
            row.createCell(4).setCellValue((double)((float)meanPoissonProb));
            row.createCell(5).setCellValue((double)((float)meanProb));
            row.createCell(6).setCellValue((double)((float)minProb));
            row.createCell(7).setCellValue((double)((float)maxProb));
            row.createCell(8).setCellValue((double)((float)(meanProb / meanPoissonProb)));
            row.createCell(9).setCellValue(SLIP_RATE_FORMAT.format(faultSegmentData.getTotalAveSlipRate() * 1000.0));
            row.createCell(10).setCellValue(AREA_LENGTH_FORMAT.format(faultSegmentData.getTotalArea() / 1000000.0));
            row.createCell(11).setCellValue(AREA_LENGTH_FORMAT.format(faultSegmentData.getTotalLength() / 1000.0));
            row.createCell(12).setCellValue(MOMENT_FORMAT.format(sourceEllB_Poiss_8.getMomentRate()));
            ++this.rowIndex;
        }
    }

    public static void main(String[] args) {
        new MakeB_FaultsTable();
    }
}

