/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeIndependentEpistemicList;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class PredictedTotalMFD_UncertPlotter {
    private static final String X_AXIS_LABEL = "Magnitude";
    private static final String Y_AXIS_LABEL = "Cumulative Rate (per year)";
    private ArrayList<IncrementalMagFreqDist> totMFDsList;
    private static final String PATH = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/logicTreeMFDs/";
    private static final String TOT_MFD_FILENAME = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_Final/data/logicTreeMFDs/TotMFDs.txt";
    private final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK);
    private final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN);
    private final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
    private final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
    private final PlotCurveCharacterstics PLOT_CHAR8 = new PlotCurveCharacterstics(PlotSymbol.CROSS, 5.0f, Color.RED);
    private ArrayList funcs = new ArrayList();
    private ArrayList<PlotCurveCharacterstics> plottingFeaturesList = new ArrayList();
    private ArrayList<ArbDiscrEmpiricalDistFunc> rateWtFuncList;
    private UCERF2_TimeIndependentEpistemicList ucerf2List = new UCERF2_TimeIndependentEpistemicList();
    private boolean drawIndividualBranches;

    public PredictedTotalMFD_UncertPlotter(boolean drawIndividualBranches) {
        this.drawIndividualBranches = drawIndividualBranches;
        this.totMFDsList = new ArrayList();
        this.readMFDsFromFile(TOT_MFD_FILENAME, this.totMFDsList);
        this.plotPredTotalMFD_Uncert();
    }

    private void readMFDsFromFile(String fileName, ArrayList<IncrementalMagFreqDist> mfdList) {
        try {
            FileReader fr = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            IncrementalMagFreqDist mfd = null;
            while (line != null) {
                if (line.startsWith("#")) {
                    mfd = new IncrementalMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
                    mfdList.add(mfd);
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(line);
                    double mag = Double.parseDouble(tokenizer.nextToken());
                    double rate = Double.parseDouble(tokenizer.nextToken());
                    mfd.set(mag, rate);
                }
                line = br.readLine();
            }
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getPlottingFeatures() {
        return this.plottingFeaturesList;
    }

    public ArrayList getCurveFunctionList() {
        return this.funcs;
    }

    private void plotPredTotalMFD_Uncert() {
        this.funcs = new ArrayList();
        this.plottingFeaturesList = new ArrayList();
        this.rateWtFuncList = new ArrayList();
        for (int i = 0; i < UCERF2.NUM_MAG; ++i) {
            this.rateWtFuncList.add(new ArbDiscrEmpiricalDistFunc());
        }
        this.doWeightedSum();
        IncrementalMagFreqDist meanMfd = new IncrementalMagFreqDist(5.0, 8.899999999999999, UCERF2.NUM_MAG);
        for (int magIndex = 0; magIndex < UCERF2.NUM_MAG; ++magIndex) {
            meanMfd.set(magIndex, this.rateWtFuncList.get(magIndex).getMean());
        }
        meanMfd.setInfo("Mean");
        this.funcs.add(meanMfd);
        this.plottingFeaturesList.add(this.PLOT_CHAR3);
        IncrementalMagFreqDist medianMfd = new IncrementalMagFreqDist(5.0, 8.899999999999999, UCERF2.NUM_MAG);
        for (int magIndex = 0; magIndex < UCERF2.NUM_MAG; ++magIndex) {
            medianMfd.set(magIndex, this.rateWtFuncList.get(magIndex).getMedian());
        }
        medianMfd.setInfo("Median");
        this.funcs.add(medianMfd);
        this.plottingFeaturesList.add(this.PLOT_CHAR2);
        IncrementalMagFreqDist percentile97_5Mfd = new IncrementalMagFreqDist(5.0, 8.899999999999999, UCERF2.NUM_MAG);
        for (int magIndex = 0; magIndex < UCERF2.NUM_MAG; ++magIndex) {
            percentile97_5Mfd.set(magIndex, this.rateWtFuncList.get(magIndex).getInterpolatedFractile(0.975));
        }
        percentile97_5Mfd.setInfo("97.5 percentile");
        this.funcs.add(percentile97_5Mfd);
        this.plottingFeaturesList.add(this.PLOT_CHAR2);
        IncrementalMagFreqDist percentile2_5Mfd = new IncrementalMagFreqDist(5.0, 8.899999999999999, UCERF2.NUM_MAG);
        for (int magIndex = 0; magIndex < UCERF2.NUM_MAG; ++magIndex) {
            percentile2_5Mfd.set(magIndex, this.rateWtFuncList.get(magIndex).getInterpolatedFractile(0.025));
        }
        percentile2_5Mfd.setInfo("2.5 percentile");
        this.funcs.add(percentile2_5Mfd);
        this.plottingFeaturesList.add(this.PLOT_CHAR2);
        UCERF2 ucerf2 = new UCERF2();
        boolean includeAfterShocks = ucerf2.areAfterShocksIncluded();
        ArrayList<EvenlyDiscretizedFunc> obsMFD = UCERF2.getObsCumMFD(includeAfterShocks);
        this.funcs.add(obsMFD.get(0));
        this.plottingFeaturesList.add(this.PLOT_CHAR7);
        this.funcs.addAll(obsMFD);
        this.plottingFeaturesList.add(this.PLOT_CHAR8);
        this.plottingFeaturesList.add(this.PLOT_CHAR8);
        this.plottingFeaturesList.add(this.PLOT_CHAR8);
        Collections.reverse(this.funcs);
        Collections.reverse(this.plottingFeaturesList);
        GraphWindow graphWindow = new GraphWindow(this.getCurveFunctionList(), "Mag Freq Dist", this.getPlottingFeatures());
        graphWindow.setVisible(true);
    }

    private void doWeightedSum() {
        int numBranches = this.ucerf2List.getNumERFs();
        for (int i = 0; i < numBranches; ++i) {
            double wt = this.ucerf2List.getERF_RelativeWeight(i);
            EvenlyDiscretizedFunc mfd = this.totMFDsList.get(i).getCumRateDistWithOffset();
            mfd.setInfo("Cumulative MFD for a logic tree branch :" + (i + 1));
            if (this.drawIndividualBranches) {
                this.funcs.add(mfd);
                this.plottingFeaturesList.add(this.PLOT_CHAR1);
            }
            for (int magIndex = 0; magIndex < UCERF2.NUM_MAG; ++magIndex) {
                this.rateWtFuncList.get(magIndex).set(mfd.getY(magIndex), wt);
            }
            System.out.println(i + "\t" + mfd.getX(20) + "\t" + mfd.getY(20) + "\t" + wt);
        }
    }

    public boolean getXLog() {
        return false;
    }

    public boolean getYLog() {
        return true;
    }

    public String getXAxisLabel() {
        return X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return Y_AXIS_LABEL;
    }

    public boolean isCustomAxis() {
        return true;
    }

    public double getUserMinX() {
        return 5.0;
    }

    public double getUserMaxX() {
        return 9.255;
    }

    public double getUserMinY() {
        return 1.0E-4;
    }

    public double getUserMaxY() {
        return 10.0;
    }

    public static void main(String[] args) {
        PredictedTotalMFD_UncertPlotter mfdPlotter1 = new PredictedTotalMFD_UncertPlotter(false);
        PredictedTotalMFD_UncertPlotter mfdPlotter2 = new PredictedTotalMFD_UncertPlotter(true);
    }
}

