/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.EqkRateModel2_MFDsPlotter;

public class ReportBulgeFigures {
    private String dirName;
    private UCERF2 ucerf2;

    public ReportBulgeFigures() {
        this.ucerf2 = new UCERF2();
    }

    public ReportBulgeFigures(UCERF2 ucerf2) {
        this.ucerf2 = ucerf2;
    }

    public void generateAnalysisFigures(String dirName) {
        ArrayList<String> paramNames = new ArrayList<String>();
        ParameterList paramList = this.ucerf2.getAdjustableParameterList();
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            paramNames.add(param.getName());
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        for (int i = 0; i <= paramNames.size(); ++i) {
            HSSFRow row = sheet.createRow(i);
            if (i <= 0) continue;
            row.createCell(0).setCellValue((String)paramNames.get(i - 1));
        }
        sheet.createRow(paramNames.size() + 1).createCell(0).setCellValue("M 6.5 pred/obs");
        this.dirName = dirName;
        this.ucerf2.setParamDefaults();
        int fig = 1;
        this.ucerf2.updateForecast();
        this.makeMFDsPlot("plot" + fig, this.ucerf2);
        sheet.getRow(0).createCell((int)((short)fig)).setCellValue("Figure " + fig);
        for (int i = 0; i < paramNames.size(); ++i) {
            if (((String)paramNames.get(i)).equalsIgnoreCase("Segmented A-Fault Solution Types")) {
                sheet.getRow(i + 1).createCell((int)((short)fig)).setCellValue("Geological Insight");
                continue;
            }
            sheet.getRow(i + 1).createCell((int)((short)fig)).setCellValue(paramList.getValue((String)paramNames.get(i)).toString());
        }
        double obsVal = UCERF2.getObsCumMFD(this.ucerf2.areAfterShocksIncluded()).get(0).getInterpolatedY(6.5);
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue("D2.2");
        this.ucerf2.updateForecast();
        this.makeMFDsPlot("plot" + ++fig, this.ucerf2);
        sheet.getRow(0).createCell((int)((short)fig)).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Deformation Model")).createCell((int)((short)fig)).setCellValue("D2.2");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue("D2.3");
        this.ucerf2.updateForecast();
        this.makeMFDsPlot("plot" + ++fig, this.ucerf2);
        sheet.getRow(0).createCell((int)((short)fig)).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Deformation Model")).createCell((int)((short)fig)).setCellValue("D2.3");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue("D2.4");
        this.ucerf2.updateForecast();
        this.makeMFDsPlot("plot" + ++fig, this.ucerf2);
        sheet.getRow(0).createCell((int)((short)fig)).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Deformation Model")).createCell((int)((short)fig)).setCellValue("D2.4");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue("D2.5");
        this.ucerf2.updateForecast();
        this.makeMFDsPlot("plot" + ++fig, this.ucerf2);
        sheet.getRow(0).createCell((int)((short)fig)).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Deformation Model")).createCell((int)((short)fig)).setCellValue("D2.5");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Deformation Model").setValue("D2.6");
        this.ucerf2.updateForecast();
        this.makeMFDsPlot("plot" + ++fig, this.ucerf2);
        sheet.getRow(0).createCell((int)((short)fig)).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Deformation Model")).createCell((int)((short)fig)).setCellValue("D2.6");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("A-Fault Solution Type").setValue("Unsegmented Model");
        this.ucerf2.updateForecast();
        sheet.getRow(0).createCell((int)((short)(++fig))).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("A-Fault Solution Type")).createCell((int)((short)fig)).setCellValue("Unsegmented Model");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.makeMFDsPlot("plot" + fig, this.ucerf2);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Wt On A-Priori Rates").setValue(1.0E7);
        this.ucerf2.updateForecast();
        sheet.getRow(0).createCell((int)((short)(++fig))).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Wt On A-Priori Rates")).createCell((int)((short)fig)).setCellValue("1e7");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.makeMFDsPlot("plot" + fig, this.ucerf2);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Mag-Area Relationship").setValue("Hanks & Bakun (2002)");
        this.ucerf2.updateForecast();
        sheet.getRow(0).createCell((int)((short)(++fig))).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Mag-Area Relationship")).createCell((int)((short)fig)).setCellValue("Hanks & Bakun (2002)");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.makeMFDsPlot("plot" + fig, this.ucerf2);
        this.ucerf2.setParamDefaults();
        this.ucerf2.getParameter("Connect More B Faults?").setValue(false);
        this.ucerf2.updateForecast();
        sheet.getRow(0).createCell((int)((short)(++fig))).setCellValue("Figure " + fig);
        sheet.getRow(1 + paramNames.indexOf("Connect More B Faults?")).createCell((int)((short)fig)).setCellValue("False");
        sheet.getRow(paramNames.size() + 1).createCell((int)((short)fig)).setCellValue(this.ucerf2.getTotalMFD().getCumRate(6.5) / obsVal);
        this.makeMFDsPlot("plot" + fig, this.ucerf2);
        HSSFCellStyle wrapCellStyle = wb.createCellStyle();
        wrapCellStyle.setWrapText(true);
        for (int rowCount = 0; rowCount <= sheet.getLastRowNum(); ++rowCount) {
            for (int colCount = 0; colCount <= fig; ++colCount) {
                HSSFCell cell = sheet.getRow(rowCount).getCell((int)((short)colCount));
                if (cell == null) continue;
                cell.setCellStyle(wrapCellStyle);
            }
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(dirName + "/Table_For_Figures.xls");
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeMFDsPlot(String fileName, UCERF2 ucerf2) {
        EqkRateModel2_MFDsPlotter mfdsPlotter = new EqkRateModel2_MFDsPlotter(ucerf2, true);
        GraphWindow graphWindow = new GraphWindow(mfdsPlotter.getCurveFunctionList(), "Cum Mag Freq Dist", mfdsPlotter.getPlottingFeatures());
        graphWindow.setVisible(true);
        try {
            graphWindow.saveAsPNG(this.dirName + "/" + fileName + ".png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void findMinBulge() {
        this.ucerf2.getParameter("Relative Wt On Segment Rates").setValue(0.0);
        String filename = "Bulge_0.txt";
        StringParameter magAreaRelParam = (StringParameter)this.ucerf2.getParameter("Mag-Area Relationship");
        StringParameter slipModelParam = (StringParameter)this.ucerf2.getParameter("A-Fault Slip Model");
        ParameterListParameter segmentedRupModelParam = (ParameterListParameter)this.ucerf2.getParameter("Segmented A-Fault Solution Types");
        ArrayList<String> magAreaOptions = ((StringConstraint)magAreaRelParam.getConstraint()).getAllowedStrings();
        ArrayList<String> slipModelOptions = ((StringConstraint)slipModelParam.getConstraint()).getAllowedStrings();
        this.ucerf2.getParameter("Fraction Smaller Events & Aftershocks").setValue(0.0);
        this.ucerf2.getParameter("Coupling Coefficient").setValue(1);
        double obVal = UCERF2.getObsCumMFD(false).get(0).getY(6.5);
        double minRatio = 10.0;
        Object str = "";
        Object minStr = "";
        try {
            FileWriter fw = new FileWriter(filename);
            String bVal1 = "default";
            String bVal2 = "default";
            for (int imag = 0; imag < magAreaOptions.size(); ++imag) {
                String[] models = new String[]{"Geological Insight", "Min Rate", "Max Rate"};
                for (int irup = 0; irup < 3; ++irup) {
                    ListIterator it = segmentedRupModelParam.getParametersIterator();
                    while (it.hasNext()) {
                        StringParameter param = (StringParameter)it.next();
                        ArrayList<String> allowedVals = param.getAllowedStrings();
                        param.setValue(allowedVals.get(irup));
                    }
                    for (int islip = 0; islip < slipModelOptions.size(); ++islip) {
                        for (double per = 0.0; per <= 100.0; per += 33.3) {
                            for (double frac = 0.0; frac <= 0.5; frac += 0.15) {
                                this.ucerf2.getParameter("Mag-Area Relationship").setValue(magAreaOptions.get(imag));
                                this.ucerf2.getParameter("A-Fault Slip Model").setValue(slipModelOptions.get(islip));
                                this.ucerf2.getParameter("Fract MoRate to Background").setValue(frac);
                                this.ucerf2.getParameter("% Char vs GR").setValue(per);
                                try {
                                    this.ucerf2.updateForecast();
                                }
                                catch (Exception e) {
                                    System.out.println(e.getMessage() + " , " + String.valueOf(magAreaOptions.get(imag)) + " , " + models[irup] + " , " + String.valueOf(slipModelOptions.get(islip)));
                                    continue;
                                }
                                double predCumRate = this.ucerf2.getTotalMFD().getCumRate(6.5);
                                double ratio = predCumRate / obVal;
                                str = (float)(predCumRate / obVal) + " , " + (float)predCumRate + " , " + String.valueOf(magAreaOptions.get(imag)) + " , " + models[irup] + " , " + String.valueOf(slipModelOptions.get(islip)) + "," + per + "," + bVal1 + "," + bVal2 + "," + frac;
                                fw.write((String)str + "\n");
                                if (!(ratio < minRatio)) continue;
                                minRatio = ratio;
                                minStr = str;
                            }
                        }
                        System.out.println((String)str);
                    }
                }
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(minRatio + "------" + (String)minStr);
    }

    public static void main(String[] args) {
        new ReportBulgeFigures();
    }
}

