/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis;

import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;

public class WriteSourcesProbAboveMag8 {
    public static void main(String[] args) {
        double duration = 30.0;
        double mag = 8.0;
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter("Rupture Offset", 10.0);
        meanUCERF2.getParameter("Probability Model").setValue("WGCEP Preferred Blend");
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        meanUCERF2.getTimeSpan().setDuration(duration);
        meanUCERF2.updateForecast();
        int numSources = meanUCERF2.getNumSources();
        for (int srcIndex = 0; srcIndex < numSources; ++srcIndex) {
            ProbEqkSource probEqkSrc = meanUCERF2.getSource(srcIndex);
            double prob = probEqkSrc.computeTotalProbAbove(mag);
            if (!(prob > 0.0)) continue;
            System.out.println(srcIndex + "\t" + probEqkSrc.getName() + "\t" + (float)prob);
        }
    }
}

