/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.util.FileUtils;

public class UCERF1MfdReader {
    private static final String UCERF1_RATE_FILE = "/data/erf/ucerf2/UCERF1_MFDs.txt";
    private static HashMap<String, ArbitrarilyDiscretizedFunc> incrMFD_Map = new HashMap();
    private static HashMap<String, ArbitrarilyDiscretizedFunc> cumMFD_Map = new HashMap();

    public static ArbitrarilyDiscretizedFunc getUCERF1IncrementalMFD(String faultName) {
        if (incrMFD_Map.containsKey(faultName)) {
            return incrMFD_Map.get(faultName);
        }
        try {
            ArbitrarilyDiscretizedFunc magRateFunc = new ArbitrarilyDiscretizedFunc();
            ArrayList<String> fileLines = FileUtils.loadJarFile(UCERF1_RATE_FILE);
            int numLines = fileLines.size();
            for (int i = 0; i < numLines; ++i) {
                String fileLine = fileLines.get(i);
                if (fileLine.trim().equals("") || fileLine.startsWith("#") || !fileLine.startsWith("-") || !fileLine.substring(1).trim().equalsIgnoreCase(faultName)) continue;
                for (int j = i + 1; j < numLines && !(fileLine = fileLines.get(j)).startsWith("-"); ++j) {
                    StringTokenizer tokenizer = new StringTokenizer(fileLine);
                    magRateFunc.set(Double.parseDouble(tokenizer.nextToken()), Double.parseDouble(tokenizer.nextToken()));
                }
                incrMFD_Map.put(faultName, magRateFunc);
                break;
            }
            magRateFunc.setName(faultName + " MFD for UCERF 1.0");
            return magRateFunc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArbitrarilyDiscretizedFunc getUCERF1CumMFD(String faultName) {
        if (cumMFD_Map.containsKey(faultName)) {
            return cumMFD_Map.get(faultName);
        }
        ArbitrarilyDiscretizedFunc ucerf1Rate = UCERF1MfdReader.getUCERF1IncrementalMFD(faultName);
        ArbitrarilyDiscretizedFunc ucerf1CumRate = new ArbitrarilyDiscretizedFunc();
        double rate = 0.0;
        for (int i = ucerf1Rate.size() - 1; i >= 0; --i) {
            ucerf1CumRate.set(ucerf1Rate.getX(i), rate += ucerf1Rate.getY(i));
        }
        ucerf1CumRate.setName(faultName + " Cumulative Rate from UCERF 1.0");
        cumMFD_Map.put(faultName, ucerf1CumRate);
        return ucerf1CumRate;
    }
}

