/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.DeformationModelPrefDataDB_DAO;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelSummaryFinal;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.PrefFaultSectionDataFinal;

public class DeformationModelPrefDataFinal
implements Serializable {
    private static final String XML_DATA_FILENAME = "DeformationModelPrefData.xml";
    private HashMap slipRateMap;
    private HashMap aseismicSlipMap;
    private HashMap stdDevMap;
    private HashMap faultSectionIdIndexMapMap;
    private HashMap<Integer, ArrayList<Integer>> faultSectionIdMap;
    private PrefFaultSectionDataFinal prefFaultSectionDataFinal = new PrefFaultSectionDataFinal();
    DeformationModelSummaryFinal deformationModelSummaryFinal;

    public DeformationModelPrefDataFinal() {
        this.readDeformationModelSummariesXML_File();
    }

    private void writeDeformationModelSummariesXML_File() {
        this.slipRateMap = new HashMap();
        this.aseismicSlipMap = new HashMap();
        this.stdDevMap = new HashMap();
        this.faultSectionIdIndexMapMap = new HashMap();
        this.faultSectionIdMap = new HashMap();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("DeformationModelPrefData");
        DeformationModelPrefDataDB_DAO deformationModelPrefDB_DAO = new DeformationModelPrefDataDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
        this.deformationModelSummaryFinal = new DeformationModelSummaryFinal();
        ArrayList deformationModelSummaryList = this.deformationModelSummaryFinal.getAllDeformationModels();
        for (int i = 0; i < deformationModelSummaryList.size(); ++i) {
            DeformationModelSummary dmSummary = (DeformationModelSummary)deformationModelSummaryList.get(i);
            int defModId = dmSummary.getDeformationModelId();
            ArrayList<Integer> faultSectionIdList = deformationModelPrefDB_DAO.getFaultSectionIdsForDeformationModel(defModId);
            HashMap<Integer, Integer> faultSectionIdIndexMap = new HashMap<Integer, Integer>();
            double[] slipRateList = new double[faultSectionIdList.size()];
            double[] slipRateStdDevList = new double[faultSectionIdList.size()];
            double[] aseismicSlipList = new double[faultSectionIdList.size()];
            Element el = root.addElement("DeformationModel");
            el.addAttribute("defModId", "" + dmSummary.getDeformationModelId());
            for (int j = 0; j < faultSectionIdList.size(); ++j) {
                int faultSectionId = faultSectionIdList.get(j);
                faultSectionIdIndexMap.put(faultSectionId, j);
                slipRateList[j] = deformationModelPrefDB_DAO.getSlipRate(defModId, faultSectionId);
                slipRateStdDevList[j] = deformationModelPrefDB_DAO.getSlipStdDev(defModId, faultSectionId);
                aseismicSlipList[j] = deformationModelPrefDB_DAO.getAseismicSlipFactor(defModId, faultSectionId);
                Element faultSectionEl = el.addElement("FaultSectionDefModelData");
                faultSectionEl.addAttribute("faultSectionId", "" + faultSectionId);
                faultSectionEl.addAttribute("slipRate", "" + slipRateList[j]);
                faultSectionEl.addAttribute("slipRateStdDev", "" + slipRateStdDevList[j]);
                faultSectionEl.addAttribute("aseismicSlip", "" + aseismicSlipList[j]);
            }
            this.slipRateMap.put(defModId, slipRateList);
            this.stdDevMap.put(defModId, slipRateStdDevList);
            this.aseismicSlipMap.put(defModId, aseismicSlipList);
            this.faultSectionIdIndexMapMap.put(defModId, faultSectionIdIndexMap);
            this.faultSectionIdMap.put(defModId, faultSectionIdList);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            System.out.println("Writing Deformation Model Summary to DeformationModelPrefData.xml");
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(XML_DATA_FILENAME), format);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FaultSectionPrefData getFaultSectionPrefData(int deformationModelId, int faultSectionId) {
        FaultSectionPrefData faultSectionPrefData = this.prefFaultSectionDataFinal.getFaultSectionPrefData(faultSectionId).clone();
        HashMap faultSectionIdIndexMap = (HashMap)this.faultSectionIdIndexMapMap.get(deformationModelId);
        int indexForSectId = (Integer)faultSectionIdIndexMap.get(faultSectionId);
        double[] slipRateList = (double[])this.slipRateMap.get(deformationModelId);
        faultSectionPrefData.setAveSlipRate(slipRateList[indexForSectId]);
        double[] stdDevList = (double[])this.stdDevMap.get(deformationModelId);
        faultSectionPrefData.setSlipRateStdDev(stdDevList[indexForSectId]);
        double[] aseismicSlipList = (double[])this.aseismicSlipMap.get(deformationModelId);
        faultSectionPrefData.setAseismicSlipFactor(aseismicSlipList[indexForSectId]);
        return faultSectionPrefData;
    }

    public ArrayList<Integer> getFaultSectionIdsForDeformationModel(int deformationModelId) {
        return this.faultSectionIdMap.get(deformationModelId);
    }

    public ArrayList<FaultSectionPrefData> getAllFaultSectionPrefData(int deformationModelId) {
        ArrayList<Integer> ids = this.getFaultSectionIdsForDeformationModel(deformationModelId);
        ArrayList<FaultSectionPrefData> sections = new ArrayList<FaultSectionPrefData>();
        for (int id : ids) {
            sections.add(this.getFaultSectionPrefData(deformationModelId, id).clone());
        }
        return sections;
    }

    private void readDeformationModelSummariesXML_File() {
        this.slipRateMap = new HashMap();
        this.aseismicSlipMap = new HashMap();
        this.stdDevMap = new HashMap();
        this.faultSectionIdIndexMapMap = new HashMap();
        this.faultSectionIdMap = new HashMap();
        SAXReader reader = new SAXReader();
        try {
            URL xmlURL = DeformationModelPrefDataFinal.class.getResource("/data/erf/ucerf2/finalReferenceFaultParamDb/DeformationModelPrefData.xml");
            Document document = reader.read(xmlURL);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element el = (Element)it.next();
                int defModId = Integer.parseInt(el.attributeValue("defModId"));
                List elements = el.elements();
                int numSections = elements.size();
                ArrayList<Integer> faultSectionIdList = new ArrayList<Integer>();
                HashMap<Integer, Integer> faultSectionIdIndexMap = new HashMap<Integer, Integer>();
                double[] slipRateList = new double[numSections];
                double[] slipRateStdDevList = new double[numSections];
                double[] aseismicSlipList = new double[numSections];
                int i = 0;
                for (Element faultSection : elements) {
                    int faultSectionId = Integer.parseInt(faultSection.attributeValue("faultSectionId"));
                    faultSectionIdList.add(faultSectionId);
                    faultSectionIdIndexMap.put(faultSectionId, i);
                    slipRateList[i] = Double.parseDouble(faultSection.attributeValue("slipRate"));
                    slipRateStdDevList[i] = Double.parseDouble(faultSection.attributeValue("slipRateStdDev"));
                    aseismicSlipList[i] = Double.parseDouble(faultSection.attributeValue("aseismicSlip"));
                    ++i;
                }
                this.slipRateMap.put(defModId, slipRateList);
                this.stdDevMap.put(defModId, slipRateStdDevList);
                this.aseismicSlipMap.put(defModId, aseismicSlipList);
                this.faultSectionIdIndexMapMap.put(defModId, faultSectionIdIndexMap);
                this.faultSectionIdMap.put(defModId, faultSectionIdList);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void saveCompleteXMLFile() {
    }

    public static void main(String[] args) {
        DeformationModelPrefDataFinal test = new DeformationModelPrefDataFinal();
    }
}

