/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.griddedSeis;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.StringTokenizer;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.PointSourceNshm;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.griddedSeis.Point2Vert_FaultPoisSource;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.FocalMech;

public class NSHMP_GridSourceGenerator
implements Serializable {
    private CaliforniaRegions.RELM_GRIDDED region;
    private final WC1994_MagLengthRelationship magLenRel = new WC1994_MagLengthRelationship();
    private static final String PATH = "/data/erf/ucerf2/griddedSeis/";
    private static final String LAT_LON_FILENAME = "/data/erf/ucerf2/griddedSeis/LonsLats.txt";
    private int[] aValIndexForLocIndex;
    private double[] sumOfAllAvals;
    private int numAvals;
    protected double[] agrd_brawly_out;
    protected double[] agrd_creeps_out;
    protected double[] agrd_cstcal_out;
    protected double[] agrd_deeps_out;
    protected double[] agrd_mendos_out;
    protected double[] agrd_wuscmp_out;
    protected double[] agrd_wusext_out;
    protected double[] agrd_impext_out;
    protected double[] area1new_agrid;
    protected double[] area2new_agrid;
    protected double[] area3new_agrid;
    protected double[] area4new_agrid;
    protected double[] mojave_agrid;
    protected double[] sangreg_agrid;
    protected double[] fltmmaxAll21ch_out6;
    protected double[] fltmmaxAll21gr_out6;
    protected double[] fltmmaxAll24ch_out6;
    protected double[] fltmmaxAll24gr_out6;
    protected static final double B_VAL = 0.8;
    protected static final double B_VAL_CREEPING = 0.9;
    protected static final double DELTA_MAG = 0.1;
    protected final double C_ZONES_MAX_MAG = 7.6;
    protected final double DEFAULT_MAX_MAG = 7.0;
    private double[] fracStrikeSlip;
    private double[] fracNormal;
    private double[] fracReverse;
    private double maxFromMaxMagFiles;
    private double magCutOff = Double.NaN;
    private WeightedList<PointSourceDistanceCorrection> distCorrs;

    public NSHMP_GridSourceGenerator(WeightedList<PointSourceDistanceCorrection> distCorrs) {
        this.region = new CaliforniaRegions.RELM_GRIDDED();
        this.distCorrs = distCorrs;
        this.setA_ValIndexForLocIndex();
        this.readAllGridFiles();
        this.getFocalMechFractions();
    }

    public GriddedRegion getGriddedRegion() {
        return this.region;
    }

    public void setAsPointSources(boolean areAllPointSources) {
        this.magCutOff = areAllPointSources ? 10.0 : 6.0;
    }

    public void setDistanceCorrections(WeightedList<PointSourceDistanceCorrection> distCorrs) {
        this.distCorrs = distCorrs;
    }

    public ArrayList<ProbEqkSource> getAllFixedStrikeSources(double duration) {
        ArrayList<ProbEqkSource> sources = new ArrayList<ProbEqkSource>();
        sources.addAll(this.getBrawleyFixedStrikeSources(duration));
        sources.addAll(this.getMendosFixedStrikeSources(duration));
        sources.addAll(this.getCreepsFixedStrikeSources(duration));
        sources.addAll(this.getArea1FixedStrikeSources(duration));
        sources.addAll(this.getArea2FixedStrikeSources(duration));
        sources.addAll(this.getArea3FixedStrikeSources(duration));
        sources.addAll(this.getArea4FixedStrikeSources(duration));
        sources.addAll(this.getMojaveFixedStrikeSources(duration));
        sources.addAll(this.getSangregFixedStrikeSources(duration));
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getBrawleyFixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.agrd_brawly_out[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(5.0, 6.5, this.agrd_brawly_out[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 157.0, duration, this.magCutOff, 0.5, 0.5, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Brawley Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getMendosFixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.agrd_mendos_out[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(5.0, 7.3, this.agrd_mendos_out[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 90.0, duration, this.magCutOff, 0.5, 0.0, 0.5, this.distCorrs));
            sources.get(sources.size() - 1).setName("Mendos Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getCreepsFixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.agrd_creeps_out[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(5.0, 6.0, this.agrd_creeps_out[locIndex], 0.9, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 317.5, duration, this.magCutOff, 1.0, 0.0, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Creeps Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getArea1FixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.area1new_agrid[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(6.5, 7.6, this.area1new_agrid[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 325.0, duration, this.magCutOff, 1.0, 0.0, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Area1 Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getArea2FixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.area2new_agrid[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(6.5, 7.6, this.area2new_agrid[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 335.0, duration, this.magCutOff, 1.0, 0.0, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Area2 Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getArea3FixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.area3new_agrid[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(6.5, 7.6, this.area3new_agrid[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 315.0, duration, this.magCutOff, 1.0, 0.0, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Area3 Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getArea4FixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.area4new_agrid[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(6.5, 7.6, this.area4new_agrid[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 315.0, duration, this.magCutOff, 1.0, 0.0, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Area4 Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getMojaveFixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.mojave_agrid[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(6.5, 7.6, this.mojave_agrid[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 313.0, duration, this.magCutOff, 1.0, 0.0, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Mojave Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<Point2Vert_FaultPoisSource> getSangregFixedStrikeSources(double duration) {
        ArrayList<Point2Vert_FaultPoisSource> sources = new ArrayList<Point2Vert_FaultPoisSource>();
        for (int locIndex = 0; locIndex < this.region.getNodeCount(); ++locIndex) {
            if (!(this.sangreg_agrid[locIndex] > 0.0)) continue;
            GutenbergRichterMagFreqDist mfd = this.getMFD(6.5, 7.6, this.sangreg_agrid[locIndex], 0.8, false);
            sources.add(new Point2Vert_FaultPoisSource(this.region.locationForIndex(locIndex), (IncrementalMagFreqDist)mfd, (MagLengthRelationship)this.magLenRel, 293.0, duration, this.magCutOff, 1.0, 0.0, 0.0, this.distCorrs));
            sources.get(sources.size() - 1).setName("Sangreg Point2Vert_FaultPoisSource");
        }
        return sources;
    }

    public ArrayList<ProbEqkSource> getAllRandomStrikeGriddedSources(double duration) {
        int numSources = this.region.getNodeCount();
        ArrayList<ProbEqkSource> sources = new ArrayList<ProbEqkSource>();
        for (int i = 0; i < numSources; ++i) {
            sources.add(this.getRandomStrikeGriddedSource(i, duration));
        }
        return sources;
    }

    public ArrayList<ProbEqkSource> getAllCrosshairGriddedSources(double duration) {
        int numSources = this.region.getNodeCount();
        ArrayList<ProbEqkSource> sources = new ArrayList<ProbEqkSource>();
        for (int i = 0; i < numSources; ++i) {
            sources.add(this.getCrosshairGriddedSource(i, duration));
        }
        return sources;
    }

    public List<ProbEqkSource> getAllNSHMP13_GriddedSources(double duration) {
        int numSources = this.region.getNodeCount();
        ArrayList<ProbEqkSource> sources = new ArrayList<ProbEqkSource>();
        for (int i = 0; i < numSources; ++i) {
            sources.add(this.getNSHMP13_GriddedSource(i, duration));
        }
        return sources;
    }

    public ProbEqkSource getRandomStrikeGriddedSource(int srcIndex, double duration) {
        SummedMagFreqDist mfdAtLoc = this.getTotMFD_atLoc(srcIndex, false, true, true, false, false);
        return new Point2Vert_FaultPoisSource(this.region.locationForIndex(srcIndex), (IncrementalMagFreqDist)mfdAtLoc, (MagLengthRelationship)this.magLenRel, duration, this.magCutOff, this.fracStrikeSlip[srcIndex], this.fracNormal[srcIndex], this.fracReverse[srcIndex], false, this.distCorrs);
    }

    public ProbEqkSource getCrosshairGriddedSource(int srcIndex, double duration) {
        boolean includeDeeps = false;
        SummedMagFreqDist mfdAtLoc = this.getTotMFD_atLoc(srcIndex, false, true, true, false, includeDeeps);
        return new Point2Vert_FaultPoisSource(this.region.locationForIndex(srcIndex), (IncrementalMagFreqDist)mfdAtLoc, (MagLengthRelationship)this.magLenRel, duration, this.magCutOff, this.fracStrikeSlip[srcIndex], this.fracNormal[srcIndex], this.fracReverse[srcIndex], true, this.distCorrs);
    }

    public ProbEqkSource getNSHMP13_GriddedSource(int srcIndex, double duration) {
        boolean includeDeeps = false;
        SummedMagFreqDist mfdAtLoc = this.getTotMFD_atLoc(srcIndex, false, true, true, false, includeDeeps);
        EnumMap mechMap = Maps.newEnumMap(FocalMech.class);
        mechMap.put(FocalMech.STRIKE_SLIP, this.fracStrikeSlip[srcIndex]);
        mechMap.put(FocalMech.NORMAL, this.fracNormal[srcIndex]);
        mechMap.put(FocalMech.REVERSE, this.fracReverse[srcIndex]);
        return new PointSourceNshm(this.region.locationForIndex(srcIndex), mfdAtLoc, duration, mechMap, this.distCorrs);
    }

    public int getNumSources() {
        return this.region.getNodeCount();
    }

    private void setA_ValIndexForLocIndex() {
        this.aValIndexForLocIndex = new int[this.region.getNodeCount()];
        for (int i = 0; i < this.aValIndexForLocIndex.length; ++i) {
            this.aValIndexForLocIndex[i] = -1;
        }
        this.numAvals = 0;
        try {
            InputStreamReader regionFileReader = new InputStreamReader(this.getClass().getResourceAsStream(LAT_LON_FILENAME));
            BufferedReader br = new BufferedReader(regionFileReader);
            String latlonLine = br.readLine();
            int fileIndex = 0;
            latlonLine = br.readLine();
            while (latlonLine != null) {
                StringTokenizer tokenizer = new StringTokenizer(latlonLine);
                double lon = Double.parseDouble(tokenizer.nextToken());
                double lat = Double.parseDouble(tokenizer.nextToken());
                Location loc = Location.backwardsCompatible(lat, lon, 0.0);
                if (this.region.contains(loc)) {
                    this.aValIndexForLocIndex[this.region.indexForLocation((Location)loc)] = fileIndex;
                }
                latlonLine = br.readLine();
                ++fileIndex;
                ++this.numAvals;
            }
            br.close();
            regionFileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readAllGridFiles() {
        this.sumOfAllAvals = new double[this.numAvals];
        this.agrd_cstcal_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_cstcal.out.asc", true);
        this.agrd_brawly_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_brawly.out.asc", true);
        this.agrd_creeps_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_creeps.out.asc", true);
        this.agrd_deeps_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_deeps.out.asc", true);
        this.agrd_mendos_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_mendos.out.asc", true);
        this.agrd_wuscmp_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_wuscmp.out.asc", true);
        this.agrd_wusext_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_wusext.out.asc", true);
        this.agrd_impext_out = this.readGridFile("/data/erf/ucerf2/griddedSeis/agrd_impext.out.asc", true);
        this.area1new_agrid = this.readGridFile("/data/erf/ucerf2/griddedSeis/area1new.agrid.asc", true);
        this.area2new_agrid = this.readGridFile("/data/erf/ucerf2/griddedSeis/area2new.agrid.asc", true);
        this.area3new_agrid = this.readGridFile("/data/erf/ucerf2/griddedSeis/area3new.agrid.asc", true);
        this.area4new_agrid = this.readGridFile("/data/erf/ucerf2/griddedSeis/area4new.agrid.asc", true);
        this.mojave_agrid = this.readGridFile("/data/erf/ucerf2/griddedSeis/mojave.agrid.asc", true);
        this.sangreg_agrid = this.readGridFile("/data/erf/ucerf2/griddedSeis/sangreg.agrid.asc", true);
        this.fltmmaxAll21ch_out6 = this.readGridFile("/data/erf/ucerf2/griddedSeis/fltmmaxALL21ch.out6.asc", false);
        this.fltmmaxAll21gr_out6 = this.readGridFile("/data/erf/ucerf2/griddedSeis/fltmmaxALL21gr.out6.asc", false);
        this.fltmmaxAll24ch_out6 = this.readGridFile("/data/erf/ucerf2/griddedSeis/fltmmaxALL24ch.out6.asc", false);
        this.fltmmaxAll24gr_out6 = this.readGridFile("/data/erf/ucerf2/griddedSeis/fltmmaxALL24gr.out6.asc", false);
        int numMags = this.fltmmaxAll21ch_out6.length;
        this.maxFromMaxMagFiles = -1.0;
        for (int i = 0; i < numMags; ++i) {
            if (this.fltmmaxAll21ch_out6[i] > this.maxFromMaxMagFiles) {
                this.maxFromMaxMagFiles = this.fltmmaxAll21ch_out6[i];
            }
            if (this.fltmmaxAll21gr_out6[i] > this.maxFromMaxMagFiles) {
                this.maxFromMaxMagFiles = this.fltmmaxAll21gr_out6[i];
            }
            if (this.fltmmaxAll24ch_out6[i] > this.maxFromMaxMagFiles) {
                this.maxFromMaxMagFiles = this.fltmmaxAll24ch_out6[i];
            }
            if (!(this.fltmmaxAll24gr_out6[i] > this.maxFromMaxMagFiles)) continue;
            this.maxFromMaxMagFiles = this.fltmmaxAll24gr_out6[i];
        }
    }

    public double[] readGridFile(String fileName, boolean addToSumOfAllAvals) {
        double[] allGridVals = new double[this.numAvals];
        try {
            InputStreamReader ratesFileReader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
            BufferedReader ratesFileBufferedReader = new BufferedReader(ratesFileReader);
            String ratesLine = ratesFileBufferedReader.readLine();
            ratesLine = ratesFileBufferedReader.readLine();
            int index = 0;
            while (ratesLine != null) {
                allGridVals[index] = Double.parseDouble(ratesLine);
                ++index;
                ratesLine = ratesFileBufferedReader.readLine();
            }
            ratesFileBufferedReader.close();
            ratesFileReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double[] gridVals = new double[this.region.getNodeCount()];
        for (int i = 0; i < gridVals.length; ++i) {
            int aValIndex = this.aValIndexForLocIndex[i];
            if (aValIndex != -1) {
                gridVals[i] = allGridVals[aValIndex];
                if (!addToSumOfAllAvals) continue;
                int n = i;
                this.sumOfAllAvals[n] = this.sumOfAllAvals[n] + gridVals[i];
                continue;
            }
            throw new RuntimeException("Problem with indices!");
        }
        return gridVals;
    }

    public GutenbergRichterMagFreqDist getMFD(double minMag, double maxMag, double aValue, double bValue, boolean applyBulgeReduction) {
        int numMag = Math.round((float)(((maxMag -= 0.05) - (minMag += 0.05)) / 0.1 + 1.0));
        GutenbergRichterMagFreqDist mfd = new GutenbergRichterMagFreqDist(minMag, numMag, 0.1, 1.0, bValue);
        mfd.scaleToIncrRate(minMag, aValue * Math.pow(10.0, -bValue * minMag));
        if (applyBulgeReduction && mfd.getMaxX() >= 6.5) {
            for (int i = mfd.getXIndex(6.55); i < mfd.size(); ++i) {
                mfd.set(i, mfd.getY(i) / 3.0);
            }
        }
        return mfd;
    }

    private GutenbergRichterMagFreqDist getTotalMFD(double minMag, double maxMag, double[] aValueArray, double bValue, boolean applyBulgeReduction) {
        double tot_aValue = 0.0;
        for (int i = 0; i < aValueArray.length; ++i) {
            tot_aValue += aValueArray[i];
        }
        return this.getMFD(minMag, maxMag, tot_aValue, bValue, applyBulgeReduction);
    }

    public IncrementalMagFreqDist getTotalC_ZoneMFD() {
        return this.getTotalC_ZoneMFD_InRegion(null);
    }

    public IncrementalMagFreqDist getTotalC_ZoneMFD_InRegion(Region region) {
        double maxMagAtLoc = 7.55;
        int numMags = (int)Math.round((maxMagAtLoc - 5.05) / 0.1) + 1;
        SummedMagFreqDist mfdAtLoc = new SummedMagFreqDist(5.05, maxMagAtLoc, numMags);
        int numLocs = this.region.getNodeCount();
        for (int i = 0; i < numLocs; ++i) {
            if (region != null && !region.contains(this.region.locationForIndex(i))) continue;
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area1new_agrid[i], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area2new_agrid[i], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area3new_agrid[i], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area4new_agrid[i], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.mojave_agrid[i], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.sangreg_agrid[i], 0.8, false), true);
        }
        return mfdAtLoc;
    }

    public SummedMagFreqDist getTotMFDForRegion(Region region, boolean includeC_zones, boolean applyBulgeReduction, boolean applyMaxMagGrid, boolean includeFixedRakeSources) {
        SummedMagFreqDist totMFD = new SummedMagFreqDist(5.05, 8.95, UCERF2.NUM_MAG);
        int numLocs = this.region.getNodeCount();
        for (int locIndex = 0; locIndex < numLocs; ++locIndex) {
            if (region != null && !region.contains(this.region.locationForIndex(locIndex))) continue;
            totMFD.addResampledMagFreqDist(this.getTotMFD_atLoc(locIndex, includeC_zones, applyBulgeReduction, applyMaxMagGrid, includeFixedRakeSources, true), true);
        }
        return totMFD;
    }

    public SummedMagFreqDist getTotMFD_atLoc(int locIndex, boolean includeC_zones, boolean applyBulgeReduction, boolean applyMaxMagGrid, boolean includeFixedRakeSources, boolean include_agrd_deeps_out) {
        double maxMagAtLoc = 7.55;
        int numMags = (int)Math.round((maxMagAtLoc - 5.05) / 0.1) + 1;
        SummedMagFreqDist mfdAtLoc = new SummedMagFreqDist(5.05, maxMagAtLoc, numMags);
        if (includeFixedRakeSources) {
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, 6.5, this.agrd_brawly_out[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, 7.3, this.agrd_mendos_out[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, 6.0, this.agrd_creeps_out[locIndex], 0.9, false), true);
        }
        if (include_agrd_deeps_out) {
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, 7.2, this.agrd_deeps_out[locIndex], 0.8, false), true);
        }
        mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21ch_out6[locIndex], 0.667 * this.agrd_impext_out[locIndex], 0.8, applyBulgeReduction), true);
        mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21gr_out6[locIndex], 0.333 * this.agrd_impext_out[locIndex], 0.8, applyBulgeReduction), true);
        if (applyMaxMagGrid) {
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21ch_out6[locIndex], 0.3335 * this.agrd_cstcal_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21gr_out6[locIndex], 0.1665 * this.agrd_cstcal_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll24ch_out6[locIndex], 0.3335 * this.agrd_cstcal_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll24gr_out6[locIndex], 0.1665 * this.agrd_cstcal_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21ch_out6[locIndex], 0.667 * this.agrd_wuscmp_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21gr_out6[locIndex], 0.333 * this.agrd_wuscmp_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21ch_out6[locIndex], 0.667 * this.agrd_wusext_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, this.fltmmaxAll21gr_out6[locIndex], 0.333 * this.agrd_wusext_out[locIndex], 0.8, applyBulgeReduction), true);
        } else {
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, 7.0, this.agrd_cstcal_out[locIndex], 0.8, applyBulgeReduction), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, 7.0, this.agrd_wuscmp_out[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(5.0, 7.0, this.agrd_wusext_out[locIndex], 0.8, applyBulgeReduction), true);
        }
        if (includeC_zones && includeFixedRakeSources) {
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area1new_agrid[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area2new_agrid[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area3new_agrid[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.area4new_agrid[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.mojave_agrid[locIndex], 0.8, false), true);
            mfdAtLoc.addResampledMagFreqDist(this.getMFD(6.5, 7.6, this.sangreg_agrid[locIndex], 0.8, false), true);
        }
        return mfdAtLoc;
    }

    public void writeNumSources() {
        int i;
        int numLocs = this.region.getNodeCount();
        System.out.println("Total Num Locs = " + numLocs);
        int num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.agrd_brawly_out[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("agrd_brawly_out: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.agrd_creeps_out[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("agrd_creeps_out: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.agrd_mendos_out[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("agrd_mendos_out: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.agrd_impext_out[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("agrd_impext_out: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.area1new_agrid[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("area1new_agrid: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.area2new_agrid[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("area2new_agrid: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.area3new_agrid[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("area3new_agrid: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.area4new_agrid[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("area4new_agrid: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.mojave_agrid[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("mojave_agrid: " + num);
        num = 0;
        for (i = 0; i < numLocs; ++i) {
            if (!(this.sangreg_agrid[i] > 0.0)) continue;
            ++num;
        }
        System.out.println("sangreg_agrid: " + num);
    }

    private void getFocalMechFractions() {
        this.fracStrikeSlip = new double[this.region.getNodeCount()];
        this.fracNormal = new double[this.region.getNodeCount()];
        this.fracReverse = new double[this.region.getNodeCount()];
        for (int loc = 0; loc < this.region.getNodeCount(); ++loc) {
            double total;
            double ss_rate = 0.0;
            double n_rate = 0.0;
            double rv_rate = 0.0;
            ss_rate += 0.5 * this.agrd_cstcal_out[loc];
            rv_rate += 0.5 * this.agrd_cstcal_out[loc];
            ss_rate += 0.5 * this.agrd_impext_out[loc];
            n_rate += 0.5 * this.agrd_impext_out[loc];
            ss_rate += 0.5 * this.agrd_wuscmp_out[loc];
            if ((ss_rate += 0.5 * this.agrd_wusext_out[loc]) / (total = ss_rate + (n_rate += 0.5 * this.agrd_wusext_out[loc]) + (rv_rate += 0.5 * this.agrd_wuscmp_out[loc])) < 0.001) {
                ss_rate = 0.0;
            }
            if (n_rate / total < 0.001) {
                n_rate = 0.0;
            }
            if (rv_rate / total < 0.001) {
                rv_rate = 0.0;
            }
            total = ss_rate + n_rate + rv_rate;
            this.fracStrikeSlip[loc] = ss_rate / total;
            this.fracNormal[loc] = n_rate / total;
            this.fracReverse[loc] = rv_rate / total;
        }
    }

    public void writeMomentRateOfFixedStrikeSources() {
        double totMoRate = 0.0;
        for (ProbEqkSource probEqkSource : this.getBrawleyFixedStrikeSources(1.0)) {
            totMoRate += probEqkSource.computeEquivTotalMomentRate(1.0);
        }
        System.out.println("BrawleyFixedStrikeSources moRate=" + (float)totMoRate);
        totMoRate = 0.0;
        for (ProbEqkSource probEqkSource : this.getMendosFixedStrikeSources(1.0)) {
            totMoRate += probEqkSource.computeEquivTotalMomentRate(1.0);
        }
        System.out.println("MendosFixedStrikeSources moRate=" + (float)totMoRate);
        totMoRate = 0.0;
        for (ProbEqkSource probEqkSource : this.getCreepsFixedStrikeSources(1.0)) {
            totMoRate += probEqkSource.computeEquivTotalMomentRate(1.0);
        }
        System.out.println("CreepsFixedStrikeSources moRate=" + (float)totMoRate);
    }

    public static void main(String[] args) {
        NSHMP_GridSourceGenerator srcGen = new NSHMP_GridSourceGenerator(null);
        srcGen.writeMomentRateOfFixedStrikeSources();
    }
}

