/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;

class FaultSectionTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{"Section Name", "Slip Rate (mm/yr)", "Slip Std Dev", "Aseismic Factor", "Length (km)", "Down Dip Width (km)", "Area (sq-km)", "Upper Depth (km)", "Lower Depth (km)", "Ave Dip (degrees)"};
    private static final DecimalFormat SLIP_RATE_FORMAT = new DecimalFormat("0.#####");
    private static final DecimalFormat AREA_LENGTH_FORMAT = new DecimalFormat("0.#");
    private static final DecimalFormat ASEISMSIC__FORMAT = new DecimalFormat("0.00");
    private ArrayList faultSectionsPrefDataList = new ArrayList();

    public FaultSectionTableModel() {
        this(null);
    }

    public FaultSectionTableModel(ArrayList faultSectionsPrefDataList) {
        this.setFaultSectionData(faultSectionsPrefDataList);
    }

    public void setFaultSectionData(ArrayList faultSectionsPrefDataList) {
        this.faultSectionsPrefDataList = faultSectionsPrefDataList;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int index) {
        return columnNames[index];
    }

    @Override
    public int getRowCount() {
        if (this.faultSectionsPrefDataList == null) {
            return 0;
        }
        return this.faultSectionsPrefDataList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.faultSectionsPrefDataList == null) {
            return "";
        }
        FaultSectionPrefData faultSectionPrefData = (FaultSectionPrefData)this.faultSectionsPrefDataList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return faultSectionPrefData.getSectionName();
            }
            case 1: {
                return SLIP_RATE_FORMAT.format(faultSectionPrefData.getOrigAveSlipRate());
            }
            case 2: {
                return SLIP_RATE_FORMAT.format(faultSectionPrefData.getOrigSlipRateStdDev());
            }
            case 3: {
                return ASEISMSIC__FORMAT.format(faultSectionPrefData.getAseismicSlipFactor());
            }
            case 4: {
                return AREA_LENGTH_FORMAT.format(faultSectionPrefData.getTraceLength());
            }
            case 5: {
                return AREA_LENGTH_FORMAT.format(faultSectionPrefData.getOrigDownDipWidth());
            }
            case 6: {
                return AREA_LENGTH_FORMAT.format(faultSectionPrefData.getOrigDownDipWidth() * faultSectionPrefData.getTraceLength());
            }
            case 7: {
                return AREA_LENGTH_FORMAT.format(faultSectionPrefData.getOrigAveUpperDepth());
            }
            case 8: {
                return AREA_LENGTH_FORMAT.format(faultSectionPrefData.getAveLowerDepth());
            }
            case 9: {
                return AREA_LENGTH_FORMAT.format(faultSectionPrefData.getAveDip());
            }
        }
        return "";
    }
}

