/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import javax.swing.table.AbstractTableModel;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;

public class ProbsTableModel
extends AbstractTableModel {
    private double[] mags = new double[]{5.0, 6.0, 6.5, 6.7, 7.0, 7.5, 8.0};
    private String[] columns = new String[]{"Mags", "A-Faults", "B-Faults", "Non-CA B-Faults", "C-Zones", "Background", "Total"};
    private DiscretizedFunc[] data;

    public ProbsTableModel(UCERF2 ucerf2) {
        int numDataCols = this.columns.length - 1;
        this.data = new DiscretizedFunc[numDataCols];
        for (int i = 0; i < numDataCols; ++i) {
            this.data[i] = this.getDiscretizedFunc();
        }
        ucerf2.getTotal_A_FaultsProb(this.data[0], null);
        ucerf2.getTotal_B_FaultsProb(this.data[1], null);
        ucerf2.getTotal_NonCA_B_FaultsProb(this.data[2], null);
        ucerf2.getTotal_C_ZoneProb(this.data[3], null);
        ucerf2.getTotal_BackgroundProb(this.data[4], null);
        ucerf2.getTotalProb(this.data[5], null);
    }

    private DiscretizedFunc getDiscretizedFunc() {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < this.mags.length; ++i) {
            func.set(this.mags[i], 1.0);
        }
        return func;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.columns[index];
    }

    @Override
    public int getRowCount() {
        return this.mags.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        double mag = this.mags[rowIndex];
        switch (columnIndex) {
            case 0: {
                return "" + this.mags[rowIndex];
            }
        }
        return "" + this.data[columnIndex - 1].getY(rowIndex);
    }
}

