/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.LogicTreeMFDsPlotter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.ReportBulgeFigures;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.analysis.UCERF1ComparisonPlotter;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.gui.EqkRateModel2_Output_Window;
import org.opensha.sha.gui.beans.ERF_GuiBean;

public class UCERF2_GUI
extends JFrame
implements ActionListener {
    private ParameterListEditor editor;
    private static final String TITLE = "Eqk Rate Model2 Params";
    private JButton calcButton = new JButton("Calculate");
    private static final int W = 300;
    private static final int H = 800;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu analysisMenu = new JMenu("Further Analysis");
    private JMenuItem genReportFigMenu = new JMenuItem("Generate MFD Figs for Report");
    private JMenuItem sjSsafReportFigMenu = new JMenuItem("Generate SJF and SSAF MFD Figs for Report");
    private JMenuItem bulgeAnalysisMenu = new JMenuItem("Make Bulge Analysis Plots");
    private JMenuItem logicTreeCumMFDplotMenu = new JMenuItem("Logic tree Cumulative plots");
    private JMenuItem logicTreeIncrMFDplotMenu = new JMenuItem("Logic tree Incremental plots");
    private ERF_GuiBean erfGuiBean;
    public static final String WGCEP_UCERF_2_Final_CLASS_NAME = "org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2";
    private String dirName = null;
    private JScrollPane scrollPane = new JScrollPane();

    public static void main(String[] args) {
        new UCERF2_GUI();
    }

    public UCERF2_GUI() {
        try {
            this.erfGuiBean = new ERF_GuiBean(ERF_Ref.UCERF_2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createGUI();
        this.calcButton.addActionListener(this);
        this.pack();
        Container container = this.getContentPane();
        container.add((Component)this.erfGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.validate();
        container.repaint();
        this.setSize(300, 800);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.show();
    }

    private void createGUI() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.calcButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.menuBar.add(this.analysisMenu);
        this.analysisMenu.add(this.genReportFigMenu);
        this.analysisMenu.add(this.sjSsafReportFigMenu);
        this.analysisMenu.add(this.bulgeAnalysisMenu);
        this.analysisMenu.add(this.logicTreeCumMFDplotMenu);
        this.analysisMenu.add(this.logicTreeIncrMFDplotMenu);
        this.setJMenuBar(this.menuBar);
        this.genReportFigMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UCERF2_GUI.this.genReportFigMenu_actionPerformed(e);
            }
        });
        this.sjSsafReportFigMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UCERF2_GUI.this.sjSsafReportFigMenu_actionPerformed(e);
            }
        });
        this.bulgeAnalysisMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UCERF2_GUI.this.bulgeAnalysisMenu_actionPerformed(e);
            }
        });
        this.logicTreeCumMFDplotMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UCERF2_GUI.this.logicTreeCumMFDplotMenu_actionPerformed(e);
            }
        });
        this.logicTreeIncrMFDplotMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UCERF2_GUI.this.logicTreeIncrMFDplotMenu_actionPerformed(e);
            }
        });
    }

    private void sjSsafReportFigMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            UCERF2 ucerf2 = (UCERF2)this.erfGuiBean.getSelectedERF_Instance();
            UCERF1ComparisonPlotter ucerf1ComparisonPlotter = new UCERF1ComparisonPlotter(ucerf2);
            ucerf1ComparisonPlotter.plot_SJ_SSAF_FaultsDefModels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void genReportFigMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            UCERF2 ucerf2 = (UCERF2)this.erfGuiBean.getSelectedERF_Instance();
            UCERF1ComparisonPlotter ucerf1ComparisonPlotter = new UCERF1ComparisonPlotter(ucerf2);
            ucerf1ComparisonPlotter.plotA_FaultMFDs_forReport("D2.1");
            ucerf1ComparisonPlotter.plotB_FaultMFDs_forReport();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logicTreeCumMFDplotMenu_actionPerformed(ActionEvent actionEvent) {
        LogicTreeMFDsPlotter logicTreeMFDsPlotter = new LogicTreeMFDsPlotter();
        logicTreeMFDsPlotter.plotMFDs(null, true);
    }

    private void logicTreeIncrMFDplotMenu_actionPerformed(ActionEvent actionEvent) {
        LogicTreeMFDsPlotter logicTreeMFDsPlotter = new LogicTreeMFDsPlotter();
        logicTreeMFDsPlotter.plotMFDs(null, false);
    }

    private void bulgeAnalysisMenu_actionPerformed(ActionEvent actionEvent) {
        String dirName = this.getDirectoryName();
        if (dirName == null) {
            return;
        }
        ReportBulgeFigures reportBulgeFigures = new ReportBulgeFigures();
        reportBulgeFigures.generateAnalysisFigures(dirName);
    }

    private String getDirectoryName() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Choose directory to save files");
        if (this.dirName != null) {
            fileChooser.setSelectedFile(new File(this.dirName));
        }
        fileChooser.setFileSelectionMode(1);
        this.dirName = fileChooser.showSaveDialog(this) == 0 ? fileChooser.getSelectedFile().getAbsolutePath() : null;
        return this.dirName;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        UCERF2 ucerf2 = null;
        if (source == this.calcButton) {
            try {
                ucerf2 = (UCERF2)this.erfGuiBean.getSelectedERF();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                e.printStackTrace();
                return;
            }
            EqkRateModel2_Output_Window outputWindow = new EqkRateModel2_Output_Window(ucerf2);
            outputWindow.setLocationRelativeTo(this);
        }
    }
}

