/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.rupCalc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.rupCalc.MultipleSectionRup;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.rupCalc.TreeBranch;

public class Tree {
    public HashMap<Integer, TreeBranch> treeBranchMap = new HashMap();
    public HashMap<String, Boolean> traversedBranchMap;
    public ArrayList<MultipleSectionRup> rupList;

    public void connectInTree(int subSectionId1, int subSectionId2) {
        if (subSectionId1 > subSectionId2) {
            this.updateTreeBranch(subSectionId1, subSectionId2);
        } else {
            this.updateTreeBranch(subSectionId2, subSectionId1);
        }
    }

    private void updateTreeBranch(int subSection1, int subSection2) {
        TreeBranch treeBranch = this.treeBranchMap.get(subSection1);
        if (treeBranch == null) {
            treeBranch = new TreeBranch(subSection1);
            this.treeBranchMap.put(subSection1, treeBranch);
        }
        treeBranch.addAdjacentSubSection(subSection2);
    }

    public void writeInfo() {
        Iterator<Integer> it = this.treeBranchMap.keySet().iterator();
        while (it.hasNext()) {
            TreeBranch treeBranch = this.treeBranchMap.get(it.next());
            System.out.println("Adjacent nodes for " + treeBranch.getSubSectionId());
            for (int i = 0; i < treeBranch.getNumAdjacentSubsections(); ++i) {
                System.out.println(treeBranch.getAdjacentSubSection(i));
            }
        }
    }

    public ArrayList getRuptures() {
        this.rupList = new ArrayList();
        for (int subSecId : this.treeBranchMap.keySet()) {
            ArrayList rupture = new ArrayList();
            this.traverse(subSecId, rupture);
        }
        return this.rupList;
    }

    private void traverse(int subSecId, ArrayList subSecList) {
        if (subSecList.contains(subSecId)) {
            return;
        }
        subSecList.add(subSecId);
        MultipleSectionRup rup = new MultipleSectionRup(subSecList);
        if (!this.rupList.contains(rup)) {
            this.rupList.add(rup);
        }
        TreeBranch branch = this.treeBranchMap.get(subSecId);
        for (int i = 0; branch != null && i < branch.getNumAdjacentSubsections(); ++i) {
            this.traverse(branch.getAdjacentSubSection(i), subSecList);
        }
    }

    private void writeRup(MultipleSectionRup rup) {
        for (int i = 0; i < rup.getNumSubSections(); ++i) {
            System.out.print(rup.getSubSection(i) + ",");
        }
        System.out.println("");
    }

    private boolean isTraversed(String subSecName) {
        Boolean isTraversed = this.traversedBranchMap.get(subSecName);
        return isTraversed != null && isTraversed != false;
    }

    public int getNumSubSections() {
        return this.getAllSubSectionsIdList().size();
    }

    public ArrayList<Integer> getAllSubSectionsIdList() {
        HashSet<Integer> subSectionIdSet = new HashSet<Integer>();
        for (int subSectionId : this.treeBranchMap.keySet()) {
            subSectionIdSet.add(subSectionId);
            subSectionIdSet.addAll(this.treeBranchMap.get(subSectionId).getAdjacentSubSectionsList());
        }
        ArrayList<Integer> subSectionIdList = new ArrayList<Integer>();
        subSectionIdList.addAll(subSectionIdSet);
        return subSectionIdList;
    }
}

