/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.data;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.data.NSHM23_PaleoDataLoader;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoProbabilityModel;

public class NSHM23_PaleoProbabilityModel
extends PaleoProbabilityModel {
    private static final Region U3_MODEL_REGION = new CaliforniaRegions.RELM_TESTING();
    private static PaleoProbabilityModel u3Model;
    private static PaleoProbabilityModel wasatchModel;
    private transient Map<FaultSection, PaleoProbabilityModel> modelCache;

    @Override
    public double getProbPaleoVisible(double mag, List<? extends FaultSection> rupSections, int sectIndex) {
        PaleoProbabilityModel model;
        for (FaultSection faultSection : rupSections) {
            if (faultSection.getSectionId() != sectIndex) continue;
            model = this.getModel(faultSection);
            if (model == null) break;
            return model.getProbPaleoVisible(mag, rupSections, sectIndex);
        }
        for (FaultSection faultSection : rupSections) {
            model = this.getModel(faultSection);
            if (model == null) continue;
            return model.getProbPaleoVisible(mag, rupSections, sectIndex);
        }
        throw new IllegalStateException("No suitable paleo probability model found for rupture including section " + sectIndex);
    }

    @Override
    public double getProbPaleoVisible(double mag, double distAlongRup) {
        throw new UnsupportedOperationException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkInitModels() {
        if (u3Model != null) return;
        Class<NSHM23_PaleoDataLoader> clazz = NSHM23_PaleoDataLoader.class;
        synchronized (NSHM23_PaleoDataLoader.class) {
            if (u3Model != null) return;
            try {
                wasatchModel = new WasatchPaleoProbabilityModel();
                u3Model = UCERF3_PaleoProbabilityModel.load();
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PaleoProbabilityModel getModel(FaultSection sect) {
        PaleoProbabilityModel cached;
        if (this.modelCache == null) {
            NSHM23_PaleoProbabilityModel nSHM23_PaleoProbabilityModel = this;
            synchronized (nSHM23_PaleoProbabilityModel) {
                if (this.modelCache == null) {
                    this.modelCache = new ConcurrentHashMap<FaultSection, PaleoProbabilityModel>();
                }
            }
        }
        if ((cached = this.modelCache.get(sect)) == null) {
            cached = NSHM23_PaleoProbabilityModel.doGetModel(sect);
            NSHM23_PaleoProbabilityModel nSHM23_PaleoProbabilityModel = this;
            synchronized (nSHM23_PaleoProbabilityModel) {
                this.modelCache.put(sect, cached);
            }
        }
        return cached;
    }

    private static PaleoProbabilityModel doGetModel(FaultSection sect) {
        NSHM23_PaleoProbabilityModel.checkInitModels();
        boolean wasatch = sect.getSectionName().toLowerCase().contains("wasatch");
        boolean u3 = false;
        for (Location loc : sect.getFaultTrace()) {
            if (!U3_MODEL_REGION.contains(loc)) continue;
            u3 = true;
            break;
        }
        if (wasatch && u3) {
            throw new IllegalStateException("Section " + sect.getSectionId() + ". " + sect.getSectionName() + " maps to both Wasatch and UCERF3");
        }
        if (wasatch) {
            return wasatchModel;
        }
        if (u3) {
            return u3Model;
        }
        return null;
    }

    public static class WasatchPaleoProbabilityModel
    extends PaleoProbabilityModel {
        @Override
        public double getProbPaleoVisible(double mag, List<? extends FaultSection> rupSections, int sectIndex) {
            return this.getProbPaleoVisible(mag, Double.NaN);
        }

        @Override
        public double getProbPaleoVisible(double mag, double distAlongRup) {
            return Math.exp(-12.51 + mag * 2.053) / (1.0 + Math.exp(-12.51 + mag * 2.053));
        }
    }
}

