/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;

public class NSHM23_SeisDepthDistributions {
    private static final ConcurrentMap<NSHM23_RegionLoader.SeismicityRegions, EvenlyDiscretizedFunc> cache = new ConcurrentHashMap<NSHM23_RegionLoader.SeismicityRegions, EvenlyDiscretizedFunc>();
    private static final String NSHM23_SD_PATH_PREFIX = "/data/erf/nshm23/seismicity/seis_depth_dists/";

    private static String getResourceName(NSHM23_RegionLoader.SeismicityRegions region) {
        return NSHM23_SD_PATH_PREFIX + region.name() + ".csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EvenlyDiscretizedFunc load(NSHM23_RegionLoader.SeismicityRegions region) throws IOException {
        EvenlyDiscretizedFunc cached = (EvenlyDiscretizedFunc)cache.get(region);
        if (cached != null) {
            return cached.deepClone();
        }
        String resourceName = NSHM23_SeisDepthDistributions.getResourceName(region);
        InputStream is = NSHM23_SeisDepthDistributions.class.getResourceAsStream(resourceName);
        Preconditions.checkNotNull((Object)is, (String)"No depth distribution available for seismicity region %s", (Object)region);
        CSVFile<String> csv = CSVFile.readStream(is, true);
        double minX = csv.getDouble(0, 0);
        double maxX = csv.getDouble(csv.getNumRows() - 1, 0);
        int size = csv.getNumRows();
        EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc(minX, maxX, size);
        for (int row = 0; row < func.size(); ++row) {
            double xTest;
            double x = func.getX(row);
            Preconditions.checkState(((float)x == (float)(xTest = csv.getDouble(row, 0)) ? 1 : 0) != 0, (String)"Seismicity depth distribution for %s isn't evenly discretized, expected %s at index %s, got %s", (Object)region, (Object)Float.valueOf((float)x), (Object)row, (Object)Float.valueOf((float)xTest));
            func.set(row, csv.getDouble(row, 1));
        }
        double sum = func.calcSumOfY_Vals();
        Preconditions.checkState((sum >= 0.99 && sum <= 1.01 ? 1 : 0) != 0, (String)"Seismicity depth distribution isn't normalied for %s, sum=%s", (Object)region, (Object)sum);
        if (sum != 1.0) {
            func.scale(1.0 / sum);
        }
        ConcurrentMap<NSHM23_RegionLoader.SeismicityRegions, EvenlyDiscretizedFunc> concurrentMap = cache;
        synchronized (concurrentMap) {
            cache.putIfAbsent(region, func);
        }
        return func.deepClone();
    }

    public static void main(String[] args) throws IOException {
        NSHM23_SeisDepthDistributions.load(NSHM23_RegionLoader.SeismicityRegions.CONUS_EAST);
    }
}

