/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree;

import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum NSHM23_PaleoUncertainties implements LogicTreeNode
{
    EVEN_FIT("Even-Fit Paleo Data", "EvenFit", 1.0, 1.0),
    OVER_FIT("Over-Fit Paleo Data (5x)", "OverFit", 0.2, 1.0),
    UNDER_FIT("Under-Fit Paleo Data (10x)", "UnderFit", 10.0, 1.0),
    AVERAGE("Branch Averaged Paleo Data", "AverageFit", Double.NaN, 0.0){

        @Override
        public double getUncertaintyScalar() {
            if (Double.isNaN(this.scalar)) {
                double weightSum = 0.0;
                double logWeightedSum = 0.0;
                for (NSHM23_PaleoUncertainties uncert : 1.values()) {
                    double weight = uncert.getNodeWeight(null);
                    if (!(weight > 0.0) || uncert == this) continue;
                    weightSum += weight;
                    double scalar = uncert.getUncertaintyScalar();
                    logWeightedSum += Math.log10(scalar) * weight;
                }
                this.scalar = Math.pow(10.0, logWeightedSum / weightSum);
            }
            return this.scalar;
        }
    };

    private String name;
    private String shortName;
    protected double scalar;
    private double weight;

    private NSHM23_PaleoUncertainties(String name, String shortName, double scalar, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.scalar = scalar;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.getShortName() + "Paleo";
    }

    public List<UncertainDataConstraint.SectMappedUncertainDataConstraint> getScaled(List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> constraints) {
        return NSHM23_PaleoUncertainties.getScaled(this.getUncertaintyScalar(), constraints);
    }

    public static List<UncertainDataConstraint.SectMappedUncertainDataConstraint> getScaled(double uncertScalar, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> constraints) {
        ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint> ret = new ArrayList<UncertainDataConstraint.SectMappedUncertainDataConstraint>();
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : constraints) {
            ret.add(NSHM23_PaleoUncertainties.getScaled(uncertScalar, sectMappedUncertainDataConstraint));
        }
        return ret;
    }

    public UncertainDataConstraint.SectMappedUncertainDataConstraint getScaled(UncertainDataConstraint.SectMappedUncertainDataConstraint constraint) {
        return NSHM23_PaleoUncertainties.getScaled(this.getUncertaintyScalar(), constraint);
    }

    public static UncertainDataConstraint.SectMappedUncertainDataConstraint getScaled(double uncertScalar, UncertainDataConstraint.SectMappedUncertainDataConstraint constraint) {
        if (uncertScalar == 1.0) {
            return constraint;
        }
        Uncertainty[] modUncerts = new Uncertainty[constraint.uncertainties.length];
        for (int i = 0; i < modUncerts.length; ++i) {
            modUncerts[i] = constraint.uncertainties[i].scaled(constraint.bestEstimate, uncertScalar);
        }
        UncertainDataConstraint.SectMappedUncertainDataConstraint ret = new UncertainDataConstraint.SectMappedUncertainDataConstraint(constraint.name, constraint.sectionIndex, constraint.sectionName, constraint.dataLocation, constraint.bestEstimate, modUncerts);
        return ret;
    }

    public double getUncertaintyScalar() {
        return this.scalar;
    }

    public static void main(String[] args) {
        for (NSHM23_PaleoUncertainties uncert : NSHM23_PaleoUncertainties.values()) {
            System.out.println(uncert.getName() + ": " + (float)uncert.getUncertaintyScalar());
        }
    }
}

