/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.AbstractSamplingNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.BranchDependentSampler;

public class BranchSamplingManager
implements SplittableRuptureModule<BranchSamplingManager> {
    private FaultSystemRupSet rupSet;
    private LogicTreeBranch<?> branch;
    private long[] nodeSpecificSeeds;
    private long[] branchNodeUniqueSeeds;
    private List<BranchDependentSampler<?>> samplers;

    public static boolean hasSamplingNodes(LogicTreeBranch<?> branch) {
        for (LogicTreeNode node : branch) {
            if (!(node instanceof AbstractSamplingNode)) continue;
            return true;
        }
        return false;
    }

    public BranchSamplingManager(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        this.rupSet = rupSet;
        this.branch = branch;
        this.nodeSpecificSeeds = new long[branch.size()];
        for (int l = 0; l < branch.size(); ++l) {
            LogicTreeLevel<?> level = branch.getLevel(l);
            Object node = branch.getValue(l);
            long nodeSeed = node instanceof LogicTreeNode.RandomlySampledNode ? ((LogicTreeNode.RandomlySampledNode)node).getSeed() : (long)Objects.hash(level.getName(), node.getName());
            this.nodeSpecificSeeds[l] = nodeSeed;
        }
        long overallSeed = BranchSamplingManager.uniqueSeedCombination(this.nodeSpecificSeeds);
        Random rand = new Random(overallSeed);
        this.branchNodeUniqueSeeds = new long[branch.size()];
        for (int l = 0; l < this.branchNodeUniqueSeeds.length; ++l) {
            this.branchNodeUniqueSeeds[l] = rand.nextLong();
        }
    }

    private BranchSamplingManager(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, long[] nodeSpecificSeeds, long[] branchNodeUniqueSeeds, List<BranchDependentSampler<?>> samplers) {
        Preconditions.checkState((samplers != null && samplers.size() == branch.size() ? 1 : 0) != 0, (Object)"Samplers must be initialized");
        this.rupSet = rupSet;
        this.branch = branch;
        this.nodeSpecificSeeds = nodeSpecificSeeds;
        this.branchNodeUniqueSeeds = branchNodeUniqueSeeds;
    }

    public static long uniqueSeedCombination(long[] seeds) {
        if (seeds == null) {
            return 0L;
        }
        long result = 1L;
        for (long element : seeds) {
            result = 31L * result + element;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitSamplers() {
        if (this.samplers == null) {
            BranchSamplingManager branchSamplingManager = this;
            synchronized (branchSamplingManager) {
                if (this.samplers == null) {
                    ArrayList samplers = new ArrayList(this.branch.size());
                    for (int i = 0; i < this.branch.size(); ++i) {
                        Object node = this.branch.getValue(i);
                        if (node instanceof AbstractSamplingNode) {
                            samplers.add((BranchDependentSampler<?>)((AbstractSamplingNode)node).buildSampler(this.rupSet, this.branch, this.branchNodeUniqueSeeds[i]));
                            continue;
                        }
                        samplers.add(null);
                    }
                    this.samplers = samplers;
                }
            }
        }
    }

    public <E extends BranchDependentSampler<E>> E getSampler(AbstractSamplingNode<E> node) {
        int index = this.nodeIndex(node);
        this.checkInitSamplers();
        BranchDependentSampler<?> sampler = this.samplers.get(index);
        return (E)sampler;
    }

    private int nodeIndex(LogicTreeNode node) {
        int ret = -1;
        String name = node.getName();
        for (int i = 0; i < this.branch.size(); ++i) {
            Object oNode = this.branch.getValue(i);
            if (oNode == null || !oNode.equals(node)) continue;
            Preconditions.checkState((ret < 0 ? 1 : 0) != 0, (String)"Node %s matches multiple levels", (Object)name);
            ret = i;
        }
        Preconditions.checkState((ret >= 0 ? 1 : 0) != 0, (String)"Node '%s' not found on our branch: %s", (Object)name, this.branch);
        return ret;
    }

    @Override
    public String getName() {
        return "Branch Sampling Manager";
    }

    @Override
    public BranchSamplingManager getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
        this.checkInitSamplers();
        ArrayList subsetSamplers = new ArrayList(this.samplers.size());
        for (BranchDependentSampler<?> sampler : this.samplers) {
            if (sampler == null) {
                subsetSamplers.add(null);
                continue;
            }
            subsetSamplers.add((BranchDependentSampler<?>)sampler.getForRuptureSubSet(rupSubSet, mappings));
        }
        return new BranchSamplingManager(rupSubSet, this.branch, this.nodeSpecificSeeds, this.branchNodeUniqueSeeds, subsetSamplers);
    }

    @Override
    public BranchSamplingManager getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
        throw new UnsupportedOperationException();
    }
}

