/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureCollection;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.GeoJSON_Type;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.NamedFaults;
import org.opensha.sha.earthquake.faultSysSolution.modules.RegionsOfInterest;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.MaxMagOffFaultBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_RegionalSeismicity;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.prior2018.NSHM18_DeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.NSHM23_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.enumTreeBranches.FaultModels;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="indices.csv"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum NSHM18_FaultModels implements LogicTreeNode,
RupSetFaultModel
{
    NSHM18_WUS_NoCA("NSHM18 WUS Except CA", "NSHM18-WUS-NoCA", NSHM18_DeformationModels.GEOL, 1.0){

        @Override
        public List<? extends FaultSection> getFaultSections() throws IOException {
            BufferedReader sectsReader = new BufferedReader(new InputStreamReader(GeoJSONFaultReader.class.getResourceAsStream(NSHM18_FaultModels.NSHM18_SECTS_PATH)));
            Preconditions.checkNotNull((Object)sectsReader, (String)"Fault model file not found: %s", (Object)NSHM18_FaultModels.NSHM18_SECTS_PATH);
            return GeoJSONFaultReader.readFaultSections(sectsReader);
        }
    }
    ,
    NSHM18_WUS_PlusU3_FM_3p1("NSHM18 WUS w/ UCERF3 FM3.1", "NSHM18-WUS-U3_FM3_1", NSHM18_DeformationModels.GEOL, 1.0){

        @Override
        public List<? extends FaultSection> getFaultSections() throws IOException {
            List<? extends FaultSection> outsideSects = NSHM18_WUS_NoCA.getFaultSections();
            HashMap<Integer, String> outsideIDs = new HashMap<Integer, String>();
            for (FaultSection faultSection : outsideSects) {
                Preconditions.checkState((!outsideIDs.containsKey(faultSection.getSectionId()) ? 1 : 0) != 0, (Object)"Duplicate ID");
                outsideIDs.put(faultSection.getSectionId(), faultSection.getSectionName());
            }
            List<FaultSection> fm31Sects = FaultModels.FM3_1.getFaultSections();
            ArrayList<? extends FaultSection> arrayList = new ArrayList<FaultSection>(outsideSects);
            for (FaultSection sect : fm31Sects) {
                if (sect.getSectionId() == 721 || sect.getSectionId() == 719) continue;
                Preconditions.checkState((!outsideIDs.containsKey(sect.getSectionId()) ? 1 : 0) != 0, (String)"UCERF3 uses ID %s for '%s', which is also mapped to '%s' outside of CA ", (Object)sect.getSectionId(), (Object)sect.getSectionName(), outsideIDs.get(sect.getSectionId()));
                arrayList.add(sect);
            }
            return arrayList;
        }
    };

    static final Set<String> STATES;
    public static final String NSHM18_SECTS_PATH = "/data/erf/nshm18/fault_models/geol_fm_2018.geojson";
    public static boolean USE_NEW_PALEO_DATA;
    private String name;
    private String shortName;
    private RupSetDeformationModel defaultDM;
    private double weight;

    private NSHM18_FaultModels(String name, String shortName, RupSetDeformationModel defaultDM, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.defaultDM = defaultDM;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public abstract List<? extends FaultSection> getFaultSections() throws IOException;

    @Override
    public RupSetDeformationModel getDefaultDeformationModel() {
        return this.defaultDM;
    }

    @Override
    public void attachDefaultModules(final FaultSystemRupSet rupSet) {
        final LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<ModelRegion>(){

            @Override
            public ModelRegion call() throws Exception {
                return new ModelRegion(NSHM23_RegionLoader.loadFullConterminousWUS());
            }
        }, ModelRegion.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<NamedFaults>(){
            final /* synthetic */ NSHM18_FaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public NamedFaults call() throws Exception {
                NamedFaults named = this.this$0.getNamedFaults();
                named.setParent(rupSet);
                return named;
            }
        }, NamedFaults.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RegionsOfInterest>(){
            final /* synthetic */ NSHM18_FaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RegionsOfInterest call() throws Exception {
                ArrayList<Region> regions = new ArrayList<Region>();
                ArrayList<IncrementalMagFreqDist> regionMFDs = new ArrayList<IncrementalMagFreqDist>();
                List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
                MaxMagOffFaultBranchNode offFaultMMax = null;
                if (branch != null) {
                    offFaultMMax = branch.getValue(MaxMagOffFaultBranchNode.class);
                }
                for (NSHM23_RegionLoader.SeismicityRegions pReg : NSHM23_RegionLoader.SeismicityRegions.values()) {
                    Region region = pReg.load();
                    if (!FaultSectionUtils.anySectInRegion(region, subSects, true)) continue;
                    double faultSysMmax = 0.0;
                    double[] fracts = rupSet.getFractRupsInsideRegion(region, true);
                    for (int rupIndex = 0; rupIndex < fracts.length; ++rupIndex) {
                        if (!(fracts[rupIndex] > 0.0)) continue;
                        faultSysMmax = Math.max(faultSysMmax, rupSet.getMagForRup(rupIndex));
                    }
                    double mMax = faultSysMmax;
                    if (offFaultMMax != null) {
                        mMax = Math.max(offFaultMMax.getMaxMagOffFault(), mMax);
                    }
                    IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(Math.max(mMax, rupSet.getMaxMag()));
                    regionMFDs.add(NSHM23_RegionalSeismicity.getBounded(pReg, refMFD, mMax));
                    regions.add(region);
                }
                for (Region region : NSHM23_RegionLoader.loadLocalRegions(subSects)) {
                    regions.add(region);
                    regionMFDs.add(null);
                }
                return new RegionsOfInterest(regions, regionMFDs);
            }
        }, RegionsOfInterest.class);
    }

    @Override
    public NamedFaults getNamedFaults() {
        Gson gson = new GsonBuilder().create();
        String namedFaultsFile = "/data/erf/nshm18/fault_models/special_faults.json";
        BufferedReader reader = new BufferedReader(new InputStreamReader(FaultModels.class.getResourceAsStream(namedFaultsFile)));
        Type type = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{Integer.class}).getType()}).getType();
        Map namedFaults = (Map)gson.fromJson((Reader)reader, type);
        Preconditions.checkState((!namedFaults.isEmpty() ? 1 : 0) != 0, (Object)"No named faults found");
        return new NamedFaults(null, namedFaults);
    }

    public static void convertConsolidatedGeoJSON(File inputGeoJSON, File outputGeoJSON) throws IOException {
        FeatureCollection inFeatures = FeatureCollection.read(inputGeoJSON);
        HashSet<Integer> ids = new HashSet<Integer>();
        ArrayList<GeoJSONFaultSection> sects = new ArrayList<GeoJSONFaultSection>();
        for (Feature feature : inFeatures) {
            FeatureProperties props = feature.properties;
            String name = props.get("name", null);
            int id = ((Number)feature.id).intValue();
            FeatureProperties cleanProps = new FeatureProperties();
            double dip = props.getDouble("dip", Double.NaN);
            Preconditions.checkState((boolean)Double.isFinite(dip), (String)"Bad dip for %s: %s", (Object)name, (Object)dip);
            cleanProps.put("DipDeg", dip);
            double lowDepth = props.getDouble("lower-depth", Double.NaN);
            Preconditions.checkState((boolean)Double.isFinite(lowDepth), (String)"Bad lower depth for %s: %s", (Object)name, (Object)lowDepth);
            cleanProps.put("LowDepth", lowDepth);
            double upDepth = props.getDouble("upper-depth", Double.NaN);
            Preconditions.checkState((boolean)Double.isFinite(upDepth), (String)"Bad upper depth for %s: %s", (Object)name, (Object)upDepth);
            cleanProps.put("UpDepth", upDepth);
            double rake = props.getDouble("rake", Double.NaN);
            Preconditions.checkState((boolean)Double.isFinite(rake), (String)"Bad rake for %s: %s", (Object)name, (Object)rake);
            cleanProps.put("Rake", rake);
            String state = props.get("state", null);
            if (state.equals("CA") || state.equals("AK")) continue;
            cleanProps.put("PrimState", state);
            Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"Bad ID for %s: %s", (Object)name, (int)id);
            Preconditions.checkState((!ids.contains(id) ? 1 : 0) != 0, (String)"Duplicate ID=%s for %s", (int)id, (Object)name);
            ids.add(id);
            cleanProps.set("FaultID", id);
            cleanProps.set("FaultName", name);
            Feature modFeature = new Feature(id, feature.geometry, cleanProps);
            sects.add(GeoJSONFaultSection.fromFeature(modFeature));
        }
        GeoJSONFaultReader.writeFaultSections(outputGeoJSON, sects);
        System.out.println("Writing " + sects.size() + " sects to " + outputGeoJSON.getAbsolutePath());
    }

    public static void convertIndividualGeoJSON(File inputDir, File outputGeoJSON) throws IOException {
        HashSet<Integer> ids = new HashSet<Integer>();
        ArrayList<GeoJSONFaultSection> sects = new ArrayList<GeoJSONFaultSection>();
        for (File stateDir : inputDir.listFiles()) {
            if (!stateDir.isDirectory()) continue;
            String state = stateDir.getName();
            if (!STATES.contains(state)) {
                System.out.println("Skipping state: " + state);
                continue;
            }
            System.out.println("Processing state: " + state);
            File stateGeo = new File(stateDir, state + ".geojson");
            FeatureCollection features = FeatureCollection.read(stateGeo);
            for (Feature feature : features) {
                FeatureProperties props = feature.properties;
                String name = props.get("name", null);
                System.out.println("\t" + name);
                int id = ((Number)feature.id).intValue();
                FeatureProperties cleanProps = new FeatureProperties();
                double dip = props.getDouble("dip", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(dip), (String)"Bad dip for %s: %s", (Object)name, (Object)dip);
                cleanProps.put("DipDeg", dip);
                double lowDepth = props.getDouble("lower-depth", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(lowDepth), (String)"Bad lower depth for %s: %s", (Object)name, (Object)lowDepth);
                cleanProps.put("LowDepth", lowDepth);
                double upDepth = props.getDouble("upper-depth", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(upDepth), (String)"Bad upper depth for %s: %s", (Object)name, (Object)upDepth);
                cleanProps.put("UpDepth", upDepth);
                double rake = props.getDouble("rake", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(rake), (String)"Bad rake for %s: %s", (Object)name, (Object)rake);
                cleanProps.put("Rake", rake);
                cleanProps.put("PrimState", state);
                Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"Bad ID for %s: %s", (Object)name, (int)id);
                Preconditions.checkState((!ids.contains(id) ? 1 : 0) != 0, (String)"Duplicate ID=%s for %s", (int)id, (Object)name);
                ids.add(id);
                cleanProps.set("FaultID", id);
                cleanProps.set("FaultName", name);
                Feature modFeature = new Feature(id, feature.geometry, cleanProps);
                sects.add(GeoJSONFaultSection.fromFeature(modFeature));
            }
        }
        GeoJSONFaultReader.writeFaultSections(outputGeoJSON, sects);
        System.out.println("Writing " + sects.size() + " sects to " + outputGeoJSON.getAbsolutePath());
    }

    public static void consolidatedFaultSearchGeoJSON(File sectsDir, File conusDir, File outputGeoJSON) throws IOException {
        HashMap<Integer, GeoJSONFaultSection> allSects = new HashMap<Integer, GeoJSONFaultSection>();
        boolean preferCONUS = true;
        for (File stateDir : sectsDir.listFiles()) {
            if (!stateDir.isDirectory()) continue;
            String state = stateDir.getName();
            if (!STATES.contains(state)) {
                System.out.println("Skipping state: " + state);
                continue;
            }
            System.out.println("Processing state: " + state);
            for (File faultDir : stateDir.listFiles()) {
                Feature feature;
                File jsonFile = new File(faultDir, faultDir.getName() + ".geojson");
                if (!jsonFile.exists()) continue;
                String name = faultDir.getName();
                System.out.println("\tReading " + jsonFile.getAbsolutePath());
                try {
                    feature = Feature.read(jsonFile);
                }
                catch (Exception e) {
                    FeatureCollection collection = FeatureCollection.read(jsonFile);
                    feature = null;
                    for (Feature oFeature : collection) {
                        if (oFeature.geometry.type != GeoJSON_Type.LineString) continue;
                        Preconditions.checkState((feature == null ? 1 : 0) != 0);
                        feature = oFeature;
                    }
                }
                FeatureProperties props = feature.properties;
                int id = ((Number)feature.id).intValue();
                FeatureProperties cleanProps = new FeatureProperties();
                double dip = props.getDouble("dip", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(dip), (String)"Bad dip for %s: %s", (Object)name, (Object)dip);
                cleanProps.put("DipDeg", dip);
                double lowDepth = props.getDouble("lower-depth", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(lowDepth), (String)"Bad lower depth for %s: %s", (Object)name, (Object)lowDepth);
                cleanProps.put("LowDepth", lowDepth);
                double upDepth = props.getDouble("upper-depth", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(upDepth), (String)"Bad upper depth for %s: %s", (Object)name, (Object)upDepth);
                cleanProps.put("UpDepth", upDepth);
                double rake = props.getDouble("rake", Double.NaN);
                Preconditions.checkState((boolean)Double.isFinite(rake), (String)"Bad rake for %s: %s", (Object)name, (Object)rake);
                cleanProps.put("Rake", rake);
                cleanProps.put("PrimState", state);
                Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"Bad ID for %s: %s", (Object)name, (int)id);
                Preconditions.checkState((!allSects.containsKey(id) ? 1 : 0) != 0, (String)"Duplicate ID=%s for %s", (int)id, (Object)name);
                cleanProps.set("FaultID", id);
                cleanProps.set("FaultName", name);
                Feature modFeature = new Feature(id, feature.geometry, cleanProps);
                allSects.put(id, GeoJSONFaultSection.fromFeature(modFeature));
            }
        }
        BufferedReader dmReader = new BufferedReader(new InputStreamReader(NSHM18_DeformationModels.class.getResourceAsStream("/data/erf/nshm18/def_models/deformation-model-data.json")));
        Preconditions.checkNotNull((Object)dmReader, (String)"Deformation model file not found: %s", (Object)"/data/erf/nshm18/def_models/deformation-model-data.json");
        Gson gson = new GsonBuilder().create();
        List records = (List)gson.fromJson((Reader)dmReader, TypeToken.getParameterized(List.class, (Type[])new Type[]{NSHM18_DeformationModels.DefModelRecord.class}).getType());
        ArrayList<GeoJSONFaultSection> sects = new ArrayList<GeoJSONFaultSection>();
        System.out.println("Mapping sections from deformation model");
        int numCONUS = 0;
        int numFS = 0;
        int numSkipped = 0;
        for (NSHM18_DeformationModels.DefModelRecord record : records) {
            GeoJSONFaultSection sect;
            if (!STATES.contains(record.state)) continue;
            System.out.println("Mapping " + record.id + ". " + record.name);
            GeoJSONFaultSection fmSect = (GeoJSONFaultSection)allSects.get(record.id);
            GeoJSONFaultSection conusSect = null;
            File jsonFile = NSHM18_FaultModels.findGeoJSON(conusDir, record.name);
            if (jsonFile != null) {
                Feature feature = Feature.read(jsonFile);
                FeatureProperties props = feature.properties;
                int id = ((Number)feature.id).intValue();
                String name = props.get("name", null);
                if (id == record.id) {
                    FeatureProperties cleanProps = new FeatureProperties();
                    double dip = props.getDouble("dip", Double.NaN);
                    Preconditions.checkState((boolean)Double.isFinite(dip), (String)"Bad dip for %s: %s", (Object)name, (Object)dip);
                    cleanProps.put("DipDeg", dip);
                    double lowDepth = props.getDouble("lower-depth", Double.NaN);
                    Preconditions.checkState((boolean)Double.isFinite(lowDepth), (String)"Bad lower depth for %s: %s", (Object)name, (Object)lowDepth);
                    cleanProps.put("LowDepth", lowDepth);
                    double upDepth = props.getDouble("upper-depth", Double.NaN);
                    Preconditions.checkState((boolean)Double.isFinite(upDepth), (String)"Bad upper depth for %s: %s", (Object)name, (Object)upDepth);
                    cleanProps.put("UpDepth", upDepth);
                    double rake = props.getDouble("rake", Double.NaN);
                    Preconditions.checkState((boolean)Double.isFinite(rake), (String)"Bad rake for %s: %s", (Object)name, (Object)rake);
                    cleanProps.put("Rake", rake);
                    cleanProps.put("PrimState", record.state);
                    Preconditions.checkState((id >= 0 ? 1 : 0) != 0, (String)"Bad ID for %s: %s", (Object)name, (int)id);
                    cleanProps.set("FaultID", id);
                    cleanProps.set("FaultName", record.name);
                    Feature modFeature = new Feature(id, feature.geometry, cleanProps);
                    conusSect = GeoJSONFaultSection.fromFeature(modFeature);
                } else {
                    System.err.println("\tWARNING: CONUS record for " + record.name + " has a different id: " + id + " != " + record.id);
                }
            }
            if ((sect = preferCONUS && conusSect != null ? conusSect : fmSect) == null) {
                System.err.println("WARNING: couldn't locate fault " + record.name + ", skipping");
                ++numSkipped;
                continue;
            }
            if (sect == conusSect) {
                System.out.println("\tUsing CONUS from " + jsonFile.getAbsolutePath());
                ++numCONUS;
            } else {
                System.out.println("\tUsing fault-sections");
                ++numFS;
            }
            if (!sect.getSectionName().equals(record.name)) {
                System.out.println("\tRenaming: " + sect.getSectionName() + " -> " + record.name);
                sect.setSectionName(record.name);
            }
            sects.add(sect);
        }
        System.out.println("Used " + numCONUS + " from CONUS");
        System.out.println("Used " + numFS + " from fault-sections");
        System.out.println("Skipped " + numSkipped);
        GeoJSONFaultReader.writeFaultSections(outputGeoJSON, sects);
        System.out.println("Writing " + sects.size() + " sects to " + outputGeoJSON.getAbsolutePath());
    }

    private static File findGeoJSON(File dir, String name) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                File match = NSHM18_FaultModels.findGeoJSON(file, name);
                if (match == null) continue;
                return match;
            }
            if (!file.getName().equals(name + ".geojson")) continue;
            return file;
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        NSHM18_WUS_PlusU3_FM_3p1.getFaultSections();
    }

    static {
        STATES = Set.of("WA", "OR", "ID", "MT", "WY", "NV", "UT", "CO", "AZ", "NM");
        USE_NEW_PALEO_DATA = true;
    }
}

