/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.WordUtils;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class SegmentationImpliedSectNuclMFD_Estimator
extends SectNucleationMFD_Estimator {
    private JumpProbabilityCalc segModel;
    private List<IncrementalMagFreqDist> estSectSupraSeisMFDs;
    private SectSegmentationJumpTracker[] sectSegTrackers;
    private boolean trackIndepJumpTargets = false;
    private List<List<IncrementalMagFreqDist>> indepJumpTargetSupraSeisMFDs;
    private double[] targetSectSupraMoRates;
    private double[] targetSectSupraSlipRates;
    public static MultiBinDistributionMethod BIN_DIST_METHOD_DEFAULT = MultiBinDistributionMethod.CAPPED_DISTRIBUTED;
    private MultiBinDistributionMethod binDistMethod;
    public static boolean SELF_CONTAINED_DEFAULT = false;
    private boolean selfContained = SELF_CONTAINED_DEFAULT;
    private boolean allowExceedInitialGR = false;
    private static final double MIN_SLIP_RATE = 0.0;
    private static final int DEBUG_SECT = -1;
    private static final DecimalFormat eDF = new DecimalFormat("0.000E0");
    private static final DecimalFormat pDF = new DecimalFormat("0.000%");
    private static final Comparator<Collection<?>> collectionSizeComparator = new Comparator<Collection<?>>(){

        @Override
        public int compare(Collection<?> o1, Collection<?> o2) {
            return Integer.compare(o1.size(), o2.size());
        }
    };

    public SegmentationImpliedSectNuclMFD_Estimator(JumpProbabilityCalc segModel) {
        this(segModel, BIN_DIST_METHOD_DEFAULT, SELF_CONTAINED_DEFAULT);
    }

    public SegmentationImpliedSectNuclMFD_Estimator(JumpProbabilityCalc segModel, MultiBinDistributionMethod binDistMethod, boolean selfContained) {
        this.segModel = segModel;
        this.binDistMethod = binDistMethod;
        this.selfContained = selfContained;
    }

    public MultiBinDistributionMethod getBinDistMethod() {
        return this.binDistMethod;
    }

    public void setBinDistMethod(MultiBinDistributionMethod binDistMethod) {
        this.binDistMethod = binDistMethod;
    }

    public boolean isSelfContained() {
        return this.selfContained;
    }

    public void setSelfContained(boolean selfContained) {
        this.selfContained = selfContained;
    }

    public boolean isAllowExceedInitialGR() {
        return this.allowExceedInitialGR;
    }

    public void setAllowExceedInitialGR(boolean allowExceedInitialGR) {
        this.allowExceedInitialGR = allowExceedInitialGR;
    }

    public boolean isTrackIndepJumpTargets() {
        return this.trackIndepJumpTargets;
    }

    public void setTrackIndepJumpTargets(boolean trackIndepJumpTargets) {
        this.trackIndepJumpTargets = trackIndepJumpTargets;
    }

    public List<List<IncrementalMagFreqDist>> getIndepJumpTargetSupraSeisMFDs() {
        return this.indepJumpTargetSupraSeisMFDs;
    }

    @Override
    public void init(FaultSystemRupSet rupSet, List<IncrementalMagFreqDist> origSectSupraSeisMFDs, double[] targetSectSupraMoRates, double[] targetSectSupraSlipRates, double[] sectSupraSlipRateStdDevs, List<BitSet> sectRupUtilizations, int[] sectMinMagIndexes, int[] sectMaxMagIndexes, int[][] sectRupInBinCounts, EvenlyDiscretizedFunc refMFD) {
        int s;
        super.init(rupSet, origSectSupraSeisMFDs, targetSectSupraMoRates, targetSectSupraSlipRates, sectSupraSlipRateStdDevs, sectRupUtilizations, sectMinMagIndexes, sectMaxMagIndexes, sectRupInBinCounts, refMFD);
        this.targetSectSupraMoRates = targetSectSupraMoRates;
        this.targetSectSupraSlipRates = targetSectSupraSlipRates;
        int numSects = rupSet.getNumSections();
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        System.out.println("Pre-processing " + cRups.size() + " ruptures for segmentation calculation");
        final HashMap<Jump.UniqueDistJump, Double> segJumpProbsMap = new HashMap<Jump.UniqueDistJump, Double>();
        this.sectSegTrackers = new SectSegmentationJumpTracker[numSects];
        for (int s2 = 0; s2 < numSects; ++s2) {
            this.sectSegTrackers[s2] = new SectSegmentationJumpTracker(refMFD.size());
        }
        block1: for (int r = 0; r < cRups.size(); ++r) {
            ClusterRupture rup = cRups.get(r);
            HashSet<Jump.UniqueDistJump> jumps = new HashSet<Jump.UniqueDistJump>();
            double worstProb = 1.0;
            for (Jump origJump : rup.getJumpsIterable()) {
                double jumpProb;
                Jump.UniqueDistJump jump = origJump.toSection.getSectionId() < origJump.fromSection.getSectionId() ? new Jump.UniqueDistJump(origJump.reverse()) : new Jump.UniqueDistJump(origJump);
                if (segJumpProbsMap.containsKey(jump)) {
                    jumpProb = (Double)segJumpProbsMap.get(jump);
                } else {
                    jumpProb = this.segModel.calcJumpProbability(rup, origJump, false);
                    Preconditions.checkState((jumpProb >= 0.0 && jumpProb <= 1.0 ? 1 : 0) != 0);
                    segJumpProbsMap.put(jump, jumpProb);
                }
                if (jumpProb == 1.0) continue;
                if (jumpProb == 0.0) continue block1;
                jumps.add(jump);
                worstProb = Math.min(worstProb, jumpProb);
            }
            double mag = rupSet.getMagForRup(r);
            int magIndex = refMFD.getClosestXIndex(mag);
            for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
                for (FaultSection sect : cluster.subSects) {
                    this.sectSegTrackers[sect.getSectionId()].processRupture(jumps, worstProb, magIndex);
                }
            }
        }
        System.out.println("Estimating section nucleation MFDs implied by " + this.segModel.getName());
        int segBins = 0;
        int segBinsAvail = 0;
        int segSects = 0;
        double[][] sectNuclToParticScalars = new double[numSects][];
        for (int s3 = 0; s3 < numSects; ++s3) {
            int minMagIndex = sectMinMagIndexes[s3];
            int maxMagIndex = sectMaxMagIndexes[s3];
            double[] nuclToParticScalars = new double[1 + maxMagIndex - minMagIndex];
            double[] avgBinAreas = new double[nuclToParticScalars.length];
            int[] avgCounts = new int[avgBinAreas.length];
            BitSet utilization = sectRupUtilizations.get(s3);
            int r = utilization.nextSetBit(0);
            while (r >= 0) {
                int index;
                int n = index = refMFD.getClosestXIndex(rupSet.getMagForRup(r)) - minMagIndex;
                avgCounts[n] = avgCounts[n] + 1;
                int n2 = index;
                avgBinAreas[n2] = avgBinAreas[n2] + rupSet.getAreaForRup(r);
                r = utilization.nextSetBit(r + 1);
            }
            double sectArea = rupSet.getAreaForSection(s3);
            for (int m = 0; m < nuclToParticScalars.length; ++m) {
                if (avgCounts[m] <= 0) continue;
                int n = m;
                avgBinAreas[n] = avgBinAreas[n] / (double)avgCounts[m];
                nuclToParticScalars[m] = avgBinAreas[m] / sectArea;
            }
            sectNuclToParticScalars[s3] = nuclToParticScalars;
        }
        ArrayList<IncrementalMagFreqDist> modSupraSeisMFDs = new ArrayList<IncrementalMagFreqDist>();
        ArrayList<double[]> origBinContributions = new ArrayList<double[]>();
        for (int s4 = 0; s4 < numSects; ++s4) {
            if (this.appliesTo(rupSet.getFaultSectionData(s4))) {
                IncrementalMagFreqDist mfd = origSectSupraSeisMFDs.get(s4).deepClone();
                modSupraSeisMFDs.add(mfd);
                double[] contribFracts = new double[mfd.size()];
                double totRate = mfd.calcSumOfY_Vals();
                for (int i = 0; i < contribFracts.length; ++i) {
                    contribFracts[i] = mfd.getY(i) / totRate;
                }
                origBinContributions.add(contribFracts);
                continue;
            }
            modSupraSeisMFDs.add(null);
            origBinContributions.add(null);
        }
        HashMap<Jump.UniqueDistJump, Double> curJumpMaxParticipationRates = new HashMap<Jump.UniqueDistJump, Double>();
        if (this.allowExceedInitialGR) {
            System.err.println("WARNING: allowExceedInitialGR = true, should only be used for debugging or plot generation");
        }
        if (this.trackIndepJumpTargets) {
            this.indepJumpTargetSupraSeisMFDs = new ArrayList<List<IncrementalMagFreqDist>>();
            for (int s5 = 0; s5 < numSects; ++s5) {
                this.indepJumpTargetSupraSeisMFDs.add(null);
            }
        }
        int minIters = 10;
        int maxIters = 1000;
        int convergeBasisIters = 50;
        double targetMaxFractChange = 0.01;
        int iterations = 0;
        double prevIterTotRateChange = Double.POSITIVE_INFINITY;
        double prevIterTotFractRateChange = Double.POSITIVE_INFINITY;
        double prevIterMaxRateChange = Double.POSITIVE_INFINITY;
        double prevIterMaxFractRateChange = Double.POSITIVE_INFINITY;
        for (int i = 0; i < maxIters && (i < minIters || Math.abs(prevIterMaxFractRateChange) > targetMaxFractChange); ++i) {
            if (i > 0) {
                System.out.println("\tIteration changes: totalRate: " + (float)prevIterTotRateChange + " (" + pDF.format(prevIterTotFractRateChange) + ")\tmaxSectBinChange: " + (float)prevIterMaxRateChange + " (" + pDF.format(prevIterMaxFractRateChange) + ")");
            }
            System.out.println("Iteration " + i);
            double[] curParticRates = new double[numSects];
            prevIterTotRateChange = 0.0;
            prevIterTotFractRateChange = 0.0;
            prevIterMaxRateChange = 0.0;
            prevIterMaxFractRateChange = 0.0;
            for (int s6 = 0; s6 < numSects; ++s6) {
                IncrementalMagFreqDist supraMFD;
                if (!(targetSectSupraMoRates[s6] > 0.0)) continue;
                double[] nuclToParticScalars = sectNuclToParticScalars[s6];
                IncrementalMagFreqDist incrementalMagFreqDist = supraMFD = this.appliesTo(rupSet.getFaultSectionData(s6)) ? (IncrementalMagFreqDist)modSupraSeisMFDs.get(s6) : origSectSupraSeisMFDs.get(s6);
                if (targetSectSupraSlipRates[s6] < 0.0) {
                    supraMFD = supraMFD.deepClone();
                    supraMFD.scaleToTotalMomentRate(FaultMomentCalc.getMoment(rupSet.getAreaForSection(s6), 0.0));
                }
                for (int m = 0; m < nuclToParticScalars.length; ++m) {
                    double binRate = supraMFD.getY(m + sectMinMagIndexes[s6]);
                    int n = s6;
                    curParticRates[n] = curParticRates[n] + binRate * nuclToParticScalars[m];
                }
                Preconditions.checkState((curParticRates[s6] > 0.0 ? 1 : 0) != 0, (String)"Bad curParticRates=%s, iteration %s, s=%s", (Object)curParticRates[s6], (Object)i, (Object)s6);
            }
            for (Jump.UniqueDistJump jump : segJumpProbsMap.keySet()) {
                double jumpProb = (Double)segJumpProbsMap.get(jump);
                Preconditions.checkState((jumpProb > 0.0 ? 1 : 0) != 0);
                double sectRate = Math.min(curParticRates[jump.fromSection.getSectionId()], curParticRates[jump.toSection.getSectionId()]);
                curJumpMaxParticipationRates.put(jump, jumpProb * sectRate);
            }
            for (int s7 = 0; s7 < numSects; ++s7) {
                int m;
                int m2;
                SectSegmentationJumpTracker tracker = this.sectSegTrackers[s7];
                if (!this.appliesTo(rupSet.getFaultSectionData(s7))) continue;
                boolean debug = s7 == -1;
                IncrementalMagFreqDist origMFD = origSectSupraSeisMFDs.get(s7);
                IncrementalMagFreqDist modMFD = (IncrementalMagFreqDist)modSupraSeisMFDs.get(s7);
                double[] origBinContribution = (double[])origBinContributions.get(s7);
                double[] nuclToParticScalars = sectNuclToParticScalars[s7];
                if (debug) {
                    System.out.println("Debug " + s7 + " iteration " + i);
                    System.out.println("Pre-loop MFD");
                    for (int j = sectMinMagIndexes[s7]; j <= sectMaxMagIndexes[s7]; ++j) {
                        System.out.println("\t" + (float)modMFD.getX(j) + "\t" + (float)modMFD.getY(j));
                    }
                    System.out.println("Pre-loop participation rate: " + curParticRates[s7]);
                }
                if (this.selfContained) {
                    for (Jump.UniqueDistJump jump : segJumpProbsMap.keySet()) {
                        if (!tracker.usesJump(jump)) continue;
                        double jumpProb = (Double)segJumpProbsMap.get(jump);
                        Preconditions.checkState((jumpProb > 0.0 ? 1 : 0) != 0);
                        curJumpMaxParticipationRates.put(jump, jumpProb * curParticRates[s7]);
                    }
                }
                final Map<Jump.UniqueDistJump, List<Integer>> fullJumpBins = tracker.getIndependentControllingJumpBinsMapping(curJumpMaxParticipationRates, sectMinMagIndexes[s7]);
                double[] ceilRates = new double[modMFD.size()];
                double sumCurRates = modMFD.calcSumOfY_Vals();
                for (m2 = 0; m2 < modMFD.size(); ++m2) {
                    ceilRates[m2] = origBinContribution[m2] * sumCurRates;
                }
                if (debug) {
                    System.out.println("Ceiling rates:");
                    for (m2 = sectMinMagIndexes[s7]; m2 <= sectMaxMagIndexes[s7]; ++m2) {
                        System.out.print("\t" + (float)refMFD.getX(m2) + "=" + eDF.format(ceilRates[m2]));
                    }
                    System.out.println();
                }
                double[] availSegRates = new double[ceilRates.length];
                Collection<Jump.UniqueDistJump> jumps = fullJumpBins.keySet();
                if (this.binDistMethod == MultiBinDistributionMethod.CAPPED_DISTRIBUTED || debug) {
                    jumps = new ArrayList<Jump.UniqueDistJump>(jumps);
                    Collections.sort((List)jumps, new Comparator<Jump.UniqueDistJump>(){
                        final /* synthetic */ SegmentationImpliedSectNuclMFD_Estimator this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public int compare(Jump.UniqueDistJump o1, Jump.UniqueDistJump o2) {
                            List bins1 = (List)fullJumpBins.get(o1);
                            List bins2 = (List)fullJumpBins.get(o2);
                            int cmp = Integer.compare((Integer)bins1.get(bins1.size() - 1), (Integer)bins2.get(bins2.size() - 1));
                            if (cmp == 0) {
                                cmp = Integer.compare((Integer)bins1.get(0), (Integer)bins2.get(0));
                            }
                            if (cmp == 0) {
                                cmp = Double.compare((Double)segJumpProbsMap.get(o1), (Double)segJumpProbsMap.get(o2));
                            }
                            return cmp;
                        }
                    });
                }
                boolean[] affectedBins = new boolean[ceilRates.length];
                ArrayList<IncrementalMagFreqDist> jumpTargets = null;
                if (this.trackIndepJumpTargets) {
                    jumpTargets = new ArrayList<IncrementalMagFreqDist>();
                    this.indepJumpTargetSupraSeisMFDs.set(s7, jumpTargets);
                }
                for (Jump.UniqueDistJump jump : jumps) {
                    List<Integer> bins = fullJumpBins.get(jump);
                    Preconditions.checkState((bins.size() > 0 ? 1 : 0) != 0);
                    for (int bin : bins) {
                        affectedBins[bin] = true;
                    }
                    double segParticTarget = (Double)curJumpMaxParticipationRates.get(jump);
                    if (segParticTarget == 0.0) continue;
                    if (debug) {
                        System.out.println("Jump: " + String.valueOf(jump) + "\tsegParticTarget=" + segParticTarget + "\t" + jump.fromSection.getName() + " -> " + jump.toSection.getName());
                    }
                    IncrementalMagFreqDist jumpTarget = null;
                    if (this.trackIndepJumpTargets) {
                        jumpTarget = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
                        jumpTargets.add(jumpTarget);
                    }
                    if (this.binDistMethod == MultiBinDistributionMethod.GREEDY) {
                        for (int bin : bins) {
                            double rate = segParticTarget / nuclToParticScalars[bin - sectMinMagIndexes[s7]];
                            int n = bin;
                            availSegRates[n] = availSegRates[n] + rate;
                            if (jumpTarget == null) continue;
                            jumpTarget.set(bin, rate);
                        }
                    } else if (this.binDistMethod == MultiBinDistributionMethod.FULLY_DISTRIBUTED || this.binDistMethod == MultiBinDistributionMethod.CAPPED_DISTRIBUTED) {
                        double origTotJumpPartic = 0.0;
                        double[] origJumpBinPartics = new double[bins.size()];
                        for (int b = 0; b < origJumpBinPartics.length; ++b) {
                            int bin = bins.get(b);
                            double origBinNuclRate = origMFD.getY(bin);
                            double origBinParticRate = origBinNuclRate * nuclToParticScalars[bin - sectMinMagIndexes[s7]];
                            origTotJumpPartic += origBinParticRate;
                            origJumpBinPartics[b] = origBinParticRate;
                        }
                        double excessPartic = 0.0;
                        for (int b = 0; b < origJumpBinPartics.length; ++b) {
                            int bin = bins.get(b);
                            double origJumpBinParticFract = origJumpBinPartics[b] / origTotJumpPartic;
                            double binTargetParticRate = segParticTarget * origJumpBinParticFract;
                            double binTargetNuclRate = binTargetParticRate / nuclToParticScalars[bin - sectMinMagIndexes[s7]];
                            if (jumpTarget != null) {
                                jumpTarget.set(bin, binTargetNuclRate);
                            }
                            if (this.binDistMethod == MultiBinDistributionMethod.CAPPED_DISTRIBUTED) {
                                double newRate = availSegRates[bin] + binTargetNuclRate;
                                if (newRate > ceilRates[bin] && !this.allowExceedInitialGR) {
                                    double excessNucl = newRate - ceilRates[bin];
                                    excessPartic += excessNucl * nuclToParticScalars[bin - sectMinMagIndexes[s7]];
                                    newRate = ceilRates[bin];
                                }
                                availSegRates[bin] = newRate;
                                continue;
                            }
                            int n = bin;
                            availSegRates[n] = availSegRates[n] + binTargetNuclRate;
                        }
                        if (this.binDistMethod == MultiBinDistributionMethod.CAPPED_DISTRIBUTED && excessPartic > 0.0) {
                            boolean[] hasRooms = new boolean[bins.size()];
                            boolean hasRoom = false;
                            for (int b = 0; b < hasRooms.length; ++b) {
                                int bin = bins.get(b);
                                hasRooms[b] = availSegRates[bin] < ceilRates[bin];
                                hasRoom = hasRoom || hasRooms[b];
                            }
                            while (hasRoom && (float)excessPartic > 0.0f) {
                                double totFract = 0.0;
                                for (int b = 0; b < hasRooms.length; ++b) {
                                    if (!hasRooms[b]) continue;
                                    totFract += origJumpBinPartics[b];
                                }
                                double distributedPartic = 0.0;
                                hasRoom = false;
                                for (int b = 0; b < hasRooms.length; ++b) {
                                    if (!hasRooms[b]) continue;
                                    int bin = bins.get(b);
                                    double myFract = origJumpBinPartics[b] / totFract;
                                    double binAvailNucl = ceilRates[bin] - availSegRates[bin];
                                    double particScalar = nuclToParticScalars[bin - sectMinMagIndexes[s7]];
                                    double binAvailPartic = binAvailNucl * particScalar;
                                    double utilizedPartic = Math.min(excessPartic * myFract, binAvailPartic);
                                    double utilizedNucl = utilizedPartic / particScalar;
                                    int n = bin;
                                    availSegRates[n] = availSegRates[n] + utilizedNucl;
                                    distributedPartic += utilizedPartic;
                                    hasRooms[b] = (float)availSegRates[bin] < (float)ceilRates[bin];
                                    hasRoom = hasRoom || hasRooms[b];
                                }
                                excessPartic -= distributedPartic;
                            }
                        }
                    } else {
                        throw new IllegalStateException("Unsupported bin distribution method: " + String.valueOf((Object)this.binDistMethod));
                    }
                    if (!debug) continue;
                    System.out.print("Avail mag bins:");
                    for (int bin : bins) {
                        System.out.print(" " + (float)refMFD.getX(bin));
                    }
                    System.out.println();
                    System.out.println("Avail seg rates after jump:");
                    for (int m3 = sectMinMagIndexes[s7]; m3 <= sectMaxMagIndexes[s7]; ++m3) {
                        System.out.print("\t" + (float)refMFD.getX(m3) + "=" + eDF.format(availSegRates[m3]) + (bins.contains(m3) ? "*" : ""));
                    }
                    System.out.println();
                }
                boolean changed = false;
                double prevRateSum = modMFD.calcSumOfY_Vals();
                double[] prevRates = new double[modMFD.size()];
                IncrementalMagFreqDist prevMFD = !this.selfContained && i > convergeBasisIters ? modMFD.deepClone() : null;
                for (m = 0; m < modMFD.size(); ++m) {
                    double prevRate;
                    prevRates[m] = prevRate = modMFD.getY(m);
                    if (prevRate == 0.0 || !affectedBins[m]) continue;
                    double modRate = this.allowExceedInitialGR ? availSegRates[m] : Math.min(ceilRates[m], availSegRates[m]);
                    changed = changed || modRate != prevRate;
                    modMFD.set(m, modRate);
                }
                if (!changed) continue;
                if (debug) {
                    System.out.println("Post-loop MFD");
                    for (int j = sectMinMagIndexes[s7]; j <= sectMaxMagIndexes[s7]; ++j) {
                        System.out.println("\t" + (float)modMFD.getX(j) + "\t" + (float)modMFD.getY(j));
                    }
                    System.out.println("\tWill scale mooment to match " + targetSectSupraMoRates[s7] + " (cur=" + modMFD.getTotalMomentRate() + ")");
                }
                if (this.trackIndepJumpTargets && !jumpTargets.isEmpty()) {
                    double scaleRate = targetSectSupraMoRates[s7] / modMFD.getTotalMomentRate();
                    for (IncrementalMagFreqDist target : jumpTargets) {
                        target.scale(scaleRate);
                    }
                }
                modMFD.scaleToTotalMomentRate(targetSectSupraMoRates[s7]);
                if (prevMFD != null) {
                    double weightPrev = i - convergeBasisIters;
                    double weightCur = 1.0;
                    double sum = weightPrev + weightCur;
                    weightPrev /= sum;
                    weightCur /= sum;
                    IncrementalMagFreqDist avgMFD = new IncrementalMagFreqDist(modMFD.getMinX(), modMFD.size(), modMFD.getDelta());
                    for (int m4 = 0; m4 < avgMFD.size(); ++m4) {
                        avgMFD.set(m4, weightCur * modMFD.getY(m4) + weightPrev * prevMFD.getY(m4));
                    }
                    modMFD = avgMFD;
                }
                for (m = sectMinMagIndexes[s7]; m <= sectMaxMagIndexes[s7]; ++m) {
                    double fract;
                    if (prevRates[m] == 0.0) continue;
                    double change = modMFD.getY(m) - prevRates[m];
                    if (Math.abs(change) > Math.abs(prevIterMaxRateChange)) {
                        prevIterMaxRateChange = change;
                    }
                    if (!(Math.abs(fract = change / prevRates[m]) > Math.abs(prevIterMaxFractRateChange))) continue;
                    prevIterMaxFractRateChange = fract;
                }
                prevIterTotRateChange += modMFD.calcSumOfY_Vals() - prevRateSum;
            }
            double newSum = 0.0;
            for (s = 0; s < numSects; ++s) {
                IncrementalMagFreqDist supraMFD = (IncrementalMagFreqDist)modSupraSeisMFDs.get(s);
                if (supraMFD == null) {
                    supraMFD = origSectSupraSeisMFDs.get(s);
                }
                newSum += supraMFD.calcSumOfY_Vals();
            }
            prevIterTotFractRateChange = prevIterTotRateChange / newSum;
            ++iterations;
        }
        double sumOrigRate = 0.0;
        double sumModRate = 0.0;
        this.estSectSupraSeisMFDs = new ArrayList<IncrementalMagFreqDist>();
        for (s = 0; s < numSects; ++s) {
            IncrementalMagFreqDist origMFD = origSectSupraSeisMFDs.get(s);
            sumOrigRate += origMFD.calcSumOfY_Vals();
            IncrementalMagFreqDist modMFD = (IncrementalMagFreqDist)modSupraSeisMFDs.get(s);
            if (modMFD == null) {
                sumModRate += origMFD.calcSumOfY_Vals();
                this.estSectSupraSeisMFDs.add(origMFD);
                continue;
            }
            sumModRate += modMFD.calcSumOfY_Vals();
            int numChanged = 0;
            for (int i = 0; i < modMFD.size(); ++i) {
                if ((float)modMFD.getY(i) == (float)origMFD.getY(i)) continue;
                ++numChanged;
            }
            segBins += numChanged;
            if (numChanged > 0) {
                ++segSects;
            }
            this.estSectSupraSeisMFDs.add(modMFD);
            segBinsAvail += this.sectSegTrackers[s].numControlledBins;
        }
        System.out.println("Completed segmentation adjustment after " + iterations + " iterations");
        System.out.println("\tAffected " + segSects + "/" + numSects + " sections and " + segBins + "/" + segBinsAvail + " bins");
        System.out.println("\tLast iteration changes: totalRate: " + (float)prevIterTotRateChange + " (" + pDF.format(prevIterTotFractRateChange) + ")\tmaxSectBinChange: " + (float)prevIterMaxRateChange + " (" + pDF.format(prevIterMaxFractRateChange) + ")");
        double fractDiff = (sumModRate - sumOrigRate) / sumOrigRate;
        Object pDiffStr = new DecimalFormat("0.00%").format(fractDiff);
        if (fractDiff > 0.0) {
            pDiffStr = "+" + (String)pDiffStr;
        }
        System.out.println("\tTotal supra-seis rate change: " + (float)sumOrigRate + " -> " + (float)sumModRate + " (" + (String)pDiffStr + ")");
    }

    @Override
    public boolean appliesTo(FaultSection sect) {
        Preconditions.checkNotNull((Object)this.sectSegTrackers, (Object)"Not initialized");
        int s = sect.getSectionId();
        return !this.sectSegTrackers[s].notControlled() && this.targetSectSupraMoRates[s] != 0.0 && this.targetSectSupraSlipRates[s] != 0.0;
    }

    @Override
    public IncrementalMagFreqDist estimateNuclMFD(FaultSection sect, IncrementalMagFreqDist curSectSupraSeisMFD, List<Integer> availableRupIndexes, List<Double> availableRupMags, UncertainDataConstraint sectMomentRate, boolean sparseGR) {
        Preconditions.checkNotNull(this.estSectSupraSeisMFDs, (Object)"Not initialized");
        return this.estSectSupraSeisMFDs.get(sect.getSectionId());
    }

    public static enum MultiBinDistributionMethod {
        GREEDY,
        FULLY_DISTRIBUTED,
        CAPPED_DISTRIBUTED;


        public String toString() {
            return WordUtils.capitalizeFully((String)this.name().replace("_", " "));
        }
    }

    private static class SectSegmentationJumpTracker {
        private BitSet unityProbBins;
        private Map<Integer, Set<Set<Jump.UniqueDistJump>>> binJumps;
        private int numControlledBins = 0;
        private Set<Jump.UniqueDistJump> allJumps;

        public SectSegmentationJumpTracker(int numBins) {
            this.unityProbBins = new BitSet(numBins);
            this.binJumps = new HashMap<Integer, Set<Set<Jump.UniqueDistJump>>>();
            this.allJumps = new HashSet<Jump.UniqueDistJump>();
        }

        public boolean controlled() {
            return this.numControlledBins > 0;
        }

        public boolean notControlled() {
            return this.numControlledBins == 0;
        }

        public boolean usesJump(Jump.UniqueDistJump jump) {
            return this.allJumps.contains(jump);
        }

        public void processRupture(HashSet<Jump.UniqueDistJump> jumps, double worstJumpProb, int magIndex) {
            if (this.unityProbBins.get(magIndex)) {
                return;
            }
            if (worstJumpProb == 1.0) {
                Set<Set<Jump.UniqueDistJump>> prev = this.binJumps.remove(magIndex);
                if (prev != null) {
                    --this.numControlledBins;
                }
                this.unityProbBins.set(magIndex);
            } else {
                Preconditions.checkState((jumps != null && !jumps.isEmpty() ? 1 : 0) != 0);
                this.allJumps.addAll(jumps);
                Set<Set<Jump.UniqueDistJump>> myBinJumps = this.binJumps.get(magIndex);
                if (myBinJumps == null) {
                    ++this.numControlledBins;
                    myBinJumps = new HashSet<Set<Jump.UniqueDistJump>>();
                    this.binJumps.put(magIndex, myBinJumps);
                } else {
                    if (myBinJumps.contains(jumps)) {
                        return;
                    }
                    int mySize = jumps.size();
                    for (Set<Jump.UniqueDistJump> otherPath : myBinJumps) {
                        if (mySize <= otherPath.size() || !jumps.containsAll(otherPath)) continue;
                        return;
                    }
                    ArrayList<Set<Jump.UniqueDistJump>> supersets = new ArrayList<Set<Jump.UniqueDistJump>>();
                    for (Set<Jump.UniqueDistJump> otherPath : myBinJumps) {
                        if (otherPath.size() <= mySize || !otherPath.containsAll(jumps)) continue;
                        supersets.add(otherPath);
                    }
                    for (Set<Jump.UniqueDistJump> superset : supersets) {
                        myBinJumps.remove(superset);
                    }
                }
                myBinJumps.add(jumps);
            }
        }

        public Map<Jump.UniqueDistJump, List<Integer>> getIndependentControllingJumpBinsMapping(Map<Jump.UniqueDistJump, Double> curJumpMaxParticipationRates, int sectMinIndex) {
            Preconditions.checkState((boolean)this.controlled());
            HashMap<Jump.UniqueDistJump, List<Integer>> map = new HashMap<Jump.UniqueDistJump, List<Integer>>();
            for (int index : this.binJumps.keySet()) {
                if (index < sectMinIndex) continue;
                Set<Set<Jump.UniqueDistJump>> myBinJumps = this.binJumps.get(index);
                HashMap<Jump.UniqueDistJump, Set> indepControllingJumps = new HashMap<Jump.UniqueDistJump, Set>();
                ArrayList<Set<Jump.UniqueDistJump>> sortedBinJumps = new ArrayList<Set<Jump.UniqueDistJump>>(myBinJumps);
                Collections.sort(sortedBinJumps, collectionSizeComparator);
                for (Set set : sortedBinJumps) {
                    Preconditions.checkState((!set.isEmpty() ? 1 : 0) != 0);
                    Jump.UniqueDistJump controllingJump = null;
                    double minRate = Double.POSITIVE_INFINITY;
                    for (Jump.UniqueDistJump jump : set) {
                        double rate = curJumpMaxParticipationRates.get(jump);
                        if (!(rate < minRate)) continue;
                        minRate = rate;
                        controllingJump = jump;
                    }
                    if (indepControllingJumps.containsKey(controllingJump)) continue;
                    ArrayList<Jump.UniqueDistJump> evictions = new ArrayList<Jump.UniqueDistJump>();
                    boolean superceded = false;
                    for (Jump.UniqueDistJump prevControlling : indepControllingJumps.keySet()) {
                        Set prevDependent = (Set)indepControllingJumps.get(prevControlling);
                        boolean intersects = false;
                        for (Jump.UniqueDistJump jump : set) {
                            if (!prevDependent.contains(jump)) continue;
                            intersects = true;
                            break;
                        }
                        if (!intersects) continue;
                        if (minRate > curJumpMaxParticipationRates.get(prevControlling)) {
                            evictions.add(prevControlling);
                            continue;
                        }
                        superceded = true;
                        break;
                    }
                    if (superceded) continue;
                    for (Jump.UniqueDistJump jump : evictions) {
                        Preconditions.checkNotNull((Object)((Set)indepControllingJumps.remove(jump)));
                    }
                    indepControllingJumps.put(controllingJump, set);
                }
                for (Jump.UniqueDistJump uniqueDistJump : indepControllingJumps.keySet()) {
                    ArrayList<Integer> list = (ArrayList<Integer>)map.get(uniqueDistJump);
                    if (list == null) {
                        list = new ArrayList<Integer>();
                        map.put(uniqueDistJump, list);
                    }
                    list.add(index);
                }
            }
            for (List list : map.values()) {
                Collections.sort(list);
            }
            return map;
        }
    }
}

