/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SupraSeisBValInversionTargetMFDs;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.SectNucleationMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public abstract class ThresholdAveragingSectNuclMFD_Estimator
extends SectNucleationMFD_Estimator {
    private HashSet<Integer> affectedSects;
    private double[] rupProbs;
    private int[] rupMagIndexes;
    private static final int MAX_DISCRETIZATIONS = 1000;
    private static final int DEBUG_SECT = -1;
    private int[] sectMinMagIndexes;
    private int[] sectMaxMagIndexes;
    protected List<Float> fixedBinEdges;
    private FaultSystemRupSet rupSet;
    private static final DecimalFormat eDF = new DecimalFormat("0.00E0");

    public static Map<Jump, Double> calcAverageJumpProbs(ClusterRuptures cRups, JumpProbabilityCalc jumpModel) {
        HashMap<Jump, QuickAvgTrack> origJumpProbsMap = new HashMap<Jump, QuickAvgTrack>();
        for (ClusterRupture rup : cRups) {
            for (Jump jump : rup.getJumpsIterable()) {
                QuickAvgTrack jumpProbs;
                if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                    jump = jump.reverse();
                }
                if ((jumpProbs = (QuickAvgTrack)origJumpProbsMap.get(jump)) == null) {
                    jumpProbs = new QuickAvgTrack();
                    origJumpProbsMap.put(jump, jumpProbs);
                }
                jumpProbs.add(jumpModel.calcJumpProbability(rup, jump, false));
            }
        }
        HashMap<Jump, Double> avgOrigJumpProbs = new HashMap<Jump, Double>();
        for (Jump jump : origJumpProbsMap.keySet()) {
            double prob = ((QuickAvgTrack)origJumpProbsMap.get(jump)).getAverage();
            avgOrigJumpProbs.put(jump, prob);
            avgOrigJumpProbs.put(jump.reverse(), prob);
        }
        return avgOrigJumpProbs;
    }

    public ThresholdAveragingSectNuclMFD_Estimator() {
        this(null);
    }

    public ThresholdAveragingSectNuclMFD_Estimator(List<? extends Number> fixedBinEdges) {
        if (fixedBinEdges != null) {
            Preconditions.checkState((!fixedBinEdges.isEmpty() ? 1 : 0) != 0);
            this.fixedBinEdges = new ArrayList<Float>();
            for (Number number : fixedBinEdges) {
                this.fixedBinEdges.add(Float.valueOf(number.floatValue()));
            }
            Collections.sort(this.fixedBinEdges);
            Collections.reverse(this.fixedBinEdges);
            if (this.fixedBinEdges.get(0).floatValue() != 1.0f) {
                this.fixedBinEdges.add(0, Float.valueOf(1.0f));
            }
        }
    }

    @Override
    public void init(FaultSystemRupSet rupSet, List<IncrementalMagFreqDist> origSectSupraSeisMFDs, double[] targetSectSupraMoRates, double[] targetSectSupraSlipRates, double[] sectSupraSlipRateStdDevs, List<BitSet> sectRupUtilizations, int[] sectMinMagIndexes, int[] sectMaxMagIndexes, int[][] sectRupInBinCounts, EvenlyDiscretizedFunc refMFD) {
        this.rupSet = rupSet;
        this.sectMinMagIndexes = sectMinMagIndexes;
        this.sectMaxMagIndexes = sectMaxMagIndexes;
        super.init(rupSet, origSectSupraSeisMFDs, targetSectSupraMoRates, targetSectSupraSlipRates, sectSupraSlipRateStdDevs, sectRupUtilizations, sectMinMagIndexes, sectMaxMagIndexes, sectRupInBinCounts, refMFD);
        this.affectedSects = new HashSet();
        this.rupProbs = new double[rupSet.getNumRuptures()];
        this.rupMagIndexes = new int[rupSet.getNumRuptures()];
        ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            ClusterRupture rup = cRups.get(r);
            this.rupProbs[r] = this.calcRupProb(rup);
            this.rupMagIndexes[r] = refMFD.getClosestXIndex(rupSet.getMagForRup(r));
            if (!(this.rupProbs[r] < 1.0)) continue;
            for (int sectIndex : rupSet.getSectionsIndicesForRup(r)) {
                this.affectedSects.add(sectIndex);
            }
        }
    }

    protected abstract double calcRupProb(ClusterRupture var1);

    @Override
    public boolean appliesTo(FaultSection sect) {
        return this.affectedSects.contains(sect.getSectionId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IncrementalMagFreqDist estimateNuclMFD(FaultSection sect, IncrementalMagFreqDist curSectSupraSeisMFD, List<Integer> availableRupIndexes, List<Double> availableRupMags, UncertainDataConstraint sectMomentRate, boolean sparseGR) {
        float prob;
        if (sectMomentRate != null && sectMomentRate.bestEstimate == 0.0 || availableRupIndexes.isEmpty() || curSectSupraSeisMFD.calcSumOfY_Vals() == 0.0) {
            return curSectSupraSeisMFD;
        }
        boolean debug = sect.getSectionId() == -1;
        List<Object> sortedProbs = new ArrayList();
        double minNonZeroProb = 1.0;
        double maxProb = 0.0;
        for (int n : availableRupIndexes) {
            int insIndex;
            Float rupProb = Float.valueOf((float)this.rupProbs[n]);
            if (!(rupProb.floatValue() > 0.0f) || (insIndex = Collections.binarySearch(sortedProbs, rupProb)) >= 0) continue;
            insIndex = -(insIndex + 1);
            sortedProbs.add(insIndex, rupProb);
            minNonZeroProb = Math.min(this.rupProbs[n], minNonZeroProb);
            maxProb = Math.max(this.rupProbs[n], maxProb);
        }
        if (debug) {
            void var14_15;
            System.out.println("Debug for " + sect.getSectionId() + ". " + sect.getSectionName());
            System.out.println("Rupture prob range: [" + (float)minNonZeroProb + ", " + (float)maxProb + "]");
            HashSet singleFaultMags = new HashSet();
            boolean bl = false;
            ClusterRuptures cRups = this.rupSet.requireModule(ClusterRuptures.class);
            for (int i = 0; i < availableRupIndexes.size(); ++i) {
                int rupIndex = availableRupIndexes.get(i);
                ClusterRupture rup = cRups.get(rupIndex);
                if (rup.getTotalNumClusters() != 1) continue;
                ++var14_15;
                double mag = availableRupMags.get(i);
                int magIndex = curSectSupraSeisMFD.getClosestXIndex(mag);
                singleFaultMags.add(Float.valueOf((float)curSectSupraSeisMFD.getX(magIndex)));
            }
            ArrayList sortedMags = new ArrayList(singleFaultMags);
            Collections.sort(sortedMags);
            System.out.println("Single fault mags (" + (int)var14_15 + " rups): " + Joiner.on((String)",").join(sortedMags));
        }
        if (maxProb == 0.0) {
            return curSectSupraSeisMFD;
        }
        Preconditions.checkState((sortedProbs.size() >= 1 ? 1 : 0) != 0);
        if (this.fixedBinEdges == null) {
            if (((Float)sortedProbs.get(sortedProbs.size() - 1)).floatValue() != 1.0f) {
                sortedProbs.add(Float.valueOf(1.0f));
            }
            if (debug) {
                System.out.print("Unique probs:");
                for (Float f : sortedProbs) {
                    System.out.print(" " + f);
                }
                System.out.println();
            }
            if (sortedProbs.size() > 1000) {
                System.out.println("Decimating " + sortedProbs.size() + " unique probabilities down to 1000 points");
                while (sortedProbs.size() > 1000) {
                    double minDist = Double.POSITIVE_INFINITY;
                    int minDistIndex = -1;
                    double prevLnProb = Math.log(((Float)sortedProbs.get(0)).floatValue());
                    for (int i = 2; i < sortedProbs.size(); ++i) {
                        double myLnProb = Math.log(((Float)sortedProbs.get(i)).floatValue());
                        double dist = myLnProb - prevLnProb;
                        Preconditions.checkState((dist > 0.0 ? 1 : 0) != 0);
                        if (dist < minDist) {
                            minDist = dist;
                            minDistIndex = i - 1;
                        }
                        prevLnProb = myLnProb;
                    }
                    sortedProbs.remove(minDistIndex);
                }
            }
            Collections.reverse(sortedProbs);
        } else {
            sortedProbs = this.fixedBinEdges;
        }
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(curSectSupraSeisMFD.getMinX(), curSectSupraSeisMFD.size(), curSectSupraSeisMFD.getDelta());
        boolean[] blArray = new boolean[ret.size()];
        BitSet stillAvailableIndexes = new BitSet(availableRupIndexes.size());
        for (int i = 0; i < availableRupIndexes.size(); ++i) {
            stillAvailableIndexes.set(i);
        }
        double origMoRate = curSectSupraSeisMFD.getTotalMomentRate();
        IncrementalMagFreqDist prevMFD = null;
        double sumWeight = 0.0;
        if (debug) {
            System.out.print("Prob\tNext\tWeight");
            for (int i = this.sectMinMagIndexes[sect.getSectionId()]; i <= this.sectMaxMagIndexes[sect.getSectionId()]; ++i) {
                System.out.print("\t" + (float)curSectSupraSeisMFD.getX(i));
            }
            System.out.println();
        }
        for (int i = 0; i < sortedProbs.size() && (prob = ((Float)sortedProbs.get(i)).floatValue()) != 0.0f; ++i) {
            int b;
            IncrementalMagFreqDist myMFD;
            float nextProb = i == sortedProbs.size() - 1 ? 0.0f : ((Float)sortedProbs.get(i + 1)).floatValue();
            Preconditions.checkState((prob > nextProb ? 1 : 0) != 0);
            double weight = prob - nextProb;
            sumWeight += weight;
            boolean changed = false;
            if (stillAvailableIndexes.cardinality() > 0) {
                int j = stillAvailableIndexes.nextSetBit(0);
                while (j >= 0) {
                    int rupIndex = availableRupIndexes.get(j);
                    if ((float)this.rupProbs[rupIndex] > nextProb) {
                        if (!blArray[this.rupMagIndexes[rupIndex]]) {
                            blArray[this.rupMagIndexes[rupIndex]] = true;
                            changed = true;
                        }
                        stillAvailableIndexes.clear(j);
                    }
                    j = stillAvailableIndexes.nextSetBit(j + 1);
                }
            }
            if (prevMFD != null && !changed) {
                myMFD = prevMFD;
            } else {
                myMFD = new IncrementalMagFreqDist(curSectSupraSeisMFD.getMinX(), curSectSupraSeisMFD.size(), curSectSupraSeisMFD.getDelta());
                for (b = 0; b < myMFD.size(); ++b) {
                    if (!blArray[b]) continue;
                    myMFD.set(b, curSectSupraSeisMFD.getY(b));
                }
                if (myMFD.calcSumOfY_Vals() > 0.0) {
                    myMFD.scaleToTotalMomentRate(origMoRate);
                }
                prevMFD = myMFD;
            }
            if (debug) {
                System.out.print(eDF.format(prob) + "\t" + eDF.format(nextProb) + "\t" + eDF.format(weight));
                for (b = this.sectMinMagIndexes[sect.getSectionId()]; b <= this.sectMaxMagIndexes[sect.getSectionId()]; ++b) {
                    System.out.print("\t" + (blArray[b] ? "1" : "0"));
                }
                System.out.println();
            }
            for (b = 0; b < myMFD.size(); ++b) {
                ret.add(b, myMFD.getY(b) * weight);
            }
        }
        if (sumWeight > 1.02 || sumWeight < 0.98) {
            System.err.println("Warning, sumWeight=" + sumWeight + " for " + sect.getSectionId() + ". " + sect.getSectionName() + ", rescaling");
        }
        ret.scaleToTotalMomentRate(origMoRate);
        return ret;
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2022_07_29-nshm23_branches-NSHM23_v1p4-CoulombRupSet-DsrUni-TotNuclRate-SubB1-ThreshAvgIterRelGR/results_NSHM23_v1p4_CoulombRupSet_branch_averaged.zip"));
        Region reg = RupSetMapMaker.buildBufferedRegion(rupSet.getFaultSectionDataList());
        double bVal = 0.5;
        Shaw07JumpDistProb segModel = Shaw07JumpDistProb.forHorzOffset(1.0, 3.0, 2.0);
        File outputDir = new File("/tmp");
        WorstAvgJumpProb improb1 = new WorstAvgJumpProb(segModel);
        String name1 = "Seg-Prob";
        RelGRWorstJumpProb improb2 = new RelGRWorstJumpProb(segModel, 100, true);
        String name2 = "Rel-GR-100-Iters";
        String prefix = "thresh_avg_vs_rel_gr_iter";
        SupraSeisBValInversionTargetMFDs.Builder builder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, bVal);
        builder.subSeisMoRateReduction(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction.SUB_SEIS_B_1);
        builder.adjustTargetsForData(improb1);
        List<UncertainIncrMagFreqDist> mfds1 = builder.build().getOnFaultSupraSeisNucleationMFDs();
        builder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, bVal);
        builder.subSeisMoRateReduction(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction.SUB_SEIS_B_1);
        builder.adjustTargetsForData(improb2);
        List<UncertainIncrMagFreqDist> mfds2 = builder.build().getOnFaultSupraSeisNucleationMFDs();
        DefaultXY_DataSet probScatter = new DefaultXY_DataSet();
        double minNonZero = 1.0;
        for (ClusterRupture rup : rupSet.requireModule(ClusterRuptures.class)) {
            double prob1 = ((ThresholdAveragingSectNuclMFD_Estimator)improb1).calcRupProb(rup);
            double prob2 = ((ThresholdAveragingSectNuclMFD_Estimator)improb2).calcRupProb(rup);
            if (prob1 == 1.0 && prob2 == 1.0 || prob1 == 0.0 && prob2 == 0.0) continue;
            probScatter.set(prob1, prob2);
            if (prob1 > 0.0) {
                minNonZero = Math.min(minNonZero, prob1);
            }
            if (!(prob2 > 0.0)) continue;
            minNonZero = Math.min(minNonZero, prob2);
        }
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        Range range = new Range(Math.pow(10.0, Math.floor(Math.log10(minNonZero))), 1.0);
        DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
        oneToOne.set(range.getLowerBound(), range.getLowerBound());
        oneToOne.set(range.getUpperBound(), range.getUpperBound());
        funcs.add(oneToOne);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        funcs.add(probScatter);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(funcs, chars, "Thresh-Avg Probabilities", name1, name2);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(spec, true, true, range, range);
        PlotUtils.writePlots(outputDir, prefix + "_probs", (GraphPanel)gp, 1000, false, true, false, false);
        if (improb1 instanceof AbstractWorstJumpProb && improb2 instanceof AbstractWorstJumpProb) {
            DefaultXY_DataSet jumpProbScatter = new DefaultXY_DataSet();
            minNonZero = 1.0;
            HashSet<Jump> prevJumps = new HashSet<Jump>();
            for (ClusterRupture rup : rupSet.requireModule(ClusterRuptures.class)) {
                for (Jump jump : rup.getJumpsIterable()) {
                    if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                        jump = jump.reverse();
                    }
                    if (prevJumps.contains(jump)) continue;
                    double prob1 = ((AbstractWorstJumpProb)improb1).calcJumpProb(rup, jump);
                    double prob2 = ((AbstractWorstJumpProb)improb2).calcJumpProb(rup, jump);
                    if (!(prob1 == 1.0 && prob2 == 1.0 || prob1 == 0.0 && prob2 == 0.0)) {
                        probScatter.set(prob1, prob2);
                        if (prob1 > 0.0) {
                            minNonZero = Math.min(minNonZero, prob1);
                        }
                        if (prob2 > 0.0) {
                            minNonZero = Math.min(minNonZero, prob2);
                        }
                    }
                    prevJumps.add(jump);
                }
            }
            funcs = new ArrayList();
            chars = new ArrayList();
            range = new Range(Math.pow(10.0, Math.floor(Math.log10(minNonZero))), 1.0);
            oneToOne = new DefaultXY_DataSet();
            oneToOne.set(range.getLowerBound(), range.getLowerBound());
            oneToOne.set(range.getUpperBound(), range.getUpperBound());
            funcs.add(oneToOne);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
            funcs.add(probScatter);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
            spec = new PlotSpec(funcs, chars, "Thresh-Avg Jump Probabilities", name1, name2);
            gp = PlotUtils.initHeadless();
            gp.drawGraphPanel(spec, true, true, range, range);
            PlotUtils.writePlots(outputDir, prefix + "_jump_probs", (GraphPanel)gp, 1000, false, true, false, false);
        }
        double[] rates1 = new double[rupSet.getNumSections()];
        double[] rates2 = new double[rupSet.getNumSections()];
        DefaultXY_DataSet rateScatter = new DefaultXY_DataSet();
        minNonZero = 1.0;
        for (int s = 0; s < rates1.length; ++s) {
            rates1[s] = mfds1.get(s).calcSumOfY_Vals();
            rates2[s] = mfds2.get(s).calcSumOfY_Vals();
            rateScatter.set(rates1[s], rates2[s]);
            if (rates1[s] > 0.0) {
                minNonZero = Math.min(minNonZero, rates1[s]);
            }
            if (!(rates2[s] > 0.0)) continue;
            minNonZero = Math.min(minNonZero, rates2[s]);
        }
        range = new Range(Math.pow(10.0, Math.floor(Math.log10(minNonZero))), 1.0);
        oneToOne = new DefaultXY_DataSet();
        oneToOne.set(range.getLowerBound(), range.getLowerBound());
        oneToOne.set(range.getUpperBound(), range.getUpperBound());
        funcs.add(oneToOne);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        funcs.add(rateScatter);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
        spec = new PlotSpec(funcs, chars, "Thresh-Avg Sect Nuclation Rates", name1, name2);
        gp.drawGraphPanel(spec, true, true, range, range);
        PlotUtils.writePlots(outputDir, prefix + "_rates_scatter", (GraphPanel)gp, 1000, false, true, false, false);
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, reg);
        CPT pDiffCPT = GMT_CPT_Files.GMT_POLAR.instance().rescale(-100.0, 100.0);
        mapMaker.plotSectScalars(ThresholdAveragingSectNuclMFD_Estimator.pDiff(rates2, rates1), pDiffCPT, "Nucleation Rate % Difference: " + name2 + " - " + name1);
        mapMaker.plot(outputDir, prefix + "_rates", "Section Nucleation Rates");
    }

    private static double[] pDiff(double[] primary, double[] comparison) {
        double[] ret = new double[primary.length];
        for (int i = 0; i < ret.length; ++i) {
            double z1 = primary[i];
            double z2 = comparison[i];
            double val = z1 == 0.0 && z2 == 0.0 ? 0.0 : (z2 == 0.0 ? Double.POSITIVE_INFINITY : 100.0 * (z1 - z2) / z2);
            ret[i] = val;
        }
        return ret;
    }

    private static class QuickAvgTrack {
        private double sum = 0.0;
        private double first = Double.NaN;
        private boolean allSame = true;
        private int count = 0;

        public void add(double value) {
            Preconditions.checkState((value >= 0.0 ? 1 : 0) != 0);
            this.sum += value;
            if (this.count == 0) {
                this.first = value;
            }
            ++this.count;
            this.allSame = this.allSame && value == this.first;
        }

        public double getAverage() {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            if (this.allSame) {
                return this.first;
            }
            return this.sum / (double)this.count;
        }
    }

    public static class WorstAvgJumpProb
    extends AbstractWorstJumpProb {
        private JumpProbabilityCalc jumpModel;
        private Map<Jump, Double> avgJumpProbs;

        public WorstAvgJumpProb(JumpProbabilityCalc improbModel) {
            this(improbModel, null);
        }

        public WorstAvgJumpProb(JumpProbabilityCalc improbModel, List<? extends Number> fixedBinEdges) {
            super(fixedBinEdges);
            this.jumpModel = improbModel;
        }

        @Override
        public void init(FaultSystemRupSet rupSet, List<IncrementalMagFreqDist> origSectSupraSeisMFDs, double[] targetSectSupraMoRates, double[] targetSectSupraSlipRates, double[] sectSupraSlipRateStdDevs, List<BitSet> sectRupUtilizations, int[] sectMinMagIndexes, int[] sectMaxMagIndexes, int[][] sectRupInBinCounts, EvenlyDiscretizedFunc refMFD) {
            this.avgJumpProbs = WorstAvgJumpProb.calcAverageJumpProbs(rupSet.requireModule(ClusterRuptures.class), this.jumpModel);
            super.init(rupSet, origSectSupraSeisMFDs, targetSectSupraMoRates, targetSectSupraSlipRates, sectSupraSlipRateStdDevs, sectRupUtilizations, sectMinMagIndexes, sectMaxMagIndexes, sectRupInBinCounts, refMFD);
        }

        @Override
        protected double calcJumpProb(ClusterRupture rup, Jump jump) {
            Double prob = this.avgJumpProbs.get(jump);
            Preconditions.checkNotNull((Object)prob, (String)"No precomputed prob for jump %s in rupture %s", (Object)jump, (Object)rup);
            return prob;
        }
    }

    public static class RelGRWorstJumpProb
    extends AbstractWorstJumpProb {
        public static boolean D = false;
        private JumpProbabilityCalc jumpModel;
        private int iterations;
        private Map<Jump, Double> jumpProbs;
        private boolean applyOrigProbFloor;

        public RelGRWorstJumpProb(JumpProbabilityCalc improbModel, int iterations, boolean applyOrigProbFloor) {
            super(null);
            this.jumpModel = improbModel;
            this.iterations = iterations;
            this.applyOrigProbFloor = applyOrigProbFloor;
        }

        @Override
        public void init(FaultSystemRupSet rupSet, List<IncrementalMagFreqDist> origSectSupraSeisMFDs, double[] targetSectSupraMoRates, double[] targetSectSupraSlipRates, double[] sectSupraSlipRateStdDevs, List<BitSet> sectRupUtilizations, int[] sectMinMagIndexes, int[] sectMaxMagIndexes, int[][] sectRupInBinCounts, EvenlyDiscretizedFunc refMFD) {
            ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
            Map<Jump, Double> avgOrigJumpProbs = RelGRWorstJumpProb.calcAverageJumpProbs(cRups, this.jumpModel);
            HashMap<Jump, BitSet> jumpMagBins = new HashMap<Jump, BitSet>();
            for (int r = 0; r < cRups.size(); ++r) {
                int magBin = refMFD.getClosestXIndex(rupSet.getMagForRup(r));
                for (Jump jump : cRups.get(r).getJumpsIterable()) {
                    BitSet bitSet;
                    if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                        jump = jump.reverse();
                    }
                    if ((bitSet = (BitSet)jumpMagBins.get(jump)) == null) {
                        bitSet = new BitSet(refMFD.size());
                        jumpMagBins.put(jump, bitSet);
                    }
                    bitSet.set(magBin);
                }
            }
            int numSects = rupSet.getNumSections();
            double[][] sectNuclToParticScalars = new double[numSects][];
            ArrayList sectRupIndexes = new ArrayList();
            ArrayList sectMags = new ArrayList();
            for (int s = 0; s < numSects; ++s) {
                int minMagIndex = sectMinMagIndexes[s];
                int maxMagIndex = sectMaxMagIndexes[s];
                double[] nuclToParticScalars = new double[1 + maxMagIndex - minMagIndex];
                double[] avgBinAreas = new double[nuclToParticScalars.length];
                int[] avgCounts = new int[avgBinAreas.length];
                ArrayList<Integer> myRupIndexes = new ArrayList<Integer>();
                sectRupIndexes.add(myRupIndexes);
                ArrayList<Double> myMags = new ArrayList<Double>();
                sectMags.add(myMags);
                BitSet utilization = sectRupUtilizations.get(s);
                int r = utilization.nextSetBit(0);
                while (r >= 0) {
                    int index;
                    int n = index = refMFD.getClosestXIndex(rupSet.getMagForRup(r)) - minMagIndex;
                    avgCounts[n] = avgCounts[n] + 1;
                    int n2 = index;
                    avgBinAreas[n2] = avgBinAreas[n2] + rupSet.getAreaForRup(r);
                    myRupIndexes.add(r);
                    myMags.add(rupSet.getMagForRup(r));
                    r = utilization.nextSetBit(r + 1);
                }
                double sectArea = rupSet.getAreaForSection(s);
                for (int m = 0; m < nuclToParticScalars.length; ++m) {
                    if (avgCounts[m] <= 0) continue;
                    int n = m;
                    avgBinAreas[n] = avgBinAreas[n] / (double)avgCounts[m];
                    nuclToParticScalars[m] = avgBinAreas[m] / sectArea;
                }
                sectNuclToParticScalars[s] = nuclToParticScalars;
            }
            Preconditions.checkState((this.iterations >= 1 ? 1 : 0) != 0);
            ExecutorService exec = Executors.newFixedThreadPool(D ? 1 : FaultSysTools.defaultNumThreads());
            HashMap<Jump, Future<Double>> jumpFutures = new HashMap<Jump, Future<Double>>();
            for (Jump jump : jumpMagBins.keySet()) {
                BitSet jumpBitSet = (BitSet)jumpMagBins.get(jump);
                double jumpProb = avgOrigJumpProbs.get(jump);
                RelGRJumpProbCalc calc = new RelGRJumpProbCalc(jump, jumpProb, jumpBitSet, refMFD, origSectSupraSeisMFDs, sectNuclToParticScalars, sectMinMagIndexes, this.iterations);
                jumpFutures.put(jump, exec.submit(calc));
            }
            this.jumpProbs = new HashMap<Jump, Double>();
            for (Jump jump : jumpFutures.keySet()) {
                double relGRProb;
                try {
                    relGRProb = (Double)((Future)jumpFutures.get(jump)).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    exec.shutdown();
                    throw ExceptionUtils.asRuntimeException(e);
                }
                if (this.applyOrigProbFloor && relGRProb > 0.0) {
                    relGRProb = Math.max(relGRProb, avgOrigJumpProbs.get(jump));
                }
                this.jumpProbs.put(jump, relGRProb);
                this.jumpProbs.put(jump.reverse(), relGRProb);
            }
            exec.shutdown();
            super.init(rupSet, origSectSupraSeisMFDs, targetSectSupraMoRates, targetSectSupraSlipRates, sectSupraSlipRateStdDevs, sectRupUtilizations, sectMinMagIndexes, sectMaxMagIndexes, sectRupInBinCounts, refMFD);
        }

        @Override
        protected double calcJumpProb(ClusterRupture rup, Jump jump) {
            Double jumpProb = this.jumpProbs.get(jump);
            Preconditions.checkNotNull((Object)jumpProb, (String)"No jump probability for %s (have %s in total)", (Object)jump, (int)this.jumpProbs.size());
            return jumpProb;
        }
    }

    public static abstract class AbstractWorstJumpProb
    extends ThresholdAveragingSectNuclMFD_Estimator {
        public AbstractWorstJumpProb() {
            this(null);
        }

        public AbstractWorstJumpProb(List<? extends Number> fixedBinEdges) {
            super(fixedBinEdges);
        }

        protected abstract double calcJumpProb(ClusterRupture var1, Jump var2);

        @Override
        protected double calcRupProb(ClusterRupture rup) {
            double worstProb = 1.0;
            for (Jump jump : rup.getJumpsIterable()) {
                worstProb = Math.min(worstProb, this.calcJumpProb(rup, jump));
            }
            return worstProb;
        }
    }

    private static class RelGRJumpProbCalc
    implements Callable<Double> {
        private Jump jump;
        private double jumpProb;
        private BitSet jumpBitSet;
        private EvenlyDiscretizedFunc refMFD;
        private List<? extends IncrementalMagFreqDist> sectMFDs;
        private double[][] sectNuclToParticScalars;
        private int[] sectMinMagIndexes;
        private int iterations;

        RelGRJumpProbCalc(Jump jump, double jumpProb, BitSet jumpBitSet, EvenlyDiscretizedFunc refMFD, List<? extends IncrementalMagFreqDist> sectMFDs, double[][] sectNuclToParticScalars, int[] sectMinMagIndexes, int iterations) {
            this.jump = jump;
            this.jumpProb = jumpProb;
            this.jumpBitSet = jumpBitSet;
            this.refMFD = refMFD;
            this.sectMFDs = sectMFDs;
            this.sectNuclToParticScalars = sectNuclToParticScalars;
            this.sectMinMagIndexes = sectMinMagIndexes;
            Preconditions.checkState((iterations >= 1 ? 1 : 0) != 0);
            this.iterations = iterations;
        }

        @Override
        public Double call() {
            boolean D = RelGRWorstJumpProb.D || this.jump.fromSection.getSectionId() == -1 || this.jump.toSection.getSectionId() == -1;
            double minProb = 1.0;
            if (D) {
                System.out.println("Jump from " + this.jump.fromSection.getSectionId() + ". " + this.jump.fromSection.getSectionName() + " to " + this.jump.toSection.getSectionId() + ". " + this.jump.toSection.getSectionName());
                System.out.println("\tDist: " + (float)this.jump.distance);
                System.out.println("\tProb: " + (float)this.jumpProb);
                Object magBinStr = null;
                for (int m = 0; m < this.refMFD.size(); ++m) {
                    if (!this.jumpBitSet.get(m)) continue;
                    magBinStr = magBinStr == null ? "" : (String)magBinStr + ",";
                    magBinStr = (String)magBinStr + (float)this.refMFD.getX(m);
                }
                System.out.println("\tMags: " + magBinStr);
            }
            if (this.jumpProb == 0.0) {
                minProb = 0.0;
            } else {
                for (int sectIndex : new int[]{this.jump.fromSection.getSectionId(), this.jump.toSection.getSectionId()}) {
                    double myProb;
                    IncrementalMagFreqDist sectMFD = this.sectMFDs.get(sectIndex);
                    if (sectMFD == null || sectMFD.calcSumOfY_Vals() == 0.0) {
                        minProb = 0.0;
                        break;
                    }
                    double totParticRate = 0.0;
                    double jumpParticRate = 0.0;
                    double[] nuclToParticScalars = this.sectNuclToParticScalars[sectIndex];
                    int binsNotUsing = 0;
                    for (int m = 0; m < nuclToParticScalars.length; ++m) {
                        int binIndex = m + this.sectMinMagIndexes[sectIndex];
                        double binRate = sectMFD.getY(binIndex);
                        double particRate = binRate * nuclToParticScalars[m];
                        totParticRate += particRate;
                        if (this.jumpBitSet.get(binIndex)) {
                            jumpParticRate += particRate;
                            continue;
                        }
                        if (!(binRate > 0.0)) continue;
                        ++binsNotUsing;
                    }
                    if (D) {
                        String name = this.jump.fromSection.getSectionId() == sectIndex ? this.jump.fromSection.getSectionName() : this.jump.toSection.getSectionName();
                        System.out.println("\tSection " + sectIndex + ". " + name);
                        System.out.println("\t\tOrig total participation rate: " + (float)totParticRate);
                        System.out.println("\t\tOrig jump participation rate: " + (float)jumpParticRate);
                    }
                    if (binsNotUsing == 0) {
                        if (D) {
                            System.out.println("\t\tAll mag bins affected, using jumpProb=" + (float)this.jumpProb);
                        }
                        myProb = this.jumpProb;
                    } else {
                        double segJumpParticRate = totParticRate * this.jumpProb;
                        double segFractOfAllotment = segJumpParticRate / jumpParticRate;
                        if (D) {
                            System.out.println("\t\tSeg-implied participation rate allotment: " + (float)segJumpParticRate);
                            System.out.println("\t\tSeg allotment fract: " + (float)segFractOfAllotment);
                        }
                        if (segFractOfAllotment < 1.0) {
                            double otherParticRate = totParticRate - jumpParticRate;
                            Preconditions.checkState((otherParticRate > 0.0 ? 1 : 0) != 0, (String)"Expected otherParticRate > 0 with %s bins not using this jump, but is %s. totParticRate=%s, jumpParticRate=%s", (Object)binsNotUsing, (Object)otherParticRate, (Object)totParticRate, (Object)jumpParticRate);
                            double origMoRate = sectMFD.getTotalMomentRate();
                            double curCorrProb = segFractOfAllotment;
                            IncrementalMagFreqDist ratesWithout = sectMFD.deepClone();
                            for (int m = 0; m < ratesWithout.size(); ++m) {
                                if (!this.jumpBitSet.get(m)) continue;
                                ratesWithout.set(m, 0.0);
                            }
                            ratesWithout.scaleToTotalMomentRate(origMoRate);
                            for (int corrIters = 0; corrIters < this.iterations; ++corrIters) {
                                double corrJumpParticRate = 0.0;
                                double corrTotalParticRate = 0.0;
                                double oneMinus = 1.0 - curCorrProb;
                                for (int m = 0; m < nuclToParticScalars.length; ++m) {
                                    int binIndex = m + this.sectMinMagIndexes[sectIndex];
                                    double binRate = oneMinus * ratesWithout.getY(binIndex) + curCorrProb * sectMFD.getY(binIndex);
                                    double particRate = binRate * nuclToParticScalars[m];
                                    corrTotalParticRate += particRate;
                                    if (!this.jumpBitSet.get(binIndex)) continue;
                                    corrJumpParticRate += particRate;
                                }
                                double effectiveProb = corrJumpParticRate / corrTotalParticRate;
                                if (D) {
                                    System.out.println("\t\t\titer " + corrIters + " curCorProb=" + (float)curCorrProb + ", eff = " + (float)corrJumpParticRate + " / " + (float)corrTotalParticRate + " = " + (float)effectiveProb);
                                }
                                double delta = Math.abs(effectiveProb - this.jumpProb);
                                double newProb = effectiveProb < this.jumpProb ? Math.min(1.0, curCorrProb + 0.5 * delta) : Math.max(0.0, curCorrProb - 0.5 * delta);
                                if ((float)newProb == (float)curCorrProb) {
                                    curCorrProb = newProb;
                                    break;
                                }
                                curCorrProb = newProb;
                            }
                            myProb = curCorrProb;
                        } else {
                            myProb = 1.0;
                        }
                    }
                    if (D) {
                        System.out.println("\t\tUpdated jump probability: " + (float)myProb);
                    }
                    minProb = Math.min(minProb, myProb);
                }
            }
            if (D) {
                System.out.println("\tRel-GR jumpProb=" + (float)minProb + " (was " + (float)this.jumpProb + ")");
            }
            return minProb;
        }
    }

    public static class WorstPrecomputedJumpProb
    extends AbstractWorstJumpProb {
        private Map<Jump, Double> jumpProbs;

        public WorstPrecomputedJumpProb(JumpProbabilityCalc improbModel, Map<Jump, Double> jumpProbs) {
            this(improbModel, jumpProbs, null);
        }

        public WorstPrecomputedJumpProb(JumpProbabilityCalc improbModel, Map<Jump, Double> jumpProbs, List<? extends Number> fixedBinEdges) {
            super(fixedBinEdges);
            this.jumpProbs = jumpProbs;
        }

        @Override
        protected double calcJumpProb(ClusterRupture rup, Jump jump) {
            Double prob = this.jumpProbs.get(jump);
            Preconditions.checkNotNull((Object)prob, (String)"No precomputed prob for jump %s in rupture %s", (Object)jump, (Object)rup);
            return prob;
        }
    }

    public static class WorstJumpProb
    extends AbstractWorstJumpProb {
        private JumpProbabilityCalc jumpModel;

        public WorstJumpProb(JumpProbabilityCalc improbModel) {
            this(improbModel, null);
        }

        public WorstJumpProb(JumpProbabilityCalc improbModel, List<? extends Number> fixedBinEdges) {
            super(fixedBinEdges);
            this.jumpModel = improbModel;
        }

        @Override
        protected double calcJumpProb(ClusterRupture rup, Jump jump) {
            return this.jumpModel.calcJumpProbability(rup, jump, false);
        }
    }

    public static class RupProbModel
    extends ThresholdAveragingSectNuclMFD_Estimator {
        private RuptureProbabilityCalc model;

        public RupProbModel(RuptureProbabilityCalc model) {
            this.model = model;
        }

        @Override
        protected double calcRupProb(ClusterRupture rup) {
            return this.model.calcRuptureProb(rup, false);
        }
    }
}

