/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import mpi.MPI;
import org.opensha.commons.data.IntegerSampler;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetScalingRelationship;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.RuptureSets;
import org.opensha.sha.earthquake.faultSysSolution.inversion.ClusterSpecificInversionConfigurationFactory;
import org.opensha.sha.earthquake.faultSysSolution.inversion.ClusterSpecificInversionSolver;
import org.opensha.sha.earthquake.faultSysSolution.inversion.GridSourceProviderFactory;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionSolver;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.JumpProbabilityConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.MFDInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.IterationCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.GenerationFunctionType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRuptureBuilder;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SlipAlongRuptureModelBranchNode;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_ConstraintBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SlipAlongRuptureModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.RupturePlausibilityModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SectionSupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationMFD_Adjustment;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SegmentationModelBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSectConstraintModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SubSeisMoRateReductions;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.BranchSamplingManager;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.random.RandomBValSampler;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SupraSeisBValInversionTargetMFDs;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.GRParticRateEstimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.AnalyticalSingleFaultInversionSolver;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.util.ClassicModelInversionSolver;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.PRVI25_GridSourceBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.SeismicityRateFileLoader;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalBValues;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalFaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_LogicTree;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeismicityRateEpoch;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionBValues;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionCaribbeanSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionCouplingModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionFaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionMuertosSeismicityRate;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class PRVI25_InvConfigFactory
implements ClusterSpecificInversionConfigurationFactory,
GridSourceProviderFactory {
    protected transient RuptureSets.Cache rupSetCache = new RuptureSets.Cache();
    protected transient Map<RupSetFaultModel, SectionDistanceAzimuthCalculator> distAzCache = new HashMap<RupSetFaultModel, SectionDistanceAzimuthCalculator>();
    protected transient File cacheDir;
    private boolean autoCache = true;
    private boolean adjustForActualRupSlips = NSHM23_ConstraintBuilder.ADJ_FOR_ACTUAL_RUP_SLIPS_DEFAULT;
    private boolean adjustForSlipAlong = NSHM23_ConstraintBuilder.ADJ_FOR_SLIP_ALONG_DEFAULT;
    public static final long NUM_ITERS_PER_RUP_DEFAULT = 2000L;
    protected long numItersPerRup = 2000L;
    public static final boolean SOLVE_CLUSTERS_INDIVIDUALLY_DEFAULT = true;
    protected boolean solveClustersIndividually = true;
    public static double MFD_MIN_FRACT_UNCERT = 0.1;
    public static double SUB_SECT_DDW_FRACT = Double.NaN;
    public static SubSectConstraintModels SUB_SECT_CONSTR_DEFAULT = SubSectConstraintModels.TOT_NUCL_RATE;
    public static SlipAlongRuptureModelBranchNode SLIP_ALONG_DEFAULT = NSHM23_SlipAlongRuptureModels.UNIFORM;
    public static boolean ALLOW_CONNECTED_PROXY_FAULTS = false;
    public static double MAX_PROXY_FAULT_RUP_LEN = Double.NaN;
    public static boolean PROXY_FAULT_MAG_CORNERS = true;
    public static boolean PROXY_FAULT_FORCE_CLASSIC_B_1 = true;
    public static double PROXY_FAULT_CLASSIC_MMAX = 7.5;

    public void setNumItersPerRup(long numItersPerRup) {
        Preconditions.checkState((numItersPerRup > 0L ? 1 : 0) != 0, (String)"numItersPerRup must be >0: %s", (long)numItersPerRup);
        this.numItersPerRup = numItersPerRup;
    }

    @Override
    public boolean isSolveClustersIndividually() {
        return this.solveClustersIndividually;
    }

    public void setSolveClustersIndividually(boolean solveClustersIndividually) {
        this.solveClustersIndividually = solveClustersIndividually;
    }

    protected synchronized FaultSystemRupSet buildGenericRupSet(LogicTreeBranch<?> branch, int threads) {
        File cachedRupSetFile;
        RuptureSets.RupSetConfig config;
        FaultSystemRupSet rupSet;
        RupturePlausibilityModels model;
        RupSetSubsectioningModel ssm;
        RupSetFaultModel fm;
        block26: {
            List<? extends FaultSection> subSects;
            fm = branch.requireValue(RupSetFaultModel.class);
            ssm = Double.isFinite(SUB_SECT_DDW_FRACT) ? SubSectionBuilder.getModel(2, SUB_SECT_DDW_FRACT, Double.NaN) : branch.requireValue(RupSetSubsectioningModel.class);
            model = branch.getValue(RupturePlausibilityModels.class);
            if (model == null) {
                model = fm instanceof PRVI25_SubductionFaultModels ? RupturePlausibilityModels.SIMPLE_SUBDUCTION : RupturePlausibilityModels.COULOMB;
            }
            if ((rupSet = this.rupSetCache.get(fm, ssm, model)) != null) {
                return rupSet;
            }
            RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
            RupSetDeformationModel dm = fm.getDefaultDeformationModel();
            try {
                subSects = this.buildSubSects(rupSet, fm, dm, ssm, branch);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            config = model.getConfig(subSects, scale);
            if (config instanceof RuptureSets.CoulombRupSetConfig) {
                ((RuptureSets.CoulombRupSetConfig)config).setConnectProxyFaults(ALLOW_CONNECTED_PROXY_FAULTS);
            }
            cachedRupSetFile = null;
            if (this.cacheDir != null) {
                File subDir = new File(this.cacheDir, "rup_sets_" + fm.getFilePrefix() + "_" + dm.getFilePrefix());
                if (!subDir.exists()) {
                    subDir.mkdir();
                }
                double dmMoment = 0.0;
                for (FaultSection faultSection : subSects) {
                    dmMoment += faultSection.calcMomentRate(false);
                }
                String momentStr = ("" + (float)dmMoment).replace('.', 'p');
                String string = "rup_set_" + model.getFilePrefix() + "_" + SectionDistanceAzimuthCalculator.getUniqueSectCacheFileStr(subSects) + "_" + momentStr + "_moment" + (ALLOW_CONNECTED_PROXY_FAULTS ? "_connProxies" : "") + ".zip";
                cachedRupSetFile = new File(subDir, string);
                config.setCacheDir(subDir);
            }
            config.setAutoCache(this.autoCache);
            if (cachedRupSetFile != null && cachedRupSetFile.exists()) {
                try {
                    rupSet = FaultSystemRupSet.load(cachedRupSetFile);
                    if (!rupSet.areSectionsEquivalentTo(subSects)) {
                        rupSet = null;
                        break block26;
                    }
                    SectionDistanceAzimuthCalculator distAzCalc = this.distAzCache.get(fm);
                    if (distAzCalc != null && rupSet.areSectionsEquivalentTo(distAzCalc.getSubSections())) {
                        rupSet.addModule(distAzCalc);
                        break block26;
                    }
                    distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
                    String name = distAzCalc.getDefaultCacheFileName();
                    File distAzCacheFile = new File(this.cacheDir, name);
                    if (distAzCacheFile.exists()) {
                        try {
                            distAzCalc.loadCacheFile(distAzCacheFile);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    rupSet.addModule(distAzCalc);
                    this.distAzCache.put(fm, distAzCalc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    rupSet = null;
                }
            } else if (cachedRupSetFile != null) {
                System.out.println("Rup set cache miss, doesn't exist: " + cachedRupSetFile.getAbsolutePath());
            } else {
                System.out.println("No cache directory supplied, will build rupture set from scratch. Consider settting a cache directory to speed up rupture set building in the future.");
            }
        }
        if (rupSet == null) {
            rupSet = config.build(threads);
        }
        this.rupSetCache.put(rupSet, fm, ssm, model);
        if (cachedRupSetFile != null && !cachedRupSetFile.exists()) {
            boolean write = true;
            try {
                int mpiRank = MPI.COMM_WORLD.Rank();
                write = mpiRank == 0;
            }
            catch (Throwable mpiRank) {
                // empty catch block
            }
            if (write && !cachedRupSetFile.exists()) {
                try {
                    rupSet.write(cachedRupSetFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rupSet;
    }

    @Override
    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public void setAutoCache(boolean autoCache) {
        this.autoCache = autoCache;
    }

    @Override
    public void writeCache() {
        if (this.cacheDir != null) {
            // empty if block
        }
    }

    public void adjustForActualRupSlips(boolean adjustForActualRupSlips, boolean adjustForSlipAlong) {
        this.adjustForActualRupSlips = adjustForActualRupSlips;
        this.adjustForSlipAlong = adjustForSlipAlong;
    }

    @Override
    public FaultSystemRupSet buildRuptureSet(LogicTreeBranch<?> branch, int threads) throws IOException {
        return this.updateRuptureSetForBranch(this.buildGenericRupSet(branch, threads), branch);
    }

    protected List<? extends FaultSection> buildSubSectsForBranch(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) throws IOException {
        RupSetFaultModel fm = branch.requireValue(RupSetFaultModel.class);
        RupSetDeformationModel dm = branch.requireValue(RupSetDeformationModel.class);
        Preconditions.checkState((boolean)dm.isApplicableTo(fm), (String)"Fault and deformation models are not compatible: %s, %s", (Object)fm.getName(), (Object)dm.getName());
        RupSetSubsectioningModel ssm = Double.isFinite(SUB_SECT_DDW_FRACT) ? SubSectionBuilder.getModel(2, SUB_SECT_DDW_FRACT, Double.NaN) : branch.requireValue(RupSetSubsectioningModel.class);
        return this.buildSubSects(rupSet, fm, dm, ssm, branch);
    }

    protected List<? extends FaultSection> buildSubSects(FaultSystemRupSet rupSet, RupSetFaultModel fm, RupSetDeformationModel dm, RupSetSubsectioningModel ssm, LogicTreeBranch<?> branch) throws IOException {
        return dm.build(fm, ssm, branch);
    }

    @Override
    public FaultSystemRupSet updateRuptureSetForBranch(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) throws IOException {
        List<? extends FaultSection> subSects;
        try {
            subSects = this.buildSubSectsForBranch(rupSet, branch);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        RuptureSubSetMappings subsetMappings = rupSet.getModule(RuptureSubSetMappings.class);
        if (subsetMappings != null) {
            ArrayList<? extends FaultSection> subsetSects = new ArrayList<FaultSection>();
            for (int s = 0; s < rupSet.getNumSections(); ++s) {
                FaultSection sect = subSects.get(subsetMappings.getOrigSectID(s)).clone();
                sect.setSectionId(s);
                subsetSects.add(sect);
            }
            subSects = subsetSects;
        }
        Preconditions.checkState((subSects.size() == rupSet.getNumSections() ? 1 : 0) != 0);
        ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
        PlausibilityConfiguration plausibility = rupSet.getModule(PlausibilityConfiguration.class);
        RupSetScalingRelationship scale = branch.requireValue(RupSetScalingRelationship.class);
        if (cRups == null) {
            rupSet = FaultSystemRupSet.builder(subSects, rupSet.getSectionIndicesForAllRups()).forScalingRelationship(scale).build();
            if (plausibility != null) {
                rupSet.addModule(plausibility);
            }
            rupSet.addModule(ClusterRuptures.singleStranged(rupSet));
        } else {
            rupSet = ClusterRuptureBuilder.buildClusterRupSet(scale, subSects, plausibility, cRups.getAll());
        }
        if (subsetMappings != null) {
            rupSet.addModule(subsetMappings);
        }
        SlipAlongRuptureModelBranchNode slipAlong = branch.hasValue(SlipAlongRuptureModelBranchNode.class) ? branch.requireValue(SlipAlongRuptureModelBranchNode.class) : SLIP_ALONG_DEFAULT;
        rupSet.addModule(slipAlong.getModel());
        return this.getSolutionLogicTreeProcessor().processRupSet(rupSet, branch);
    }

    @Override
    public SolutionLogicTree.SolutionProcessor getSolutionLogicTreeProcessor() {
        return new PRVI25SolProcessor();
    }

    private static NSHM23_ConstraintBuilder getAveragedConstraintBuilder(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        Object[] bVals = branch.hasValue(SupraSeisBValues.AVERAGE) ? SupraSeisBValues.values() : (branch.hasValue(PRVI25_SubductionBValues.AVERAGE) ? PRVI25_SubductionBValues.values() : (branch.hasValue(PRVI25_SubductionBValues.AVERAGE) ? PRVI25_SubductionBValues.values() : new SectionSupraSeisBValues[]{branch.requireValue(SectionSupraSeisBValues.class)}));
        NSHM23_SegmentationModels[] segModels = branch.hasValue(NSHM23_SegmentationModels.AVERAGE) ? NSHM23_SegmentationModels.values() : new NSHM23_SegmentationModels[]{branch.getValue(NSHM23_SegmentationModels.class)};
        ArrayList<LogicTreeBranch<Object>> avgBranches = new ArrayList<LogicTreeBranch<Object>>();
        ArrayList<Double> avgWeights = new ArrayList<Double>();
        ArrayList levels = new ArrayList();
        for (int i = 0; i < branch.size(); ++i) {
            levels.add(branch.getLevel(i));
        }
        LogicTreeBranch<LogicTreeNode> branchCopy = new LogicTreeBranch<LogicTreeNode>(levels);
        for (LogicTreeNode node : branch) {
            branchCopy.setValue(node);
        }
        for (Object bVal : bVals) {
            for (NSHM23_SegmentationModels segModel : segModels) {
                LogicTreeBranch<Object> subBranch = branchCopy.copy();
                subBranch.setValue(bVal);
                if (segModel != null) {
                    subBranch.setValue(segModel);
                }
                double subBranchWeight = 1.0;
                if (bVals.length > 1) {
                    subBranchWeight *= bVal.getNodeWeight(subBranch);
                }
                if (segModels.length > 1) {
                    subBranchWeight *= segModel.getNodeWeight(subBranch);
                }
                if (!(subBranchWeight > 0.0)) continue;
                avgBranches.add(subBranch);
                avgWeights.add(subBranchWeight);
            }
        }
        System.out.println("Building average SupraSeisBValTargetMFDs across " + avgBranches.size() + " sub-branches");
        Preconditions.checkState((avgBranches.size() > 1 ? 1 : 0) != 0, (Object)"Expected multiple branches to average");
        SupraSeisBValInversionTargetMFDs.SupraBAverager averager = new SupraSeisBValInversionTargetMFDs.SupraBAverager();
        for (int i = 0; i < avgBranches.size(); ++i) {
            LogicTreeBranch avgBranch = (LogicTreeBranch)avgBranches.get(i);
            double weight = (Double)avgWeights.get(i);
            Object branchStr = null;
            if (bVals.length > 1) {
                branchStr = avgBranch.requireValue(SectionSupraSeisBValues.class).getShortName();
            }
            if (segModels.length > 1) {
                branchStr = branchStr == null ? "" : (String)branchStr + ", ";
                branchStr = (String)branchStr + "SegModel=" + avgBranch.requireValue(NSHM23_SegmentationModels.class).name();
            }
            System.out.println("Building target MFDs for branch " + i + "/" + avgBranches.size() + ": " + (String)branchStr);
            NSHM23_ConstraintBuilder builder = PRVI25_InvConfigFactory.doGetConstraintBuilder(rupSet, avgBranch);
            averager.process(builder.getTargetMFDs(), weight);
        }
        SupraSeisBValInversionTargetMFDs avgTargets = averager.getSupraSeisAverageInstance();
        NSHM23_ConstraintBuilder ret = PRVI25_InvConfigFactory.doGetConstraintBuilder(rupSet, branch);
        ret.setExternalTargetMFDs(avgTargets);
        rupSet.addModule(avgTargets);
        return ret;
    }

    private static NSHM23_ConstraintBuilder getConstraintBuilder(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        if (branch.hasValue(NSHM23_SegmentationModels.AVERAGE) || branch.hasValue(SupraSeisBValues.AVERAGE) || branch.hasValue(PRVI25_CrustalBValues.AVERAGE) || branch.hasValue(PRVI25_SubductionBValues.AVERAGE)) {
            return PRVI25_InvConfigFactory.getAveragedConstraintBuilder(rupSet, branch);
        }
        return PRVI25_InvConfigFactory.doGetConstraintBuilder(rupSet, branch);
    }

    private static NSHM23_ConstraintBuilder doGetConstraintBuilder(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        double bVal;
        RandomBValSampler.Node bValNode = branch.getValue(RandomBValSampler.Node.class);
        double[] sectSpecificBValues = null;
        if (bValNode != null) {
            RandomBValSampler sampler = rupSet.requireModule(BranchSamplingManager.class).getSampler(bValNode);
            sectSpecificBValues = sampler.getBValues();
            Preconditions.checkState((sectSpecificBValues.length == rupSet.getNumSections() ? 1 : 0) != 0, (String)"Have %s sections but %s section b-values", (int)rupSet.getNumSections(), (int)sectSpecificBValues.length);
            bVal = NSHM23_ConstraintBuilder.momentWeightedAverage(rupSet, sectSpecificBValues);
        } else {
            SectionSupraSeisBValues bValues = branch.requireValue(SectionSupraSeisBValues.class);
            sectSpecificBValues = bValues.getSectBValues(rupSet);
            bVal = Double.isFinite(bValues.getB()) ? bValues.getB() : SectionSupraSeisBValues.momentWeightedAverage(rupSet, sectSpecificBValues);
        }
        NSHM23_ConstraintBuilder constrBuilder = new NSHM23_ConstraintBuilder(rupSet, bVal, sectSpecificBValues);
        SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction reduction = SupraSeisBValInversionTargetMFDs.SUB_SEIS_MO_RATE_REDUCTION_DEFAULT;
        if (branch.hasValue(SubSeisMoRateReductions.class)) {
            reduction = branch.getValue(SubSeisMoRateReductions.class).getChoice();
        }
        constrBuilder.subSeisMoRateReduction(reduction);
        constrBuilder.magDepRelStdDev(M -> MFD_MIN_FRACT_UNCERT * Math.max(1.0, Math.pow(10.0, bVal * 0.5 * (M - 6.0))));
        constrBuilder.adjustForActualRupSlips(NSHM23_ConstraintBuilder.ADJ_FOR_ACTUAL_RUP_SLIPS_DEFAULT, NSHM23_ConstraintBuilder.ADJ_FOR_SLIP_ALONG_DEFAULT);
        NSHM23_SegmentationModels segModel = branch.getValue(NSHM23_SegmentationModels.class);
        if (segModel != null && PROXY_FAULT_MAG_CORNERS) {
            double magCorner;
            switch (segModel) {
                case CLASSIC: {
                    if (PROXY_FAULT_FORCE_CLASSIC_B_1 || PROXY_FAULT_CLASSIC_MMAX > 0.0) {
                        magCorner = Double.NaN;
                        break;
                    }
                    magCorner = 7.2;
                    break;
                }
                case HIGH: {
                    magCorner = 7.2;
                    break;
                }
                case MID: {
                    magCorner = 7.4;
                    break;
                }
                case LOW: {
                    magCorner = 7.6;
                    break;
                }
                case NONE: {
                    magCorner = Double.NaN;
                    break;
                }
                case AVERAGE: {
                    magCorner = 7.4;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected segmentation model: " + String.valueOf(segModel));
                }
            }
            constrBuilder.proxyFaultMagCorner(magCorner);
        }
        if (PROXY_FAULT_FORCE_CLASSIC_B_1 && segModel == NSHM23_SegmentationModels.CLASSIC) {
            constrBuilder.proxyFaultBValue(1.0);
        }
        if (PRVI25_InvConfigFactory.hasJumps(rupSet)) {
            JumpProbabilityCalc targetSegModel;
            RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExclusionModel = PRVI25_InvConfigFactory.getExclusionModel(rupSet, branch, rupSet.requireModule(ClusterRuptures.class));
            if (rupExclusionModel != null) {
                constrBuilder.excludeRuptures(rupExclusionModel);
            }
            if ((targetSegModel = PRVI25_InvConfigFactory.buildSegModel(rupSet, branch)) != null) {
                if (targetSegModel instanceof JumpProbabilityCalc.BinaryJumpProbabilityCalc) {
                    Preconditions.checkNotNull((Object)rupExclusionModel);
                } else {
                    SegmentationMFD_Adjustment segAdj = branch.getValue(SegmentationMFD_Adjustment.class);
                    if (segAdj == null) {
                        constrBuilder.adjustForSegmentationModel(targetSegModel);
                    } else {
                        constrBuilder.adjustForSegmentationModel(targetSegModel, segAdj);
                    }
                }
            }
        }
        return constrBuilder;
    }

    public static boolean hasJumps(FaultSystemRupSet rupSet) {
        for (ClusterRupture cRup : rupSet.requireModule(ClusterRuptures.class)) {
            if (cRup.getTotalNumJumps() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPaleoData(FaultSystemRupSet rupSet) {
        PaleoseismicConstraintData data = rupSet.getModule(PaleoseismicConstraintData.class);
        return data != null && (data.hasPaleoRateConstraints() || data.hasPaleoSlipConstraints());
    }

    private static boolean hasConstrainableJumps(FaultSystemRupSet rupSet, JumpProbabilityCalc segModel) {
        if (segModel instanceof JumpProbabilityCalc.BinaryJumpProbabilityCalc) {
            return false;
        }
        for (ClusterRupture cRup : rupSet.requireModule(ClusterRuptures.class)) {
            for (Jump jump : cRup.getJumpsIterable()) {
                double prob = segModel.calcJumpProbability(cRup, jump, false);
                if (!(prob > 0.0) || !(prob < 1.0)) continue;
                return true;
            }
        }
        return false;
    }

    private static JumpProbabilityCalc buildSegModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        SegmentationModelBranchNode segModel = branch.getValue(SegmentationModelBranchNode.class);
        JumpProbabilityCalc jumpProb = segModel == null ? null : segModel.getModel(rupSet, branch);
        return jumpProb;
    }

    @Override
    public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
        double nuclMFDWeight;
        NSHM23_ConstraintBuilder constrBuilder = PRVI25_InvConfigFactory.getConstraintBuilder(rupSet, branch);
        if (rupSet.hasModule(ModSectMinMags.class) && rupSet.hasModule(RuptureSubSetMappings.class)) {
            int numBelowMinMag = constrBuilder.getRupIndexesBelowMinMag().size();
            Preconditions.checkState((numBelowMinMag >= 0 && numBelowMinMag <= rupSet.getNumRuptures() ? 1 : 0) != 0);
            if (numBelowMinMag == rupSet.getNumRuptures()) {
                System.out.println("Warning: skipping cluster specific inversion for cluster with " + rupSet.getNumSections() + " sections and " + rupSet.getNumRuptures() + " ruptures, all below minimum mag");
                return null;
            }
        }
        boolean hasNonZeroSlip = false;
        for (double slipRate : rupSet.requireModule(SectSlipRates.class).getSlipRates()) {
            if (!(slipRate > 0.0)) continue;
            hasNonZeroSlip = true;
            break;
        }
        if (!hasNonZeroSlip) {
            System.out.println("Warning: skipping inversion for rupture set with " + rupSet.getNumSections() + " sections and " + rupSet.getNumRuptures() + " ruptures, no positive slip rates");
            return null;
        }
        constrBuilder.adjustForActualRupSlips(this.adjustForActualRupSlips, this.adjustForSlipAlong);
        SubSectConstraintModels constrModel = branch.hasValue(SubSectConstraintModels.class) ? branch.getValue(SubSectConstraintModels.class) : SUB_SECT_CONSTR_DEFAULT;
        double slipWeight = 1.0;
        double mfdWeight = constrModel == SubSectConstraintModels.NUCL_MFD ? 1.0 : 10.0;
        double nuclWeight = constrModel == SubSectConstraintModels.TOT_NUCL_RATE ? 0.5 : 0.0;
        double d = nuclMFDWeight = constrModel == SubSectConstraintModels.NUCL_MFD ? 0.5 : 0.0;
        if (slipWeight > 0.0) {
            constrBuilder.slipRates().weight(slipWeight);
        }
        if (mfdWeight > 0.0) {
            constrBuilder.supraBValMFDs().weight(mfdWeight);
        }
        if (nuclWeight > 0.0) {
            constrBuilder.sectSupraRates().weight(nuclWeight);
        }
        if (nuclMFDWeight > 0.0) {
            constrBuilder.sectSupraNuclMFDs().weight(nuclMFDWeight);
        }
        IntegerSampler.ExclusionIntegerSampler sampler = rupSet.hasModule(ModSectMinMags.class) ? constrBuilder.getSkipBelowMinSampler() : null;
        RuptureProbabilityCalc.BinaryRuptureProbabilityCalc rupExcludeModel = constrBuilder.getRupExclusionModel();
        if (rupExcludeModel != null) {
            sampler = PRVI25_InvConfigFactory.getExcludeSampler(rupSet.requireModule(ClusterRuptures.class), sampler, rupExcludeModel);
        }
        List<InversionConstraint> constraints = constrBuilder.build();
        SupraSeisBValInversionTargetMFDs targetMFDs = rupSet.requireModule(SupraSeisBValInversionTargetMFDs.class);
        GRParticRateEstimator rateEst = new GRParticRateEstimator(rupSet, targetMFDs);
        JumpProbabilityCalc segModel = PRVI25_InvConfigFactory.buildSegModel(rupSet, branch);
        if (segModel != null && PRVI25_InvConfigFactory.hasConstrainableJumps(rupSet, segModel)) {
            constraints = new ArrayList<InversionConstraint>(constraints);
            double weight = 100000.0;
            boolean ineq = true;
            constraints.add(new JumpProbabilityConstraint.RelativeRate(weight, ineq, rupSet, PRVI25_InvConfigFactory.buildSegModel(rupSet, branch), rateEst));
        }
        int avgThreads = Integer.max(1, threads / 4);
        int numRups = rupSet.getNumRuptures();
        if (sampler != null) {
            numRups = sampler.size();
        }
        long equivNumVars = Long.max(numRups, (long)rupSet.getNumSections() * 100L);
        IterationCompletionCriteria completion = new IterationCompletionCriteria(equivNumVars * this.numItersPerRup);
        IterationCompletionCriteria subCompletion = new IterationCompletionCriteria(equivNumVars);
        IterationCompletionCriteria avgCompletion = new IterationCompletionCriteria(equivNumVars * 50L);
        InversionConfiguration.Builder builder = InversionConfiguration.builder(constraints, completion).threads(threads).subCompletion(subCompletion).avgThreads(avgThreads, avgCompletion).perturbation(GenerationFunctionType.VARIABLE_EXPONENTIAL_SCALE).nonNegativity(NonnegativityConstraintType.TRY_ZERO_RATES_OFTEN).sampler(sampler).reweight().variablePertubationBasis(rateEst.estimateRuptureRates());
        return builder.build();
    }

    public static RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, ClusterRuptures cRups) {
        RuptureProbabilityCalc.BinaryRuptureProbabilityCalc exclusionModel;
        ArrayList<RuptureProbabilityCalc.BinaryRuptureProbabilityCalc> exclusionModels = new ArrayList<RuptureProbabilityCalc.BinaryRuptureProbabilityCalc>();
        SegmentationModelBranchNode segChoice = branch.getValue(SegmentationModelBranchNode.class);
        if (segChoice != null && (exclusionModel = segChoice.getExclusionModel(rupSet, branch)) != null) {
            exclusionModels.add(exclusionModel);
        }
        if (!ALLOW_CONNECTED_PROXY_FAULTS) {
            System.out.println("Excluding jumps to/from proxy faults");
            exclusionModels.add(new ProxyConnectionExclusionModel());
        }
        if (MAX_PROXY_FAULT_RUP_LEN > 0.0) {
            System.out.println("Excluding proxy fault ruptures longer than " + (float)MAX_PROXY_FAULT_RUP_LEN + " km");
            exclusionModels.add(new ProxyMaxLenExclusionModel(MAX_PROXY_FAULT_RUP_LEN));
        }
        if (PROXY_FAULT_CLASSIC_MMAX > 0.0 && branch.hasValue(NSHM23_SegmentationModels.CLASSIC)) {
            System.out.println("Excluding proxy fault ruptures on classic branch with M>" + (float)PROXY_FAULT_CLASSIC_MMAX);
            exclusionModels.add(new ProxyMaxMagExclusionModel(rupSet, PROXY_FAULT_CLASSIC_MMAX));
        }
        if (exclusionModels.isEmpty()) {
            return null;
        }
        if (exclusionModels.size() == 1) {
            return (RuptureProbabilityCalc.BinaryRuptureProbabilityCalc)exclusionModels.get(0);
        }
        System.out.println("Combining " + exclusionModels.size() + " exclusion models");
        return new RuptureProbabilityCalc.LogicalAnd(exclusionModels.toArray(new RuptureProbabilityCalc.BinaryRuptureProbabilityCalc[0]));
    }

    @Override
    public InversionSolver getSolver(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
        NSHM23_SegmentationModels segModel = branch.getValue(NSHM23_SegmentationModels.class);
        if (segModel == NSHM23_SegmentationModels.CLASSIC || segModel == NSHM23_SegmentationModels.CLASSIC_FULL) {
            if (this.isSolveClustersIndividually()) {
                System.out.println("Returning classic model solver");
                ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
                return new ClassicModelInversionSolver(rupSet, branch, PRVI25_InvConfigFactory.getExclusionModel(rupSet, branch, cRups));
            }
            if (!PRVI25_InvConfigFactory.hasPaleoData(rupSet)) {
                ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
                RuptureProbabilityCalc.BinaryRuptureProbabilityCalc exclusionModel = PRVI25_InvConfigFactory.getExclusionModel(rupSet, branch, cRups);
                boolean hasIncludedJump = false;
                for (ClusterRupture cRup : cRups) {
                    int numJumps = cRup.getTotalNumJumps();
                    if (numJumps <= 0 || exclusionModel != null && !exclusionModel.isRupAllowed(cRup, false)) continue;
                    hasIncludedJump = true;
                    break;
                }
                if (!hasIncludedJump) {
                    return new AnalyticalSingleFaultInversionSolver(exclusionModel);
                }
            }
            System.err.println("WARNING: solving classic model via full system inversion");
            return new InversionSolver.Default();
        }
        if (this.isSolveClustersIndividually()) {
            return new ExclusionAwareClusterSpecificInversionSolver();
        }
        return new InversionSolver.Default();
    }

    private static IntegerSampler.ExclusionIntegerSampler getExcludeSampler(ClusterRuptures cRups, IntegerSampler.ExclusionIntegerSampler currentSampler, RuptureProbabilityCalc.BinaryRuptureProbabilityCalc excludeCalc) {
        HashSet<Integer> skips = new HashSet<Integer>();
        for (int r = 0; r < cRups.size(); ++r) {
            if (excludeCalc.isRupAllowed(cRups.get(r), false)) continue;
            skips.add(r);
        }
        System.out.println("\tSkipped " + skips.size() + " ruptures");
        if (skips.isEmpty()) {
            return currentSampler;
        }
        IntegerSampler.ExclusionIntegerSampler skipSampler = new IntegerSampler.ExclusionIntegerSampler(0, cRups.size(), skips);
        if (currentSampler == null) {
            return skipSampler;
        }
        return currentSampler.getCombinedWith(skipSampler);
    }

    @Override
    public LogicTree<?> getGridSourceTree(LogicTree<?> faultTree) {
        if (faultTree.getBranch(0).hasValue(PRVI25_CrustalFaultModels.class)) {
            return LogicTree.buildExhaustive(PRVI25_LogicTree.levelsCrustalOffFault, true, new LogicTreeNode[0]);
        }
        if (faultTree.getBranch(0).hasValue(PRVI25_SubductionFaultModels.class)) {
            return LogicTree.buildExhaustive(PRVI25_LogicTree.levelsSubductionGridded, true, new LogicTreeNode[0]);
        }
        return null;
    }

    @Override
    public GridSourceProvider buildGridSourceProvider(FaultSystemSolution sol, LogicTreeBranch<?> fullBranch) throws IOException {
        if (fullBranch.hasValue(PRVI25_CrustalFaultModels.class)) {
            return PRVI25_GridSourceBuilder.buildCrustalGridSourceProv(sol, fullBranch);
        }
        if (fullBranch.hasValue(PRVI25_SubductionFaultModels.class)) {
            return PRVI25_GridSourceBuilder.buildCombinedSubductionGridSourceList(sol, fullBranch);
        }
        throw new IllegalStateException("Unexpected logic tree branch: " + String.valueOf(fullBranch));
    }

    @Override
    public void preGridBuildHook(FaultSystemSolution sol, LogicTreeBranch<?> faultBranch) throws IOException {
        PRVI25_GridSourceBuilder.doPreGridBuildHook(sol, faultBranch);
    }

    public static class PRVI25SolProcessor
    implements SolutionLogicTree.SolutionProcessor {
        private Table<RupSetFaultModel, RupturePlausibilityModels, PlausibilityConfiguration> configCache = HashBasedTable.create();

        @Override
        public synchronized FaultSystemRupSet processRupSet(final FaultSystemRupSet rupSet, final LogicTreeBranch<?> branch) {
            RupSetFaultModel fm;
            rupSet.addModule(branch);
            if (branch.hasValue(RupSetScalingRelationship.class)) {
                rupSet.offerAvailableModule(new Callable<AveSlipModule>(){
                    final /* synthetic */ PRVI25SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public AveSlipModule call() throws Exception {
                        return AveSlipModule.forModel(rupSet, branch.requireValue(RupSetScalingRelationship.class));
                    }
                }, AveSlipModule.class);
            }
            if (branch.hasValue(SlipAlongRuptureModelBranchNode.class)) {
                SlipAlongRuptureModel model = branch.getValue(SlipAlongRuptureModelBranchNode.class).getModel();
                if (rupSet.getModule(SlipAlongRuptureModel.class) != model) {
                    rupSet.addModule(model);
                }
            }
            if ((fm = branch.getValue(RupSetFaultModel.class)) != null) {
                fm.attachDefaultModules(rupSet);
            }
            rupSet.offerAvailableModule(new Callable<SupraSeisBValInversionTargetMFDs>(){
                final /* synthetic */ PRVI25SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public SupraSeisBValInversionTargetMFDs call() throws Exception {
                    return PRVI25_InvConfigFactory.getConstraintBuilder(rupSet, branch).getTargetMFDs();
                }
            }, SupraSeisBValInversionTargetMFDs.class);
            rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SectSlipRates>(){
                final /* synthetic */ PRVI25SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public SectSlipRates call() throws Exception {
                    SupraSeisBValInversionTargetMFDs.Builder builder;
                    SupraSeisBValInversionTargetMFDs targetMFDs = rupSet.getModule(SupraSeisBValInversionTargetMFDs.class, false);
                    if (targetMFDs != null) {
                        return targetMFDs.getSectSlipRates();
                    }
                    SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction moRateRed = branch.hasValue(SubSeisMoRateReductions.class) ? branch.getValue(SubSeisMoRateReductions.class).getChoice() : SupraSeisBValInversionTargetMFDs.SUB_SEIS_MO_RATE_REDUCTION_DEFAULT;
                    RandomBValSampler.Node bValNode = branch.getValue(RandomBValSampler.Node.class);
                    if (bValNode != null) {
                        RandomBValSampler sampler = rupSet.requireModule(BranchSamplingManager.class).getSampler(bValNode);
                        builder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, sampler.getBValues());
                    } else {
                        builder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, branch.requireValue(SectionSupraSeisBValues.class));
                    }
                    return builder.subSeisMoRateReduction(moRateRed).buildSlipRatesOnly();
                }
            }, SectSlipRates.class);
            final List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
            rupSet.offerAvailableModule(new Callable<PlausibilityConfiguration>(){
                final /* synthetic */ PRVI25SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PlausibilityConfiguration call() throws Exception {
                    PlausibilityConfiguration config;
                    RupturePlausibilityModels model = branch.requireValue(RupturePlausibilityModels.class);
                    RupSetFaultModel fm = branch.requireValue(RupSetFaultModel.class);
                    Table<RupSetFaultModel, RupturePlausibilityModels, PlausibilityConfiguration> table = this.this$0.configCache;
                    synchronized (table) {
                        config = (PlausibilityConfiguration)this.this$0.configCache.get((Object)fm, (Object)model);
                        if (config == null) {
                            config = model.getConfig(subSects, branch.requireValue(RupSetScalingRelationship.class)).getPlausibilityConfig();
                            this.this$0.configCache.put((Object)fm, (Object)model, (Object)config);
                        }
                    }
                    return config;
                }
            }, PlausibilityConfiguration.class);
            rupSet.offerAvailableModule(new Callable<ClusterRuptures>(){
                final /* synthetic */ PRVI25SolProcessor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ClusterRuptures call() throws Exception {
                    return ClusterRuptures.singleStranged(rupSet);
                }
            }, ClusterRuptures.class);
            if (BranchSamplingManager.hasSamplingNodes(branch)) {
                rupSet.offerAvailableModule(new Callable<BranchSamplingManager>(){
                    final /* synthetic */ PRVI25SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public BranchSamplingManager call() throws Exception {
                        return new BranchSamplingManager(rupSet, branch);
                    }
                }, BranchSamplingManager.class);
            }
            return rupSet;
        }

        @Override
        public FaultSystemSolution processSolution(final FaultSystemSolution sol, LogicTreeBranch<?> branch) {
            final FaultSystemRupSet rupSet = sol.getRupSet();
            if (!sol.hasAvailableModule(SolutionSlipRates.class) && rupSet.hasAvailableModule(AveSlipModule.class) && rupSet.hasAvailableModule(SlipAlongRuptureModel.class)) {
                sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SolutionSlipRates>(){
                    final /* synthetic */ PRVI25SolProcessor this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public SolutionSlipRates call() throws Exception {
                        return SolutionSlipRates.calc(sol, rupSet.requireModule(AveSlipModule.class), rupSet.requireModule(SlipAlongRuptureModel.class));
                    }
                }, SolutionSlipRates.class);
            }
            if (!sol.hasModule(LogicTreeBranch.class) || !branch.equals(sol.getModule(LogicTreeBranch.class))) {
                sol.addModule(branch);
            }
            return sol;
        }
    }

    private static class ProxyConnectionExclusionModel
    implements JumpProbabilityCalc.BinaryJumpProbabilityCalc {
        private ProxyConnectionExclusionModel() {
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "Proxy Fault Connections Excluded";
        }

        @Override
        public boolean isJumpAllowed(ClusterRupture fullRupture, Jump jump, boolean verbose) {
            return !jump.fromSection.isProxyFault() && !jump.toSection.isProxyFault();
        }
    }

    private static class ProxyMaxLenExclusionModel
    implements RuptureProbabilityCalc.BinaryRuptureProbabilityCalc {
        private double maxLen;

        public ProxyMaxLenExclusionModel(double maxLen) {
            this.maxLen = maxLen;
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "Proxy Fault Len<" + (float)this.maxLen + " km";
        }

        @Override
        public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
            double proxyLen = 0.0;
            for (FaultSubsectionCluster cluster : fullRupture.getClustersIterable()) {
                for (FaultSection sect : cluster.subSects) {
                    if (!sect.isProxyFault() || !((proxyLen += sect.getTraceLength()) > this.maxLen)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class ProxyMaxMagExclusionModel
    implements RuptureProbabilityCalc.BinaryRuptureProbabilityCalc {
        private double maxMag;
        private FaultSystemRupSet rupSet;
        private HashSet<UniqueRupture> excludes = new HashSet();

        public ProxyMaxMagExclusionModel(FaultSystemRupSet rupSet, double maxMag) {
            this.rupSet = rupSet;
            this.maxMag = maxMag;
            ClusterRuptures cRups = rupSet.requireModule(ClusterRuptures.class);
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                if (!(rupSet.getMagForRup(r) > maxMag)) continue;
                boolean isProxy = false;
                for (FaultSection sect : rupSet.getFaultSectionDataForRupture(r)) {
                    if (!sect.isProxyFault()) continue;
                    isProxy = true;
                    break;
                }
                if (!isProxy) continue;
                this.excludes.add(cRups.get((int)r).unique);
            }
        }

        @Override
        public boolean isDirectional(boolean splayed) {
            return false;
        }

        @Override
        public String getName() {
            return "Proxy Fault Mmax=" + (float)this.maxMag;
        }

        @Override
        public boolean isRupAllowed(ClusterRupture fullRupture, boolean verbose) {
            return !this.excludes.contains(fullRupture.unique);
        }
    }

    private static class ExclusionAwareClusterSpecificInversionSolver
    extends ClusterSpecificInversionSolver {
        private ExclusionAwareClusterSpecificInversionSolver() {
        }

        @Override
        protected RuptureProbabilityCalc.BinaryRuptureProbabilityCalc getRuptureExclusionModel(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch) {
            return PRVI25_InvConfigFactory.getExclusionModel(rupSet, branch, rupSet.requireModule(ClusterRuptures.class));
        }
    }

    public static class Rates1973scaledTo1900
    extends PRVI25_InvConfigFactory {
        @Override
        public LogicTree<?> getGridSourceTree(LogicTree<?> faultTree) {
            LogicTreeNode[] required = new LogicTreeNode[]{PRVI25_SeismicityRateEpoch.RECENT_SCALED};
            if (faultTree.getBranch(0).hasValue(PRVI25_CrustalFaultModels.class)) {
                return LogicTree.buildExhaustive(PRVI25_LogicTree.levelsCrustalOffFault, true, new BranchWeightProvider.NodeWeightOverrides(required, 1.0), required);
            }
            if (faultTree.getBranch(0).hasValue(PRVI25_SubductionFaultModels.class)) {
                return LogicTree.buildExhaustive(PRVI25_LogicTree.levelsSubductionGridded, true, new BranchWeightProvider.NodeWeightOverrides(required, 1.0), required);
            }
            throw new IllegalStateException();
        }
    }

    public static class MueAsCrustal
    extends PRVI25_InvConfigFactory {
        public MueAsCrustal() {
            MAX_PROXY_FAULT_RUP_LEN = 0.0;
            PRVI25_GridSourceBuilder.MUERTOS_AS_CRUSTAL = true;
        }

        /*
         * WARNING - void declaration
         */
        public static List<? extends FaultSection> removeMuertosFromInterface(List<? extends FaultSection> origSubSects) {
            ArrayList<void> modSubSects = new ArrayList<void>();
            for (FaultSection faultSection : origSubSects) {
                void var3_3;
                if (faultSection.getSectionName().contains("Muertos")) continue;
                if (faultSection.getSectionId() != modSubSects.size()) {
                    FaultSection faultSection2 = faultSection.clone();
                    faultSection2.setSectionId(modSubSects.size());
                }
                modSubSects.add(var3_3);
            }
            Preconditions.checkState((modSubSects.size() < origSubSects.size() ? 1 : 0) != 0);
            return modSubSects;
        }

        public static List<? extends FaultSection> addMuertosToCrustal(List<? extends FaultSection> origSubSects, RupSetFaultModel fm, RupSetDeformationModel dm, LogicTreeBranch<?> branch) throws IOException {
            ArrayList<? extends FaultSection> modSubSects = new ArrayList<FaultSection>();
            modSubSects.addAll(origSubSects);
            LogicTreeBranch<LogicTreeNode> interfaceBranch = PRVI25_LogicTree.DEFAULT_SUBDUCTION_INTERFACE.copy();
            if (dm == PRVI25_CrustalDeformationModels.GEOLOGIC_DIST_AVG) {
                interfaceBranch.setValue(PRVI25_SubductionCouplingModels.PREFERRED);
            } else {
                double rand = Math.random();
                double sumWeight = 0.0;
                for (PRVI25_SubductionCouplingModels coupling : PRVI25_SubductionCouplingModels.values()) {
                    double weight = coupling.getNodeWeight(branch);
                    if (!(weight > 0.0) || !(rand <= (sumWeight += weight))) continue;
                    interfaceBranch.setValue(coupling);
                    break;
                }
            }
            List<FaultSection> interfaceSects = PRVI25_SubductionDeformationModels.FULL.build(PRVI25_SubductionFaultModels.PRVI_SUB_FM_LARGE, interfaceBranch);
            for (FaultSection sect : interfaceSects) {
                if (!sect.getSectionName().contains("Muertos")) continue;
                sect = sect.clone();
                sect.setSectionId(modSubSects.size());
                modSubSects.add(sect);
            }
            Preconditions.checkState((modSubSects.size() > origSubSects.size() ? 1 : 0) != 0);
            return modSubSects;
        }

        @Override
        protected List<? extends FaultSection> buildSubSects(FaultSystemRupSet rupSet, RupSetFaultModel fm, RupSetDeformationModel dm, RupSetSubsectioningModel ssm, LogicTreeBranch<?> branch) throws IOException {
            List<? extends FaultSection> modSubSects;
            this.cacheDir = null;
            List<? extends FaultSection> origSubSects = super.buildSubSects(rupSet, fm, dm, ssm, branch);
            if (fm instanceof PRVI25_CrustalFaultModels) {
                modSubSects = MueAsCrustal.addMuertosToCrustal(origSubSects, fm, dm, branch);
            } else {
                Preconditions.checkState((boolean)(fm instanceof PRVI25_SubductionFaultModels));
                modSubSects = MueAsCrustal.removeMuertosFromInterface(origSubSects);
            }
            Preconditions.checkState((!modSubSects.isEmpty() ? 1 : 0) != 0);
            return modSubSects;
        }
    }

    public static class NoProxyLengthLimit
    extends PRVI25_InvConfigFactory {
        public NoProxyLengthLimit() {
            MAX_PROXY_FAULT_RUP_LEN = 0.0;
        }
    }

    public static class GriddedForceSlab2Depths
    extends PRVI25_InvConfigFactory {
        public GriddedForceSlab2Depths() {
            PRVI25_GridSourceBuilder.INTERFACE_USE_SECT_PROPERTIES = false;
        }
    }

    public static class GriddedForceCrustalRateBalancing
    extends PRVI25_InvConfigFactory {
        public GriddedForceCrustalRateBalancing() {
            PRVI25_GridSourceBuilder.RATE_BALANCE_CRUSTAL_GRIDDED = true;
        }
    }

    public static class GriddedUseExactBounds
    extends PRVI25_InvConfigFactory {
        public GriddedUseExactBounds() {
            PRVI25_CrustalSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.EXACT;
            PRVI25_SubductionCaribbeanSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.EXACT;
            PRVI25_SubductionMuertosSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.EXACT;
        }
    }

    public static class GriddedUseM1toMmaxBounds
    extends PRVI25_InvConfigFactory {
        public GriddedUseM1toMmaxBounds() {
            PRVI25_CrustalSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.M1_TO_MMAX;
            PRVI25_SubductionCaribbeanSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.M1_TO_MMAX;
            PRVI25_SubductionMuertosSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.M1_TO_MMAX;
        }
    }

    public static class GriddedUseM1Bounds
    extends PRVI25_InvConfigFactory {
        public GriddedUseM1Bounds() {
            PRVI25_CrustalSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.M1;
            PRVI25_SubductionCaribbeanSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.M1;
            PRVI25_SubductionMuertosSeismicityRate.TYPE = SeismicityRateFileLoader.RateType.M1;
        }
    }

    public static class RateBalanceAndLimitCrustalBelowObserved_0p9
    extends LimitCrustalBelowObserved {
        static double LIMIT_FRACT = 0.9;
        static double WEIGHT = 1000.0;

        public RateBalanceAndLimitCrustalBelowObserved_0p9() {
            super(LIMIT_FRACT, WEIGHT);
            PRVI25_GridSourceBuilder.RATE_BALANCE_CRUSTAL_GRIDDED = true;
        }
    }

    public static class LimitCrustalBelowObserved_0p9
    extends LimitCrustalBelowObserved {
        static double LIMIT_FRACT = 0.9;
        static double WEIGHT = 1000.0;

        public LimitCrustalBelowObserved_0p9() {
            super(LIMIT_FRACT, WEIGHT);
        }
    }

    private static abstract class LimitCrustalBelowObserved
    extends PRVI25_InvConfigFactory {
        private double limitFract;
        private double weight;

        protected LimitCrustalBelowObserved(double limitFract, double weight) {
            this.limitFract = limitFract;
            this.weight = weight;
        }

        @Override
        public InversionConfiguration buildInversionConfig(FaultSystemRupSet rupSet, LogicTreeBranch<?> branch, int threads) {
            IncrementalMagFreqDist obsMFD;
            InversionConfiguration config = super.buildInversionConfig(rupSet, branch, threads);
            IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(2.55, rupSet.getMaxMag());
            try {
                obsMFD = PRVI25_CrustalSeismicityRate.PREFFERRED.build(PRVI25_SeismicityRateEpoch.DEFAULT, refMFD, refMFD.getX(refMFD.getClosestXIndex(rupSet.getMaxMag())));
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            RuptureSubSetMappings subsetMappings = rupSet.getModule(RuptureSubSetMappings.class);
            if (this.limitFract != 1.0) {
                obsMFD.scale(this.limitFract);
            }
            if (subsetMappings != null) {
                int targetIndex;
                IncrementalMagFreqDist subsetTargets = rupSet.requireModule(InversionTargetMFDs.class).getTotalOnFaultSupraSeisMFD();
                IncrementalMagFreqDist origTargets = subsetMappings.getOrigRupSet().requireModule(InversionTargetMFDs.class).getTotalOnFaultSupraSeisMFD();
                Preconditions.checkState((subsetTargets.getMinX() == origTargets.getMinX() ? 1 : 0) != 0, (String)"%s != %s", (Object)subsetTargets.getMinX(), (Object)origTargets.getMinX());
                int mfdOffset = 0;
                if ((float)subsetTargets.getMinX() != (float)obsMFD.getMinX()) {
                    Preconditions.checkState((subsetTargets.getMinX() <= obsMFD.getMinX() ? 1 : 0) != 0, (String)"Targets MFD minX=%s must be <= obs MFD minX=%s", (Object)subsetTargets.getMinX(), (Object)obsMFD.getMinX());
                    mfdOffset = subsetTargets.getClosestXIndex(obsMFD.getMinX());
                }
                for (int i = 0; i < obsMFD.size() && (targetIndex = i + mfdOffset) < subsetTargets.size(); ++i) {
                    double targetX = subsetTargets.getX(targetIndex);
                    double obsX = obsMFD.getX(i);
                    Preconditions.checkState(((float)obsX == (float)targetX ? 1 : 0) != 0);
                    double subsetRate = subsetTargets.getY(targetIndex);
                    if (!(subsetRate > 0.0)) continue;
                    double origRate = origTargets.getY(targetIndex);
                    double obsRate = obsMFD.getY(i);
                    obsMFD.set(i, obsRate * subsetRate / origRate);
                }
            }
            MFDInversionConstraint constraint = new MFDInversionConstraint(rupSet, this.weight, true, ConstraintWeightingType.NORMALIZED, List.of(obsMFD));
            config = InversionConfiguration.builder(config).add(constraint).build();
            return config;
        }
    }
}

