/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.calc.magScalingRelations.MagLengthRelationship;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.CubedGriddedRegion;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultCubeAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.MaxMagOffFaultBranchNode;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_FaultCubeAssociations;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.gridded.NSHM23_SingleRegionGridSourceProvider;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_ScalingRelationships;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.PRVI25_InvConfigFactory;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalFaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_LogicTree;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeisSmoothingAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeismicityRateEpoch;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionCaribbeanSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionFaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionMuertosSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionScalingRelationships;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionSlabMMax;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.erf.ETAS.SeisDepthDistribution;

public class PRVI25_GridSourceBuilder {
    public static boolean RATE_BALANCE_CRUSTAL_GRIDDED = false;
    public static boolean RATE_BALANCE_INTERFACE_GRIDDED = false;
    public static boolean INTERFACE_USE_SECT_PROPERTIES = false;
    public static double INTERFACE_CAR_MAX_DEPTH = 50.0;
    public static double INTERFACE_MUE_MAX_DEPTH = 50.0;
    public static final int CAR_SLAB_ASSOC_ID = 7510;
    public static final int MUE_SLAB_ASSOC_ID = 7511;
    public static boolean MUERTOS_AS_CRUSTAL = false;
    public static final double OVERALL_MMIN = 2.55;
    public static double SLAB_M_CORNER = Double.NaN;
    private static Double CRUSTAL_FRACT_SS;
    private static Double CRUSTAL_FRACT_REV;
    private static Double CRUSTAL_FRACT_NORM;
    private static EnumMap<PRVI25_RegionLoader.PRVI25_SeismicityRegions, GriddedGeoDataSet> gridDepths;
    private static EnumMap<PRVI25_RegionLoader.PRVI25_SeismicityRegions, GriddedGeoDataSet> gridStrikes;
    private static EnumMap<PRVI25_RegionLoader.PRVI25_SeismicityRegions, GriddedGeoDataSet> gridDips;
    private static final String DEPTHS_DIR = "/data/erf/prvi25/seismicity/depths/";

    public static void doPreGridBuildHook(FaultSystemSolution sol, LogicTreeBranch<?> faultBranch) throws IOException {
        if (faultBranch.hasValue(PRVI25_CrustalFaultModels.class)) {
            FaultSystemRupSet rupSet = sol.getRupSet();
            if (!rupSet.hasModule(ModelRegion.class) && faultBranch.hasValue(PRVI25_CrustalFaultModels.class)) {
                rupSet.addModule(PRVI25_CrustalFaultModels.getDefaultRegion(faultBranch));
            }
            Region modelReg = rupSet.requireModule(ModelRegion.class).getRegion();
            FaultCubeAssociations cubeAssociations = rupSet.getModule(FaultCubeAssociations.class);
            if (cubeAssociations == null) {
                GriddedRegion modelGridReg = new GriddedRegion(modelReg, 0.1, GriddedRegion.ANCHOR_0_0);
                cubeAssociations = new NSHM23_FaultCubeAssociations(rupSet, new CubedGriddedRegion(modelGridReg), 12.0);
                rupSet.addModule(cubeAssociations);
            }
            Preconditions.checkNotNull((Object)cubeAssociations, (Object)"Cube associations is null");
        }
    }

    public static GridSourceList buildCrustalGridSourceProv(FaultSystemSolution sol, LogicTreeBranch<?> branch) throws IOException {
        PRVI25_GridSourceBuilder.doPreGridBuildHook(sol, branch);
        FaultSystemRupSet rupSet = sol.getRupSet();
        Preconditions.checkState((!branch.hasValue(PRVI25_SubductionFaultModels.class) ? 1 : 0) != 0, (Object)"This should only be used to build crustal models");
        FaultCubeAssociations cubeAssociations = rupSet.requireModule(FaultCubeAssociations.class);
        NSHM23_SingleRegionGridSourceProvider gridProv = PRVI25_GridSourceBuilder.buildCrustalGridSourceProv(sol, branch, cubeAssociations);
        GridSourceList gridList = gridProv.convertToGridSourceList(2.55);
        if (MUERTOS_AS_CRUSTAL) {
            PRVI25_SubductionScalingRelationships.LogAPlusC scale;
            LogicTreeBranch<LogicTreeNode> mueBranch = PRVI25_LogicTree.DEFAULT_SUBDUCTION_GRIDDED.copy();
            mueBranch.setValue(branch.requireValue(PRVI25_DeclusteringAlgorithms.class));
            mueBranch.setValue(branch.requireValue(PRVI25_SeisSmoothingAlgorithms.class));
            mueBranch.setValue(PRVI25_SubductionMuertosSeismicityRate.valueOf(branch.requireValue(PRVI25_CrustalSeismicityRate.class).name()));
            switch (branch.requireValue(NSHM23_ScalingRelationships.class)) {
                case LOGA_C4p1: {
                    scale = new PRVI25_SubductionScalingRelationships.LogAPlusC(4.1);
                    break;
                }
                case LOGA_C4p2: {
                    scale = new PRVI25_SubductionScalingRelationships.LogAPlusC(4.2);
                    break;
                }
                case LOGA_C4p3: {
                    scale = new PRVI25_SubductionScalingRelationships.LogAPlusC(4.3);
                    break;
                }
                case LOGA_C4p2_SQRT_LEN: {
                    scale = new PRVI25_SubductionScalingRelationships.LogAPlusC(4.2);
                    break;
                }
                default: {
                    scale = new PRVI25_SubductionScalingRelationships.LogAPlusC(4.2);
                }
            }
            GridSourceList mueList = PRVI25_GridSourceBuilder.buildInterfaceGridSourceList(sol, mueBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE, scale, null);
            ArrayList rupLists = new ArrayList();
            for (int l = 0; l < mueList.getNumLocations(); ++l) {
                ArrayList<GridSourceList.GriddedRupture> rups = new ArrayList<GridSourceList.GriddedRupture>();
                for (GridSourceList.GriddedRupture rup : mueList.getRuptures(TectonicRegionType.SUBDUCTION_INTERFACE, l)) {
                    GridSourceList.GriddedRuptureProperties props = rup.properties;
                    GridSourceList.GriddedRuptureProperties modProps = new GridSourceList.GriddedRuptureProperties(props.magnitude, props.rake, props.dip, props.strike, props.strikeRange, props.upperDepth, props.lowerDepth, props.length, props.hypocentralDepth, props.hypocentralDAS, TectonicRegionType.ACTIVE_SHALLOW);
                    rups.add(new GridSourceList.GriddedRupture(l, rup.location, modProps, rup.rate, rup.associatedSections, rup.associatedSectionFracts));
                }
                rupLists.add(rups);
            }
            mueList = new GridSourceList.Precomputed(mueList.getGriddedRegion(), TectonicRegionType.ACTIVE_SHALLOW, rupLists);
            gridList = GridSourceList.combine(gridList, mueList);
        }
        return gridList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkCalcCrustalFaultCategories() throws IOException {
        if (CRUSTAL_FRACT_SS != null) return;
        Class<PRVI25_GridSourceBuilder> clazz = PRVI25_GridSourceBuilder.class;
        synchronized (PRVI25_GridSourceBuilder.class) {
            if (CRUSTAL_FRACT_SS != null) return;
            PRVI25_GridSourceBuilder.calcCrustalFaultCategories();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static double getCrustalFractSS() {
        try {
            PRVI25_GridSourceBuilder.checkCalcCrustalFaultCategories();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        return CRUSTAL_FRACT_SS;
    }

    public static double getCrustalFractRev() {
        try {
            PRVI25_GridSourceBuilder.checkCalcCrustalFaultCategories();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        return CRUSTAL_FRACT_REV;
    }

    public static double getCrustalFractNorm() {
        try {
            PRVI25_GridSourceBuilder.checkCalcCrustalFaultCategories();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        return CRUSTAL_FRACT_NORM;
    }

    private static void calcCrustalFaultCategories() throws IOException {
        PRVI25_CrustalFaultModels fm = PRVI25_CrustalFaultModels.PRVI_CRUSTAL_FM_V1p1;
        PRVI25_CrustalDeformationModels dm = PRVI25_CrustalDeformationModels.GEOLOGIC_DIST_AVG;
        List<FaultSection> sects = dm.build(fm);
        double momentSS = 0.0;
        double momentRev = 0.0;
        double momentNorm = 0.0;
        double momentTot = 0.0;
        for (FaultSection sect : sects) {
            double moment = sect.calcMomentRate(false);
            double rake = sect.getAveRake();
            if ((int)rake == -135 || (int)rake == -45) {
                momentNorm += 0.5 * moment;
                momentSS += 0.5 * moment;
            } else if ((int)rake == 45 || (int)rake == 135) {
                momentRev += 0.5 * moment;
                momentSS += 0.5 * moment;
            } else if (rake >= -135.0 && rake < -45.0) {
                momentNorm += moment;
            } else if (rake >= 45.0 && rake < 135.0) {
                momentRev += moment;
            } else {
                momentSS += moment;
            }
            momentTot += moment;
        }
        CRUSTAL_FRACT_SS = momentSS / momentTot;
        CRUSTAL_FRACT_REV = momentRev / momentTot;
        CRUSTAL_FRACT_NORM = momentNorm / momentTot;
        System.out.println("Crustal fractional moments:");
        System.out.println("\tSS:\t" + (float)(momentSS / momentTot));
        System.out.println("\tRev:\t" + (float)(momentRev / momentTot));
        System.out.println("\tNorm:\t" + (float)(momentNorm / momentTot));
    }

    public static NSHM23_SingleRegionGridSourceProvider buildCrustalGridSourceProv(FaultSystemSolution sol, LogicTreeBranch<?> branch, FaultCubeAssociations cubeAssociations) throws IOException {
        double maxMagOff = branch.requireValue(MaxMagOffFaultBranchNode.class).getMaxMagOffFault();
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(2.55, Math.max(maxMagOff, sol.getRupSet().getMaxMag()));
        PRVI25_CrustalSeismicityRate seisBranch = branch.requireValue(PRVI25_CrustalSeismicityRate.class);
        PRVI25_SeismicityRateEpoch epoch = branch.requireValue(PRVI25_SeismicityRateEpoch.class);
        IncrementalMagFreqDist totalGR = seisBranch.build(epoch, refMFD, maxMagOff);
        return PRVI25_GridSourceBuilder.buildCrustalGridSourceProv(sol, branch, cubeAssociations, totalGR);
    }

    public static NSHM23_SingleRegionGridSourceProvider buildCrustalGridSourceProv(FaultSystemSolution sol, LogicTreeBranch<?> branch, FaultCubeAssociations cubeAssociations, IncrementalMagFreqDist totalGR) throws IOException {
        PRVI25_DeclusteringAlgorithms declusteringAlg = branch.requireValue(PRVI25_DeclusteringAlgorithms.class);
        PRVI25_SeisSmoothingAlgorithms seisSmooth = branch.requireValue(PRVI25_SeisSmoothingAlgorithms.class);
        double[] pdf = seisSmooth.load(PRVI25_RegionLoader.PRVI25_SeismicityRegions.CRUSTAL, declusteringAlg);
        return PRVI25_GridSourceBuilder.buildCrustalGridSourceProv(sol, cubeAssociations, totalGR, pdf);
    }

    public static NSHM23_SingleRegionGridSourceProvider buildCrustalGridSourceProv(FaultSystemSolution sol, FaultCubeAssociations cubeAssociations, IncrementalMagFreqDist totalGR, double[] pdf) throws IOException {
        GriddedRegion gridReg = cubeAssociations.getRegion();
        IncrementalMagFreqDist totalGridded = new IncrementalMagFreqDist(totalGR.getMinX(), totalGR.size(), totalGR.getDelta());
        IncrementalMagFreqDist solNuclMFD = sol.calcNucleationMFD_forRegion((Region)gridReg, totalGR.getMinX(), totalGR.getMaxX(), totalGR.size(), false);
        for (int i = 0; i < totalGR.size(); ++i) {
            double totalRate = totalGR.getY(i);
            if (!(totalRate > 0.0)) continue;
            if (RATE_BALANCE_CRUSTAL_GRIDDED) {
                double solRate = solNuclMFD.getY(i);
                if (solRate > totalRate) {
                    System.err.println("WARNING: MFD bulge at M=" + (float)totalGR.getX(i) + "\tGR=" + (float)totalRate + "\tsol=" + (float)solRate);
                    continue;
                }
                totalGridded.set(i, totalRate - solRate);
                continue;
            }
            totalGridded.set(i, totalRate);
        }
        double[] fractStrikeSlip = new double[gridReg.getNodeCount()];
        double[] fractReverse = new double[gridReg.getNodeCount()];
        double[] fractNormal = new double[gridReg.getNodeCount()];
        PRVI25_GridSourceBuilder.checkCalcCrustalFaultCategories();
        for (int i = 0; i < fractStrikeSlip.length; ++i) {
            fractStrikeSlip[i] = CRUSTAL_FRACT_SS;
            fractReverse[i] = CRUSTAL_FRACT_REV;
            fractNormal[i] = CRUSTAL_FRACT_NORM;
        }
        SeisDepthDistribution seisDepthDistribution = new SeisDepthDistribution();
        double delta = 2.0;
        HistogramFunction binnedDepthDistFunc = new HistogramFunction(1.0, 12, delta);
        for (int i = 0; i < binnedDepthDistFunc.size(); ++i) {
            double prob = seisDepthDistribution.getProbBetweenDepths(binnedDepthDistFunc.getX(i) - delta / 2.0, binnedDepthDistFunc.getX(i) + delta / 2.0);
            binnedDepthDistFunc.set(i, prob);
        }
        boolean preserveTotalMFD = RATE_BALANCE_CRUSTAL_GRIDDED;
        return new NSHM23_SingleRegionGridSourceProvider(sol, cubeAssociations, pdf, totalGridded, preserveTotalMFD, binnedDepthDistFunc, fractStrikeSlip, fractNormal, fractReverse, null);
    }

    public static GridSourceList buildCombinedSubductionGridSourceList(FaultSystemSolution sol, LogicTreeBranch<?> fullBranch) throws IOException {
        GridSourceList muertosSlab = PRVI25_GridSourceBuilder.buildSlabGridSourceList(fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB);
        GridSourceList carSlab = PRVI25_GridSourceBuilder.buildSlabGridSourceList(fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB);
        GridSourceList muertosInterface = MUERTOS_AS_CRUSTAL ? null : PRVI25_GridSourceBuilder.buildInterfaceGridSourceList(sol, fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE);
        GridSourceList carInterface = PRVI25_GridSourceBuilder.buildInterfaceGridSourceList(sol, fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE);
        Region muertosUnionRegion = MUERTOS_AS_CRUSTAL ? PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB.load() : Region.union(PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB.load(), PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE.load());
        Region carUnionRegion = Region.union(PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB.load(), PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE.load());
        Preconditions.checkNotNull((Object)muertosUnionRegion, (Object)"Couldn't union Muertos regions");
        Preconditions.checkNotNull((Object)carUnionRegion, (Object)"Couldn't union CAR regions");
        Region unionRegion = Region.union(muertosUnionRegion, carUnionRegion);
        Preconditions.checkNotNull((Object)unionRegion, (Object)"Couldn't union CAR regions");
        GriddedRegion griddedUnionRegion = new GriddedRegion(unionRegion, muertosSlab.getGriddedRegion().getSpacing(), GriddedRegion.ANCHOR_0_0);
        if (MUERTOS_AS_CRUSTAL) {
            return GridSourceList.combine(griddedUnionRegion, carInterface, carSlab, muertosSlab);
        }
        return GridSourceList.combine(griddedUnionRegion, carInterface, carSlab, muertosInterface, muertosSlab);
    }

    public static GriddedGeoDataSet loadSubductionDepths(PRVI25_RegionLoader.PRVI25_SeismicityRegions seisReg) throws IOException {
        PRVI25_GridSourceBuilder.loadRegionDepthStrikeData(seisReg);
        return gridDepths.get(seisReg).copy();
    }

    public static GriddedGeoDataSet loadSubductionStrikes(PRVI25_RegionLoader.PRVI25_SeismicityRegions seisReg) throws IOException {
        PRVI25_GridSourceBuilder.loadRegionDepthStrikeData(seisReg);
        return gridStrikes.get(seisReg).copy();
    }

    public static GriddedGeoDataSet loadSubductionDips(PRVI25_RegionLoader.PRVI25_SeismicityRegions seisReg) throws IOException {
        PRVI25_GridSourceBuilder.loadRegionDepthStrikeData(seisReg);
        return gridDips.get(seisReg).copy();
    }

    private static synchronized void loadRegionDepthStrikeData(PRVI25_RegionLoader.PRVI25_SeismicityRegions seisReg) throws IOException {
        if (gridDepths == null) {
            gridDepths = new EnumMap(PRVI25_RegionLoader.PRVI25_SeismicityRegions.class);
            gridStrikes = new EnumMap(PRVI25_RegionLoader.PRVI25_SeismicityRegions.class);
            gridDips = new EnumMap(PRVI25_RegionLoader.PRVI25_SeismicityRegions.class);
        }
        if (!gridDepths.containsKey(seisReg)) {
            GriddedRegion gridReg;
            String fileName;
            PRVI25_RegionLoader.PRVI25_SeismicityRegions[] applicableRegions;
            if (seisReg == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE || seisReg == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB) {
                applicableRegions = new PRVI25_RegionLoader.PRVI25_SeismicityRegions[]{PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE, PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB};
                fileName = "/data/erf/prvi25/seismicity/depths/CAR_slab2_extended-v2.csv";
                gridReg = new GriddedRegion(PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB.load(), 0.05, GriddedRegion.ANCHOR_0_0);
            } else if (seisReg == PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE || seisReg == PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB) {
                applicableRegions = new PRVI25_RegionLoader.PRVI25_SeismicityRegions[]{PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB};
                fileName = "/data/erf/prvi25/seismicity/depths/MUE_slab2_extended-v2.csv";
                gridReg = new GriddedRegion(PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB.load(), 0.02, GriddedRegion.ANCHOR_0_0);
            } else {
                throw new IllegalStateException("Not applicable to region: " + String.valueOf(seisReg));
            }
            System.out.println("Loading gridded Slab2 depth/strike/dip data from " + fileName);
            InputStream depthResources = PRVI25_GridSourceBuilder.class.getResourceAsStream(fileName);
            Preconditions.checkNotNull((Object)depthResources, (String)"Depth CSV not found: %s", (Object)fileName);
            CSVFile<String> csv = CSVFile.readStream(depthResources, true);
            GriddedGeoDataSet depths = new GriddedGeoDataSet(gridReg);
            GriddedGeoDataSet strikes = new GriddedGeoDataSet(gridReg);
            GriddedGeoDataSet dips = new GriddedGeoDataSet(gridReg);
            for (int i = 0; i < depths.size(); ++i) {
                depths.set(i, Double.NaN);
                strikes.set(i, Double.NaN);
                dips.set(i, Double.NaN);
            }
            int numFilled = 0;
            int numSkipped = 0;
            for (int row = 1; row < csv.getNumRows(); ++row) {
                double lon = csv.getDouble(row, 0);
                double lat = csv.getDouble(row, 1);
                Location loc = new Location(lat, lon);
                int gridIndex = gridReg.indexForLocation(loc);
                if (gridIndex < 0) {
                    ++numSkipped;
                    continue;
                }
                Preconditions.checkState((boolean)LocationUtils.areSimilar(loc, gridReg.getLocation(gridIndex)), (String)"Location mismatch: ours[%s]=%s, theirs=%s", (Object)gridIndex, (Object)gridReg.getLocation(gridIndex), (Object)loc);
                double depth = csv.getDouble(row, 2);
                Preconditions.checkState((boolean)Double.isFinite(depth));
                FaultUtils.assertValidDepth(depth);
                depths.set(gridIndex, depth);
                double strike = csv.getDouble(row, 3);
                Preconditions.checkState((boolean)Double.isFinite(strike));
                FaultUtils.assertValidStrike(strike);
                strikes.set(gridIndex, strike);
                double dip = csv.getDouble(row, 4);
                Preconditions.checkState((boolean)Double.isFinite(dip));
                FaultUtils.assertValidDip(dip);
                dips.set(gridIndex, dip);
                ++numFilled;
            }
            System.out.println("\tFilled in data for " + numFilled + "/" + depths.size() + " Slab2 grid nodes (skipped " + numSkipped + " from file)");
            for (PRVI25_RegionLoader.PRVI25_SeismicityRegions reg : applicableRegions) {
                gridDepths.put(reg, depths);
                gridStrikes.put(reg, strikes);
                gridDips.put(reg, dips);
            }
        }
    }

    public static GridSourceList buildSlabGridSourceList(LogicTreeBranch<?> branch) throws IOException {
        GridSourceList muertos = PRVI25_GridSourceBuilder.buildSlabGridSourceList(branch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB);
        GridSourceList car = PRVI25_GridSourceBuilder.buildSlabGridSourceList(branch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB);
        return GridSourceList.combine(car, muertos);
    }

    public static GridSourceList buildSlabGridSourceList(LogicTreeBranch<?> branch, PRVI25_RegionLoader.PRVI25_SeismicityRegions seisRegion) throws IOException {
        IncrementalMagFreqDist totalGR;
        Preconditions.checkState((seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB || seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB ? 1 : 0) != 0);
        PRVI25_SubductionSlabMMax mMaxBranch = branch.requireValue(PRVI25_SubductionSlabMMax.class);
        PRVI25_SeismicityRateEpoch epoch = branch.requireValue(PRVI25_SeismicityRateEpoch.class);
        double maxMagOff = mMaxBranch.getMmax();
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(2.55, maxMagOff);
        maxMagOff = refMFD.getX(refMFD.getClosestXIndex(maxMagOff - 0.01));
        Preconditions.checkState((maxMagOff <= mMaxBranch.getMmax() ? 1 : 0) != 0);
        if (seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB) {
            PRVI25_SubductionMuertosSeismicityRate seisBranch = branch.requireValue(PRVI25_SubductionMuertosSeismicityRate.class);
            totalGR = seisBranch.build(epoch, refMFD, maxMagOff, SLAB_M_CORNER, true);
        } else if (seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB) {
            PRVI25_SubductionCaribbeanSeismicityRate seisBranch = branch.requireValue(PRVI25_SubductionCaribbeanSeismicityRate.class);
            totalGR = seisBranch.build(epoch, refMFD, maxMagOff, SLAB_M_CORNER, true);
        } else {
            throw new IllegalStateException("Not a slab region: " + String.valueOf(seisRegion));
        }
        return PRVI25_GridSourceBuilder.buildSlabGridSourceList(branch, seisRegion, totalGR);
    }

    public static GridSourceList buildSlabGridSourceList(LogicTreeBranch<?> branch, PRVI25_RegionLoader.PRVI25_SeismicityRegions seisRegion, IncrementalMagFreqDist totalGR) throws IOException {
        Preconditions.checkState((seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB || seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTRASLAB ? 1 : 0) != 0);
        int assocID = seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB ? 7510 : 7511;
        int[] assocIDarray = new int[]{assocID};
        double[] assocFractArray = new double[]{1.0};
        PRVI25_DeclusteringAlgorithms declusteringAlg = branch.requireValue(PRVI25_DeclusteringAlgorithms.class);
        PRVI25_SeisSmoothingAlgorithms seisSmooth = branch.requireValue(PRVI25_SeisSmoothingAlgorithms.class);
        GriddedGeoDataSet pdf = seisSmooth.loadXYZ(seisRegion, declusteringAlg);
        ArrayList ruptureLists = new ArrayList(pdf.size());
        PRVI25_GridSourceBuilder.loadRegionDepthStrikeData(seisRegion);
        GriddedGeoDataSet depthData = gridDepths.get(seisRegion);
        Preconditions.checkNotNull((Object)depthData);
        double rake = 0.0;
        double dip = 90.0;
        double strike = Double.NaN;
        boolean truePointSources = true;
        double maxDDW = 0.0;
        Object scale = null;
        double hypocentralDepth = Double.NaN;
        double hypocentralDAS = Double.NaN;
        for (int gridIndex = 0; gridIndex < pdf.size(); ++gridIndex) {
            double fract = pdf.get(gridIndex);
            if (fract == 0.0) {
                ruptureLists.add(null);
                continue;
            }
            Location loc = pdf.getLocation(gridIndex);
            int depthIndex = depthData.indexOf(loc);
            Location depthLoc = depthData.getLocation(depthIndex);
            Preconditions.checkState((boolean)LocationUtils.areSimilar(loc, depthLoc));
            double upper = depthData.get(depthIndex);
            ArrayList<GridSourceList.GriddedRupture> ruptureList = new ArrayList<GridSourceList.GriddedRupture>(totalGR.size());
            ruptureLists.add(ruptureList);
            for (int i = 0; i < totalGR.size(); ++i) {
                double lower;
                double length;
                double mag = totalGR.getX(i);
                double rate = totalGR.getY(i) * fract;
                if (rate == 0.0 || (float)mag < 2.55f) continue;
                if (truePointSources) {
                    length = 0.0;
                    lower = upper;
                } else {
                    if (!(scale instanceof MagLengthRelationship)) {
                        throw new IllegalStateException();
                    }
                    length = ((MagLengthRelationship)scale).getMedianLength(mag);
                    double ddw = Math.min(maxDDW, length);
                    lower = dip == 90.0 ? upper + ddw : upper + ddw * Math.sin(Math.toRadians(dip));
                }
                GridSourceList.GriddedRuptureProperties props = new GridSourceList.GriddedRuptureProperties(mag, rake, dip, strike, null, upper, lower, length, hypocentralDepth, hypocentralDAS, TectonicRegionType.SUBDUCTION_SLAB);
                ruptureList.add(new GridSourceList.GriddedRupture(gridIndex, loc, props, rate, assocIDarray, assocFractArray));
            }
        }
        return new GridSourceList.Precomputed(pdf.getRegion(), TectonicRegionType.SUBDUCTION_SLAB, ruptureLists);
    }

    public static GridSourceList buildInterfaceGridSourceList(FaultSystemSolution sol, LogicTreeBranch<?> fullBranch) throws IOException {
        GridSourceList muertos = PRVI25_GridSourceBuilder.buildInterfaceGridSourceList(sol, fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE);
        GridSourceList car = PRVI25_GridSourceBuilder.buildInterfaceGridSourceList(sol, fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE);
        return GridSourceList.combine(car, muertos);
    }

    public static GridSourceList buildInterfaceGridSourceList(FaultSystemSolution sol, LogicTreeBranch<?> fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions seisRegion) throws IOException {
        PRVI25_SubductionScalingRelationships scaleBranch = fullBranch.requireValue(PRVI25_SubductionScalingRelationships.class);
        MagAreaRelationship scale = scaleBranch.getMagAreaRelationship();
        return PRVI25_GridSourceBuilder.buildInterfaceGridSourceList(sol, fullBranch, seisRegion, scale, null);
    }

    /*
     * WARNING - void declaration
     */
    public static GridSourceList buildInterfaceGridSourceList(FaultSystemSolution sol, LogicTreeBranch<?> fullBranch, PRVI25_RegionLoader.PRVI25_SeismicityRegions seisRegion, MagAreaRelationship scale, Function<Double, IncrementalMagFreqDist> mfdBuilderFunc) throws IOException {
        int gridIndex;
        List<? extends FaultSection> sectsForMinMag;
        int[] parentIDs;
        switch (seisRegion) {
            case CAR_INTERFACE: {
                parentIDs = new int[]{7500, 7501};
                break;
            }
            case MUE_INTERFACE: {
                parentIDs = new int[]{7550};
                break;
            }
            default: {
                throw new IllegalStateException("Not an interface SeismicityRegion: " + String.valueOf(seisRegion));
            }
        }
        boolean D = false;
        System.out.println("Building interface GridSourceList for " + String.valueOf(seisRegion) + ", useSectProps=" + INTERFACE_USE_SECT_PROPERTIES);
        FaultSystemRupSet rupSet = sol.getRupSet();
        List<? extends FaultSection> sectsForGeom = sectsForMinMag = rupSet.getFaultSectionDataList();
        if (INTERFACE_USE_SECT_PROPERTIES && seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE && !fullBranch.hasValue(PRVI25_SubductionFaultModels.PRVI_SUB_FM_LARGE)) {
            PRVI25_SubductionFaultModels fm = PRVI25_SubductionFaultModels.PRVI_SUB_FM_LARGE;
            PRVI25_SubductionDeformationModels dm = fullBranch.getValue(PRVI25_SubductionDeformationModels.class);
            if (dm == null) {
                dm = PRVI25_SubductionDeformationModels.FULL;
            }
            sectsForGeom = dm.build(fm);
            if (MUERTOS_AS_CRUSTAL) {
                sectsForGeom = PRVI25_InvConfigFactory.MueAsCrustal.removeMuertosFromInterface(sectsForGeom);
            }
            Preconditions.checkState((sectsForGeom.size() == sectsForMinMag.size() ? 1 : 0) != 0, (String)"Geometry (%s) and min-mag (%s) section counts differ!", (int)sectsForGeom.size(), (int)sectsForMinMag.size());
        }
        final IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(2.55, 9.0);
        HashMap<Double, IncrementalMagFreqDist> mMaxMFDCache = new HashMap<Double, IncrementalMagFreqDist>();
        if (mfdBuilderFunc == null) {
            Enum seisBranch;
            final PRVI25_SeismicityRateEpoch epoch = fullBranch.requireValue(PRVI25_SeismicityRateEpoch.class);
            if (seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.MUE_INTERFACE) {
                seisBranch = fullBranch.requireValue(PRVI25_SubductionMuertosSeismicityRate.class);
                mfdBuilderFunc = new Function<Double, IncrementalMagFreqDist>(){

                    @Override
                    public IncrementalMagFreqDist apply(Double mMax) {
                        try {
                            return seisBranch.build(epoch, refMFD, mMax, Double.NaN, false);
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException((Throwable)e);
                        }
                    }
                };
            } else if (seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE) {
                seisBranch = fullBranch.requireValue(PRVI25_SubductionCaribbeanSeismicityRate.class);
                mfdBuilderFunc = new Function<Double, IncrementalMagFreqDist>(){
                    final /* synthetic */ PRVI25_SubductionCaribbeanSeismicityRate val$seisBranch;
                    final /* synthetic */ PRVI25_SeismicityRateEpoch val$epoch;
                    final /* synthetic */ IncrementalMagFreqDist val$refMFD;
                    {
                        this.val$seisBranch = pRVI25_SubductionCaribbeanSeismicityRate;
                        this.val$epoch = pRVI25_SeismicityRateEpoch;
                        this.val$refMFD = incrementalMagFreqDist;
                    }

                    @Override
                    public IncrementalMagFreqDist apply(Double mMax) {
                        try {
                            return this.val$seisBranch.build(this.val$epoch, this.val$refMFD, mMax, Double.NaN, false);
                        }
                        catch (IOException e) {
                            throw ExceptionUtils.asRuntimeException((Throwable)e);
                        }
                    }
                };
            } else {
                throw new IllegalStateException("Not an interface region: " + String.valueOf(seisRegion));
            }
        }
        PRVI25_DeclusteringAlgorithms declusteringAlg = fullBranch.requireValue(PRVI25_DeclusteringAlgorithms.class);
        PRVI25_SeisSmoothingAlgorithms seisSmooth = fullBranch.requireValue(PRVI25_SeisSmoothingAlgorithms.class);
        PRVI25_GridSourceBuilder.loadRegionDepthStrikeData(seisRegion);
        GriddedGeoDataSet depthData = gridDepths.get(seisRegion);
        Preconditions.checkNotNull((Object)depthData);
        GriddedGeoDataSet strikeData = gridStrikes.get(seisRegion);
        Preconditions.checkNotNull((Object)strikeData);
        GriddedGeoDataSet dipData = gridDips.get(seisRegion);
        Preconditions.checkNotNull((Object)dipData);
        GriddedGeoDataSet pdf = seisSmooth.loadXYZ(seisRegion, declusteringAlg);
        GriddedRegion region = pdf.getRegion();
        ArrayList<FaultSection> minMagMatchingSubSects = null;
        ArrayList<Double> minMagMatchingSubSectMMins = null;
        ArrayList<Double> minMagMatchingSubSectMMaxs = null;
        ArrayList<RuptureSurface> minMagMatchingSectSurfs = null;
        double maxSectMinMag = 0.0;
        int[] minMagSectMappings = null;
        ArrayList<FaultSection> geomMatchingSubSects = null;
        ArrayList<RuptureSurface> geomMatchingSectSurfs = null;
        int[] geomSectMappings = null;
        double overallFurthestMinMagMatch = 0.0;
        double overallFurthestGeomMatch = 0.0;
        for (boolean geom : new boolean[]{false, true}) {
            double overallFurthestMatch;
            int[] sectMappings;
            ArrayList<RuptureSurface> matchingSectSurfs;
            ArrayList<Double> matchingSubSectMMaxs;
            ArrayList<Double> matchingSubSectMMins;
            ArrayList<FaultSection> matchingSubSects;
            if (geom && sectsForGeom == sectsForMinMag) {
                matchingSubSects = minMagMatchingSubSects;
                matchingSubSectMMins = null;
                matchingSubSectMMaxs = null;
                matchingSectSurfs = minMagMatchingSectSurfs;
                sectMappings = minMagSectMappings;
                overallFurthestMatch = overallFurthestMinMagMatch;
            } else {
                List<? extends FaultSection> sects = geom ? sectsForGeom : sectsForMinMag;
                matchingSubSects = new ArrayList<FaultSection>();
                ArrayList<Region> matchingSubSectOutlines = new ArrayList<Region>();
                matchingSubSectMMins = geom ? null : new ArrayList<Double>();
                matchingSubSectMMaxs = geom ? null : new ArrayList<Double>();
                ArrayList<Location[]> matchingSubSectFirstEdges = new ArrayList<Location[]>();
                ArrayList<Location[]> matchingSubSectLastEdges = new ArrayList<Location[]>();
                matchingSectSurfs = new ArrayList<RuptureSurface>();
                for (FaultSection faultSection : sects) {
                    double sectMaxMag;
                    int sectParentID = faultSection.getParentSectionId();
                    if (!Ints.contains((int[])parentIDs, (int)sectParentID)) continue;
                    matchingSubSects.add(faultSection);
                    RuptureSurface surf = faultSection.getFaultSurface(2.0, false, false);
                    matchingSectSurfs.add(surf);
                    matchingSubSectOutlines.add(new Region(surf.getPerimeter(), BorderType.MERCATOR_LINEAR));
                    FaultTrace upper = surf.getUpperEdge();
                    LocationList lower = surf.getEvenlyDiscritizedLowerEdge();
                    Location[] firstEdge = new Location[]{lower.first(), upper.first()};
                    Location[] lastEdge = new Location[]{lower.last(), upper.last()};
                    matchingSubSectFirstEdges.add(firstEdge);
                    matchingSubSectLastEdges.add(lastEdge);
                    double sectMinMag = geom ? Double.NaN : rupSet.getMinMagForSection(faultSection.getSectionId());
                    double d = sectMaxMag = geom ? Double.NaN : rupSet.getMaxMagForSection(faultSection.getSectionId());
                    if (geom) continue;
                    matchingSubSectMMins.add(sectMinMag);
                    matchingSubSectMMaxs.add(sectMaxMag);
                    maxSectMinMag = Math.max(maxSectMinMag, sectMinMag);
                }
                sectMappings = new int[pdf.size()];
                overallFurthestMatch = 0.0;
                for (gridIndex = 0; gridIndex < pdf.size(); ++gridIndex) {
                    if (pdf.get(gridIndex) == 0.0) continue;
                    Location location = pdf.getLocation(gridIndex);
                    int matchingSectIndex = -1;
                    for (int i = 0; i < matchingSubSects.size(); ++i) {
                        if (!((Region)matchingSubSectOutlines.get(i)).contains(location)) continue;
                        matchingSectIndex = i;
                        break;
                    }
                    if (matchingSectIndex < 0) {
                        double minEdgeDist = Double.POSITIVE_INFINITY;
                        int minEdgeIndex = -1;
                        for (int i = 0; i < matchingSubSects.size(); ++i) {
                            boolean pos2;
                            Location[] firstEdge = (Location[])matchingSubSectFirstEdges.get(i);
                            Location[] lastEdge = (Location[])matchingSubSectLastEdges.get(i);
                            double dist1 = LocationUtils.distanceToLineFast(firstEdge[0], firstEdge[1], location);
                            boolean pos1 = dist1 >= 0.0;
                            double dist2 = LocationUtils.distanceToLineFast(lastEdge[0], lastEdge[1], location);
                            boolean bl = pos2 = dist2 >= 0.0;
                            if (pos1 != pos2) {
                                Preconditions.checkState((matchingSectIndex < 0 ? 1 : 0) != 0, (Object)"Edge positivity test matched multiple sections!");
                                matchingSectIndex = i;
                                continue;
                            }
                            double dist = Math.min(Math.abs(dist1), Math.abs(dist2));
                            if (!(dist < minEdgeDist)) continue;
                            minEdgeDist = dist;
                            minEdgeIndex = i;
                        }
                        if (matchingSectIndex < 0) {
                            matchingSectIndex = minEdgeIndex;
                        }
                        double dist = ((Region)matchingSubSectOutlines.get(matchingSectIndex)).distanceToLocation(location);
                        overallFurthestMatch = Math.max(overallFurthestMatch, dist);
                    }
                    FaultSection matchingSection = (FaultSection)matchingSubSects.get(matchingSectIndex);
                    sectMappings[gridIndex] = matchingSectIndex;
                }
            }
            if (geom) {
                geomMatchingSubSects = matchingSubSects;
                geomMatchingSectSurfs = matchingSectSurfs;
                geomSectMappings = sectMappings;
                overallFurthestGeomMatch = overallFurthestMatch;
                continue;
            }
            minMagMatchingSubSects = matchingSubSects;
            minMagMatchingSubSectMMins = matchingSubSectMMins;
            minMagMatchingSubSectMMaxs = matchingSubSectMMaxs;
            minMagMatchingSectSurfs = matchingSectSurfs;
            minMagSectMappings = sectMappings;
            overallFurthestMinMagMatch = overallFurthestMatch;
        }
        System.out.println("MFD Gridding Mmmax=" + (float)refMFD.getMaxX());
        ArrayList ruptureLists = new ArrayList(pdf.size());
        double overallMinDepth = depthData.getMinZ();
        double overallMaxDepth = depthData.getMaxZ();
        double minDepthRangeLimit = 0.2 * (overallMaxDepth - overallMinDepth);
        double[] gridRateSubtracts = null;
        if (RATE_BALANCE_INTERFACE_GRIDDED) {
            double[] sectNuclRates = sol.calcNucleationRateForAllSects(0.0, Double.POSITIVE_INFINITY);
            int[] sectMappingCounts = new int[sectsForMinMag.size()];
            for (int gridIndex2 = 0; gridIndex2 < pdf.size(); ++gridIndex2) {
                void sectIndex;
                void v2 = sectIndex = geomSectMappings[gridIndex2];
                sectMappingCounts[v2] = sectMappingCounts[v2] + 1;
            }
            gridRateSubtracts = new double[pdf.size()];
            for (int gridIndex2 = 0; gridIndex2 < pdf.size(); ++gridIndex2) {
                int sectIndex = geomSectMappings[gridIndex2];
                gridRateSubtracts[gridIndex2] = sectNuclRates[sectIndex] / (double)sectMappingCounts[sectIndex];
            }
        }
        double overallDepthUpperLimit = Double.NaN;
        double overallDepthLowerLimit = Double.NaN;
        if (!INTERFACE_USE_SECT_PROPERTIES) {
            overallDepthLowerLimit = seisRegion == PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE ? INTERFACE_CAR_MAX_DEPTH : INTERFACE_MUE_MAX_DEPTH;
            overallDepthUpperLimit = depthData.getMinZ();
            Preconditions.checkState((overallDepthUpperLimit >= 0.0 ? 1 : 0) != 0);
            System.out.println("Gridded depth limits for " + String.valueOf(region) + ": [" + (float)overallDepthUpperLimit + ", " + (float)overallDepthUpperLimit + "]");
        }
        double totRateM5 = 0.0;
        DataUtils.MinMaxAveTracker reductionPDiffStats = RATE_BALANCE_INTERFACE_GRIDDED ? new DataUtils.MinMaxAveTracker() : null;
        for (gridIndex = 0; gridIndex < pdf.size(); ++gridIndex) {
            double subtract;
            double mMax;
            double dip;
            double strike;
            double depthLowerLimit;
            double depthUpperLimit;
            double depth;
            double d = pdf.get(gridIndex);
            if (d == 0.0) {
                ruptureLists.add(new ArrayList());
                continue;
            }
            Location gridLoc = pdf.getLocation(gridIndex);
            boolean DD = false;
            if (DD) {
                System.out.println("DEBUG for grid " + gridIndex + " at " + String.valueOf(gridLoc));
            }
            FaultSection matchingSection = (FaultSection)geomMatchingSubSects.get(geomSectMappings[gridIndex]);
            if (INTERFACE_USE_SECT_PROPERTIES) {
                RuptureSurface surf = (RuptureSurface)geomMatchingSectSurfs.get(geomSectMappings[gridIndex]);
                if (surf instanceof EvenlyGriddedSurface) {
                    EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
                    double closest = Double.POSITIVE_INFINITY;
                    int closestRow = -1;
                    int closestCol = -1;
                    for (int row = 0; row < gridSurf.getNumRows(); ++row) {
                        for (int col = 0; col < gridSurf.getNumCols(); ++col) {
                            Location loc = (Location)gridSurf.get(row, col);
                            double dist = LocationUtils.horzDistanceFast(loc, gridLoc);
                            if (!(dist < closest)) continue;
                            closest = dist;
                            closestRow = row;
                            closestCol = col;
                        }
                    }
                    depth = ((Location)gridSurf.get((int)closestRow, (int)closestCol)).depth;
                    depthUpperLimit = ((Location)gridSurf.get((int)0, (int)closestCol)).depth;
                    depthLowerLimit = ((Location)gridSurf.get((int)(gridSurf.getNumRows() - 1), (int)closestCol)).depth;
                } else {
                    double closest = Double.POSITIVE_INFINITY;
                    Location closestLoc = null;
                    depthUpperLimit = Double.POSITIVE_INFINITY;
                    depthLowerLimit = Double.NEGATIVE_INFINITY;
                    for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                        depthUpperLimit = Math.min(depthUpperLimit, loc.depth);
                        depthLowerLimit = Math.max(depthLowerLimit, loc.depth);
                        double dist = LocationUtils.horzDistanceFast(loc, gridLoc);
                        if (!(dist < closest)) continue;
                        closest = dist;
                        closestLoc = loc;
                    }
                    depth = closestLoc.depth;
                }
                strike = surf.getAveStrike();
                dip = matchingSection.getAveDip();
                if (DD) {
                    System.out.println("\tOriginal sect depth is " + (float)depthData.get(gridIndex));
                    System.out.println("\tClosest sect depth is " + (float)depth);
                    System.out.println("\tSect depth limits are [" + (float)depthUpperLimit + ", " + (float)depthLowerLimit + "]");
                }
            } else {
                int depthIndex = depthData.indexOf(gridLoc);
                Preconditions.checkState((depthIndex >= 0 ? 1 : 0) != 0, (String)"No location in depth data for %s. %s", (int)gridIndex, (Object)gridLoc);
                Location depthLoc = depthData.getLocation(depthIndex);
                Preconditions.checkState((boolean)LocationUtils.areSimilar(depthLoc, gridLoc), (String)"Depth data location mismatch: %s. %s != %s. %s", (Object)gridIndex, (Object)gridLoc, (Object)depthIndex, (Object)depthLoc);
                strike = strikeData.get(depthIndex);
                depth = depthData.get(depthIndex);
                Preconditions.checkState((depth >= overallDepthUpperLimit ? 1 : 0) != 0, (String)"Depth=%s < limit=%s", (Object)depth, (Object)overallDepthUpperLimit);
                Preconditions.checkState((depth <= overallDepthLowerLimit ? 1 : 0) != 0, (String)"Depth=%s > limit=%s", (Object)depth, (Object)overallDepthLowerLimit);
                depthUpperLimit = overallDepthUpperLimit;
                depthLowerLimit = overallDepthLowerLimit;
                dip = dipData.get(depthIndex);
                Preconditions.checkState((boolean)Double.isFinite(dip), (String)"Bad dip for location %s: %s", (int)gridIndex, (Object)gridLoc);
                FaultUtils.assertValidDip(dip);
            }
            int[] assocIDs = new int[]{matchingSection.getSectionId()};
            double[] assocFracts = new double[]{1.0};
            double dipRad = Math.toRadians(dip);
            double rake = 90.0;
            double sectMmin = (Double)minMagMatchingSubSectMMins.get(minMagSectMappings[gridIndex]);
            int sectMminIndex = refMFD.getClosestXIndex(sectMmin);
            Preconditions.checkState((sectMminIndex > 0 ? 1 : 0) != 0);
            if (RATE_BALANCE_INTERFACE_GRIDDED) {
                double sectMmax = (Double)minMagMatchingSubSectMMaxs.get(minMagSectMappings[gridIndex]);
                int sectMmaxIndex = refMFD.getClosestXIndex(sectMmax);
                Preconditions.checkState((sectMmaxIndex > 0 ? 1 : 0) != 0);
                mMax = refMFD.getX(sectMmaxIndex);
            } else {
                mMax = refMFD.getX(sectMminIndex - 1);
            }
            double maxDDW = (depthLowerLimit - depthUpperLimit) / Math.sin(dipRad);
            IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)mMaxMFDCache.get(mMax);
            if (mfd == null) {
                mfd = mfdBuilderFunc.apply(mMax);
                mMaxMFDCache.put(mMax, mfd);
            }
            mfd = mfd.deepClone();
            mfd.scale(d);
            if (RATE_BALANCE_INTERFACE_GRIDDED && (subtract = gridRateSubtracts[gridIndex]) > 0.0) {
                int m5Index = mfd.getClosestXIndex(5.01);
                double origRateM5 = mfd.getCumRate(m5Index);
                double targetRateM5 = origRateM5 - subtract;
                if (targetRateM5 <= 0.0) {
                    System.err.println("WARNING: subtractRate=" + (float)subtract + " > gridM5[" + gridIndex + "]=" + origRateM5 + ", setting grid rate to zero");
                    ruptureLists.add(new ArrayList());
                    reductionPDiffStats.addValue(100.0);
                    continue;
                }
                Preconditions.checkState((sectMminIndex > 0 ? 1 : 0) != 0);
                for (int i = sectMminIndex; i < mfd.size(); ++i) {
                    mfd.set(i, 0.0);
                }
                double afterCarveRateM5 = mfd.getCumRate(m5Index);
                double scalar = targetRateM5 / afterCarveRateM5;
                reductionPDiffStats.addValue(100.0 * subtract / origRateM5);
                mfd.scale(scalar);
                Preconditions.checkState((boolean)Precision.equals((double)targetRateM5, (double)mfd.getCumRate(m5Index), (double)1.0E-5));
            }
            ArrayList<GridSourceList.GriddedRupture> ruptureList = new ArrayList<GridSourceList.GriddedRupture>(sectMminIndex);
            ruptureLists.add(ruptureList);
            for (int i = 0; i < mfd.size(); ++i) {
                double lower;
                double upper;
                double length;
                double ddw;
                double mag = mfd.getX(i);
                double rate = mfd.getY(i);
                if (rate == 0.0 || (float)mag < 2.55f) continue;
                if (mag >= 5.0) {
                    totRateM5 += rate;
                }
                double area = scale.getMedianArea(mag);
                double sqRtArea = Math.sqrt(area);
                double hypocentralDAS = Double.NaN;
                double hypocentralDepth = depth;
                Preconditions.checkState((boolean)Double.isFinite(depth), (String)"closestDepth=%s?", (Object)depth);
                if (sqRtArea <= maxDDW) {
                    ddw = sqRtArea;
                    length = sqRtArea;
                    double vertDDW = ddw * Math.sin(dipRad);
                    Preconditions.checkState((boolean)Double.isFinite(vertDDW), (String)"vertDDW=%s with ddw=%s, dip=%s, dipRad=%s", (Object)vertDDW, (Object)ddw, (Object)dip, (Object)dipRad);
                    double calcUpper = hypocentralDepth - 0.5 * vertDDW;
                    if (calcUpper < depthUpperLimit) {
                        upper = depthUpperLimit;
                        lower = upper + vertDDW;
                    } else {
                        double calcLower = hypocentralDepth + 0.5 * vertDDW;
                        if (calcLower > depthLowerLimit) {
                            lower = depthLowerLimit;
                            upper = depthLowerLimit - vertDDW;
                        } else {
                            upper = calcUpper;
                            lower = calcLower;
                        }
                    }
                } else {
                    ddw = maxDDW;
                    length = area / ddw;
                    upper = depthUpperLimit;
                    lower = depthLowerLimit;
                }
                if (DD) {
                    System.out.println("\tM" + (float)mag + " with depth=" + (float)hypocentralDepth + ", range=[" + (float)upper + ", " + (float)lower + "]");
                }
                Preconditions.checkState((boolean)Double.isFinite(upper));
                Preconditions.checkState((boolean)Double.isFinite(lower), (String)"lower=%s? depthLowerLimit=%s, ddw=%s", (Object)lower, (Object)depthLowerLimit, (Object)ddw);
                GridSourceList.GriddedRuptureProperties props = new GridSourceList.GriddedRuptureProperties(mag, rake, dip, strike, null, upper, lower, length, hypocentralDepth, hypocentralDAS, TectonicRegionType.SUBDUCTION_INTERFACE);
                ruptureList.add(new GridSourceList.GriddedRupture(gridIndex, gridLoc, props, rate, assocIDs, assocFracts));
            }
        }
        System.out.println("Done building gridded provider for " + String.valueOf(seisRegion) + "; worst grid-to-interface distance: " + (float)overallFurthestGeomMatch + "km");
        if (RATE_BALANCE_INTERFACE_GRIDDED) {
            IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)mMaxMFDCache.values().iterator().next();
            double d = mfd.getCumRate(mfd.getClosestXIndex(5.001));
            double origM6 = mfd.getCumRate(mfd.getClosestXIndex(6.001));
            System.out.println("Rate balance for " + String.valueOf(seisRegion) + ":");
            System.out.println("\treduced origM5=" + (float)d + " to " + (float)totRateM5 + " (" + new DecimalFormat("0.000%").format((totRateM5 - d) / d) + ")");
            System.out.println("\tReduction %diff stats: " + String.valueOf(reductionPDiffStats));
        }
        return new GridSourceList.Precomputed(pdf.getRegion(), TectonicRegionType.SUBDUCTION_INTERFACE, ruptureLists);
    }

    public static void main(String[] args) throws IOException {
        ModuleContainer.VERBOSE_DEFAULT = false;
        ArrayList<LogicTreeLevel<LogicTreeLevel<? extends LogicTreeNode>>> levels = new ArrayList<LogicTreeLevel<LogicTreeLevel<? extends LogicTreeNode>>>();
        levels.addAll(PRVI25_LogicTree.levelsSubduction);
        levels.addAll(PRVI25_LogicTree.levelsSubductionGridded);
        LogicTreeBranch<LogicTreeNode> branch = new LogicTreeBranch<LogicTreeNode>(levels);
        for (LogicTreeNode node : PRVI25_LogicTree.DEFAULT_SUBDUCTION_INTERFACE) {
            branch.setValue(node);
        }
        for (LogicTreeNode node : PRVI25_LogicTree.DEFAULT_SUBDUCTION_GRIDDED) {
            branch.setValue(node);
        }
        branch.setValue(PRVI25_SubductionScalingRelationships.AVERAGE);
        branch.setValue(PRVI25_SubductionMuertosSeismicityRate.PREFFERRED);
        branch.setValue(PRVI25_SubductionCaribbeanSeismicityRate.PREFFERRED);
        branch.setValue(PRVI25_SeisSmoothingAlgorithms.AVERAGE);
        branch.setValue(PRVI25_DeclusteringAlgorithms.AVERAGE);
        FaultSystemSolution sol = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/nshm23/batch_inversions/2025_08_01-prvi25_subduction_branches/results_PRVI_SUB_FM_LARGE_branch_averaged.zip"));
        branch.setValue(PRVI25_SubductionFaultModels.PRVI_SUB_FM_LARGE);
        GridSourceList combSources = PRVI25_GridSourceBuilder.buildCombinedSubductionGridSourceList(sol, branch);
        sol.setGridSourceProvider(combSources);
        sol.write(new File("/tmp/prvi_comb_grid_source_test.zip"));
        FaultSystemSolution.load(new File("/tmp/prvi_comb_grid_source_test.zip")).getGridSourceProvider();
    }
}

