/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Region;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.SeismicityRateFileLoader;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeisSmoothingAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class SeismicityRateModel {
    private final UncertaintyBoundType boundType;
    private final double lowerQuantile;
    private final double upperQuantile;
    private final SeismicityRateFileLoader.RateRecord meanRecord;
    private final SeismicityRateFileLoader.RateRecord lowerRecord;
    private final SeismicityRateFileLoader.RateRecord upperRecord;
    private static final DecimalFormat oDF = new DecimalFormat("0.##");

    public SeismicityRateModel(CSVFile<String> csv, SeismicityRateFileLoader.RateType type, UncertaintyBoundType boundType) {
        this(SeismicityRateFileLoader.loadRecords(csv, type), boundType);
    }

    public SeismicityRateModel(List<? extends SeismicityRateFileLoader.RateRecord> rates, UncertaintyBoundType boundType) {
        this.boundType = boundType;
        switch (boundType) {
            case CONF_68: {
                this.lowerQuantile = 0.16;
                this.upperQuantile = 0.84;
                break;
            }
            case ONE_SIGMA: {
                this.lowerQuantile = 0.16;
                this.upperQuantile = 0.84;
                break;
            }
            case CONF_95: {
                this.lowerQuantile = 0.025;
                this.upperQuantile = 0.975;
                break;
            }
            case TWO_SIGMA: {
                this.lowerQuantile = 0.025;
                this.upperQuantile = 0.975;
                break;
            }
            default: {
                throw new IllegalStateException("Not supported: " + String.valueOf((Object)boundType));
            }
        }
        this.meanRecord = SeismicityRateFileLoader.locateMean(rates);
        this.lowerRecord = SeismicityRateFileLoader.locateQuantile(rates, this.lowerQuantile);
        this.upperRecord = SeismicityRateFileLoader.locateQuantile(rates, this.upperQuantile);
    }

    public SeismicityRateModel(SeismicityRateFileLoader.RateRecord meanRecord, SeismicityRateFileLoader.RateRecord lowerRecord, SeismicityRateFileLoader.RateRecord upperRecord, UncertaintyBoundType boundType) {
        this.boundType = boundType;
        switch (boundType) {
            case CONF_68: {
                this.lowerQuantile = 0.16;
                this.upperQuantile = 0.84;
                break;
            }
            case ONE_SIGMA: {
                this.lowerQuantile = 0.16;
                this.upperQuantile = 0.84;
                break;
            }
            case CONF_95: {
                this.lowerQuantile = 0.025;
                this.upperQuantile = 0.975;
                break;
            }
            case TWO_SIGMA: {
                this.lowerQuantile = 0.025;
                this.upperQuantile = 0.975;
                break;
            }
            default: {
                throw new IllegalStateException("Not supported: " + String.valueOf((Object)boundType));
            }
        }
        this.meanRecord = meanRecord;
        this.lowerRecord = lowerRecord;
        this.upperRecord = upperRecord;
    }

    public UncertaintyBoundType getBoundType() {
        return this.boundType;
    }

    public double getLowerQuantile() {
        return this.lowerQuantile;
    }

    public double getUpperQuantile() {
        return this.upperQuantile;
    }

    public SeismicityRateFileLoader.RateRecord getMeanRecord() {
        return this.meanRecord;
    }

    public SeismicityRateFileLoader.RateRecord getLowerRecord() {
        return this.lowerRecord;
    }

    public SeismicityRateFileLoader.RateRecord getUpperRecord() {
        return this.upperRecord;
    }

    private static IncrementalMagFreqDist adjustForCrossover(IncrementalMagFreqDist branchIncr, IncrementalMagFreqDist prefIncr, boolean lower) {
        Preconditions.checkState((prefIncr.size() == branchIncr.size() ? 1 : 0) != 0);
        Preconditions.checkState(((float)prefIncr.getMinX() == (float)branchIncr.getMinX() ? 1 : 0) != 0);
        IncrementalMagFreqDist ret = new IncrementalMagFreqDist(branchIncr.getMinX(), branchIncr.getMaxX(), branchIncr.size());
        boolean anyOutside = false;
        for (int i = 0; i < branchIncr.size(); ++i) {
            double prefY = prefIncr.getY(i);
            double myY = branchIncr.getY(i);
            if (lower && myY > prefY || !lower && myY < prefY) {
                anyOutside = true;
                ret.set(i, prefY);
                continue;
            }
            ret.set(i, myY);
        }
        if (anyOutside) {
            ret.setName(branchIncr.getName());
            return ret;
        }
        return branchIncr;
    }

    public IncrementalMagFreqDist buildPreferred(EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        return this.build(this.meanRecord, refMFD, mMax);
    }

    public IncrementalMagFreqDist buildPreferred(EvenlyDiscretizedFunc refMFD, double mMax, double magCorner) throws IOException {
        return this.build(this.meanRecord, refMFD, mMax, magCorner);
    }

    public IncrementalMagFreqDist buildLower(EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        return this.build(this.lowerRecord, refMFD, mMax);
    }

    public IncrementalMagFreqDist buildLower(EvenlyDiscretizedFunc refMFD, double mMax, double magCorner) throws IOException {
        return this.build(this.lowerRecord, refMFD, mMax, magCorner);
    }

    public IncrementalMagFreqDist buildUpper(EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        return this.build(this.upperRecord, refMFD, mMax);
    }

    public IncrementalMagFreqDist buildUpper(EvenlyDiscretizedFunc refMFD, double mMax, double magCorner) throws IOException {
        return this.build(this.upperRecord, refMFD, mMax, magCorner);
    }

    private IncrementalMagFreqDist build(SeismicityRateFileLoader.RateRecord record, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        return this.build(record, refMFD, mMax, Double.NaN);
    }

    private IncrementalMagFreqDist build(SeismicityRateFileLoader.RateRecord record, EvenlyDiscretizedFunc refMFD, double mMax, double magCorner) throws IOException {
        boolean preferred;
        IncrementalMagFreqDist mfd = SeismicityRateFileLoader.buildIncrementalMFD(record, refMFD, mMax, magCorner);
        boolean bl = preferred = record.mean || record.quantile == 0.5;
        if (!(record instanceof SeismicityRateFileLoader.Exact) && !preferred) {
            mfd = SeismicityRateModel.adjustForCrossover(mfd, this.build(this.meanRecord, refMFD, mMax), record.quantile < 0.5);
        }
        Object name = "Observed";
        if (!preferred) {
            name = (String)name + " (p" + oDF.format(100.0 * record.quantile) + ")";
        }
        name = (String)name + ", N" + oDF.format(record.M1) + "=" + oDF.format(record.rateAboveM1);
        mfd.setName((String)name);
        return mfd;
    }

    public UncertainBoundedIncrMagFreqDist getBounded(EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        return this.getBounded(refMFD, mMax, Double.NaN);
    }

    public UncertainBoundedIncrMagFreqDist getBounded(EvenlyDiscretizedFunc refMFD, double mMax, double magCorner) throws IOException {
        IncrementalMagFreqDist upper = this.buildUpper(refMFD, mMax, magCorner);
        IncrementalMagFreqDist lower = this.buildLower(refMFD, mMax, magCorner);
        IncrementalMagFreqDist pref = this.buildPreferred(refMFD, mMax, magCorner);
        double M1 = this.meanRecord.M1;
        UncertainBoundedIncrMagFreqDist bounded = new UncertainBoundedIncrMagFreqDist(pref, lower, upper, this.boundType);
        bounded.setName(pref.getName());
        bounded.setBoundName(this.getBoundName(lower, upper, M1));
        return bounded;
    }

    public UncertainArbDiscFunc getBoundedCml(EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        EvenlyDiscretizedFunc pref;
        EvenlyDiscretizedFunc lower;
        EvenlyDiscretizedFunc upper;
        if (this.upperRecord instanceof SeismicityRateFileLoader.Exact) {
            upper = ((SeismicityRateFileLoader.Exact)this.upperRecord).cumulativeDist;
            lower = ((SeismicityRateFileLoader.Exact)this.lowerRecord).cumulativeDist;
            pref = ((SeismicityRateFileLoader.Exact)this.meanRecord).cumulativeDist;
        } else {
            upper = this.buildUpper(refMFD, mMax).getCumRateDistWithOffset();
            lower = this.buildLower(refMFD, mMax).getCumRateDistWithOffset();
            pref = this.buildPreferred(refMFD, mMax).getCumRateDistWithOffset();
        }
        double M1 = this.meanRecord.M1;
        UncertainArbDiscFunc bounded = new UncertainArbDiscFunc(pref, lower, upper, this.boundType);
        bounded.setName(pref.getName());
        bounded.setBoundName(this.getBoundName(lower, upper, M1));
        return bounded;
    }

    String getBoundName(IncrementalMagFreqDist lower, IncrementalMagFreqDist upper, double M1) {
        return this.getBoundName(lower.getCumRateDistWithOffset(), upper.getCumRateDistWithOffset(), M1);
    }

    String getBoundName(EvenlyDiscretizedFunc lower, EvenlyDiscretizedFunc upper, double M1) {
        Object boundName = this.boundType.toString();
        double lowerN = lower.getInterpolatedY(M1);
        double upperN = upper.getInterpolatedY(M1);
        boundName = (String)boundName + ": N" + oDF.format(M1) + "\u2208[" + oDF.format(lowerN) + "," + oDF.format(upperN) + "]";
        return boundName;
    }

    public UncertainBoundedIncrMagFreqDist getRescaled(double fractN, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        IncrementalMagFreqDist pref = this.buildPreferred(refMFD, mMax);
        pref.scale(fractN);
        IncrementalMagFreqDist uppper = this.buildUpper(refMFD, mMax);
        uppper.scale(fractN);
        IncrementalMagFreqDist lower = this.buildLower(refMFD, mMax);
        lower.scale(fractN);
        for (int i = 0; i < pref.size(); ++i) {
            double prefVal = pref.getY(i);
            if (!(prefVal > 0.0)) continue;
            double origUpper = uppper.getY(i);
            double origLower = lower.getY(i);
            double upperRatio = origUpper / prefVal;
            double lowerRatio = origLower / prefVal;
            uppper.set(i, prefVal * (upperRatio *= 1.0 / Math.sqrt(fractN)));
            lower.set(i, prefVal * (lowerRatio /= 1.0 / Math.sqrt(fractN)));
        }
        UncertainBoundedIncrMagFreqDist rescaled = new UncertainBoundedIncrMagFreqDist(pref, lower, uppper, this.boundType);
        double M1 = this.meanRecord.M1;
        double prefN = rescaled.getCumRateDistWithOffset().getInterpolatedY(M1);
        String name = "Remmapped Observed [pdfFractN=" + oDF.format(fractN) + ", N" + oDF.format(M1) + "=" + oDF.format(prefN) + "]";
        rescaled.setName(name);
        rescaled.setBoundName(this.getBoundName(rescaled.getLower(), rescaled.getUpper(), M1));
        return rescaled;
    }

    public UncertainBoundedIncrMagFreqDist getRemapped(Region region, PRVI25_RegionLoader.PRVI25_SeismicityRegions seisRegion, PRVI25_DeclusteringAlgorithms declustering, PRVI25_SeisSmoothingAlgorithms smoothing, EvenlyDiscretizedFunc refMFD, double mMax) throws IOException {
        GriddedGeoDataSet pdf = smoothing.loadXYZ(seisRegion, declustering);
        double fractN = 0.0;
        for (int i = 0; i < pdf.size(); ++i) {
            if (!region.contains(pdf.getLocation(i))) continue;
            fractN += pdf.get(i);
        }
        return this.getRescaled(fractN, refMFD, mMax);
    }
}

