/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModelRegion;
import org.opensha.sha.earthquake.faultSysSolution.modules.ProxyFaultSectionInstances;
import org.opensha.sha.earthquake.faultSysSolution.modules.RegionsOfInterest;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionUtils;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_DeclusteringAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeisSmoothingAlgorithms;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeismicityRateEpoch;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="indices.csv"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
public enum PRVI25_CrustalFaultModels implements RupSetFaultModel,
RupSetSubsectioningModel
{
    PRVI_CRUSTAL_FM_V1p1("PRVI25 Crustal FM v1.1", "Crustal FM v1.1", "/data/erf/prvi25/fault_models/crustal/NSHM2025_GeoDefModel_PRVI_v1-1_mod.geojson", 1.0),
    PRVI_CRUSTAL_FM_V1p2("PRVI25 Crustal FM v1.2", "Crustal FM v1.2", "/data/erf/prvi25/fault_models/crustal/NSHM2025_GeoDefModel_PRVI_v1-2_ProjRates_mod.geojson", 0.0);

    private String name;
    private String shortName;
    private String jsonPath;
    private double weight;
    public static final boolean PROJECT_TO_PLANE = false;
    public static final String HIGH_RATE_PROP_NAME = "HighRate";
    public static final String LOW_RATE_PROP_NAME = "LowRate";
    static final double DOWN_DIP_FRACT_DEFAULT = 0.5;
    static final double MAX_LEN_DEFAULT = Double.NaN;
    static final int MIN_SUB_SECTS_PER_FAULT_DEFAULT = 2;

    private PRVI25_CrustalFaultModels(String name, String shortName, String jsonPath, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.jsonPath = jsonPath;
        this.weight = weight;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<? extends FaultSection> getFaultSections() throws IOException {
        return this.getFaultSections(false);
    }

    public List<? extends FaultSection> getFaultSections(boolean projectToPlane) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(PRVI25_CrustalFaultModels.class.getResourceAsStream(this.jsonPath)));
        List<GeoJSONFaultSection> sects = GeoJSONFaultReader.readFaultSections(reader);
        if (projectToPlane) {
            for (GeoJSONFaultSection sect : sects) {
                sect.setAveSlipRate(PRVI25_CrustalFaultModels.projectSlip(sect.getOrigAveSlipRate(), sect.getAveDip(), sect.getAveRake()));
                FeatureProperties props = sect.getProperties();
                props.set(HIGH_RATE_PROP_NAME, PRVI25_CrustalFaultModels.projectSlip(props.getDouble(HIGH_RATE_PROP_NAME, Double.NaN), sect.getAveDip(), sect.getAveRake()));
                props.set(LOW_RATE_PROP_NAME, PRVI25_CrustalFaultModels.projectSlip(props.getDouble(LOW_RATE_PROP_NAME, Double.NaN), sect.getAveDip(), sect.getAveRake()));
            }
        }
        return sects;
    }

    public static double projectSlip(double origSlipRate, double dip, double rake) {
        FaultUtils.assertValidRake(rake);
        double absRake = Math.abs(rake);
        boolean oblique = (float)absRake != 180.0f && (float)absRake != 90.0f && (float)absRake != 0.0f;
        boolean origIsHorizontal = (float)absRake > 135.0f || (float)absRake < 45.0f;
        double slipRate = origSlipRate;
        if (dip != 90.0 && !origIsHorizontal) {
            slipRate /= Math.sin(Math.toRadians(dip));
        }
        if (oblique) {
            double obliqueAngle = origIsHorizontal ? Math.min(absRake, Math.abs(absRake - 180.0)) : Math.abs(absRake - 90.0);
            Preconditions.checkState(((float)obliqueAngle <= 45.0f ? 1 : 0) != 0, (String)"Oblique angle should never be >45: %s", (Object)Float.valueOf((float)obliqueAngle));
            if (obliqueAngle > 0.0) {
                slipRate /= Math.cos(Math.toRadians(obliqueAngle));
            }
        }
        return slipRate;
    }

    public static ModelRegion getDefaultRegion(LogicTreeBranch<?> branch) throws IOException {
        return new ModelRegion(PRVI25_RegionLoader.loadPRVI_ModelBroad());
    }

    @Override
    public void attachDefaultModules(final FaultSystemRupSet rupSet) {
        final LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<ModelRegion>(){
            final /* synthetic */ PRVI25_CrustalFaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ModelRegion call() throws Exception {
                return PRVI25_CrustalFaultModels.getDefaultRegion(branch);
            }
        }, ModelRegion.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<ProxyFaultSectionInstances>(){
            final /* synthetic */ PRVI25_CrustalFaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ProxyFaultSectionInstances call() throws Exception {
                return ProxyFaultSectionInstances.build(rupSet, 5, 3.0, 0.25, 5, 10, true);
            }
        }, ProxyFaultSectionInstances.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RegionsOfInterest>(){
            final /* synthetic */ PRVI25_CrustalFaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RegionsOfInterest call() throws Exception {
                ArrayList<Region> regions = new ArrayList<Region>();
                ArrayList<IncrementalMagFreqDist> regionMFDs = new ArrayList<IncrementalMagFreqDist>();
                ArrayList<TectonicRegionType> regionTRTs = new ArrayList<TectonicRegionType>();
                List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
                for (PRVI25_RegionLoader.PRVI25_SeismicityRegions seisReg : new PRVI25_RegionLoader.PRVI25_SeismicityRegions[]{PRVI25_RegionLoader.PRVI25_SeismicityRegions.CRUSTAL}) {
                    Region region = seisReg.load();
                    if (!FaultSectionUtils.anySectInRegion(region, subSects, true)) continue;
                    regionMFDs.add(PRVI25_CrustalFaultModels.getRegionalMFD(seisReg, null, branch));
                    regions.add(region);
                    regionTRTs.add(TectonicRegionType.ACTIVE_SHALLOW);
                }
                Region mapRegion = PRVI25_RegionLoader.loadPRVI_MapExtents();
                if (FaultSectionUtils.anySectInRegion(mapRegion, subSects, true)) {
                    mapRegion.setName("PRVI - NSHMP Map Region");
                    regions.add(mapRegion);
                    regionMFDs.add(PRVI25_CrustalFaultModels.getRegionalMFD(PRVI25_RegionLoader.PRVI25_SeismicityRegions.CRUSTAL, mapRegion, branch));
                    regionTRTs.add(null);
                }
                for (int i = 0; i < regions.size(); ++i) {
                    String regName = ((Region)regions.get(i)).getName();
                    System.out.println(regName);
                    IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)regionMFDs.get(i);
                    if (mfd == null) continue;
                    System.out.println("\t" + mfd.getName());
                    if (!(mfd instanceof UncertainBoundedDiscretizedFunc)) continue;
                    System.out.println("\t" + ((UncertainBoundedDiscretizedFunc)((Object)mfd)).getBoundName());
                }
                return new RegionsOfInterest(regions, regionMFDs, regionTRTs);
            }
        }, RegionsOfInterest.class);
        rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RupSetTectonicRegimes>(){
            final /* synthetic */ PRVI25_CrustalFaultModels this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public RupSetTectonicRegimes call() throws Exception {
                return RupSetTectonicRegimes.constant(rupSet, TectonicRegionType.ACTIVE_SHALLOW);
            }
        }, RupSetTectonicRegimes.class);
    }

    private static UncertainBoundedIncrMagFreqDist getRegionalMFD(PRVI25_RegionLoader.PRVI25_SeismicityRegions seisRegion, Region region, LogicTreeBranch<?> branch) throws IOException {
        double mMax = 9.01;
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(2.55, mMax);
        ArrayList<UncertainBoundedIncrMagFreqDist> mfds = new ArrayList<UncertainBoundedIncrMagFreqDist>();
        ArrayList<Double> weights = new ArrayList<Double>();
        for (PRVI25_SeismicityRateEpoch epoch : PRVI25_SeismicityRateEpoch.values()) {
            double weight = epoch.getNodeWeight(branch);
            if (weight == 0.0) continue;
            UncertainBoundedIncrMagFreqDist mfd = region != null ? PRVI25_CrustalSeismicityRate.loadRateModel(epoch).getRemapped(region, seisRegion, PRVI25_DeclusteringAlgorithms.AVERAGE, PRVI25_SeisSmoothingAlgorithms.AVERAGE, refMFD, mMax) : PRVI25_CrustalSeismicityRate.loadRateModel(epoch).getBounded(refMFD, mMax);
            mfds.add(mfd);
            weights.add(weight);
        }
        return PRVI25_SeismicityRateEpoch.averageUncert(mfds, weights);
    }

    @Override
    public RupSetDeformationModel getDefaultDeformationModel() {
        return PRVI25_CrustalDeformationModels.GEOLOGIC;
    }

    @Override
    public List<? extends FaultSection> buildSubSects(RupSetFaultModel faultModel, List<? extends FaultSection> fullSections) {
        return SubSectionBuilder.buildSubSects(fullSections, 2, 0.5, Double.NaN);
    }
}

