/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalFaultModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalRandomlySampledDeformationModelLevel;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="rates.csv")})
@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_source_locations.csv"), @DoesNotAffect(value="grid_sources.csv")})
public class PRVI25_CrustalRandomlySampledDeformationModels
implements LogicTreeNode.RandomlySampledNode,
RupSetDeformationModel {
    private String name;
    private String shortName;
    private String prefix;
    private double weight;
    private long seed;
    private static final String PATH = "/data/erf/prvi25/def_models/crustal/synth_dm_pdfs";
    private static Map<Integer, DiscretizedFunc> pdfs = null;
    private static Map<Integer, IntegerPDF_FunctionSampler> pdfSamplers = null;
    private static final DecimalFormat pDF = new DecimalFormat("0.00%");

    private PRVI25_CrustalRandomlySampledDeformationModels() {
    }

    PRVI25_CrustalRandomlySampledDeformationModels(int index, long seed, double weight) {
        this.init("Deformation Model Sample " + index, "DMSample" + index, "DMSample" + index, weight, seed);
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.prefix;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    public String toString() {
        return this.shortName;
    }

    @Override
    public void init(String name, String shortName, String prefix, double weight, long seed) {
        this.name = name;
        this.shortName = shortName;
        this.prefix = prefix;
        this.weight = weight;
        this.seed = seed;
    }

    @Override
    public boolean isApplicableTo(RupSetFaultModel faultModel) {
        return faultModel instanceof PRVI25_CrustalFaultModels;
    }

    @Override
    public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) throws IOException {
        return this.buildDefModel(subSects, fullSects);
    }

    private List<? extends FaultSection> buildDefModel(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) throws IOException {
        this.applySlipRates(subSects, fullSects);
        PRVI25_CrustalDeformationModels.applyStdDevDefaults(subSects);
        PRVI25_CrustalDeformationModels.applyCreepDefaults(subSects);
        return subSects;
    }

    private Map<Integer, Double> drawSectSlipRates(List<? extends FaultSection> fullSects) throws IOException {
        PRVI25_CrustalRandomlySampledDeformationModels.checkLoadPDFs(fullSects);
        Random rand = new Random(this.seed);
        HashMap<Integer, Double> randSlips = new HashMap<Integer, Double>(fullSects.size());
        for (FaultSection faultSection : fullSects) {
            DiscretizedFunc pdf = pdfs.get(faultSection.getSectionId());
            IntegerPDF_FunctionSampler sampler = pdfSamplers.get(faultSection.getSectionId());
            int index = sampler.getRandomInt(rand);
            double slip = pdf.getX(index);
            randSlips.put(faultSection.getSectionId(), slip);
        }
        return randSlips;
    }

    private void applySlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) throws IOException {
        Map<Integer, Double> randSlips = this.drawSectSlipRates(fullSects);
        for (FaultSection faultSection : subSects) {
            double slip = randSlips.get(faultSection.getParentSectionId());
            faultSection.setAveSlipRate(slip);
        }
    }

    public static void applyDistAvgSlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects) throws IOException {
        PRVI25_CrustalRandomlySampledDeformationModels.checkLoadPDFs(fullSects);
        HashMap<Integer, Double> avgSlips = new HashMap<Integer, Double>(fullSects.size());
        for (FaultSection faultSection : fullSects) {
            DiscretizedFunc pdf = pdfs.get(faultSection.getSectionId());
            Preconditions.checkState(((float)pdf.calcSumOfY_Vals() == 1.0f ? 1 : 0) != 0);
            double slip = 0.0;
            for (Point2D pt : pdf) {
                slip += pt.getX() * pt.getY();
            }
            avgSlips.put(faultSection.getSectionId(), slip);
        }
        for (FaultSection faultSection : subSects) {
            double slip = (Double)avgSlips.get(faultSection.getParentSectionId());
            faultSection.setAveSlipRate(slip);
        }
    }

    private static synchronized void checkLoadPDFs(List<? extends FaultSection> fullSects) throws IOException {
        if (pdfs == null) {
            pdfs = new HashMap<Integer, DiscretizedFunc>(fullSects.size());
            pdfSamplers = new HashMap<Integer, IntegerPDF_FunctionSampler>(fullSects.size());
            for (FaultSection faultSection : fullSects) {
                String fName = faultSection.getSectionName() + ".csv";
                String path = "/data/erf/prvi25/def_models/crustal/synth_dm_pdfs/" + fName;
                InputStream is = PRVI25_CrustalRandomlySampledDeformationModels.class.getResourceAsStream(path);
                Preconditions.checkNotNull((Object)is, (String)"%s was not found", (Object)path);
                CSVFile<String> csv = CSVFile.readStream(is, true);
                ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                for (int row = 0; row < csv.getNumRows(); ++row) {
                    func.set(csv.getDouble(row, 0), csv.getDouble(row, 1));
                }
                int negCount = 0;
                double negWt = 0.0;
                boolean hasZero = false;
                for (int i = 0; i < func.size(); ++i) {
                    double x = func.getX(i);
                    hasZero = x == 0.0;
                    double y = func.getY(i);
                    Preconditions.checkState((y >= 0.0 ? 1 : 0) != 0);
                    if (!(x < 0.0)) continue;
                    ++negCount;
                    negWt += y;
                }
                if (negCount > 0) {
                    System.err.println("WARNING: " + faultSection.getName() + " pdf has " + negCount + " negative slip rate bin(s) with wt=" + (float)negWt);
                    ArbitrarilyDiscretizedFunc modFunc = new ArbitrarilyDiscretizedFunc();
                    if (!hasZero) {
                        modFunc.set(0.0, func.getInterpolatedY(0.0));
                    }
                    for (int i = negCount; i < func.size(); ++i) {
                        modFunc.set(func.get(i));
                    }
                    func = modFunc;
                }
                func.scale(1.0 / func.calcSumOfY_Vals());
                pdfs.put(faultSection.getSectionId(), func);
                double[] yVals = new double[func.size()];
                for (int i = 0; i < func.size(); ++i) {
                    yVals[i] = func.getY(i);
                }
                pdfSamplers.put(faultSection.getSectionId(), new IntegerPDF_FunctionSampler(yVals));
            }
        } else {
            Preconditions.checkState((pdfs.size() == fullSects.size() ? 1 : 0) != 0);
        }
    }

    public static void main(String[] args) throws IOException {
        int numSamples = 750;
        long randSeed = 12345678L;
        Random rand = new Random(randSeed);
        PRVI25_CrustalRandomlySampledDeformationModelLevel level = new PRVI25_CrustalRandomlySampledDeformationModelLevel(numSamples, rand);
        List nodes = level.getNodes();
        PRVI25_CrustalFaultModels fm = PRVI25_CrustalFaultModels.PRVI_CRUSTAL_FM_V1p1;
        List<? extends FaultSection> fullSects = fm.getFaultSections(true);
        List<? extends FaultSection> fullSectsUnprojected = fm.getFaultSections(false);
        ArrayList<DataUtils.MinMaxAveTracker> parentTracks = new ArrayList<DataUtils.MinMaxAveTracker>();
        for (int i = 0; i < fullSects.size(); ++i) {
            parentTracks.add(new DataUtils.MinMaxAveTracker());
        }
        for (PRVI25_CrustalRandomlySampledDeformationModels node : nodes) {
            Map<Integer, Double> slipSample = node.drawSectSlipRates(fullSects);
            for (int i = 0; i < fullSects.size(); ++i) {
                int id = fullSects.get(i).getSectionId();
                double slip = slipSample.get(id);
                ((DataUtils.MinMaxAveTracker)parentTracks.get(i)).addValue(slip);
            }
        }
        DecimalFormat slipDF = new DecimalFormat("0.000");
        for (int i = 0; i < fullSects.size(); ++i) {
            FaultSection sect = fullSects.get(i);
            double origMean = sect.getOrigAveSlipRate();
            double origUpper = ((GeoJSONFaultSection)sect).getProperties().getDouble("HighRate", Double.NaN);
            double origLower = ((GeoJSONFaultSection)sect).getProperties().getDouble("LowRate", Double.NaN);
            DiscretizedFunc pdf = pdfs.get(sect.getSectionId());
            DataUtils.MinMaxAveTracker track = (DataUtils.MinMaxAveTracker)parentTracks.get(i);
            double sampleMean = track.getAverage();
            double pdfMean = 0.0;
            double pdfMin = Double.POSITIVE_INFINITY;
            double pdfMax = Double.NEGATIVE_INFINITY;
            for (Point2D pt : pdf) {
                if (!(pt.getY() > 0.0)) continue;
                pdfMean += pt.getX() * pt.getY();
                pdfMin = Math.min(pdfMin, pt.getX());
                pdfMax = Math.max(pdfMax, pt.getX());
            }
            FaultSection unprojectedSect = fullSectsUnprojected.get(i);
            double unprojectedMean = unprojectedSect.getOrigAveSlipRate();
            double unprojectedUpper = ((GeoJSONFaultSection)unprojectedSect).getProperties().getDouble("HighRate", Double.NaN);
            double unprojectedLower = ((GeoJSONFaultSection)unprojectedSect).getProperties().getDouble("LowRate", Double.NaN);
            boolean projected = (float)unprojectedMean != (float)origMean;
            System.out.println(sect.getSectionId() + ". " + sect.getSectionName() + "\t(dip=" + (float)sect.getAveDip() + ", rake=" + (float)sect.getAveRake() + ")");
            if ((float)unprojectedMean != (float)origMean) {
                System.out.println("\tOriginal mean and range:\t" + slipDF.format(unprojectedMean) + "\t[" + slipDF.format(unprojectedLower) + "," + slipDF.format(unprojectedUpper) + "]");
            }
            System.out.println("\t" + (projected ? "Projected" : "Original") + " mean and range:\t" + slipDF.format(origMean) + "\t[" + slipDF.format(origLower) + "," + slipDF.format(origUpper) + "]\tmeanFract=" + slipDF.format((origMean - origLower) / (origUpper - origLower)));
            System.out.println("\tGeo DM PDF mean and range:\t" + slipDF.format(pdfMean) + "\t[" + slipDF.format(pdfMin) + "," + slipDF.format(pdfMax) + "]");
            System.out.println("\tCompared to " + (projected ? "projected" : "original") + ":\t" + PRVI25_CrustalRandomlySampledDeformationModels.compPercentStr(sampleMean, origMean) + "\t[" + PRVI25_CrustalRandomlySampledDeformationModels.compPercentStr(pdfMin, origLower) + "," + PRVI25_CrustalRandomlySampledDeformationModels.compPercentStr(pdfMax, origUpper) + "]");
        }
    }

    private static String compPercentStr(double testVal, double refVal) {
        String plus = testVal > refVal ? "+" : "";
        return plus + pDF.format((testVal - refVal) / refVal);
    }
}

