/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.opensha.commons.logicTree.AffectsNone;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.nshmp.GroundMotionLogicTreeFilter;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_GMM_Wrapper;
import org.opensha.sha.imr.logicTree.ScalarIMR_ParamsLogicTreeNode;
import org.opensha.sha.util.TectonicRegionType;

@AffectsNone
public enum PRVI25_GMM_GenericEpistemicModel implements ScalarIMR_ParamsLogicTreeNode
{
    EPI_LOW("Low", "Low", "epi-lo", 0.185),
    EPI_OFF("Off", "Off", "epi-off", 0.63),
    EPI_HIGH("High", "High", "epi-hi", 0.185);

    final String name;
    final String shortName;
    final String matchStr;
    final double weight;

    private PRVI25_GMM_GenericEpistemicModel(String name, String shortName, String matchStr, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.matchStr = matchStr;
        this.weight = weight;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isApplicableTo(ScalarIMR imr) {
        return imr instanceof NSHMP_GMM_Wrapper;
    }

    @Override
    public void setParams(ScalarIMR imr) {
        PRVI25_GMM_GenericEpistemicModel.setParams(imr, this.matchStr, null);
    }

    public static void setParams(ScalarIMR imr, String matchStr, TectonicRegionType trt) {
        GroundMotionLogicTreeFilter.StringMatching filter;
        NSHMP_GMM_Wrapper gmm = (NSHMP_GMM_Wrapper)imr;
        if (trt != null && gmm.getTRT() != trt) {
            return;
        }
        GroundMotionLogicTreeFilter upstream = gmm.getGroundMotionTreeFilter();
        if (upstream == null) {
            filter = new GroundMotionLogicTreeFilter.StringMatching(matchStr);
        } else {
            Preconditions.checkState((boolean)(upstream instanceof GroundMotionLogicTreeFilter.StringMatching), (Object)"Can only combine with other string matching filters");
            String[] required = ((GroundMotionLogicTreeFilter.StringMatching)upstream).getRequired();
            required = Arrays.copyOf(required, required.length + 1);
            required[required.length - 1] = matchStr;
            filter = new GroundMotionLogicTreeFilter.StringMatching(required);
        }
        gmm.setGroundMotionTreeFilter(filter);
    }
}

