/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.SeismicityRateFileLoader;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.gridded.SeismicityRateModel;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalSeismicityRate;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SeismicityRateEpoch;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.util.PRVI25_RegionLoader;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv"), @DoesNotAffect(value="rates.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_mech_weights.csv"), @DoesNotAffect(value="grid_source_locations.csv")})
@Affects.Affected(value={@Affects(value="grid_sub_seis_mfds.csv"), @Affects(value="grid_unassociated_mfds.csv"), @Affects(value="grid_sources.csv")})
public enum PRVI25_SubductionCaribbeanSeismicityRate implements LogicTreeNode
{
    LOW("Lower Seismicity Bound (p2.5)", "Low", 0.13){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax, double magCorner, boolean slab) throws IOException {
            return 1.loadRateModel(epoch, TYPE, slab).buildLower(refMFD, mMax, magCorner);
        }
    }
    ,
    PREFFERRED("Preffered Seismicity Rate", "Preferred", 0.74){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax, double magCorner, boolean slab) throws IOException {
            return 2.loadRateModel(epoch, TYPE, slab).buildPreferred(refMFD, mMax, magCorner);
        }
    }
    ,
    HIGH("Upper Seismicity Bound (p97.5)", "High", 0.13){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax, double magCorner, boolean slab) throws IOException {
            return 3.loadRateModel(epoch, TYPE, slab).buildUpper(refMFD, mMax, magCorner);
        }
    }
    ,
    AVERAGE("Average Seismicity Rate", "Average", 0.0){

        @Override
        public IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch epoch, EvenlyDiscretizedFunc refMFD, double mMax, double magCorner, boolean slab) throws IOException {
            AbstractDiscretizedFunc ret = null;
            double weightSum = 0.0;
            for (PRVI25_SubductionCaribbeanSeismicityRate seis : 4.values()) {
                if (seis == this || seis.weight == 0.0) continue;
                weightSum += seis.weight;
                IncrementalMagFreqDist mfd = seis.build(epoch, refMFD, mMax, magCorner, slab);
                if (ret == null) {
                    ret = new IncrementalMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
                } else {
                    Preconditions.checkState((mfd.size() == ((EvenlyDiscretizedFunc)ret).size() ? 1 : 0) != 0);
                }
                for (int i = 0; i < ((EvenlyDiscretizedFunc)ret).size(); ++i) {
                    ((EvenlyDiscretizedFunc)ret).add(i, mfd.getY(i) * seis.weight);
                }
            }
            if ((float)weightSum != 1.0f) {
                ret.scale(1.0 / weightSum);
            }
            return ret;
        }
    };

    public static String RATE_DATE;
    private static final String RATES_PATH_PREFIX = "/data/erf/prvi25/seismicity/rates/";
    public static SeismicityRateFileLoader.RateType TYPE;
    private static final UncertaintyBoundType BOUND_TYPE;
    private static Table<PRVI25_SeismicityRateEpoch, SeismicityRateFileLoader.RateType, SeismicityRateModel> slabRateModels;
    private static Table<PRVI25_SeismicityRateEpoch, SeismicityRateFileLoader.RateType, SeismicityRateModel> interfaceRateModels;
    private static Map<PRVI25_SeismicityRateEpoch, CSVFile<String>> slabCSVs;
    private static Map<PRVI25_SeismicityRateEpoch, CSVFile<String>> interfaceCSVs;
    private String name;
    private String shortName;
    private double weight;

    public static synchronized void clearCache() {
        slabRateModels = null;
        slabCSVs = null;
        interfaceRateModels = null;
        interfaceCSVs = null;
    }

    public abstract IncrementalMagFreqDist build(PRVI25_SeismicityRateEpoch var1, EvenlyDiscretizedFunc var2, double var3, double var5, boolean var7) throws IOException;

    public static SeismicityRateModel loadRateModel(PRVI25_SeismicityRateEpoch epoch, boolean slab) throws IOException {
        return PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(epoch, TYPE, slab);
    }

    public static List<? extends SeismicityRateFileLoader.RateRecord> loadRates(PRVI25_SeismicityRateEpoch epoch, SeismicityRateFileLoader.RateType type, boolean slab) throws IOException {
        if (epoch == PRVI25_SeismicityRateEpoch.RECENT_SCALED) {
            return PRVI25_CrustalSeismicityRate.getScaledToFull(PRVI25_SubductionCaribbeanSeismicityRate.loadRates(PRVI25_SeismicityRateEpoch.RECENT, type, slab));
        }
        CSVFile<String> csv = PRVI25_SubductionCaribbeanSeismicityRate.loadCSV(epoch, slab);
        return SeismicityRateFileLoader.loadRecords(csv, type);
    }

    public static synchronized SeismicityRateModel loadRateModel(PRVI25_SeismicityRateEpoch epoch, SeismicityRateFileLoader.RateType type, boolean slab) throws IOException {
        SeismicityRateModel rateModel;
        if (slab) {
            if (slabRateModels == null) {
                slabRateModels = HashBasedTable.create();
            }
            rateModel = (SeismicityRateModel)slabRateModels.get((Object)epoch, (Object)type);
        } else {
            if (interfaceRateModels == null) {
                interfaceRateModels = HashBasedTable.create();
            }
            rateModel = (SeismicityRateModel)interfaceRateModels.get((Object)epoch, (Object)type);
        }
        if (rateModel != null) {
            return rateModel;
        }
        if (epoch == PRVI25_SeismicityRateEpoch.RECENT_SCALED) {
            rateModel = PRVI25_CrustalSeismicityRate.getScaledToFull(PRVI25_SubductionCaribbeanSeismicityRate.loadRateModel(PRVI25_SeismicityRateEpoch.RECENT, type, slab), type);
        } else {
            CSVFile<String> csv = PRVI25_SubductionCaribbeanSeismicityRate.loadCSV(epoch, slab);
            rateModel = new SeismicityRateModel(csv, type, BOUND_TYPE);
        }
        if (slab) {
            slabRateModels.put((Object)epoch, (Object)type, (Object)rateModel);
        } else {
            interfaceRateModels.put((Object)epoch, (Object)type, (Object)rateModel);
        }
        return rateModel;
    }

    private static synchronized CSVFile<String> loadCSV(PRVI25_SeismicityRateEpoch epoch, boolean slab) throws IOException {
        CSVFile<String> csv;
        if (slab) {
            if (slabCSVs == null) {
                slabCSVs = new HashMap<PRVI25_SeismicityRateEpoch, CSVFile<String>>();
            }
            csv = slabCSVs.get(epoch);
        } else {
            if (interfaceCSVs == null) {
                interfaceCSVs = new HashMap<PRVI25_SeismicityRateEpoch, CSVFile<String>>();
            }
            csv = interfaceCSVs.get(epoch);
        }
        if (csv != null) {
            return csv;
        }
        String resourceName = RATES_PATH_PREFIX + RATE_DATE + "/" + epoch.getRateSubDirName() + "/";
        resourceName = slab ? resourceName + PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTRASLAB.name() : resourceName + PRVI25_RegionLoader.PRVI25_SeismicityRegions.CAR_INTERFACE.name();
        resourceName = resourceName + ".csv";
        InputStream stream = PRVI25_SubductionCaribbeanSeismicityRate.class.getResourceAsStream(resourceName);
        Preconditions.checkNotNull((Object)stream, (String)"Error loading stream for '%s'", (Object)resourceName);
        csv = CSVFile.readStream(stream, false);
        stream.close();
        if (slab) {
            slabCSVs.put(epoch, csv);
        } else {
            interfaceCSVs.put(epoch, csv);
        }
        return csv;
    }

    private PRVI25_SubductionCaribbeanSeismicityRate(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.getShortName();
    }

    public static void main(String[] args) throws IOException {
        for (boolean slab : new boolean[]{false, true}) {
            if (slab) {
                System.out.println("SLAB");
            } else {
                System.out.println("INTERFACE");
            }
            double mMax = 7.95;
            double magCorner = Double.NaN;
            IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(5.01, mMax);
            for (PRVI25_SeismicityRateEpoch epoch : PRVI25_SeismicityRateEpoch.values()) {
                float x;
                System.out.println("Epoch: " + String.valueOf(epoch));
                IncrementalMagFreqDist pref = PREFFERRED.build(epoch, refMFD, mMax, magCorner, true);
                IncrementalMagFreqDist low = LOW.build(epoch, refMFD, mMax, magCorner, true);
                IncrementalMagFreqDist high = HIGH.build(epoch, refMFD, mMax, magCorner, true);
                for (int i = 0; i < refMFD.size() && !((x = (float)refMFD.getX(i)) > (float)refMFD.getClosestXIndex(mMax)); ++i) {
                    if (x != 5.05f && x != 6.05f && x != 7.05f) continue;
                    System.out.println(x + "\t" + (float)pref.getY(i) + "\t[" + (float)low.getY(i) + "," + (float)high.getY(i) + "]");
                }
                System.out.println();
            }
        }
    }

    static {
        RATE_DATE = PRVI25_CrustalSeismicityRate.RATE_DATE;
        TYPE = SeismicityRateFileLoader.RateType.M1_TO_MMAX;
        BOUND_TYPE = UncertaintyBoundType.CONF_95;
    }
}

