/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.MinisectionMappings;
import org.opensha.sha.earthquake.faultSysSolution.util.minisections.MinisectionSlipRecord;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_CrustalDeformationModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionCouplingModels;
import org.opensha.sha.earthquake.rupForecastImpl.prvi25.logicTree.PRVI25_SubductionFaultModels;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

@Affects.Affected(value={@Affects(value="fault_sections.geojson"), @Affects(value="properties.csv"), @Affects(value="rates.csv")})
@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="grid_region.geojson"), @DoesNotAffect(value="grid_source_locations.csv"), @DoesNotAffect(value="grid_sources.csv")})
public enum PRVI25_SubductionDeformationModels implements RupSetDeformationModel
{
    FULL("Full Partitioning", "Full", 0.5),
    PARTIAL("Trench-Normal Partitioning", "Trench-Normal", 0.5);

    private static final String VERSION = "v5";
    private static final String PREFIX = "/data/erf/prvi25/def_models/subduction/v5/";
    private static final double DEFAULT_FRACT_SLIP_STD_DEV = 0.1;
    public static final double STD_DEV_FLOOR = 1.0E-4;
    public static double HARDCODED_FRACTIONAL_STD_DEV;
    public static double HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND;
    public static double ASEIS;
    private String name;
    private String shortName;
    private double weight;
    private Map<String, Map<Integer, List<MinisectionSlipRecord>>> dmMinisMap;
    private static final DecimalFormat pDF;

    private PRVI25_SubductionDeformationModels(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    @Override
    public double getNodeWeight(LogicTreeBranch<?> fullBranch) {
        return this.weight;
    }

    @Override
    public String getFilePrefix() {
        return this.name();
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isApplicableTo(RupSetFaultModel faultModel) {
        return faultModel instanceof PRVI25_SubductionFaultModels;
    }

    @Override
    public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> fullSects, List<? extends FaultSection> subSects) throws IOException {
        String minisectsFileName = "PRVI_sub_v5_" + faultModel.getFilePrefix() + "_" + this.getFilePrefix();
        PRVI25_SubductionCouplingModels coupling = branch == null || !branch.hasValue(PRVI25_SubductionCouplingModels.class) ? PRVI25_SubductionCouplingModels.PREFERRED : branch.getValue(PRVI25_SubductionCouplingModels.class);
        minisectsFileName = minisectsFileName + "_" + coupling.getFilePrefix() + "_rate_minisections.txt";
        Preconditions.checkNotNull((Object)minisectsFileName, (String)"No minisection file mapping for fm=%s", (Object)faultModel);
        return this.buildDefModel(subSects, fullSects, minisectsFileName);
    }

    private List<? extends FaultSection> buildDefModel(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects, String minisectsFileName) throws IOException {
        this.applySlipRates(subSects, fullSects, minisectsFileName);
        PRVI25_SubductionDeformationModels.applyStdDevDefaults(subSects);
        this.applyCreepDefaults(subSects);
        return subSects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applySlipRates(List<? extends FaultSection> subSects, List<? extends FaultSection> fullSects, String minisectsFileName) throws IOException {
        Map<Integer, List<MinisectionSlipRecord>> dmMinis;
        PRVI25_SubductionDeformationModels pRVI25_SubductionDeformationModels = this;
        synchronized (pRVI25_SubductionDeformationModels) {
            if (this.dmMinisMap == null) {
                this.dmMinisMap = new HashMap<String, Map<Integer, List<MinisectionSlipRecord>>>();
            }
            if ((dmMinis = this.dmMinisMap.get(minisectsFileName)) == null) {
                InputStream is = PRVI25_CrustalDeformationModels.class.getResourceAsStream(PREFIX + minisectsFileName);
                dmMinis = MinisectionSlipRecord.readMinisectionsFile(is);
                is.close();
                this.dmMinisMap.put(minisectsFileName, dmMinis);
            }
        }
        MinisectionMappings mappings = new MinisectionMappings(fullSects, subSects);
        mappings.mapDefModelMinisToSubSects(dmMinis);
    }

    public static boolean isHardcodedFractionalStdDev() {
        return HARDCODED_FRACTIONAL_STD_DEV > 0.0;
    }

    public static void applyStdDevDefaults(List<? extends FaultSection> subSects) {
        if (PRVI25_SubductionDeformationModels.isHardcodedFractionalStdDev()) {
            System.out.println("Overriding deformation model slip rates std devs and using hardcoded fractional value: " + HARDCODED_FRACTIONAL_STD_DEV);
            Preconditions.checkState((!(HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND > 0.0) ? 1 : 0) != 0, (Object)"Can't supply both hardcoded fractional std dev, and a fractional upper bound");
        }
        int numZeroSlips = 0;
        int numFractDefault = 0;
        int numFloor = 0;
        for (FaultSection faultSection : subSects) {
            double stdDev;
            double origStdDev;
            double slipRate = faultSection.getOrigAveSlipRate();
            Preconditions.checkState((Double.isFinite(slipRate) && slipRate >= 0.0 ? 1 : 0) != 0, (String)"Bad slip rate for %s. %s: %s", (Object)faultSection.getSectionId(), (Object)faultSection.getSectionName(), (Object)slipRate);
            if ((float)slipRate == 0.0f) {
                ++numZeroSlips;
            }
            if (faultSection instanceof GeoJSONFaultSection && slipRate > 0.0 && Double.isFinite(origStdDev = faultSection.getOrigSlipRateStdDev())) {
                ((GeoJSONFaultSection)faultSection).setProperty("OrigFractStdDev", origStdDev / slipRate);
            }
            if (PRVI25_SubductionDeformationModels.isHardcodedFractionalStdDev()) {
                stdDev = HARDCODED_FRACTIONAL_STD_DEV * slipRate;
            } else {
                stdDev = faultSection.getOrigSlipRateStdDev();
                if (!Double.isFinite(stdDev)) {
                    stdDev = 0.0;
                }
                if (HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND > 0.0) {
                    double floorSD = HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND * slipRate;
                    if ((float)stdDev <= 0.0f || floorSD < stdDev) {
                        stdDev = floorSD;
                    }
                }
                if ((float)stdDev <= 0.0f && (float)stdDev <= 0.0f) {
                    stdDev = slipRate * 0.1;
                    ++numFractDefault;
                }
            }
            if ((float)stdDev < 1.0E-4f) {
                stdDev = 1.0E-4;
                ++numFloor;
            }
            faultSection.setSlipRateStdDev(stdDev);
        }
        if (numZeroSlips > 0) {
            System.err.println("WARNING: " + numZeroSlips + "/" + subSects.size() + " (" + pDF.format((double)numZeroSlips / (double)subSects.size()) + ") subsection slip rates are 0");
        }
        if (numFractDefault > 0) {
            System.err.println("WARNING: Set " + numFractDefault + "/" + subSects.size() + " (" + pDF.format((double)numFractDefault / (double)subSects.size()) + ") subsection slip rate standard deviations to the default: 0.1 x slipRate");
        }
        if (numFloor > 0) {
            System.err.println("WARNING: Set " + numFloor + "/" + subSects.size() + " (" + pDF.format((double)numFloor / (double)subSects.size()) + ") subsection slip rate standard deviations to the floor value of 1.0E-4 (mm/yr)");
        }
    }

    private void applyCreepDefaults(List<? extends FaultSection> subSects) {
        double aseis = ASEIS;
        double coupling = 1.0;
        for (FaultSection faultSection : subSects) {
            faultSection.setAseismicSlipFactor(aseis);
            faultSection.setCouplingCoeff(coupling);
        }
    }

    static {
        HARDCODED_FRACTIONAL_STD_DEV = 0.0;
        HARDCODED_FRACTIONAL_STD_DEV_UPPER_BOUND = 0.1;
        ASEIS = 0.0;
        pDF = new DecimalFormat("0.00%");
    }
}

