/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.step;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class STEP_AlaskanPipeForecast
extends AbstractERF
implements ParameterChangeListener {
    private static String C = new String("STEP_AlaskanPipeForecast");
    private boolean D = false;
    public static String NAME = new String("STEP Alaskan Pipeline ERF");
    private static final String INPUT_FILE_NAME = "/data/erf/step/PipelineGrid.txt";
    private ArrayList inputFileLines;
    private static final double RAKE = 0.0;
    private static final double DIP = 90.0;
    private static final double MAG_LOWER = 4.0;
    private static final double MAG_UPPER = 8.0;
    private static final int NUM_MAG = 41;
    private static final double DEPTH = 0.0;
    ArrayList sources;

    public STEP_AlaskanPipeForecast() {
        try {
            this.inputFileLines = FileUtils.loadJarFile(INPUT_FILE_NAME);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.toString());
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        StringTokenizer st = new StringTokenizer(this.inputFileLines.get(0).toString());
        int year = Integer.valueOf(st.nextToken());
        int month = Integer.valueOf(st.nextToken());
        int day = Integer.valueOf(st.nextToken());
        int hour = Integer.valueOf(st.nextToken());
        int minute = Integer.valueOf(st.nextToken());
        int second = Integer.valueOf(st.nextToken());
        if (this.D) {
            System.out.println("year=" + year + "; month=" + month + "; day=" + day + "; hour=" + hour + "; minute=" + minute + "; second=" + second);
        }
        st = new StringTokenizer(this.inputFileLines.get(1).toString());
        double duration = Double.valueOf(st.nextToken());
        if (this.D) {
            System.out.println("duration=" + duration);
        }
        this.timeSpan = new TimeSpan("Seconds", "Days");
        this.timeSpan.setStartTime(year, month, day, hour, minute, second);
        this.timeSpan.setDuration(duration);
        this.timeSpan.setStartTimeConstraint("Start Year", year, year);
        this.timeSpan.setStartTimeConstraint("Start Month", month, month);
        this.timeSpan.setStartTimeConstraint("Start Day", day, day);
        this.timeSpan.setStartTimeConstraint("Start Hour", hour, hour);
        this.timeSpan.setStartTimeConstraint("Start Minute", minute, minute);
        this.timeSpan.setStartTimeConstraint("Start Second", second, second);
        this.timeSpan.setDuractionConstraint(duration, duration);
        if (this.D) {
            System.out.println("Start-Time Calendar toString: \n" + this.timeSpan.getStartTimeCalendar().toString());
        }
        if (this.D) {
            System.out.println("Number of lines in file = " + this.inputFileLines.size());
        }
        this.makeSources();
        this.inputFileLines = null;
    }

    private void makeSources() {
        String S = C + ": makeSources(): ";
        if (this.D) {
            System.out.println(S + "Starting");
        }
        this.sources = new ArrayList();
        double duration = this.timeSpan.getDuration();
        ListIterator it = this.inputFileLines.listIterator();
        StringTokenizer st = new StringTokenizer(it.next().toString());
        st = new StringTokenizer(it.next().toString());
        while (it.hasNext()) {
            st = new StringTokenizer(it.next().toString());
            double lon = Double.parseDouble(st.nextToken());
            double lat = Double.parseDouble(st.nextToken());
            IncrementalMagFreqDist magFreqDist = new IncrementalMagFreqDist(4.0, 8.0, 41);
            for (int i = 0; i < 41; ++i) {
                double rate = Double.parseDouble(st.nextToken());
                if (this.D) {
                    System.out.println("rate(mag=" + magFreqDist.getX(i) + ")=" + rate);
                }
                if (i < 20) {
                    magFreqDist.set(i, 0.0);
                    continue;
                }
                double rupLen = Math.pow(10.0, -3.55 + 0.74 * magFreqDist.getX(i));
                magFreqDist.set(i, rate *= rupLen / 10.6);
            }
            PointSource.PoissonPointSource ptSource = ((PointSource.PoissonBuilder)PointSource.poissonBuilder(new Location(lat, lon, 0.0)).truePointSources()).duration(duration).forMFDAndFocalMech(magFreqDist, new FocalMechanism(Double.NaN, 90.0, 0.0)).build();
            this.sources.add(ptSource);
            if (!this.D) continue;
            System.out.println(C + "makeSources(): numRups=" + ptSource.getNumRuptures() + " for source " + this.sources.size());
        }
    }

    @Override
    public void setTimeSpan(TimeSpan timeSpan) {
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return (ProbEqkSource)this.sources.get(iSource);
    }

    @Override
    public int getNumSources() {
        return this.sources.size();
    }

    public Iterator getSourcesIterator() {
        Iterator i = this.getSourceList().iterator();
        return i;
    }

    public ArrayList getSourceList() {
        return this.sources;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void updateForecast() {
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.parameterChangeFlag = true;
    }

    public static void main(String[] args) {
        double rate;
        ProbEqkRupture rup;
        STEP_AlaskanPipeForecast forecast = new STEP_AlaskanPipeForecast();
        System.out.println("startTimeFromCal:\n " + forecast.getTimeSpan().getStartTimeCalendar().toString());
        System.out.println("Duration: " + forecast.getTimeSpan().getDuration() + "  " + forecast.getTimeSpan().getDurationUnits());
        System.out.println("getNumSources(): " + forecast.getNumSources());
        int index = 0;
        PointSource.PoissonPointSource qkSrc = (PointSource.PoissonPointSource)forecast.getSource(index);
        System.out.println("getNumRuptures(): " + qkSrc.getNumRuptures());
        double duration = qkSrc.getDuration();
        for (int i = 0; i < qkSrc.getNumRuptures(); ++i) {
            rup = qkSrc.getRupture(i);
            Location loc = rup.getRuptureSurface().getFirstLocOnUpperEdge();
            if (i == 0) {
                System.out.println("First Source:\n" + loc.getLongitude() + "  " + loc.getLatitude());
            }
            rate = -Math.log(1.0 - rup.getProbability()) / duration;
            System.out.println((float)rup.getMag() + "  " + rate);
        }
        index = forecast.getNumSources() - 1;
        qkSrc = (PointSource.PoissonPointSource)forecast.getSource(index);
        System.out.println("getNumRuptures(): " + qkSrc.getNumRuptures());
        duration = qkSrc.getDuration();
        double cumRate = 0.0;
        for (int i = qkSrc.getNumRuptures() - 1; i >= 0; --i) {
            rup = qkSrc.getRupture(i);
            Location loc = rup.getRuptureSurface().getFirstLocOnUpperEdge();
            if (i == 0) {
                System.out.println("Last Source:\n" + loc.getLongitude() + "  " + loc.getLatitude());
            }
            rate = -Math.log(1.0 - rup.getProbability());
            System.out.println((float)rup.getMag() + "  " + rate + "  " + (cumRate += rate));
        }
    }
}

