/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.util;

import com.google.common.base.Preconditions;
import org.opensha.commons.data.WeightedList;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.util.GridCellSupersamplingSettings;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrection;
import org.opensha.sha.faultSurface.utils.PointSourceDistanceCorrections;

public class GriddedSeismicitySettings {
    public static GriddedSeismicitySettings DEFAULT = new GriddedSeismicitySettings(5.0, BackgroundRupType.POINT, 6.0, PointSourceDistanceCorrections.DEFAULT, null);
    public final double minimumMagnitude;
    public final BackgroundRupType surfaceType;
    public final double pointSourceMagnitudeCutoff;
    public final WeightedList<PointSourceDistanceCorrection> distanceCorrections;
    public final GridCellSupersamplingSettings supersamplingSettings;

    private GriddedSeismicitySettings(double minimumMagnitude, BackgroundRupType surfaceType, double pointSourceMagnitudeCutoff, PointSourceDistanceCorrections distanceCorrs, GridCellSupersamplingSettings supersamplingSettings) {
        this(minimumMagnitude, surfaceType, pointSourceMagnitudeCutoff, (WeightedList<PointSourceDistanceCorrection>)(distanceCorrs == null ? null : distanceCorrs.get()), supersamplingSettings);
    }

    private GriddedSeismicitySettings(double minimumMagnitude, BackgroundRupType surfaceType, double pointSourceMagnitudeCutoff, WeightedList<PointSourceDistanceCorrection> distanceCorrs, GridCellSupersamplingSettings supersamplingSettings) {
        Preconditions.checkState((surfaceType != null ? 1 : 0) != 0, (Object)"Surface type cannot be null");
        this.minimumMagnitude = minimumMagnitude;
        this.surfaceType = surfaceType;
        this.pointSourceMagnitudeCutoff = pointSourceMagnitudeCutoff;
        this.distanceCorrections = distanceCorrs;
        this.supersamplingSettings = supersamplingSettings;
    }

    public GriddedSeismicitySettings forMinimumMagnitude(double minimumMagnitude) {
        if (this.minimumMagnitude == minimumMagnitude) {
            return this;
        }
        return new GriddedSeismicitySettings(minimumMagnitude, this.surfaceType, this.pointSourceMagnitudeCutoff, this.distanceCorrections, this.supersamplingSettings);
    }

    public GriddedSeismicitySettings forSurfaceType(BackgroundRupType surfaceType) {
        if (this.surfaceType == surfaceType) {
            return this;
        }
        return new GriddedSeismicitySettings(this.minimumMagnitude, surfaceType, this.pointSourceMagnitudeCutoff, this.distanceCorrections, this.supersamplingSettings);
    }

    public GriddedSeismicitySettings forPointSourceMagCutoff(double pointSourceMagnitudeCutoff) {
        if (this.pointSourceMagnitudeCutoff == pointSourceMagnitudeCutoff) {
            return this;
        }
        return new GriddedSeismicitySettings(this.minimumMagnitude, this.surfaceType, pointSourceMagnitudeCutoff, this.distanceCorrections, this.supersamplingSettings);
    }

    public GriddedSeismicitySettings forDistanceCorrections(PointSourceDistanceCorrections distanceCorrs) {
        if (distanceCorrs != null && this.distanceCorrections == distanceCorrs.get()) {
            return this;
        }
        return new GriddedSeismicitySettings(this.minimumMagnitude, this.surfaceType, this.pointSourceMagnitudeCutoff, distanceCorrs, this.supersamplingSettings);
    }

    public GriddedSeismicitySettings forDistanceCorrections(WeightedList<PointSourceDistanceCorrection> distanceCorrections) {
        if (this.distanceCorrections == distanceCorrections) {
            return this;
        }
        return new GriddedSeismicitySettings(this.minimumMagnitude, this.surfaceType, this.pointSourceMagnitudeCutoff, distanceCorrections, this.supersamplingSettings);
    }

    public GriddedSeismicitySettings forSupersamplingSettings(GridCellSupersamplingSettings supersamplingSettings) {
        if (this.supersamplingSettings == supersamplingSettings) {
            return this;
        }
        return new GriddedSeismicitySettings(this.minimumMagnitude, this.surfaceType, this.pointSourceMagnitudeCutoff, this.distanceCorrections, supersamplingSettings);
    }

    public String toString() {
        return "GriddedSeismicitySettings [minMag=" + this.minimumMagnitude + ", type=" + String.valueOf((Object)this.surfaceType) + ", ptSrcMagCut=" + this.pointSourceMagnitudeCutoff + ", distCorrs=" + String.valueOf(this.distanceCorrections) + ", superssample=" + String.valueOf(this.supersamplingSettings) + "]";
    }
}

