/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.commons.data.Container2DImpl;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;

public abstract class AbstractEvenlyGriddedSurface
extends Container2DImpl<Location>
implements EvenlyGriddedSurface,
CacheEnabledSurface,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String C = "EvenlyGriddedSurface";
    protected static final boolean D = false;
    protected double gridSpacingAlong;
    protected double gridSpacingDown;
    protected Boolean sameGridSpacing;
    private SurfaceDistanceCache cache = SurfaceCachingPolicy.build(this);
    private LocationList surfLocs;

    public AbstractEvenlyGriddedSurface() {
    }

    public AbstractEvenlyGriddedSurface(int numRows, int numCols, double gridSpacing) {
        super(numRows, numCols);
        this.gridSpacingAlong = gridSpacing;
        this.gridSpacingDown = gridSpacing;
        this.sameGridSpacing = true;
    }

    public AbstractEvenlyGriddedSurface(int numRows, int numCols, double gridSpacingAlong, double gridSpacingDown) {
        super(numRows, numCols);
        this.gridSpacingAlong = gridSpacingAlong;
        this.gridSpacingDown = gridSpacingDown;
        this.sameGridSpacing = gridSpacingAlong == gridSpacingDown ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        if (this.surfLocs == null) {
            AbstractEvenlyGriddedSurface abstractEvenlyGriddedSurface = this;
            synchronized (abstractEvenlyGriddedSurface) {
                if (this.surfLocs == null) {
                    long size = this.size();
                    Preconditions.checkState((size < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Can't create a list with mroe that Integer.MAX_VALUE items");
                    LocationList locList = new LocationList((int)size);
                    ListIterator it = this.listIterator();
                    while (it.hasNext()) {
                        locList.add((Location)it.next());
                    }
                    this.surfLocs = locList.unmodifiableList();
                }
            }
        }
        return this.surfLocs;
    }

    @Override
    public double getGridSpacingAlongStrike() {
        return this.gridSpacingAlong;
    }

    @Override
    public double getGridSpacingDownDip() {
        return this.gridSpacingDown;
    }

    @Override
    public Boolean isGridSpacingSame() {
        return this.sameGridSpacing;
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        return GriddedSurfaceUtils.getEvenlyDiscritizedPerimeter(this);
    }

    @Override
    public LocationList getPerimeter() {
        return this.getEvenlyDiscritizedPerimeter();
    }

    @Override
    public Location getLocation(int row, int column) {
        return (Location)this.get(row, column);
    }

    @Override
    public int getEvenlyDiscretizedNumLocs() {
        return (int)this.size();
    }

    @Override
    public Location getEvenlyDiscretizedLocation(int index) {
        int row = index / this.numCols;
        int col = index % this.numCols;
        return (Location)this.get(row, col);
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.listIterator();
    }

    @Override
    public FaultTrace getRowAsTrace(int row) {
        FaultTrace trace = new FaultTrace(null);
        for (int col = 0; col < this.getNumCols(); ++col) {
            trace.add((Location)this.get(row, col));
        }
        return trace;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        return GriddedSurfaceUtils.getMinDistanceBetweenSurfaces(surface, this);
    }

    @Override
    public SurfaceDistances calcDistances(Location loc) {
        double[] dCalc = GriddedSurfaceUtils.getPropagationDistances(this, loc);
        return new SurfaceDistances(dCalc[0], dCalc[1], dCalc[2]);
    }

    @Override
    public double getDistanceRup(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public double getDistanceJB(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceJB();
    }

    @Override
    public double getDistanceSeis(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceSeis();
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double calcQuickDistance(Location siteLoc) {
        return GriddedSurfaceUtils.getCornerMidpointDistance(this, siteLoc);
    }

    @Override
    public double calcDistanceX(Location siteLoc) {
        return GriddedSurfaceUtils.getDistanceX(this.getEvenlyDiscritizedUpperEdge(), siteLoc);
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return this.cache.getDistanceX(siteLoc);
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        return this.getRowAsTrace(0);
    }

    @Override
    public FaultTrace getEvenlyDiscritizedLowerEdge() {
        return this.getRowAsTrace(this.getNumRows() - 1);
    }

    @Override
    public FaultTrace getUpperEdge() {
        return this.getEvenlyDiscritizedUpperEdge();
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        double numInside = 0.0;
        for (Location loc : this) {
            if (!region.contains(loc)) continue;
            numInside += 1.0;
        }
        return numInside / (double)this.size();
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        return (Location)this.get(0, 0);
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        return (Location)this.get(0, this.getNumCols() - 1);
    }

    @Override
    public double getAveLength() {
        return this.getGridSpacingAlongStrike() * (double)(this.getNumCols() - 1);
    }

    @Override
    public double getAveWidth() {
        return this.getGridSpacingDownDip() * (double)(this.getNumRows() - 1);
    }

    @Override
    public double getArea() {
        return this.getAveWidth() * this.getAveLength();
    }

    @Override
    public double getAveGridSpacing() {
        return (this.gridSpacingAlong + this.gridSpacingDown) / 2.0;
    }

    @Override
    public String getInfo() {
        return GriddedSurfaceUtils.getSurfaceInfo(this);
    }

    @Override
    public boolean isPointSurface() {
        return this.size() == 1L;
    }

    protected abstract AbstractEvenlyGriddedSurface getNewInstance();

    @Override
    public AbstractEvenlyGriddedSurface getMoved(LocationVector v) {
        Preconditions.checkNotNull((Object)v, (Object)"vector cannot be null");
        AbstractEvenlyGriddedSurface moved = this.copyShallow();
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                moved.set(row, col, LocationUtils.location((Location)this.get(row, col), v));
            }
        }
        return moved;
    }

    @Override
    public AbstractEvenlyGriddedSurface copyShallow() {
        AbstractEvenlyGriddedSurface o = this.getNewInstance();
        Preconditions.checkState((o.getNumCols() == this.getNumCols() ? 1 : 0) != 0);
        Preconditions.checkState((o.getNumRows() == this.getNumRows() ? 1 : 0) != 0);
        Preconditions.checkState((o.getGridSpacingAlongStrike() == this.getGridSpacingAlongStrike() ? 1 : 0) != 0);
        Preconditions.checkState((o.getGridSpacingDownDip() == this.getGridSpacingDownDip() ? 1 : 0) != 0);
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                o.set(row, col, (Location)this.get(row, col));
            }
        }
        return o;
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }

    public Location getInterpolatedLocation(double das, double ddw) {
        double depthDelta;
        double vertAz;
        double vertDist;
        double horzAz;
        double horzDist;
        Preconditions.checkState((this.numRows > 1 && this.numCols > 1 ? 1 : 0) != 0);
        double spacingAS = this.getGridSpacingAlongStrike();
        double spacingDD = this.getGridSpacingDownDip();
        double indexAS = das / spacingAS;
        int asIndexBefore = (int)indexAS;
        Preconditions.checkState((asIndexBefore >= 0 && asIndexBefore < this.numCols ? 1 : 0) != 0);
        double indexDD = ddw / spacingDD;
        int ddIndexBefore = (int)indexDD;
        Preconditions.checkState((ddIndexBefore >= 0 && ddIndexBefore < this.numRows ? 1 : 0) != 0);
        Location topLeftLoc = (Location)this.get(ddIndexBefore, asIndexBefore);
        if (asIndexBefore == this.numCols - 1) {
            horzDist = 0.0;
            horzAz = 0.0;
        } else {
            Location topRightLoc = (Location)this.get(ddIndexBefore, asIndexBefore + 1);
            horzDist = LocationUtils.horzDistance(topLeftLoc, topRightLoc);
            horzAz = LocationUtils.azimuthRad(topLeftLoc, topRightLoc);
        }
        if (ddIndexBefore == this.numRows - 1) {
            vertDist = 0.0;
            vertAz = 0.0;
            depthDelta = 0.0;
        } else {
            Location botLeftLoc = (Location)this.get(ddIndexBefore + 1, asIndexBefore);
            vertDist = LocationUtils.horzDistance(topLeftLoc, botLeftLoc);
            vertAz = LocationUtils.azimuthRad(topLeftLoc, botLeftLoc);
            depthDelta = botLeftLoc.getDepth() - topLeftLoc.getDepth();
        }
        double relativeVertPos = indexDD - (double)ddIndexBefore;
        double relativeHorzPos = indexAS - (double)asIndexBefore;
        Location loc = topLeftLoc;
        loc = LocationUtils.location(loc, horzAz, horzDist * relativeHorzPos);
        if ((float)vertDist > 0.0f) {
            loc = LocationUtils.location(loc, vertAz, vertDist * relativeVertPos);
        }
        return new Location(loc.getLatitude(), loc.getLongitude(), loc.getDepth() + depthDelta * relativeVertPos);
    }

    public double getStrikeAtDAS(double das) {
        Preconditions.checkState((this.numCols > 1 ? 1 : 0) != 0);
        double spacingAS = this.getGridSpacingAlongStrike();
        double indexAS = das / spacingAS;
        int asIndexBefore = (int)indexAS;
        Preconditions.checkState((asIndexBefore >= 0 && asIndexBefore < this.numCols ? 1 : 0) != 0);
        if (asIndexBefore == this.numCols - 1) {
            --asIndexBefore;
        }
        return LocationUtils.azimuth((Location)this.get(0, asIndexBefore - 1), (Location)this.get(0, asIndexBefore));
    }
}

