/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.GriddedSubsetSurface;

public abstract class AbstractEvenlyGriddedSurfaceWithSubsets
extends AbstractEvenlyGriddedSurface {
    private static final long serialVersionUID = 1L;

    public AbstractEvenlyGriddedSurfaceWithSubsets() {
    }

    public AbstractEvenlyGriddedSurfaceWithSubsets(int numRows, int numCols, double gridSpacing) {
        super(numRows, numCols, gridSpacing);
    }

    public AbstractEvenlyGriddedSurfaceWithSubsets(int numRows, int numCols, double gridSpacingAlong, double gridSpacingDown) {
        super(numRows, numCols, gridSpacingAlong, gridSpacingDown);
    }

    public GriddedSubsetSurface getNthSubsetSurface(int numSubSurfaceCols, int numSubSurfaceRows, int numSubSurfaceOffsetAlong, int numSubSurfaceOffsetDown, int n) {
        int nSubSurfaceAlong = (int)Math.floor((this.numCols - numSubSurfaceCols) / numSubSurfaceOffsetAlong + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
        }
        if (numSubSurfaceCols > this.getNumCols()) {
            numSubSurfaceCols = this.getNumCols();
        }
        if (numSubSurfaceRows > this.getNumRows()) {
            numSubSurfaceRows = this.getNumRows();
        }
        return this.getNthSubsetSurface(numSubSurfaceCols, numSubSurfaceRows, numSubSurfaceOffsetAlong, numSubSurfaceOffsetDown, nSubSurfaceAlong, n);
    }

    private GriddedSubsetSurface getNthSubsetSurface(int numSubSurfaceCols, int numSubSurfaceRows, int numSubSurfaceOffsetAlong, int numSubSurfaceOffsetDown, int nSubSurfaceAlong, int n) {
        int startRow = n / nSubSurfaceAlong * numSubSurfaceOffsetDown;
        int startCol = n % nSubSurfaceAlong * numSubSurfaceOffsetAlong;
        return new GriddedSubsetSurface(numSubSurfaceRows, numSubSurfaceCols, startRow, startCol, this);
    }

    public GriddedSubsetSurface getNthSubsetSurface(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset, int n) {
        return this.getNthSubsetSurface((int)Math.rint(subSurfaceLength / this.gridSpacingAlong + 1.0), (int)Math.rint(subSurfaceWidth / this.gridSpacingDown + 1.0), (int)Math.rint(subSurfaceOffset / this.gridSpacingAlong), (int)Math.rint(subSurfaceOffset / this.gridSpacingDown), n);
    }

    public GriddedSubsetSurface getNthSubsetSurfaceCenteredDownDip(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset, int n) {
        int numSubSurfaceCols = (int)Math.rint(subSurfaceLength / this.gridSpacingAlong + 1.0);
        int startCol = -1;
        if (numSubSurfaceCols > this.getNumCols()) {
            numSubSurfaceCols = this.getNumCols();
            startCol = 0;
        } else {
            startCol = n * (int)Math.rint(subSurfaceOffset / this.gridSpacingAlong);
        }
        int numSubSurfaceRows = (int)Math.rint(subSurfaceWidth / this.gridSpacingDown + 1.0);
        int startRow = -1;
        if (numSubSurfaceRows >= this.getNumRows()) {
            numSubSurfaceRows = this.getNumRows();
            startRow = 0;
        } else {
            startRow = (int)Math.floor((this.getNumRows() - numSubSurfaceRows) / 2);
        }
        return new GriddedSubsetSurface(numSubSurfaceRows, numSubSurfaceCols, startRow, startCol, this);
    }

    public Iterator<GriddedSubsetSurface> getSubsetSurfacesIterator(int numSubSurfaceCols, int numSubSurfaceRows, int numSubSurfaceOffsetAlong, int numSubSurfaceOffsetDown) {
        int nSubSurfaceDown;
        ArrayList<GriddedSubsetSurface> v = new ArrayList<GriddedSubsetSurface>();
        int nSubSurfaceAlong = (int)Math.floor((this.getNumCols() - numSubSurfaceCols) / numSubSurfaceOffsetAlong + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
            numSubSurfaceCols = this.getNumCols();
        }
        if ((nSubSurfaceDown = (int)Math.floor((this.getNumRows() - numSubSurfaceRows) / numSubSurfaceOffsetDown + 1)) <= 1) {
            nSubSurfaceDown = 1;
            numSubSurfaceRows = this.getNumRows();
        }
        int totalSubSetSurface = nSubSurfaceAlong * nSubSurfaceDown;
        v.clear();
        for (int i = 0; i < totalSubSetSurface; ++i) {
            v.add(this.getNthSubsetSurface(numSubSurfaceCols, numSubSurfaceRows, numSubSurfaceOffsetAlong, numSubSurfaceOffsetDown, nSubSurfaceAlong, i));
        }
        return v.iterator();
    }

    public Iterator<GriddedSubsetSurface> getSubsetSurfacesIterator(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset) {
        return this.getSubsetSurfacesIterator((int)Math.rint(subSurfaceLength / this.gridSpacingAlong + 1.0), (int)Math.rint(subSurfaceWidth / this.gridSpacingDown + 1.0), (int)Math.rint(subSurfaceOffset / this.gridSpacingAlong), (int)Math.rint(subSurfaceOffset / this.gridSpacingDown));
    }

    public int getNumSubsetSurfaces(double subSurfaceLength, double subSurfaceWidth, double subSurfaceOffset) {
        int nSubSurfaceDown;
        int lengthCols = (int)Math.rint(subSurfaceLength / this.gridSpacingAlong + 1.0);
        int widthCols = (int)Math.rint(subSurfaceWidth / this.gridSpacingDown + 1.0);
        int offsetColsAlong = (int)Math.rint(subSurfaceOffset / this.gridSpacingAlong);
        int offsetColsDown = (int)Math.rint(subSurfaceOffset / this.gridSpacingDown);
        int nSubSurfaceAlong = (int)Math.floor((this.getNumCols() - lengthCols) / offsetColsAlong + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
        }
        if ((nSubSurfaceDown = (int)Math.floor((this.getNumRows() - widthCols) / offsetColsDown + 1)) <= 1) {
            nSubSurfaceDown = 1;
        }
        return nSubSurfaceAlong * nSubSurfaceDown;
    }

    public int getNumSubsetSurfacesAlongLength(double subSurfaceLength, double subSurfaceOffset) {
        int lengthCols = (int)Math.rint(subSurfaceLength / this.gridSpacingAlong + 1.0);
        int offsetCols = (int)Math.rint(subSurfaceOffset / this.gridSpacingAlong);
        int nSubSurfaceAlong = (int)Math.floor((this.getNumCols() - lengthCols) / offsetCols + 1);
        if (nSubSurfaceAlong <= 1) {
            nSubSurfaceAlong = 1;
        }
        return nSubSurfaceAlong;
    }
}

