/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.base.Preconditions;
import java.io.FileWriter;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.FaultTrace;

public class ApproxEvenlyGriddedSurface
extends AbstractEvenlyGriddedSurfaceWithSubsets {
    private static final boolean D = false;
    private static final long serialVersionUID = 1L;
    private FaultTrace upperFaultTrace = null;
    private FaultTrace lowerFaultTrace = null;
    private double avgDip = Double.NaN;
    private double avgDipDir = Double.NaN;
    private double aveUpperDepth = Double.NaN;
    private double aveLowerDepth = Double.NaN;

    public ApproxEvenlyGriddedSurface(int numRows, int numCols, double aveGridSpacing) {
        this.setNumRowsAndNumCols(numRows, numCols);
        this.gridSpacingAlong = aveGridSpacing;
        this.gridSpacingDown = aveGridSpacing;
        this.sameGridSpacing = true;
    }

    public ApproxEvenlyGriddedSurface(FaultTrace upperFaultTrace, FaultTrace lowerFaultTrace, double aveGridSpacing) {
        this(upperFaultTrace, lowerFaultTrace, aveGridSpacing, false, 0.0);
    }

    public ApproxEvenlyGriddedSurface(FaultTrace upperFaultTrace, FaultTrace lowerFaultTrace, double aveGridSpacing, boolean aseisReducesArea, double aseismicSlipFactor) {
        double idealDipDir;
        double traceDistFactor;
        this.gridSpacingAlong = aveGridSpacing;
        this.gridSpacingDown = aveGridSpacing;
        this.sameGridSpacing = true;
        FaultTrace tmpUpperFaultTrace = new FaultTrace(upperFaultTrace.getName());
        tmpUpperFaultTrace.addAll(upperFaultTrace);
        upperFaultTrace = tmpUpperFaultTrace;
        FaultTrace tmpLowerFaultTrace = new FaultTrace(lowerFaultTrace.getName());
        tmpLowerFaultTrace.addAll(lowerFaultTrace);
        lowerFaultTrace = tmpLowerFaultTrace;
        this.upperFaultTrace = upperFaultTrace;
        this.lowerFaultTrace = lowerFaultTrace;
        if (aseisReducesArea) {
            Preconditions.checkState((aseismicSlipFactor >= 0.0 && aseismicSlipFactor < 1.0 ? 1 : 0) != 0, (String)"Bad aseismicSlipFactor=%s", (Object)aseismicSlipFactor);
            if (aseismicSlipFactor == 0.0) {
                traceDistFactor = 1.0;
                aseisReducesArea = false;
            } else {
                traceDistFactor = 1.0 - aseismicSlipFactor;
            }
        } else {
            aseismicSlipFactor = 0.0;
            traceDistFactor = 1.0;
        }
        double upperAz = upperFaultTrace.getAveStrike();
        double lowerAz = lowerFaultTrace.getAveStrike();
        double azDiff = FaultUtils.getAbsAngleDiff(upperAz, lowerAz);
        if (azDiff > 90.0) {
            lowerFaultTrace.reverse();
        }
        double dipDir = FaultUtils.getAngleAverage(List.of(Double.valueOf(LocationUtils.azimuth(upperFaultTrace.first(), lowerFaultTrace.first())), Double.valueOf(LocationUtils.azimuth(upperFaultTrace.last(), lowerFaultTrace.last()))));
        for (idealDipDir = upperAz + 90.0; idealDipDir > 360.0; idealDipDir -= 360.0) {
        }
        double arDiff = FaultUtils.getAbsAngleDiff(idealDipDir, dipDir);
        if (arDiff > 90.0) {
            upperFaultTrace.reverse();
            lowerFaultTrace.reverse();
        }
        double aveTraceLength = (upperFaultTrace.getTraceLength() + lowerFaultTrace.getTraceLength()) / 2.0;
        int num = (int)Math.round(aveTraceLength / aveGridSpacing);
        FaultTrace resampUpperTrace = FaultUtils.resampleTrace(upperFaultTrace, num);
        FaultTrace resampLowerTrace = FaultUtils.resampleTrace(lowerFaultTrace, num);
        Preconditions.checkState((resampUpperTrace.size() == num + 1 ? 1 : 0) != 0, (String)"Resampled upper has %s but expected %s", (int)resampUpperTrace.size(), (int)(num + 1));
        Preconditions.checkState((resampLowerTrace.size() == num + 1 ? 1 : 0) != 0, (String)"Resampled lower has %s but expected %s", (int)resampLowerTrace.size(), (int)(num + 1));
        double aveDist = 0.0;
        for (int i = 0; i < resampUpperTrace.size(); ++i) {
            Location topLoc = (Location)resampUpperTrace.get(i);
            Location botLoc = (Location)resampLowerTrace.get(i);
            aveDist += LocationUtils.linearDistanceFast(topLoc, botLoc);
        }
        aveDist /= (double)resampUpperTrace.size();
        int nRows = (int)Math.round((aveDist *= traceDistFactor) / aveGridSpacing) + 1;
        this.setNumRowsAndNumCols(nRows, num + 1);
        for (int c = 0; c < resampUpperTrace.size(); ++c) {
            Location topLoc = (Location)resampUpperTrace.get(c);
            Location botLoc = (Location)resampLowerTrace.get(c);
            LocationVector dir = LocationUtils.vector(topLoc, botLoc);
            if (aseisReducesArea) {
                double horzDist = dir.getHorzDistance();
                Preconditions.checkState((horzDist >= 0.0 ? 1 : 0) != 0);
                double vertDist = dir.getVertDistance();
                Preconditions.checkState((vertDist >= 0.0 ? 1 : 0) != 0);
                topLoc = LocationUtils.location(topLoc, dir.getAzimuthRad(), horzDist * aseismicSlipFactor);
                topLoc = new Location(topLoc.getLatitude(), topLoc.getLongitude(), topLoc.getDepth() + vertDist * aseismicSlipFactor);
                dir = LocationUtils.vector(topLoc, botLoc);
            }
            double horzIncr = dir.getHorzDistance() / (double)(nRows - 1);
            double vertIncr = dir.getVertDistance() / (double)(nRows - 1);
            dir.setHorzDistance(horzIncr);
            dir.setVertDistance(vertIncr);
            this.setLocation(0, c, topLoc);
            Location prevLoc = topLoc;
            for (int r = 1; r < nRows; ++r) {
                Location nextLoc = LocationUtils.location(prevLoc, dir);
                this.setLocation(r, c, nextLoc);
                prevLoc = nextLoc;
            }
        }
        Location loc1 = (Location)resampLowerTrace.get(resampLowerTrace.size() - 1);
        Location loc2 = this.getLocation(this.numRows - 1, this.numCols - 1);
    }

    public static void test1(Location l1, Location l2) {
        System.out.println("TEST-1");
        double numSubdivisions = 100.0;
        LocationVector dir = LocationUtils.vector(l1, l2);
        System.out.println("Azimuth p1 to p2: " + dir.getAzimuth());
        double horzIncr = dir.getHorzDistance() / numSubdivisions;
        double vertIncr = dir.getVertDistance() / numSubdivisions;
        dir.setHorzDistance(horzIncr);
        dir.setVertDistance(vertIncr);
        Location prevLoc = l1;
        int r = 0;
        while ((double)r < numSubdivisions) {
            Location nextLoc;
            prevLoc = nextLoc = LocationUtils.location(prevLoc, dir);
            ++r;
        }
        double accuracyCheck = LocationUtils.linearDistanceFast(l2, prevLoc);
        System.out.println("Distance between actual and computed bottom point = " + (float)accuracyCheck);
        System.out.println("DeltaLat = " + (float)((l2.getLatitude() - prevLoc.getLatitude()) * 111.0));
        System.out.println("DeltaLon = " + (float)((l2.getLongitude() - prevLoc.getLongitude()) * 111.0));
        System.out.println("DeltaDepth = " + (float)(l2.getDepth() - prevLoc.getDepth()));
        System.out.println("");
    }

    public static void test2(Location l1, Location l2) {
        System.out.println("TEST-2");
        double numSubdivisions = 100.0;
        LocationVector dir = LocationUtils.vector(l1, l2);
        double horzIncr = dir.getHorzDistance() / numSubdivisions;
        double vertIncr = dir.getVertDistance() / numSubdivisions;
        dir.setHorzDistance(horzIncr);
        dir.setVertDistance(vertIncr);
        Location prevLoc = l1;
        int r = 0;
        while ((double)r < numSubdivisions) {
            Location nextLoc;
            prevLoc = nextLoc = LocationUtils.location(prevLoc, dir);
            dir.setAzimuth(LocationUtils.azimuth(prevLoc, l2));
            ++r;
        }
        double accuracyCheck = LocationUtils.linearDistanceFast(l2, prevLoc);
        System.out.println("Distance between actual and computed bottom point = " + (float)accuracyCheck);
        System.out.println("DeltaLat = " + (float)((l2.getLatitude() - prevLoc.getLatitude()) * 111.0));
        System.out.println("DeltaLon = " + (float)((l2.getLongitude() - prevLoc.getLongitude()) * 111.0));
        System.out.println("DeltaDepth = " + (float)(l2.getDepth() - prevLoc.getDepth()));
        System.out.println("");
    }

    public void setLocation(int row, int column, Location location) {
        super.set(row, column, location);
    }

    public void writeXYZ_toFile(String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write("lat\tlon\tdepth\n");
            ListIterator<Location> it = this.getLocationsIterator();
            while (it.hasNext()) {
                Location loc = (Location)it.next();
                fw.write(loc.getLatitude() + "\t" + loc.getLongitude() + "\t" + loc.getDepth() + "\n");
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double computeAveGridSpacingAlongStrike() {
        double aveDist = 0.0;
        int num = 0;
        for (int r = 0; r < this.numRows; ++r) {
            for (int c = 0; c < this.numCols - 1; ++c) {
                aveDist += LocationUtils.linearDistanceFast(this.getLocation(r, c), this.getLocation(r, c + 1));
                ++num;
            }
        }
        return aveDist / (double)num;
    }

    public double computeAveGridSpacingDownDip() {
        double aveDist = 0.0;
        int num = 0;
        for (int c = 0; c < this.numCols; ++c) {
            for (int r = 0; r < this.numRows - 1; ++r) {
                aveDist += LocationUtils.linearDistanceFast(this.getLocation(r, c), this.getLocation(r + 1, c));
                ++num;
            }
        }
        return aveDist / (double)num;
    }

    public static void main(String[] args) {
        Location top1 = new Location(20.0, 0.0, 10.0);
        Location bot1 = new Location(40.0, 0.0, 50.0);
        Location top2 = new Location(40.0, 0.0, 10.0);
        Location bot2 = new Location(40.0, 20.0, 50.0);
        ApproxEvenlyGriddedSurface.test1(top1, bot1);
        ApproxEvenlyGriddedSurface.test1(top2, bot2);
        ApproxEvenlyGriddedSurface.test2(top1, bot1);
        ApproxEvenlyGriddedSurface.test2(top2, bot2);
    }

    @Override
    public synchronized double getAveDip() {
        if (!Double.isNaN(this.avgDip)) {
            return this.avgDip;
        }
        FaultTrace ut = this.upperFaultTrace;
        FaultTrace lt = this.lowerFaultTrace;
        Location pUp = (Location)ut.get(0);
        Location pLo = (Location)lt.get(0);
        LocationVector v = LocationUtils.vector(pUp, pLo);
        double d1 = Math.atan(v.getVertDistance() / v.getHorzDistance());
        pUp = (Location)ut.get(ut.size() - 1);
        pLo = (Location)lt.get(lt.size() - 1);
        v = LocationUtils.vector(pUp, pLo);
        double d2 = Math.atan(v.getVertDistance() / v.getHorzDistance());
        this.avgDip = (d1 + d2) / 2.0 * GeoTools.TO_DEG;
        return this.avgDip;
    }

    @Override
    public synchronized double getAveDipDirection() {
        if (!Double.isNaN(this.avgDipDir)) {
            return this.avgDipDir;
        }
        FaultTrace ut = this.upperFaultTrace;
        FaultTrace lt = this.lowerFaultTrace;
        Location pUp = (Location)ut.get(0);
        Location pLo = (Location)lt.get(0);
        LocationVector v = LocationUtils.vector(pUp, pLo);
        FaultUtils.AngleAverager avg = new FaultUtils.AngleAverager();
        avg.add(v.getAzimuth(), 1.0);
        v = LocationUtils.vector(pUp, pLo);
        avg.add(v.getAzimuth(), 1.0);
        this.avgDipDir = avg.getAverage();
        return this.avgDipDir;
    }

    @Override
    public synchronized double getAveRupTopDepth() {
        if (!Double.isNaN(this.aveUpperDepth)) {
            return this.aveUpperDepth;
        }
        double aveDepth = 0.0;
        FaultTrace topTrace = this.getRowAsTrace(0);
        for (Location loc : topTrace) {
            aveDepth += loc.getDepth();
        }
        this.aveUpperDepth = aveDepth / (double)topTrace.size();
        return this.aveUpperDepth;
    }

    public synchronized double getAveRupBottomDepth() {
        if (!Double.isNaN(this.aveLowerDepth)) {
            return this.aveLowerDepth;
        }
        double aveDepth = 0.0;
        FaultTrace botTrace = this.getRowAsTrace(this.numRows - 1);
        for (Location loc : botTrace) {
            aveDepth += loc.getDepth();
        }
        this.aveLowerDepth = aveDepth / (double)botTrace.size();
        return this.aveLowerDepth;
    }

    @Override
    public double getAveStrike() {
        FaultUtils.AngleAverager averager = new FaultUtils.AngleAverager();
        averager.add(this.upperFaultTrace.getAveStrike(), 1.0);
        averager.add(this.lowerFaultTrace.getAveStrike(), 1.0);
        return averager.getAverage();
    }

    @Override
    public FaultTrace getUpperEdge() {
        return this.upperFaultTrace;
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        return new ApproxEvenlyGriddedSurface(this.getNumRows(), this.getNumCols(), this.gridSpacingAlong);
    }
}

