/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

public class EvenlyGridCenteredSurface
extends AbstractEvenlyGriddedSurfaceWithSubsets {
    private static final long serialVersionUID = 1L;
    private EvenlyGriddedSurface origSurface;

    public EvenlyGridCenteredSurface(EvenlyGriddedSurface surface) {
        if (surface instanceof FrankelGriddedSurface) {
            throw new UnsupportedOperationException("Grid-Centered Surface not defined for Frankel surface");
        }
        this.origSurface = surface;
        this.gridSpacingAlong = surface.getGridSpacingAlongStrike();
        this.gridSpacingDown = surface.getGridSpacingDownDip();
        this.sameGridSpacing = surface.isGridSpacingSame();
        this.getGridCenteredSurface();
    }

    private EvenlyGridCenteredSurface() {
    }

    private void getGridCenteredSurface() {
        int numRows = this.origSurface.getNumRows() - 1;
        int numCols = this.origSurface.getNumCols() - 1;
        this.setNumRowsAndNumCols(numRows, numCols);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                Location loc1 = this.origSurface.getLocation(i, j);
                Location loc2 = this.origSurface.getLocation(i, j + 1);
                Location loc3 = this.origSurface.getLocation(i + 1, j);
                Location loc4 = this.origSurface.getLocation(i + 1, j + 1);
                double locLat = (loc1.getLatitude() + loc2.getLatitude() + loc3.getLatitude() + loc4.getLatitude()) / 4.0;
                double locLon = (loc1.getLongitude() + loc2.getLongitude() + loc3.getLongitude() + loc4.getLongitude()) / 4.0;
                double locDepth = (loc1.getDepth() + loc2.getDepth() + loc3.getDepth() + loc4.getDepth()) / 4.0;
                Location loc = new Location(locLat, locLon, locDepth);
                this.set(i, j, loc);
            }
        }
    }

    public RuptureSurface getOrigSurface() {
        return this.origSurface;
    }

    @Override
    public double getAveStrike() {
        return this.origSurface.getAveStrike();
    }

    @Override
    public double getAveDip() {
        return this.origSurface.getAveDip();
    }

    @Override
    public double getAveDipDirection() {
        return 0.0;
    }

    @Override
    public double getAveRupTopDepth() {
        return this.origSurface.getAveRupTopDepth() + this.gridSpacingDown / 2.0;
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        EvenlyGridCenteredSurface surf = new EvenlyGridCenteredSurface();
        surf.setNumRowsAndNumCols(this.numRows, this.numCols);
        surf.gridSpacingAlong = this.getGridSpacingAlongStrike();
        surf.gridSpacingDown = this.getGridSpacingDownDip();
        return surf;
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        double gridSpacingDown = this.getGridSpacingDownDip();
        double gridSpacingAlong = this.getGridSpacingAlongStrike();
        double areaEach = gridSpacingAlong * gridSpacingDown;
        double areaInside = 0.0;
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumCols(); ++col) {
                if (!region.contains((Location)this.get(row, col))) continue;
                areaInside += areaEach;
            }
        }
        return areaInside;
    }
}

