/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.List;
import java.util.Objects;
import org.dom4j.Element;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.Named;
import org.opensha.commons.geo.Region;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.sha.faultSurface.ApproxEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.QuadSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

public interface FaultSection
extends Named,
XMLSaveable,
Cloneable {
    public long getDateOfLastEvent();

    public void setDateOfLastEvent(long var1);

    public void setSlipInLastEvent(double var1);

    public double getSlipInLastEvent();

    public double getAseismicSlipFactor();

    public void setAseismicSlipFactor(double var1);

    public double getCouplingCoeff();

    public void setCouplingCoeff(double var1);

    public double getAveDip();

    public double getOrigAveSlipRate();

    public void setAveSlipRate(double var1);

    default public double getReducedAveSlipRate() {
        return this.getOrigAveSlipRate() * this.getCouplingCoeff();
    }

    public double getAveLowerDepth();

    public double getAveRake();

    public void setAveRake(double var1);

    public double getOrigAveUpperDepth();

    default public double getReducedAveUpperDepth() {
        double depthToReduce = this.getAseismicSlipFactor() * (this.getAveLowerDepth() - this.getOrigAveUpperDepth());
        return this.getOrigAveUpperDepth() + depthToReduce;
    }

    public float getDipDirection();

    public FaultTrace getFaultTrace();

    default public FaultTrace getLowerFaultTrace() {
        return null;
    }

    public int getSectionId();

    public void setSectionId(int var1);

    default public String getSectionName() {
        return this.getName();
    }

    public void setSectionName(String var1);

    public int getParentSectionId();

    public void setParentSectionId(int var1);

    public String getParentSectionName();

    public void setParentSectionName(String var1);

    default public double getTraceLength() {
        return this.getFaultTrace().getTraceLength();
    }

    default public double getOrigDownDipWidth() {
        return (this.getAveLowerDepth() - this.getOrigAveUpperDepth()) / Math.sin(this.getAveDip() * Math.PI / 180.0);
    }

    default public double getReducedDownDipWidth() {
        return this.getOrigDownDipWidth() * (1.0 - this.getAseismicSlipFactor());
    }

    default public List<? extends FaultSection> getSubSectionsList(double maxSubSectionLen) {
        return this.getSubSectionsList(maxSubSectionLen, 1000 * this.getSectionId());
    }

    default public List<? extends FaultSection> getSubSectionsList(double maxSubSectionLen, int startId) {
        return this.getSubSectionsList(maxSubSectionLen, startId, 1);
    }

    public List<? extends FaultSection> getSubSectionsList(double var1, int var3, int var4);

    public double getOrigSlipRateStdDev();

    default public double getReducedSlipRateStdDev() {
        return this.getOrigSlipRateStdDev() * this.getCouplingCoeff();
    }

    public void setSlipRateStdDev(double var1);

    public boolean isConnector();

    public boolean isProxyFault();

    public Region getZonePolygon();

    public void setZonePolygon(Region var1);

    public Element toXMLMetadata(Element var1, String var2);

    default public double getArea(boolean creepReduced) {
        double ddw = creepReduced ? this.getReducedDownDipWidth() : this.getOrigDownDipWidth();
        double len = this.getTraceLength();
        if (this.getLowerFaultTrace() != null) {
            len = 0.5 * len + 0.5 * this.getLowerFaultTrace().getTraceLength();
        }
        return ddw * len * 1000000.0;
    }

    default public double calcMomentRate(boolean creepReduced) {
        double area = this.getArea(creepReduced);
        double slipRate = creepReduced ? this.getReducedAveSlipRate() : this.getOrigAveSlipRate();
        return FaultMomentCalc.getMoment(area, slipRate * 0.001);
    }

    public RuptureSurface getFaultSurface(double var1);

    public RuptureSurface getFaultSurface(double var1, boolean var3, boolean var4);

    default public SimpleFaultData getSimpleFaultData(boolean aseisReducesArea) {
        double upperDepth = this.getOrigAveUpperDepth();
        if (aseisReducesArea) {
            upperDepth = this.getReducedAveUpperDepth();
        }
        return new SimpleFaultData(this.getAveDip(), this.getAveLowerDepth(), upperDepth, this.getFaultTrace(), this.getDipDirection());
    }

    public FaultSection clone();

    public static int hashCode(FaultSection sect) {
        return Objects.hash(sect.getParentSectionId(), sect.getSectionId());
    }

    public static boolean equals(FaultSection sect, Object obj) {
        if (sect == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!FaultSection.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        FaultSection other = (FaultSection)obj;
        return sect.getParentSectionId() == other.getParentSectionId() && sect.getSectionId() == other.getSectionId();
    }

    public static class QuadSurfaceCache {
        boolean lastPreserveGridSpacingExactly;
        boolean lastAseisReducesArea;
        private QuadSurface quadSurf = null;
        private FaultSection sect;

        public QuadSurfaceCache(FaultSection sect) {
            this.sect = sect;
        }

        public synchronized QuadSurface getQuadSurface(boolean aseisReducesArea, double spacingForGridOperations) {
            if (this.lastAseisReducesArea == aseisReducesArea && this.quadSurf != null) {
                this.quadSurf.setAveGridSpacing(spacingForGridOperations);
                return this.quadSurf;
            }
            this.lastAseisReducesArea = aseisReducesArea;
            this.quadSurf = new QuadSurface(this.sect, aseisReducesArea);
            return this.quadSurf;
        }
    }

    public static class ApproxEvenlyGriddedSurfaceCache {
        double lastGridSpacing = Double.NaN;
        boolean lastAseisReducesArea;
        private ApproxEvenlyGriddedSurface approxGriddedSurface = null;
        private FaultSection sect;
        private FaultTrace lowerTrace;

        public ApproxEvenlyGriddedSurfaceCache(FaultSection sect, FaultTrace lowerTrace) {
            this.sect = sect;
            this.lowerTrace = lowerTrace;
        }

        public synchronized ApproxEvenlyGriddedSurface getApproxEvenlyGriddedSurface(double gridSpacing, boolean aseisReducesArea) {
            if (gridSpacing == this.lastGridSpacing && this.approxGriddedSurface != null && aseisReducesArea == this.lastAseisReducesArea) {
                return this.approxGriddedSurface;
            }
            this.approxGriddedSurface = new ApproxEvenlyGriddedSurface(this.sect.getFaultTrace(), this.lowerTrace, gridSpacing, aseisReducesArea, this.sect.getAseismicSlipFactor());
            this.lastAseisReducesArea = aseisReducesArea;
            this.lastGridSpacing = gridSpacing;
            return this.approxGriddedSurface;
        }
    }

    public static class StirlingSurfaceCache {
        double lastGridSpacing = Double.NaN;
        boolean lastPreserveGridSpacingExactly;
        boolean lastAseisReducesArea;
        private StirlingGriddedSurface stirlingGriddedSurface = null;
        private FaultSection sect;

        public StirlingSurfaceCache(FaultSection sect) {
            this.sect = sect;
        }

        public synchronized StirlingGriddedSurface getStirlingGriddedSurface(double gridSpacing, boolean preserveGridSpacingExactly, boolean aseisReducesArea) {
            if (gridSpacing == this.lastGridSpacing && this.stirlingGriddedSurface != null && preserveGridSpacingExactly == this.lastPreserveGridSpacingExactly && aseisReducesArea == this.lastAseisReducesArea) {
                return this.stirlingGriddedSurface;
            }
            this.stirlingGriddedSurface = preserveGridSpacingExactly ? new StirlingGriddedSurface(this.sect.getSimpleFaultData(aseisReducesArea), gridSpacing) : new StirlingGriddedSurface(this.sect.getSimpleFaultData(aseisReducesArea), gridSpacing, gridSpacing);
            this.lastPreserveGridSpacingExactly = preserveGridSpacingExactly;
            this.lastAseisReducesArea = aseisReducesArea;
            this.lastGridSpacing = gridSpacing;
            return this.stirlingGriddedSurface;
        }
    }
}

