/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.util.FaultUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionPolygonBuilder;
import org.opensha.sha.faultSurface.ApproxEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

public final class GeoJSONFaultSection
implements FaultSection {
    private int id;
    private String name;
    private double dip;
    private double rake;
    private double upperDepth;
    private double lowerDepth;
    private float dipDirection;
    private FaultTrace trace;
    private Region zonePolygon;
    private FeatureProperties properties;
    private double aveLongTermSlipRate;
    private double slipRateStdDev;
    private String parentSectionName;
    private int parentSectionId = -1;
    private long dateOfLastEventMillis = Long.MIN_VALUE;
    private int hashCode;
    private FaultTrace lowerTrace;
    private FaultSection.StirlingSurfaceCache stirlingCache;
    private FaultSection.ApproxEvenlyGriddedSurfaceCache approxGriddedCache;
    public static final String FAULT_ID = "FaultID";
    public static final String FAULT_NAME = "FaultName";
    public static final String DIP = "DipDeg";
    public static final String DIP_DIR = "DipDir";
    public static final String RAKE = "Rake";
    public static final String LOW_DEPTH = "LowDepth";
    public static final String UPPER_DEPTH = "UpDepth";
    public static final String DATE_LAST = "DateLastEvent";
    public static final String SLIP_LAST = "SlipLastEvent";
    public static final String ASEIS = "AseismicSlipFactor";
    public static final String COUPLING = "CouplingCoeff";
    public static final String SLIP_RATE = "SlipRate";
    public static final String PARENT_ID = "ParentID";
    public static final String PARENT_NAME = "ParentName";
    public static final String SLIP_STD_DEV = "SlipRateStdDev";
    public static final String CONNECTOR = "Connector";
    public static final String CREEP_RATE = "CreepRate";
    public static final String PROXY = "Proxy";
    @Deprecated
    private static final String LOWER_TRACE = "LowerTrace";

    private GeoJSONFaultSection(Feature feature) {
        Preconditions.checkNotNull((Object)feature, (Object)"feature cannot be null");
        Preconditions.checkNotNull((Object)feature.geometry, (Object)"geometry cannot be null");
        Preconditions.checkNotNull((Object)feature.properties, (Object)"properties cannot be null");
        this.properties = new FeatureProperties(feature.properties);
        if (feature.id != null && feature.id instanceof Number) {
            this.id = ((Number)feature.id).intValue();
        } else {
            Preconditions.checkState((boolean)feature.properties.containsKey(FAULT_ID), (String)"Must supply feature ID or %s property", (Object)FAULT_ID);
            this.id = this.properties.getInt(FAULT_ID, -1);
        }
        Preconditions.checkState((this.id >= 0 ? 1 : 0) != 0, (Object)"ID must be >= 0");
        this.name = this.properties.get(FAULT_NAME, null);
        this.rake = this.properties.getDouble(RAKE, Double.NaN);
        this.upperDepth = this.properties.getDouble(UPPER_DEPTH, Double.NaN);
        this.lowerDepth = this.properties.getDouble(LOW_DEPTH, Double.NaN);
        this.dip = this.properties.getDouble(DIP, Double.NaN);
        this.dipDirection = Float.NaN;
        if (this.properties.containsKey(DIP_DIR)) {
            Object dipDirProp = this.properties.get(DIP_DIR);
            if (dipDirProp instanceof Number) {
                this.dipDirection = ((Number)dipDirProp).floatValue();
            } else if (dipDirProp instanceof String) {
                try {
                    this.dipDirection = (float)Double.parseDouble(dipDirProp.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.setGeometry(feature.geometry);
        Preconditions.checkNotNull((Object)this.trace, (Object)"Didn't find a FaultTrace in the supplied Feature. LineString and MultiLineString are supported");
        this.checkLoadDeprecatedLowerTraceProperty();
        if (this.lowerTrace != null) {
            this.validateLowerTrace(this.trace, this.lowerTrace);
        } else if (!Double.isFinite(this.upperDepth)) {
            Preconditions.checkState((boolean)feature.geometry.isSerializeZeroDepths(), (Object)"Can't infer upper depth: upper depth not specified, and fault trace did not specify depths.");
            int num = Integer.max(10, (int)this.trace.getTraceLength());
            this.upperDepth = FaultUtils.resampleTrace(this.trace, num).stream().map(S -> S.depth).mapToDouble(d -> d).average().getAsDouble();
            this.properties.set(UPPER_DEPTH, this.upperDepth);
        }
        GeoJSONFaultSection.checkPropFinite(UPPER_DEPTH, this.upperDepth);
        FaultUtils.assertValidDepth(this.upperDepth);
        GeoJSONFaultSection.checkPropFinite(LOW_DEPTH, this.lowerDepth);
        FaultUtils.assertValidDepth(this.lowerDepth);
        GeoJSONFaultSection.checkPropFinite(DIP, this.dip);
        FaultUtils.assertValidDip(this.dip);
        if (!Double.isFinite(this.dipDirection)) {
            if (this.lowerTrace == null) {
                this.setDipDirection((float)(this.trace.getAveStrike() + 90.0));
            } else {
                ApproxEvenlyGriddedSurface surf = this.getApproxGriddedSurface(1.0, false);
                this.setDipDirection((float)surf.getAveDipDirection());
            }
        }
        this.cacheCommonValues();
    }

    private void checkLoadDeprecatedLowerTraceProperty() {
        Geometry lowerTraceGeom = this.properties.get(LOWER_TRACE, null);
        if (lowerTraceGeom != null) {
            LocationList line;
            System.err.println("WARNING: deprecated LowerTrace property used; use a MultiLineString geometry instead");
            this.properties.remove(LOWER_TRACE);
            Preconditions.checkState((this.lowerTrace == null ? 1 : 0) != 0, (Object)"Can't have both an explicit LowerTrace and a lower trace in a MultiLineString geometry");
            if (lowerTraceGeom instanceof Geometry.LineString) {
                line = ((Geometry.LineString)lowerTraceGeom).line;
            } else if (lowerTraceGeom instanceof Geometry.MultiLineString) {
                Geometry.MultiLineString multiLine = (Geometry.MultiLineString)lowerTraceGeom;
                Preconditions.checkState((multiLine.lines.size() == 1 ? 1 : 0) != 0, (Object)"Lower trace MultiLineString only supported if exactly 1 line");
                line = (LocationList)multiLine.lines.get(0);
            } else {
                throw new IllegalStateException("Unsupported lower trace type: " + String.valueOf((Object)lowerTraceGeom.type));
            }
            this.lowerTrace = new FaultTrace(this.name);
            this.lowerTrace.addAll(line);
        }
    }

    private void cacheCommonValues() {
        this.aveLongTermSlipRate = this.properties.getDouble(SLIP_RATE, Double.NaN);
        this.slipRateStdDev = this.properties.getDouble(SLIP_STD_DEV, Double.NaN);
        this.parentSectionName = this.properties.get(PARENT_NAME, null);
        this.parentSectionId = this.properties.getInt(PARENT_ID, -1);
        this.dateOfLastEventMillis = this.properties.getLong(DATE_LAST, Long.MIN_VALUE);
        this.updateHashCode();
    }

    private void setGeometry(Geometry geometry) {
        if (geometry instanceof Geometry.GeometryCollection) {
            for (Geometry subGeom : ((Geometry.GeometryCollection)geometry).geometries) {
                Preconditions.checkState((!(subGeom instanceof Geometry.GeometryCollection) ? 1 : 0) != 0, (Object)"GeoJSONFaultSections don't support nested geometry collections.");
                this.setGeometry(subGeom);
            }
        } else if (geometry instanceof Geometry.LineString) {
            LocationList line = ((Geometry.LineString)geometry).line;
            Preconditions.checkNotNull((Object)line, (Object)"LineString has null geometry");
            Preconditions.checkState((!line.isEmpty() ? 1 : 0) != 0, (Object)"LineString is empty");
            Preconditions.checkState((this.trace == null ? 1 : 0) != 0, (Object)"Encountered a LineString but already have a fault trace");
            this.trace = new FaultTrace(this.name);
            this.trace.addAll(line);
        } else if (geometry instanceof Geometry.MultiLineString) {
            ImmutableList<LocationList> lines = ((Geometry.MultiLineString)geometry).lines;
            Preconditions.checkNotNull(lines, (Object)"MultiLineString has null geometry");
            Preconditions.checkState((!lines.isEmpty() ? 1 : 0) != 0, (Object)"MultiLineString is empty");
            Preconditions.checkState((this.trace == null ? 1 : 0) != 0, (Object)"Encountered a MultiLineString but already have a fault trace");
            this.trace = new FaultTrace(this.name);
            this.trace.addAll((Collection)lines.get(0));
            if (lines.size() > 1) {
                Preconditions.checkState((lines.size() == 2 ? 1 : 0) != 0, (Object)"MultiLineString supplied; must either containe 1 trace (upper only) or 2 (upper and then lower).");
                Preconditions.checkState((boolean)geometry.isSerializeZeroDepths(), (Object)"Depths must be explicitly supplied in the GeoJSON coordinates array of a lower trace");
                double avgUpperDepth = 0.0;
                for (Location loc : this.trace) {
                    avgUpperDepth += loc.depth;
                }
                avgUpperDepth /= (double)this.trace.size();
                this.lowerTrace = new FaultTrace(this.name);
                this.lowerTrace.addAll((Collection)lines.get(1));
                double avgLowerDepth = 0.0;
                for (Location loc : this.lowerTrace) {
                    avgLowerDepth += loc.depth;
                }
                Preconditions.checkState(((avgLowerDepth /= (double)this.lowerTrace.size()) > avgUpperDepth ? 1 : 0) != 0, (Object)("MultiLineString supplied with upper and lower traces, but lower trace (depth=" + (float)avgLowerDepth + ") is not below upper trace (depth=" + (float)avgUpperDepth + "). Were depths supplied in GeoJSON (tuples)?"));
            }
        } else if (geometry instanceof Geometry.Polygon) {
            Region polygon = ((Geometry.Polygon)geometry).asRegion();
            Preconditions.checkNotNull((Object)polygon, (Object)"Polygon has null geometry");
            Preconditions.checkState((this.zonePolygon == null ? 1 : 0) != 0, (Object)"Encountered a Polygon but already have a zone polygon");
            this.zonePolygon = polygon;
        } else if (geometry instanceof Geometry.MultiPolygon) {
            ImmutableList<Geometry.Polygon> polygons = ((Geometry.MultiPolygon)geometry).polygons;
            Preconditions.checkNotNull(polygons, (Object)"MultiPolygon has null geometry");
            Preconditions.checkState((!polygons.isEmpty() ? 1 : 0) != 0, (Object)"MultiPolygon is empty");
            Preconditions.checkState((polygons.size() == 1 ? 1 : 0) != 0, (String)"Only support 1 zone polygon, this MultiPolygon has %s", (int)polygons.size());
            Preconditions.checkState((this.zonePolygon == null ? 1 : 0) != 0, (Object)"Encountered a MultiPolygon but already have a zone polygon");
            this.zonePolygon = ((Geometry.Polygon)polygons.get(0)).asRegion();
        } else {
            System.err.println("Skipping unexpected FaultSection geometry type: " + String.valueOf((Object)geometry.type));
        }
        if (this.upperDepth != 0.0 && this.dip != 90.0 && !geometry.isSerializeZeroDepths()) {
            Preconditions.checkState((!Double.isNaN(this.upperDepth) ? 1 : 0) != 0, (Object)"Can't infer upper depth: upper depth not specified, and fault trace did not specify depths.");
            LocationList modTrace = new LocationList();
            for (Location loc : this.trace) {
                modTrace.add(new Location(loc.getLatitude(), loc.getLongitude(), this.upperDepth));
            }
            this.trace = new FaultTrace(this.trace.getName());
            this.trace.addAll(modTrace);
        }
    }

    private void validateLowerTrace(FaultTrace upper, FaultTrace lower) {
        int num = Integer.max(10, (int)Math.max(upper.getTraceLength(), lower.getTraceLength()));
        FaultTrace resampledUpper = FaultUtils.resampleTrace(upper, num);
        double upperDepth = resampledUpper.stream().map(S -> S.depth).mapToDouble(d -> d).average().getAsDouble();
        FaultTrace resampledLower = FaultUtils.resampleTrace(lower, num);
        double lowerDepth = resampledLower.stream().map(S -> S.depth).mapToDouble(d -> d).average().getAsDouble();
        Preconditions.checkState((lowerDepth > upperDepth ? 1 : 0) != 0, (String)"Upper trace (depth=%s) must be above (less than) lower trace (depth=%s)", (Object)upperDepth, (Object)lowerDepth);
        if (Double.isNaN(this.upperDepth)) {
            this.upperDepth = upperDepth;
            this.properties.set(UPPER_DEPTH, upperDepth);
        }
        if (Double.isNaN(this.lowerDepth)) {
            this.lowerDepth = lowerDepth;
            this.properties.set(UPPER_DEPTH, lowerDepth);
        }
        ApproxEvenlyGriddedSurface surf = this.getApproxGriddedSurface(1.0, false);
        this.dip = this.properties.getDouble(DIP, Double.NaN);
        if (!Double.isFinite(this.dip)) {
            this.dip = surf.getAveDip();
            this.properties.set(DIP, this.dip);
        }
        if (this.dip < 90.0 && (this.dip <= 85.0 || LocationUtils.horzDistanceFast(upper.first(), lower.first()) > 0.1 || LocationUtils.horzDistanceFast(upper.last(), lower.last()) > 0.1)) {
            double idealDipDir;
            double strike = upper.getAveStrike();
            double simpleDipDir = FaultUtils.getAngleAverage(List.of(Double.valueOf(LocationUtils.azimuth(upper.first(), lower.first())), Double.valueOf(LocationUtils.azimuth(upper.last(), lower.last()))));
            for (idealDipDir = strike + 90.0; idealDipDir > 360.0; idealDipDir -= 360.0) {
            }
            double arDiff = FaultUtils.getAbsAngleDiff(idealDipDir, simpleDipDir);
            Preconditions.checkState((arDiff <= 90.0 ? 1 : 0) != 0, (String)"Right hand rule violation: dip=%s, dipDir=%s, idealDipDir=%s, diff=%s", (Object)this.dip, (Object)simpleDipDir, (Object)idealDipDir, (Object)arDiff);
        }
        if (!Double.isFinite(this.dipDirection)) {
            this.setDipDirection((float)surf.getAveDipDirection());
        }
    }

    private static void checkPropNonNull(String propName, Object value) {
        Preconditions.checkNotNull((Object)value, (String)"FaultSections must have the '%s' GeoJSON property", (Object)propName);
    }

    private static void checkPropFinite(String propName, double value) {
        Preconditions.checkState((boolean)Double.isFinite(value), (String)"FaultSections must have the '%s' GeoJSON property", (Object)propName);
    }

    public GeoJSONFaultSection(FaultSection sect) {
        this.id = sect.getSectionId();
        this.name = sect.getSectionName();
        this.dip = sect.getAveDip();
        this.rake = sect.getAveRake();
        this.upperDepth = sect.getOrigAveUpperDepth();
        this.lowerDepth = sect.getAveLowerDepth();
        this.dipDirection = sect.getDipDirection();
        this.trace = sect.getFaultTrace();
        this.lowerTrace = sect.getLowerFaultTrace();
        this.zonePolygon = sect.getZonePolygon();
        if (sect instanceof GeoJSONFaultSection) {
            this.properties = new FeatureProperties(((GeoJSONFaultSection)sect).properties);
        } else {
            this.properties = new FeatureProperties();
            this.setProperty(FAULT_ID, this.id);
            this.setProperty(FAULT_NAME, this.name);
            this.setProperty(DIP, this.dip);
            this.setProperty(RAKE, this.rake);
            this.setProperty(LOW_DEPTH, this.lowerDepth);
            this.setProperty(UPPER_DEPTH, this.upperDepth);
            if (this.dipDirection == (float)(this.trace.getAveStrike() + 90.0) || Float.isFinite(this.dipDirection)) {
                // empty if block
            }
            this.setProperty(DIP_DIR, Float.valueOf(this.dipDirection));
            this.setDateOfLastEvent(sect.getDateOfLastEvent());
            this.setSlipInLastEvent(sect.getSlipInLastEvent());
            this.setAseismicSlipFactor(sect.getAseismicSlipFactor());
            this.setCouplingCoeff(sect.getCouplingCoeff());
            this.setAveSlipRate(sect.getOrigAveSlipRate());
            this.setParentSectionId(sect.getParentSectionId());
            this.setParentSectionName(sect.getParentSectionName());
            this.setSlipRateStdDev(sect.getOrigSlipRateStdDev());
            if (sect.isConnector()) {
                this.properties.set(CONNECTOR, true);
            }
            if (sect.isProxyFault()) {
                this.properties.set(PROXY, true);
            }
            this.setZonePolygon(sect.getZonePolygon());
        }
        this.cacheCommonValues();
    }

    GeoJSONFaultSection(int id, String name, double dip, double rake, double upperDepth, double lowerDepth, float dipDirection, FaultTrace trace, FeatureProperties properties) {
        this.id = id;
        this.name = name;
        this.dip = dip;
        this.rake = rake;
        this.upperDepth = upperDepth;
        this.lowerDepth = lowerDepth;
        this.dipDirection = dipDirection;
        this.trace = trace;
        this.properties = properties;
        this.cacheCommonValues();
    }

    public static GeoJSONFaultSection fromFeature(Feature feature) {
        return new GeoJSONFaultSection(feature);
    }

    public static Feature toFeature(FaultSection sect) {
        return new GeoJSONFaultSection(sect).toFeature();
    }

    public static GeoJSONFaultSection fromNSHMP_HazFeature(Feature feature) {
        FeatureProperties origProps = feature.properties;
        FeatureProperties mappedProps = new FeatureProperties();
        Preconditions.checkState((feature.id != null && feature.id instanceof Number ? 1 : 0) != 0);
        int id = ((Number)feature.id).intValue();
        String name = origProps.require("name", String.class);
        mappedProps.set(FAULT_NAME, name);
        Geometry geometry = feature.geometry;
        if (geometry instanceof Geometry.MultiLineString && ((Geometry.MultiLineString)geometry).lines.size() == 2) {
            Geometry.MultiLineString multiGeom = (Geometry.MultiLineString)geometry;
            LocationList upperTrace = (LocationList)multiGeom.lines.get(0);
            FaultTrace upperAsFaultTrace = new FaultTrace(null);
            upperAsFaultTrace.addAll(upperTrace);
            LocationList lowerTrace = (LocationList)multiGeom.lines.get(1);
            FaultTrace lowerAsFaultTrace = new FaultTrace(null);
            lowerAsFaultTrace.addAll(lowerTrace);
            ApproxEvenlyGriddedSurface approxSurf = new ApproxEvenlyGriddedSurface(upperAsFaultTrace, lowerAsFaultTrace, 1.0);
            mappedProps.set(DIP, approxSurf.getAveDip());
            if (origProps.containsKey("rake")) {
                mappedProps.set(RAKE, origProps.require("rake", Double.class));
            }
            mappedProps.set(UPPER_DEPTH, approxSurf.getAveRupTopDepth());
            mappedProps.set(LOW_DEPTH, approxSurf.getAveRupBottomDepth());
            mappedProps.set(DIP_DIR, approxSurf.getAveDipDirection());
            LocationList newUpperTrace = new LocationList();
            double aveDepth = approxSurf.getAveRupTopDepth();
            double dipDir = approxSurf.getAveDipDirection();
            double dip = approxSurf.getAveDip();
            System.out.println("aveDep=" + (float)aveDepth + "\tdipDir=" + (float)dipDir + "\tdip=" + (float)dip + "\n");
            for (Location loc : upperTrace) {
                double deltaDep = aveDepth - loc.depth;
                double azimuth = Double.NaN;
                azimuth = deltaDep > 0.0 ? dipDir : dipDir + 180.0;
                double horzDist = Math.abs(deltaDep) / Math.tan(dip * Math.PI / 180.0);
                LocationVector dir = new LocationVector(azimuth, horzDist, deltaDep);
                newUpperTrace.add(LocationUtils.location(loc, dir));
            }
            geometry = new Geometry.LineString(newUpperTrace);
            mappedProps.put(LOWER_TRACE, new Geometry.LineString(lowerTrace));
        } else {
            mappedProps.set(DIP, origProps.require("dip", Double.class));
            if (origProps.containsKey("rake")) {
                mappedProps.set(RAKE, origProps.require("rake", Double.class));
            }
            mappedProps.set(UPPER_DEPTH, origProps.require("upper-depth", Double.class));
            mappedProps.set(LOW_DEPTH, origProps.require("lower-depth", Double.class));
            if (origProps.containsKey("dip-direction")) {
                mappedProps.set(DIP_DIR, origProps.require("dip-direction", Double.class));
            }
        }
        if (origProps.containsKey("state")) {
            mappedProps.set("PrimState", origProps.require("state", String.class));
        }
        if (origProps.containsKey("references")) {
            mappedProps.set("references", origProps.require("references", String.class));
        }
        if (origProps.containsKey("aseismicity")) {
            mappedProps.set(ASEIS, origProps.require("aseismicity", Double.class));
        }
        if (origProps.containsKey("slip-rate")) {
            mappedProps.set(SLIP_RATE, origProps.require("slip-rate", Double.class));
        }
        if (origProps.containsKey("index")) {
            mappedProps.set(PARENT_ID, id);
            id = origProps.getInt("index", 0);
        }
        if (origProps.containsKey("parent-id")) {
            mappedProps.set(PARENT_ID, origProps.getInt("parent-id", 0));
        }
        return new GeoJSONFaultSection(new Feature(id, geometry, mappedProps));
    }

    public Feature toFeature() {
        Geometry geometry;
        Preconditions.checkNotNull((Object)this.trace, (Object)"Trace is null");
        Geometry traceGeom = this.lowerTrace != null ? new Geometry.MultiLineString(List.of(this.trace, this.lowerTrace)) : new Geometry.LineString(this.trace);
        if (this.upperDepth != 0.0 && this.dip != 90.0 || this.lowerTrace != null) {
            traceGeom.setSerializeZeroDepths(true);
        }
        if (this.zonePolygon != null) {
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            geometries.add(traceGeom);
            geometries.add(new Geometry.Polygon(this.zonePolygon));
            geometry = new Geometry.GeometryCollection(geometries);
        } else {
            geometry = traceGeom;
        }
        return new Feature(this.id, geometry, this.properties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getDateOfLastEvent() {
        return this.dateOfLastEventMillis;
    }

    @Override
    public void setDateOfLastEvent(long dateOfLastEventMillis) {
        this.dateOfLastEventMillis = dateOfLastEventMillis;
        this.properties.setConditional(DATE_LAST, dateOfLastEventMillis, dateOfLastEventMillis > Long.MIN_VALUE);
    }

    @Override
    public void setSlipInLastEvent(double slipInLastEvent) {
        this.properties.setConditional(SLIP_LAST, slipInLastEvent, Double.isFinite(slipInLastEvent));
    }

    @Override
    public double getSlipInLastEvent() {
        return this.properties.getDouble(SLIP_LAST, Double.NaN);
    }

    @Override
    public double getAseismicSlipFactor() {
        return this.properties.getDouble(ASEIS, 0.0);
    }

    @Override
    public void setAseismicSlipFactor(double aseismicSlipFactor) {
        Preconditions.checkArgument((aseismicSlipFactor >= 0.0 && aseismicSlipFactor <= 1.0 ? 1 : 0) != 0, (String)"aseismicSlipFactor not in the range [0,1]: %s", (Object)aseismicSlipFactor);
        this.properties.set(ASEIS, aseismicSlipFactor);
    }

    @Override
    public double getCouplingCoeff() {
        return this.properties.getDouble(COUPLING, 1.0);
    }

    @Override
    public void setCouplingCoeff(double couplingCoeff) {
        Preconditions.checkArgument((couplingCoeff >= 0.0 && couplingCoeff <= 1.0 ? 1 : 0) != 0, (String)"couplingCoeff not in the range [0,1]: %s", (Object)couplingCoeff);
        this.properties.set(COUPLING, couplingCoeff);
    }

    @Override
    public double getAveDip() {
        return this.dip;
    }

    @Override
    public double getOrigAveSlipRate() {
        return this.aveLongTermSlipRate;
    }

    @Override
    public void setAveSlipRate(double aveLongTermSlipRate) {
        this.aveLongTermSlipRate = aveLongTermSlipRate;
        this.properties.setConditional(SLIP_RATE, aveLongTermSlipRate, Double.isFinite(aveLongTermSlipRate));
    }

    @Override
    public double getAveLowerDepth() {
        return this.lowerDepth;
    }

    @Override
    public double getAveRake() {
        return this.rake;
    }

    @Override
    public void setAveRake(double aveRake) {
        FaultUtils.assertValidRake(aveRake);
        this.rake = aveRake;
        this.properties.set(RAKE, aveRake);
    }

    @Override
    public double getOrigAveUpperDepth() {
        return this.upperDepth;
    }

    @Override
    public float getDipDirection() {
        return this.dipDirection;
    }

    public void setDipDirection(float dipDirection) {
        while (dipDirection > 360.0f) {
            dipDirection -= 360.0f;
        }
        while (dipDirection < 0.0f) {
            dipDirection += 360.0f;
        }
        this.dipDirection = dipDirection;
        this.properties.set(DIP_DIR, Float.valueOf(dipDirection));
    }

    @Override
    public FaultTrace getFaultTrace() {
        return this.trace;
    }

    @Override
    public FaultTrace getLowerFaultTrace() {
        return this.lowerTrace;
    }

    @Override
    public int getSectionId() {
        return this.id;
    }

    @Override
    public void setSectionId(int sectID) {
        this.id = sectID;
        this.properties.set(FAULT_ID, this.id);
        this.updateHashCode();
    }

    @Override
    public void setSectionName(String sectName) {
        this.name = sectName;
        this.properties.set(FAULT_NAME, sectName);
    }

    @Override
    public int getParentSectionId() {
        return this.parentSectionId;
    }

    @Override
    public void setParentSectionId(int parentSectionId) {
        this.parentSectionId = parentSectionId;
        this.properties.setConditional(PARENT_ID, parentSectionId, parentSectionId >= 0);
        this.updateHashCode();
    }

    @Override
    public String getParentSectionName() {
        return this.parentSectionName;
    }

    @Override
    public void setParentSectionName(String parentSectionName) {
        this.parentSectionName = parentSectionName;
        this.properties.set(PARENT_NAME, parentSectionName);
    }

    public List<GeoJSONFaultSection> getSubSectionsList(double maxSubSectionLen, int startId, int minSubSections) {
        ArrayList<Object> equalLengthLowerSubsTrace;
        ArrayList<FaultTrace> equalLengthSubsTrace;
        if (this.lowerTrace == null) {
            equalLengthSubsTrace = FaultUtils.getEqualLengthSubsectionTraces(this.trace, maxSubSectionLen, minSubSections);
            equalLengthLowerSubsTrace = null;
        } else {
            int i;
            int numResample = Integer.max(100, (int)Math.max(this.trace.getTraceLength(), this.lowerTrace.getTraceLength()));
            FaultTrace upperResampled = FaultUtils.resampleTrace(this.trace, numResample);
            FaultTrace lowerResampled = FaultUtils.resampleTrace(this.lowerTrace, numResample);
            Preconditions.checkState((upperResampled.size() == lowerResampled.size() ? 1 : 0) != 0);
            FaultTrace middleTrace = new FaultTrace(null);
            double maxHorzDist = 0.0;
            for (int i2 = 0; i2 < upperResampled.size(); ++i2) {
                Location upperLoc = (Location)upperResampled.get(i2);
                Location lowerLoc = (Location)lowerResampled.get(i2);
                LocationVector vector = LocationUtils.vector(upperLoc, lowerLoc);
                maxHorzDist = Math.max(maxHorzDist, vector.getHorzDistance());
                vector.setHorzDistance(0.5 * vector.getHorzDistance());
                vector.setVertDistance(0.5 * vector.getVertDistance());
                middleTrace.add(LocationUtils.location(upperLoc, vector));
            }
            ArrayList<FaultTrace> equalLengthMiddleTraces = FaultUtils.getEqualLengthSubsectionTraces(middleTrace, maxSubSectionLen, minSubSections);
            int numSubSects = equalLengthMiddleTraces.size();
            int[][] closestUpperIndexes = new int[numSubSects][2];
            int[][] closestLowerIndexes = new int[numSubSects][2];
            for (i = 0; i < numSubSects; ++i) {
                FaultTrace middle = equalLengthMiddleTraces.get(i);
                double strike = middle.getAveStrike();
                double leftOfStrikeRad = Math.toRadians(strike - 90.0);
                double rightOfStrikeRad = Math.toRadians(strike + 90.0);
                Location[] firstLine = new Location[]{LocationUtils.location(middle.first(), leftOfStrikeRad, maxHorzDist), LocationUtils.location(middle.first(), rightOfStrikeRad, maxHorzDist)};
                Location[] lastLine = new Location[]{LocationUtils.location(middle.last(), leftOfStrikeRad, maxHorzDist), LocationUtils.location(middle.last(), rightOfStrikeRad, maxHorzDist)};
                double upperFirstDist = Double.POSITIVE_INFINITY;
                double upperLastDist = Double.POSITIVE_INFINITY;
                double lowerFirstDist = Double.POSITIVE_INFINITY;
                double lowerLastDist = Double.POSITIVE_INFINITY;
                for (int j = 0; j < upperResampled.size(); ++j) {
                    double distLowLast;
                    double distLowFirst;
                    double distUpLast;
                    double distUpFirst = Math.abs(LocationUtils.distanceToLineFast(firstLine[0], firstLine[1], (Location)upperResampled.get(j)));
                    if (distUpFirst < upperFirstDist) {
                        upperFirstDist = distUpFirst;
                        closestUpperIndexes[i][0] = j;
                    }
                    if ((distUpLast = Math.abs(LocationUtils.distanceToLineFast(lastLine[0], lastLine[1], (Location)upperResampled.get(j)))) < upperLastDist) {
                        upperLastDist = distUpLast;
                        closestUpperIndexes[i][1] = j;
                    }
                    if ((distLowFirst = Math.abs(LocationUtils.distanceToLineFast(firstLine[0], firstLine[1], (Location)lowerResampled.get(j)))) < lowerFirstDist) {
                        lowerFirstDist = distLowFirst;
                        closestLowerIndexes[i][0] = j;
                    }
                    if (!((distLowLast = Math.abs(LocationUtils.distanceToLineFast(lastLine[0], lastLine[1], (Location)lowerResampled.get(j)))) < lowerLastDist)) continue;
                    lowerLastDist = distLowLast;
                    closestLowerIndexes[i][1] = j;
                }
            }
            for (i = 0; i < numSubSects; ++i) {
                int[] myUpper = closestUpperIndexes[i];
                int[] myLower = closestLowerIndexes[i];
                if (i == 0) {
                    myUpper[0] = 0;
                    myLower[0] = 0;
                } else {
                    int[] prevLower;
                    int[] prevUpper = closestUpperIndexes[i - 1];
                    if (myUpper[0] != prevUpper[1]) {
                        int avg;
                        double tieBreaker = myUpper[1] - myUpper[0] > prevUpper[1] - prevUpper[0] ? 0.1 : -0.1;
                        myUpper[0] = avg = (int)(0.5 * (double)(myUpper[0] + prevUpper[1]) + tieBreaker);
                        prevUpper[1] = avg;
                    }
                    if (myLower[0] != (prevLower = closestLowerIndexes[i - 1])[1]) {
                        int avg;
                        double tieBreaker = myLower[1] - myLower[0] > prevLower[1] - prevLower[0] ? 0.1 : -0.1;
                        myLower[0] = avg = (int)(0.5 * (double)(myLower[0] + prevLower[1]) + tieBreaker);
                        prevLower[1] = avg;
                    }
                }
                if (i != numSubSects - 1) continue;
                myUpper[1] = upperResampled.size() - 1;
                myLower[1] = upperResampled.size() - 1;
            }
            boolean fail = false;
            for (int i3 = 0; i3 < numSubSects; ++i3) {
                int[] myUpper = closestUpperIndexes[i3];
                int[] myLower = closestLowerIndexes[i3];
                if (myUpper[0] < myUpper[1] && myLower[0] < myLower[1]) continue;
                System.out.println("Fail for subsection " + i3);
                System.out.println("\tupper: " + myUpper[0] + "->" + myUpper[1]);
                System.out.println("\tlower: " + myLower[0] + "->" + myLower[1]);
                fail = true;
                break;
            }
            if (fail) {
                System.err.println("WARNING: failed to build unskewed subsections for " + this.id + ". " + this.name + ", reverting to splitting upper and lower trace evenly");
                equalLengthSubsTrace = FaultUtils.getEqualLengthSubsectionTraces(this.trace, maxSubSectionLen, minSubSections);
                equalLengthLowerSubsTrace = FaultUtils.getEqualLengthSubsectionTraces(this.lowerTrace, equalLengthSubsTrace.size());
                Preconditions.checkState((equalLengthLowerSubsTrace.size() == equalLengthLowerSubsTrace.size() ? 1 : 0) != 0);
            } else {
                equalLengthSubsTrace = new ArrayList(numSubSects);
                equalLengthLowerSubsTrace = new ArrayList(numSubSects);
                int upperSearchStartIndex = 0;
                int lowerSearchStartIndex = 0;
                for (int i4 = 0; i4 < numSubSects; ++i4) {
                    FaultTrace upperSubTrace = new FaultTrace(null);
                    FaultTrace lowerSubTrace = new FaultTrace(null);
                    int[] myUpper = closestUpperIndexes[i4];
                    int[] myLower = closestLowerIndexes[i4];
                    Location upperFirst = (Location)upperResampled.get(myUpper[0]);
                    Location upperLast = (Location)upperResampled.get(myUpper[1]);
                    Location lowerFirst = (Location)lowerResampled.get(myLower[0]);
                    Location lowerLast = (Location)lowerResampled.get(myLower[1]);
                    upperSubTrace.add(upperFirst);
                    lowerSubTrace.add(lowerFirst);
                    upperSearchStartIndex = GeoJSONFaultSection.addIntermediateTracePoints(this.trace, upperSubTrace, upperFirst, upperLast, upperSearchStartIndex);
                    lowerSearchStartIndex = GeoJSONFaultSection.addIntermediateTracePoints(this.lowerTrace, lowerSubTrace, lowerFirst, lowerLast, lowerSearchStartIndex);
                    upperSubTrace.add(upperLast);
                    lowerSubTrace.add(lowerLast);
                    equalLengthSubsTrace.add(upperSubTrace);
                    equalLengthLowerSubsTrace.add(lowerSubTrace);
                }
            }
        }
        ArrayList<GeoJSONFaultSection> subSectionList = new ArrayList<GeoJSONFaultSection>();
        for (int i = 0; i < equalLengthSubsTrace.size(); ++i) {
            int myID = startId + i;
            String myName = this.name + ", Subsection " + i;
            GeoJSONFaultSection subSection = new GeoJSONFaultSection(this);
            subSection.properties.remove(FAULT_ID);
            subSection.properties.remove(FAULT_NAME);
            subSection.setSectionName(myName);
            subSection.setSectionId(myID);
            subSection.trace = (FaultTrace)equalLengthSubsTrace.get(i);
            subSection.setParentSectionId(this.id);
            subSection.setParentSectionName(this.name);
            subSection.setDipDirection(this.dipDirection);
            if (this.lowerTrace != null) {
                FaultTrace lowerSubTrace;
                subSection.lowerTrace = lowerSubTrace = (FaultTrace)equalLengthLowerSubsTrace.get(i);
                subSection.dip = new ApproxEvenlyGriddedSurface(subSection.trace, subSection.lowerTrace, subSection.trace.getTraceLength() / 20.0).getAveDip();
                subSection.properties.set(DIP, subSection.dip);
                int num = Integer.max(10, (int)Math.max(subSection.trace.getTraceLength(), lowerSubTrace.getTraceLength()));
                subSection.upperDepth = FaultUtils.resampleTrace(subSection.trace, num).stream().map(S -> S.depth).mapToDouble(d -> d).average().getAsDouble();
                subSection.properties.set(UPPER_DEPTH, subSection.upperDepth);
                subSection.lowerDepth = FaultUtils.resampleTrace(lowerSubTrace, num).stream().map(S -> S.depth).mapToDouble(d -> d).average().getAsDouble();
                subSection.properties.set(LOW_DEPTH, subSection.lowerDepth);
            }
            subSection.setZonePolygon(null);
            subSectionList.add(subSection);
        }
        if (this.zonePolygon != null) {
            SubSectionPolygonBuilder.buildSubsectionPolygons(subSectionList, this.zonePolygon);
        }
        return subSectionList;
    }

    private static int addIntermediateTracePoints(FaultTrace rawTrace, FaultTrace subSectTrace, Location subsectionStart, Location subsectionEnd, int searchStartIndex) {
        int i;
        double minDist = Double.POSITIVE_INFINITY;
        int closestSegToStart = -1;
        for (int i2 = searchStartIndex; i2 < rawTrace.size() - 1; ++i2) {
            Location loc2;
            Location loc1 = (Location)rawTrace.get(i2);
            double distToSeg = LocationUtils.distanceToLineSegmentFast(loc1, loc2 = (Location)rawTrace.get(i2 + 1), subsectionStart);
            if (distToSeg < minDist) {
                closestSegToStart = i2;
                minDist = distToSeg;
                continue;
            }
            if (minDist < 1.0 && distToSeg > 10.0) break;
        }
        minDist = Double.POSITIVE_INFINITY;
        int closestSegToEnd = -1;
        for (i = closestSegToStart; i < rawTrace.size() - 1; ++i) {
            Location loc2;
            Location loc1 = (Location)rawTrace.get(i);
            double distToSeg = LocationUtils.distanceToLineSegmentFast(loc1, loc2 = (Location)rawTrace.get(i + 1), subsectionEnd);
            if (distToSeg < minDist) {
                closestSegToEnd = i;
                minDist = distToSeg;
                continue;
            }
            if (minDist < 1.0 && distToSeg > 10.0) break;
        }
        if (closestSegToStart < closestSegToEnd) {
            for (i = closestSegToStart + 1; i <= closestSegToEnd; ++i) {
                subSectTrace.add((Location)rawTrace.get(i));
            }
        }
        return closestSegToEnd;
    }

    @Override
    public double getOrigSlipRateStdDev() {
        return this.slipRateStdDev;
    }

    @Override
    public void setSlipRateStdDev(double slipRateStdDev) {
        this.slipRateStdDev = slipRateStdDev;
        this.properties.setConditional(SLIP_STD_DEV, slipRateStdDev, Double.isFinite(slipRateStdDev));
    }

    @Override
    public boolean isConnector() {
        return this.properties.getBoolean(CONNECTOR, false);
    }

    @Override
    public boolean isProxyFault() {
        return this.properties.getBoolean(PROXY, false);
    }

    @Override
    public Region getZonePolygon() {
        return this.zonePolygon;
    }

    @Override
    public void setZonePolygon(Region zonePolygon) {
        this.zonePolygon = zonePolygon;
    }

    @Override
    public RuptureSurface getFaultSurface(double gridSpacing) {
        return this.getFaultSurface(gridSpacing, false, true);
    }

    @Override
    public RuptureSurface getFaultSurface(double gridSpacing, boolean preserveGridSpacingExactly, boolean aseisReducesArea) {
        if (this.lowerTrace != null || !this.isUpperTraceSameDepth()) {
            return this.getApproxGriddedSurface(gridSpacing, aseisReducesArea);
        }
        return this.getStirlingGriddedSurface(gridSpacing, preserveGridSpacingExactly, aseisReducesArea);
    }

    private boolean isUpperTraceSameDepth() {
        double depth = this.trace.first().depth;
        for (int i = 0; i < this.trace.size(); ++i) {
            if (depth == ((Location)this.trace.get((int)i)).depth) continue;
            return false;
        }
        return true;
    }

    public void setProperty(String name, Object value) {
        this.properties.set(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public <E> E getProperty(String name, E defaultValue) {
        return this.properties.get(name, defaultValue);
    }

    public FeatureProperties getProperties() {
        return this.properties;
    }

    public synchronized StirlingGriddedSurface getStirlingGriddedSurface(double gridSpacing, boolean preserveGridSpacingExactly, boolean aseisReducesArea) {
        if (this.stirlingCache == null) {
            this.stirlingCache = new FaultSection.StirlingSurfaceCache(this);
        }
        return this.stirlingCache.getStirlingGriddedSurface(gridSpacing, preserveGridSpacingExactly, aseisReducesArea);
    }

    public synchronized ApproxEvenlyGriddedSurface getApproxGriddedSurface(double gridSpacing, boolean aseisReducesArea) {
        if (this.approxGriddedCache == null) {
            FaultTrace lowerTrace = this.lowerTrace;
            if (lowerTrace == null) {
                if (this.dip == 90.0) {
                    lowerTrace = new FaultTrace(this.name);
                    for (Location loc : this.trace) {
                        lowerTrace.add(new Location(loc.lat, loc.lon, this.lowerDepth));
                    }
                } else {
                    double aveDipRad = Math.toRadians(this.dip);
                    lowerTrace = new FaultTrace(this.name);
                    for (Location traceLoc : this.trace) {
                        Location upperLoc = StirlingGriddedSurface.getTopLocation(traceLoc, this.upperDepth, aveDipRad, this.dipDirection);
                        double vertToBottom = this.lowerDepth - upperLoc.depth;
                        Preconditions.checkState((vertToBottom > 0.0 ? 1 : 0) != 0, (String)"lower depth is above upper loc? %s %s", (Object)this.lowerDepth, (Object)upperLoc.depth);
                        double horzToBottom = vertToBottom * Math.tan(aveDipRad);
                        Preconditions.checkState((this.dip == 90.0 || horzToBottom > 0.0 ? 1 : 0) != 0, (String)"no horizontal offset (%s) for lower trace with dip=%s?", (Object)horzToBottom, (Object)this.dip);
                        LocationVector dir = new LocationVector(this.dipDirection, horzToBottom, vertToBottom);
                        Location lowerLoc = LocationUtils.location(upperLoc, dir);
                        lowerTrace.add(lowerLoc);
                    }
                }
            }
            this.approxGriddedCache = new FaultSection.ApproxEvenlyGriddedSurfaceCache(this, lowerTrace);
        }
        return this.approxGriddedCache.getApproxEvenlyGriddedSurface(gridSpacing, aseisReducesArea);
    }

    @Override
    public GeoJSONFaultSection clone() {
        return new GeoJSONFaultSection(this);
    }

    @Override
    public Element toXMLMetadata(Element root, String name) {
        FaultSectionPrefData prefData = new FaultSectionPrefData();
        prefData.setFaultSectionPrefData(this);
        return prefData.toXMLMetadata(root, name);
    }

    @Override
    public Element toXMLMetadata(Element root) {
        FaultSectionPrefData prefData = new FaultSectionPrefData();
        prefData.setFaultSectionPrefData(this);
        return prefData.toXMLMetadata(root, this.name);
    }

    public static GeoJSONFaultSection fromXMLMetadata(Element el) {
        return new GeoJSONFaultSection(FaultSectionPrefData.fromXMLMetadata(el));
    }

    private void updateHashCode() {
        this.hashCode = FaultSection.hashCode(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return FaultSection.equals(this, obj);
    }
}

