/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import com.google.common.base.Preconditions;
import java.util.ListIterator;
import java.util.Random;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.QuadSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.cache.CacheEnabledSurface;
import org.opensha.sha.faultSurface.cache.SurfaceCachingPolicy;
import org.opensha.sha.faultSurface.cache.SurfaceDistanceCache;
import org.opensha.sha.faultSurface.cache.SurfaceDistances;

public class LineSurface
implements RuptureSurface,
CacheEnabledSurface {
    static final boolean D = false;
    private double dipDeg;
    private double depth;
    private FaultTrace trace;
    private FaultTrace traceBelowSeis;
    private boolean allSameDepth;
    private double[] segmentLengths;
    private double discr_km = 1.0;
    private SurfaceDistanceCache cache = SurfaceCachingPolicy.build(this);
    private LocationList disretizedTrace;

    public LineSurface(FaultTrace trace, double dip) {
        this.trace = trace;
        this.dipDeg = dip;
        double sumLen = 0.0;
        Preconditions.checkArgument((trace.size() > 1 ? 1 : 0) != 0, (Object)"Must have at least 2 locations");
        double sumLenDepthProd = 0.0;
        this.allSameDepth = true;
        boolean anyAboveSeis = false;
        this.segmentLengths = new double[trace.size() - 1];
        for (int i = 0; i < trace.size() - 1; ++i) {
            Location l0 = (Location)trace.get(i);
            Location l1 = (Location)trace.get(i + 1);
            this.allSameDepth &= l0.depth == l1.depth;
            anyAboveSeis |= l0.depth > 3.0 | l1.depth > 3.0;
            this.segmentLengths[i] = LocationUtils.linearDistanceFast(l0, l1);
            double depth = 0.5 * (l0.depth + l1.depth);
            sumLenDepthProd += depth * this.segmentLengths[i];
            sumLen += this.segmentLengths[i];
        }
        this.depth = this.allSameDepth ? trace.first().depth : sumLenDepthProd / sumLen;
        if (anyAboveSeis) {
            this.traceBelowSeis = new FaultTrace("below seis");
            for (Location loc : trace) {
                if (loc.depth > 3.0) {
                    this.traceBelowSeis.add(new Location(loc.lat, loc.lon, 3.0));
                    continue;
                }
                this.traceBelowSeis.add(loc);
            }
        } else {
            this.traceBelowSeis = trace;
        }
    }

    @Override
    public SurfaceDistances calcDistances(Location loc) {
        double[] segHorzDists = LineSurface.calcSegHorzDists(this.trace, loc);
        double distRup = this.distance(this.trace, loc, true, segHorzDists);
        double distJB = this.distance(this.trace, loc, false, segHorzDists);
        double distSeis = this.trace == this.traceBelowSeis ? distRup : this.distance(this.traceBelowSeis, loc, true, segHorzDists);
        return new SurfaceDistances(distRup, distJB, distSeis);
    }

    @Override
    public double getDistanceRup(Location loc) {
        return this.cache.getSurfaceDistances(loc).getDistanceRup();
    }

    @Override
    public double getDistanceJB(Location loc) {
        return this.cache.getSurfaceDistances(loc).getDistanceJB();
    }

    @Override
    public double getDistanceSeis(Location loc) {
        return this.cache.getSurfaceDistances(loc).getDistanceSeis();
    }

    private static double[] calcSegHorzDists(FaultTrace trace, Location loc) {
        double[] segHorzDists = new double[trace.size() - 1];
        for (int i = 0; i < segHorzDists.length; ++i) {
            segHorzDists[i] = LocationUtils.distanceToLineSegmentFast((Location)trace.get(i), (Location)trace.get(i + 1), loc);
        }
        return segHorzDists;
    }

    private double distance(FaultTrace trace, Location loc, boolean threeD) {
        return this.distance(trace, loc, threeD, LineSurface.calcSegHorzDists(trace, loc));
    }

    private double distance(FaultTrace trace, Location loc, boolean threeD, double[] segHorzDists) {
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < trace.size() - 1; ++i) {
            double segDist;
            Location l0 = (Location)trace.get(i);
            Location l1 = (Location)trace.get(i + 1);
            double horzDist = segHorzDists[i];
            if (threeD && !this.allSameDepth) {
                double horzDistSq = horzDist * horzDist;
                if (horzDistSq > distance) continue;
                if (l0.depth == l1.depth) {
                    segDist = horzDistSq + l0.depth * l0.depth;
                } else {
                    double distL1_LC;
                    double distL0_LC;
                    double calcLen;
                    double distL0 = LocationUtils.horzDistanceFast(loc, l0);
                    double distL1 = LocationUtils.horzDistanceFast(loc, l1);
                    segDist = Double.NaN;
                    if ((float)horzDist < (float)distL0 && (float)horzDist < (float)distL1 && (float)(calcLen = (distL0_LC = Math.sqrt(distL0 * distL0 - horzDistSq)) + (distL1_LC = Math.sqrt(distL1 * distL1 - horzDistSq))) <= (float)this.segmentLengths[i]) {
                        double depthLC = distL0_LC / calcLen * l1.depth + distL1_LC / calcLen * l0.depth;
                        segDist = horzDistSq + depthLC * depthLC;
                    }
                    if (Double.isNaN(segDist)) {
                        segDist = distL0 <= distL1 ? horzDistSq + l0.depth * l0.depth : horzDistSq + l1.depth * l1.depth;
                    }
                }
            } else {
                segDist = horzDist;
            }
            distance = Math.min(distance, segDist);
        }
        Preconditions.checkState((!Double.isNaN(distance) ? 1 : 0) != 0);
        if (threeD) {
            if (this.allSameDepth) {
                double depth = trace.first().depth;
                distance = Math.sqrt(distance * distance + depth * depth);
            } else {
                distance = Math.sqrt(distance);
            }
        }
        return distance;
    }

    @Override
    public double getQuickDistance(Location siteLoc) {
        return this.cache.getQuickDistance(siteLoc);
    }

    @Override
    public double calcQuickDistance(Location siteLoc) {
        return this.cache.getSurfaceDistances(siteLoc).getDistanceRup();
    }

    @Override
    public synchronized double calcDistanceX(Location siteLoc) {
        double rLast;
        double[] horzDists = LineSurface.calcSegHorzDists(this.trace, siteLoc);
        int minIndex = -1;
        double minDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < horzDists.length; ++i) {
            if (!(horzDists[i] < minDist)) continue;
            minDist = horzDists[i];
            minIndex = i;
        }
        double rFirst = LocationUtils.horzDistanceFast((Location)this.trace.get(0), siteLoc);
        return minDist < Math.min(rFirst, rLast = LocationUtils.horzDistanceFast(this.trace.last(), siteLoc)) ? LocationUtils.distanceToLineFast((Location)this.trace.get(minIndex), (Location)this.trace.get(minIndex + 1), siteLoc) : LocationUtils.distanceToLineFast(this.trace.first(), this.trace.last(), siteLoc);
    }

    @Override
    public double getDistanceX(Location siteLoc) {
        return this.cache.getDistanceX(siteLoc);
    }

    @Override
    public double getAveDip() {
        return this.dipDeg;
    }

    @Override
    public double getAveStrike() {
        return this.trace.getAveStrike();
    }

    @Override
    public double getAveLength() {
        return this.trace.getTraceLength();
    }

    @Override
    public double getAveWidth() {
        return 0.0;
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public double getAreaInsideRegion(Region region) {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocationList getEvenlyDiscritizedListOfLocsOnSurface() {
        if (this.disretizedTrace == null) {
            LineSurface lineSurface = this;
            synchronized (lineSurface) {
                if (this.disretizedTrace == null) {
                    this.disretizedTrace = FaultUtils.resampleTrace(this.trace, this.getNumDiscrAlongStrike()).unmodifiableList();
                }
            }
        }
        return this.disretizedTrace;
    }

    @Override
    public ListIterator<Location> getLocationsIterator() {
        return this.getEvenlyDiscritizedListOfLocsOnSurface().listIterator();
    }

    @Override
    public LocationList getEvenlyDiscritizedPerimeter() {
        return this.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public FaultTrace getEvenlyDiscritizedUpperEdge() {
        LocationList discretized = this.getEvenlyDiscritizedListOfLocsOnSurface();
        FaultTrace ret = new FaultTrace(null, discretized.size());
        ret.addAll(discretized);
        return ret;
    }

    @Override
    public LocationList getEvenlyDiscritizedLowerEdge() {
        return this.getEvenlyDiscritizedListOfLocsOnSurface();
    }

    @Override
    public double getAveGridSpacing() {
        return this.discr_km;
    }

    public synchronized void setAveGridSpacing(double gridSpacing) {
        this.discr_km = gridSpacing;
        this.disretizedTrace = null;
    }

    @Override
    public double getAveRupTopDepth() {
        return this.depth;
    }

    @Override
    public double getAveDipDirection() {
        return this.trace.getAveStrike() + 90.0;
    }

    @Override
    public FaultTrace getUpperEdge() {
        return this.trace;
    }

    @Override
    public LocationList getPerimeter() {
        return this.trace;
    }

    private int getNumDiscrAlongStrike() {
        int val = (int)Math.ceil((1.0E-5 + this.getAveLength()) / this.discr_km);
        return val > 2 ? val : 2;
    }

    @Override
    public Location getFirstLocOnUpperEdge() {
        return (Location)this.trace.get(0);
    }

    @Override
    public Location getLastLocOnUpperEdge() {
        return this.trace.last();
    }

    @Override
    public double getFractionOfSurfaceInRegion(Region region) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public boolean isPointSurface() {
        return false;
    }

    @Override
    public double getMinDistance(RuptureSurface surface) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public RuptureSurface getMoved(LocationVector v) {
        FaultTrace traceMoved = new FaultTrace(this.trace.getName());
        for (Location loc : this.trace) {
            traceMoved.add(LocationUtils.location(loc, v));
        }
        return new LineSurface(traceMoved, this.dipDeg);
    }

    @Override
    public LineSurface copyShallow() {
        return new LineSurface(this.trace, this.dipDeg);
    }

    @Override
    public void clearCache() {
        this.cache.clearCache();
    }

    public static void main(String[] args) {
        int numBenchmark = 1000000;
        Location[] testLocs = new Location[Integer.min(numBenchmark, 10000)];
        Random r = new Random(1234 * testLocs.length);
        for (int i = 0; i < testLocs.length; ++i) {
            testLocs[i] = new Location(34.0 + r.nextDouble() * 2.0, -120.0 + r.nextDouble() * 2.0);
        }
        Double fixedDepth = null;
        FaultTrace trace = new FaultTrace(null);
        trace.add(new Location(34.0, -118.0, fixedDepth == null ? 2.0 : fixedDepth));
        trace.add(new Location(34.7, -117.4, fixedDepth == null ? 5.0 : fixedDepth));
        trace.add(new Location(35.0, -117.0, fixedDepth == null ? 3.0 : fixedDepth));
        LineSurface lineSurf = new LineSurface(trace, 0.0);
        QuadSurface quadSurf = new QuadSurface(trace, 90.0, 1.0E-6);
        double minEPS = 0.1;
        double fractEPS = 0.05;
        for (int i = 0; i < testLocs.length; ++i) {
            SurfaceDistances lineDists = lineSurf.calcDistances(testLocs[i]);
            SurfaceDistances quadDists = quadSurf.calcDistances(testLocs[i]);
            double eps = Math.max(minEPS, fractEPS * quadDists.getDistanceRup());
            Preconditions.checkState((boolean)Precision.equals((double)lineDists.getDistanceJB(), (double)quadDists.getDistanceJB(), (double)eps), (String)"rJB mismatch; line=%s, quad=%s", (Object)Float.valueOf((float)lineDists.getDistanceJB()), (Object)Float.valueOf((float)quadDists.getDistanceJB()));
            Preconditions.checkState((boolean)Precision.equals((double)lineDists.getDistanceRup(), (double)quadDists.getDistanceRup(), (double)eps), (String)"rRup mismatch; line=%s, quad=%s", (Object)Float.valueOf((float)lineDists.getDistanceRup()), (Object)Float.valueOf((float)quadDists.getDistanceRup()));
        }
    }
}

